/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectIntPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.map.primitive.ObjectIntMap;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.ImmutableObjectIntMap;
import com.gs.collections.api.map.primitive.MutableObjectIntMap;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.map.mutable.primitive.ObjectIntHashMap;

/**
 * ImmutableObjectIntHashMap is the non-modifiable equivalent of {@link ObjectIntHashMap}.
 * This file was automatically generated from template file immutableObjectPrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableObjectIntHashMap<K> extends AbstractImmutableObjectIntMap<K> implements Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableObjectIntMap<K> delegate;

    ImmutableObjectIntHashMap(ObjectIntMap<? extends K> delegate)
    {
        this.delegate = new ObjectIntHashMap<K>(delegate);
    }

    public IntIterator intIterator()
    {
        return this.delegate.intIterator();
    }

    public void forEach(IntProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(IntPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableIntCollection select(IntPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableIntCollection reject(IntPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function)
    {
        return ((ObjectIntHashMap<T>) this.delegate).injectInto(injectedValue, function);
    }

    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public int max()
    {
        return this.delegate.max();
    }

    public int maxIfEmpty(int defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public int min()
    {
        return this.delegate.min();
    }

    public int minIfEmpty(int defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public int[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }


    public MutableIntList toSortedList()
    {
        return this.delegate.toSortedList();
    }


    public int[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(int value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(int... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(IntIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableIntList toList()
    {
        return this.delegate.toList();
    }

    public MutableIntSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableIntBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyIntIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableObjectIntMap<K> newWithKeyValue(K key, int value)
    {
        ObjectIntHashMap<K> map = ObjectIntHashMap.newMap();
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableObjectIntMap<K> newWithoutKey(K key)
    {
        ObjectIntHashMap<K> map = ObjectIntHashMap.newMap();
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableObjectIntMap<K> newWithoutAllKeys(Iterable<? extends K> keys)
    {
        ObjectIntHashMap<K> map = ObjectIntHashMap.newMap();
        map.putAll(this);
        Iterator<? extends K> iterator = keys.iterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int get(Object key)
    {
        return this.delegate.get(key);
    }

    public int getOrThrow(Object key)
    {
        return this.delegate.getOrThrow(key);
    }

    public int getIfAbsent(Object key, int ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(int value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(IntProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectIntProcedure<? super K> objectIntProcedure)
    {
        this.delegate.forEachKeyValue(objectIntProcedure);
    }

    public ImmutableObjectIntMap<K> select(ObjectIntPredicate<? super K> objectIntPredicate)
    {
        return this.delegate.select(objectIntPredicate).toImmutable();
    }

    public ImmutableObjectIntMap<K> reject(ObjectIntPredicate<? super K> objectIntPredicate)
    {
        return this.delegate.reject(objectIntPredicate).toImmutable();
    }

    public ImmutableObjectIntMap<K> toImmutable()
    {
        return this;
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public Set<K> keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableIntCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    private Object writeReplace()
    {
        return new ImmutableObjectIntMapSerializationProxy<K>(this);
    }
}
