/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectLongPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectLongProcedure;
import com.gs.collections.api.map.primitive.ObjectLongMap;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.ImmutableObjectLongMap;
import com.gs.collections.api.map.primitive.MutableObjectLongMap;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.map.mutable.primitive.ObjectLongHashMap;

/**
 * ImmutableObjectLongHashMap is the non-modifiable equivalent of {@link ObjectLongHashMap}.
 * This file was automatically generated from template file immutableObjectPrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableObjectLongHashMap<K> extends AbstractImmutableObjectLongMap<K> implements Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableObjectLongMap<K> delegate;

    ImmutableObjectLongHashMap(ObjectLongMap<? extends K> delegate)
    {
        this.delegate = new ObjectLongHashMap<K>(delegate);
    }

    public LongIterator longIterator()
    {
        return this.delegate.longIterator();
    }

    public void forEach(LongProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(LongPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableLongCollection select(LongPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongCollection reject(LongPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return ((ObjectLongHashMap<T>) this.delegate).injectInto(injectedValue, function);
    }

    public <V> ImmutableCollection<V> collect(LongToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public long max()
    {
        return this.delegate.max();
    }

    public long maxIfEmpty(long defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public long min()
    {
        return this.delegate.min();
    }

    public long minIfEmpty(long defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public long[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }


    public MutableLongList toSortedList()
    {
        return this.delegate.toSortedList();
    }


    public long[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(long value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(long... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(LongIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableLongList toList()
    {
        return this.delegate.toList();
    }

    public MutableLongSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableLongBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyLongIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableObjectLongMap<K> newWithKeyValue(K key, long value)
    {
        ObjectLongHashMap<K> map = ObjectLongHashMap.newMap();
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableObjectLongMap<K> newWithoutKey(K key)
    {
        ObjectLongHashMap<K> map = ObjectLongHashMap.newMap();
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableObjectLongMap<K> newWithoutAllKeys(Iterable<? extends K> keys)
    {
        ObjectLongHashMap<K> map = ObjectLongHashMap.newMap();
        map.putAll(this);
        Iterator<? extends K> iterator = keys.iterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public long get(Object key)
    {
        return this.delegate.get(key);
    }

    public long getOrThrow(Object key)
    {
        return this.delegate.getOrThrow(key);
    }

    public long getIfAbsent(Object key, long ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(long value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(LongProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectLongProcedure<? super K> objectLongProcedure)
    {
        this.delegate.forEachKeyValue(objectLongProcedure);
    }

    public ImmutableObjectLongMap<K> select(ObjectLongPredicate<? super K> objectLongPredicate)
    {
        return this.delegate.select(objectLongPredicate).toImmutable();
    }

    public ImmutableObjectLongMap<K> reject(ObjectLongPredicate<? super K> objectLongPredicate)
    {
        return this.delegate.reject(objectLongPredicate).toImmutable();
    }

    public ImmutableObjectLongMap<K> toImmutable()
    {
        return this;
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public Set<K> keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableLongCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    private Object writeReplace()
    {
        return new ImmutableObjectLongMapSerializationProxy<K>(this);
    }
}
