/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.factory.map.primitive.ImmutableObjectShortMapFactory;
import com.gs.collections.api.map.primitive.ImmutableObjectShortMap;
import com.gs.collections.api.map.primitive.ObjectShortMap;

/**
 * ImmutableObjectShortMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableObjectShortMap}.
 * This file was automatically generated from template file immutableObjectPrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableObjectShortMapFactoryImpl implements ImmutableObjectShortMapFactory
{
    public <K> ImmutableObjectShortMap<K> of()
    {
        return this.with();
    }

    public <K> ImmutableObjectShortMap<K> with()
    {
        return (ImmutableObjectShortMap<K>) ImmutableObjectShortEmptyMap.INSTANCE;
    }

    public <K> ImmutableObjectShortMap<K> of(K key, short value)
    {
        return this.with(key, value);
    }

    public <K> ImmutableObjectShortMap<K> with(K key, short value)
    {
        return new ImmutableObjectShortSingletonMap<K>(key, value);
    }

    public <K> ImmutableObjectShortMap<K> ofAll(ObjectShortMap<? extends K> map)
    {
        return this.withAll(map);
    }

    public <K> ImmutableObjectShortMap<K> withAll(ObjectShortMap<? extends K> map)
    {
        if (map instanceof ImmutableObjectShortMap)
        {
            return (ImmutableObjectShortMap<K>) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            //TODO use keysView() when available.
            final Object[] array = new Object[1];
            map.forEachKey(new Procedure<K>()
            {
                public void value(K each)
                {
                    array[0] = each;
                }
            });
            return new ImmutableObjectShortSingletonMap<K>((K) array[0], map.get(array[0]));
        }
        return new ImmutableObjectShortHashMap<K>(map);
    }
}
