/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableShortBooleanMapFactory;
import com.gs.collections.api.map.primitive.ImmutableShortBooleanMap;
import com.gs.collections.api.map.primitive.ShortBooleanMap;

/**
 * ImmutableShortBooleanMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableShortBooleanMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableShortBooleanMapFactoryImpl implements ImmutableShortBooleanMapFactory
{
    public ImmutableShortBooleanMap of()
    {
        return this.with();
    }

    public ImmutableShortBooleanMap with()
    {
        return ImmutableShortBooleanEmptyMap.INSTANCE;
    }

    public ImmutableShortBooleanMap of(short key, boolean value)
    {
        return this.with(key, value);
    }

    public ImmutableShortBooleanMap with(short key, boolean value)
    {
        return new ImmutableShortBooleanSingletonMap(key, value);
    }

    public ImmutableShortBooleanMap ofAll(ShortBooleanMap map)
    {
        return this.withAll(map);
    }

    public ImmutableShortBooleanMap withAll(ShortBooleanMap map)
    {
        if (map instanceof ImmutableShortBooleanMap)
        {
            return (ImmutableShortBooleanMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            short key = map.keysView().shortIterator().next();
            return new ImmutableShortBooleanSingletonMap(key, map.get(key));
        }
        return new ImmutableShortBooleanHashMap(map);
    }
}
