/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableShortCharMapFactory;
import com.gs.collections.api.map.primitive.ImmutableShortCharMap;
import com.gs.collections.api.map.primitive.ShortCharMap;

/**
 * ImmutableShortCharMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableShortCharMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableShortCharMapFactoryImpl implements ImmutableShortCharMapFactory
{
    public ImmutableShortCharMap of()
    {
        return this.with();
    }

    public ImmutableShortCharMap with()
    {
        return ImmutableShortCharEmptyMap.INSTANCE;
    }

    public ImmutableShortCharMap of(short key, char value)
    {
        return this.with(key, value);
    }

    public ImmutableShortCharMap with(short key, char value)
    {
        return new ImmutableShortCharSingletonMap(key, value);
    }

    public ImmutableShortCharMap ofAll(ShortCharMap map)
    {
        return this.withAll(map);
    }

    public ImmutableShortCharMap withAll(ShortCharMap map)
    {
        if (map instanceof ImmutableShortCharMap)
        {
            return (ImmutableShortCharMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            short key = map.keysView().shortIterator().next();
            return new ImmutableShortCharSingletonMap(key, map.get(key));
        }
        return new ImmutableShortCharHashMap(map);
    }
}
