/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.factory.map.primitive.ImmutableShortObjectMapFactory;
import com.gs.collections.api.map.primitive.ImmutableShortObjectMap;
import com.gs.collections.api.map.primitive.ShortObjectMap;

/**
 * ImmutableShortObjectMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableShortObjectMap}.
 * This file was automatically generated from template file immutablePrimitiveObjectMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableShortObjectMapFactoryImpl implements ImmutableShortObjectMapFactory
{
    public <V> ImmutableShortObjectMap<V> of()
    {
        return this.with();
    }

    public <V> ImmutableShortObjectMap<V> with()
    {
        return (ImmutableShortObjectMap<V>) ImmutableShortObjectEmptyMap.INSTANCE;
    }

    public <V> ImmutableShortObjectMap<V> of(short key, V value)
    {
        return this.with(key, value);
    }

    public <V> ImmutableShortObjectMap<V> with(short key, V value)
    {
        return new ImmutableShortObjectSingletonMap<V>(key, value);
    }

    public <V> ImmutableShortObjectMap<V> ofAll(ShortObjectMap<? extends V> map)
    {
        return this.withAll(map);
    }

    public <V> ImmutableShortObjectMap<V> withAll(ShortObjectMap<? extends V> map)
    {
        if (map instanceof ImmutableShortObjectMap)
        {
            return (ImmutableShortObjectMap<V>) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            //TODO use keysView() when available.
            final short[] array = new short[1];
            map.forEachKey(new ShortProcedure()
            {
                public void value(short each)
                {
                    array[0] = each;
                }
            });
            return new ImmutableShortObjectSingletonMap<V>(array[0], map.get(array[0]));
        }
        return new ImmutableShortObjectHashMap<V>(map);
    }
}
