/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction0;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.CharToIntFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.predicate.primitive.CharIntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.CharIntProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.ImmutableCharIntMap;
import com.gs.collections.api.map.primitive.CharIntMap;
import com.gs.collections.api.map.primitive.MutableCharIntMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.factory.primitive.CharIntMaps;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableCharIntMap
        implements MutableCharIntMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableCharIntMap map;

    UnmodifiableCharIntMap(MutableCharIntMap map)
    {
        this.map = map;
    }

    private boolean isAbsent(int result, char key)
    {
        return result == CharIntHashMap.EMPTY_VALUE && !this.containsKey(key);
    }

    private int getIfAbsentThrow(char key)
    {
        int result = this.map.get(key);
        if (this.isAbsent(result, key))
        {
            throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(char key, int value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(CharIntMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(char key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(char key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public int removeKeyIfAbsent(char key, int value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public int getIfAbsentPut(char key, int value)
    {
        return this.getIfAbsentThrow(key);
    }

    public int getIfAbsentPut(char key, IntFunction0 function)
    {
        return this.getIfAbsentThrow(key);
    }

    public int getIfAbsentPutWithKey(char key, CharToIntFunction function)
    {
        return this.getIfAbsentThrow(key);
    }

    public <P> int getIfAbsentPutWith(char key, IntFunction<? super P> function, P parameter)
    {
        return this.getIfAbsentThrow(key);
    }

    public int updateValue(char key, int initialValueIfAbsent, IntToIntFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public int get(char key)
    {
        return this.map.get(key);
    }

    public int getIfAbsent(char key, int ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public int getOrThrow(char key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(char key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(int value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(IntProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(CharProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(CharIntProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyCharIterable keysView()
    {
        return this.map.keysView();
    }

    public MutableCharIntMap select(CharIntPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableCharIntMap reject(CharIntPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public IntIterator intIterator()
    {
        return this.map.intIterator();
    }

    public void forEach(IntProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(IntPredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableIntCollection select(IntPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableIntCollection reject(IntPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public long sum()
    {
        return this.map.sum();
    }

    public int max()
    {
        return this.map.max();
    }

    public int maxIfEmpty(int defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public int min()
    {
        return this.map.min();
    }

    public int minIfEmpty(int defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public int[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableIntList toSortedList()
    {
        return this.map.toSortedList();
    }

    public int[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(int value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(int... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(IntIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableIntList toList()
    {
        return this.map.toList();
    }

    public MutableIntSet toSet()
    {
        return this.map.toSet();
    }

    public MutableIntBag toBag()
    {
        return this.map.toBag();
    }

    public LazyIntIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableCharIntMap withKeyValue(char key, int value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableCharIntMap withoutKey(char key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableCharIntMap withoutAllKeys(CharIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableCharIntMap asUnmodifiable()
    {
        return this;
    }

    public MutableCharIntMap asSynchronized()
    {
        return new SynchronizedCharIntMap(this);
    }

    public ImmutableCharIntMap toImmutable()
    {
        return CharIntMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableCharSet keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableIntCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }
}
