/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction0;
import com.gs.collections.api.block.function.primitive.ShortToShortFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.CharToShortFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.predicate.primitive.CharShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.block.procedure.primitive.CharShortProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.ImmutableCharShortMap;
import com.gs.collections.api.map.primitive.CharShortMap;
import com.gs.collections.api.map.primitive.MutableCharShortMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.factory.primitive.CharShortMaps;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableCharShortMap
        implements MutableCharShortMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableCharShortMap map;

    UnmodifiableCharShortMap(MutableCharShortMap map)
    {
        this.map = map;
    }

    private boolean isAbsent(short result, char key)
    {
        return result == CharShortHashMap.EMPTY_VALUE && !this.containsKey(key);
    }

    private short getIfAbsentThrow(char key)
    {
        short result = this.map.get(key);
        if (this.isAbsent(result, key))
        {
            throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(char key, short value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(CharShortMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(char key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(char key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public short removeKeyIfAbsent(char key, short value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public short getIfAbsentPut(char key, short value)
    {
        return this.getIfAbsentThrow(key);
    }

    public short getIfAbsentPut(char key, ShortFunction0 function)
    {
        return this.getIfAbsentThrow(key);
    }

    public short getIfAbsentPutWithKey(char key, CharToShortFunction function)
    {
        return this.getIfAbsentThrow(key);
    }

    public <P> short getIfAbsentPutWith(char key, ShortFunction<? super P> function, P parameter)
    {
        return this.getIfAbsentThrow(key);
    }

    public short updateValue(char key, short initialValueIfAbsent, ShortToShortFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public short get(char key)
    {
        return this.map.get(key);
    }

    public short getIfAbsent(char key, short ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public short getOrThrow(char key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(char key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(short value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(ShortProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(CharProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(CharShortProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyCharIterable keysView()
    {
        return this.map.keysView();
    }

    public MutableCharShortMap select(CharShortPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableCharShortMap reject(CharShortPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public ShortIterator shortIterator()
    {
        return this.map.shortIterator();
    }

    public void forEach(ShortProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(ShortPredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableShortCollection select(ShortPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableShortCollection reject(ShortPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public long sum()
    {
        return this.map.sum();
    }

    public short max()
    {
        return this.map.max();
    }

    public short maxIfEmpty(short defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public short min()
    {
        return this.map.min();
    }

    public short minIfEmpty(short defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public short[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableShortList toSortedList()
    {
        return this.map.toSortedList();
    }

    public short[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(short value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(short... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(ShortIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableShortList toList()
    {
        return this.map.toList();
    }

    public MutableShortSet toSet()
    {
        return this.map.toSet();
    }

    public MutableShortBag toBag()
    {
        return this.map.toBag();
    }

    public LazyShortIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableCharShortMap withKeyValue(char key, short value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableCharShortMap withoutKey(char key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableCharShortMap withoutAllKeys(CharIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableCharShortMap asUnmodifiable()
    {
        return this;
    }

    public MutableCharShortMap asSynchronized()
    {
        return new SynchronizedCharShortMap(this);
    }

    public ImmutableCharShortMap toImmutable()
    {
        return CharShortMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableCharSet keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableShortCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }
}
