/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction0;
import com.gs.collections.api.block.function.primitive.ByteToByteFunction;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.FloatToByteFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.FloatBytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatByteProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.map.primitive.ImmutableFloatByteMap;
import com.gs.collections.api.map.primitive.FloatByteMap;
import com.gs.collections.api.map.primitive.MutableFloatByteMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.impl.factory.primitive.FloatByteMaps;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableFloatByteMap
        implements MutableFloatByteMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableFloatByteMap map;

    UnmodifiableFloatByteMap(MutableFloatByteMap map)
    {
        this.map = map;
    }

    private boolean isAbsent(byte result, float key)
    {
        return result == FloatByteHashMap.EMPTY_VALUE && !this.containsKey(key);
    }

    private byte getIfAbsentThrow(float key)
    {
        byte result = this.map.get(key);
        if (this.isAbsent(result, key))
        {
            throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(float key, byte value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(FloatByteMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(float key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(float key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public byte removeKeyIfAbsent(float key, byte value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public byte getIfAbsentPut(float key, byte value)
    {
        return this.getIfAbsentThrow(key);
    }

    public byte getIfAbsentPut(float key, ByteFunction0 function)
    {
        return this.getIfAbsentThrow(key);
    }

    public byte getIfAbsentPutWithKey(float key, FloatToByteFunction function)
    {
        return this.getIfAbsentThrow(key);
    }

    public <P> byte getIfAbsentPutWith(float key, ByteFunction<? super P> function, P parameter)
    {
        return this.getIfAbsentThrow(key);
    }

    public byte updateValue(float key, byte initialValueIfAbsent, ByteToByteFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public byte get(float key)
    {
        return this.map.get(key);
    }

    public byte getIfAbsent(float key, byte ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public byte getOrThrow(float key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(float key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(byte value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(ByteProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(FloatProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(FloatByteProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyFloatIterable keysView()
    {
        return this.map.keysView();
    }

    public MutableFloatByteMap select(FloatBytePredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableFloatByteMap reject(FloatBytePredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public ByteIterator byteIterator()
    {
        return this.map.byteIterator();
    }

    public void forEach(ByteProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(BytePredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableByteCollection select(BytePredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableByteCollection reject(BytePredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public long sum()
    {
        return this.map.sum();
    }

    public byte max()
    {
        return this.map.max();
    }

    public byte maxIfEmpty(byte defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public byte min()
    {
        return this.map.min();
    }

    public byte minIfEmpty(byte defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public byte[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableByteList toSortedList()
    {
        return this.map.toSortedList();
    }

    public byte[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(byte value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(byte... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(ByteIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableByteList toList()
    {
        return this.map.toList();
    }

    public MutableByteSet toSet()
    {
        return this.map.toSet();
    }

    public MutableByteBag toBag()
    {
        return this.map.toBag();
    }

    public LazyByteIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableFloatByteMap withKeyValue(float key, byte value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableFloatByteMap withoutKey(float key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableFloatByteMap withoutAllKeys(FloatIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableFloatByteMap asUnmodifiable()
    {
        return this;
    }

    public MutableFloatByteMap asSynchronized()
    {
        return new SynchronizedFloatByteMap(this);
    }

    public ImmutableFloatByteMap toImmutable()
    {
        return FloatByteMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableFloatSet keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableByteCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }
}
