/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction0;
import com.gs.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.IntToDoubleFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.predicate.primitive.IntDoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.IntDoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.ImmutableIntDoubleMap;
import com.gs.collections.api.map.primitive.IntDoubleMap;
import com.gs.collections.api.map.primitive.MutableIntDoubleMap;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.factory.primitive.IntDoubleMaps;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableIntDoubleMap
        implements MutableIntDoubleMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableIntDoubleMap map;

    UnmodifiableIntDoubleMap(MutableIntDoubleMap map)
    {
        this.map = map;
    }

    private boolean isAbsent(double result, int key)
    {
        return result == IntDoubleHashMap.EMPTY_VALUE && !this.containsKey(key);
    }

    private double getIfAbsentThrow(int key)
    {
        double result = this.map.get(key);
        if (this.isAbsent(result, key))
        {
            throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(int key, double value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(IntDoubleMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(int key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(int key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public double removeKeyIfAbsent(int key, double value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public double getIfAbsentPut(int key, double value)
    {
        return this.getIfAbsentThrow(key);
    }

    public double getIfAbsentPut(int key, DoubleFunction0 function)
    {
        return this.getIfAbsentThrow(key);
    }

    public double getIfAbsentPutWithKey(int key, IntToDoubleFunction function)
    {
        return this.getIfAbsentThrow(key);
    }

    public <P> double getIfAbsentPutWith(int key, DoubleFunction<? super P> function, P parameter)
    {
        return this.getIfAbsentThrow(key);
    }

    public double updateValue(int key, double initialValueIfAbsent, DoubleToDoubleFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public double get(int key)
    {
        return this.map.get(key);
    }

    public double getIfAbsent(int key, double ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public double getOrThrow(int key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(int key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(double value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(DoubleProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(IntProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(IntDoubleProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyIntIterable keysView()
    {
        return this.map.keysView();
    }

    public MutableIntDoubleMap select(IntDoublePredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableIntDoubleMap reject(IntDoublePredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public DoubleIterator doubleIterator()
    {
        return this.map.doubleIterator();
    }

    public void forEach(DoubleProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(DoublePredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(DoublePredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(DoublePredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(DoublePredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableDoubleCollection select(DoublePredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableDoubleCollection reject(DoublePredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public double sum()
    {
        return this.map.sum();
    }

    public double max()
    {
        return this.map.max();
    }

    public double maxIfEmpty(double defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public double min()
    {
        return this.map.min();
    }

    public double minIfEmpty(double defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public double[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableDoubleList toSortedList()
    {
        return this.map.toSortedList();
    }

    public double[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(double value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(double... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(DoubleIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableDoubleList toList()
    {
        return this.map.toList();
    }

    public MutableDoubleSet toSet()
    {
        return this.map.toSet();
    }

    public MutableDoubleBag toBag()
    {
        return this.map.toBag();
    }

    public LazyDoubleIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableIntDoubleMap withKeyValue(int key, double value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableIntDoubleMap withoutKey(int key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableIntDoubleMap withoutAllKeys(IntIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableIntDoubleMap asUnmodifiable()
    {
        return this;
    }

    public MutableIntDoubleMap asSynchronized()
    {
        return new SynchronizedIntDoubleMap(this);
    }

    public ImmutableIntDoubleMap toImmutable()
    {
        return IntDoubleMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableIntSet keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableDoubleCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }
}
