/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction0;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.predicate.primitive.LongLongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongLongProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.ImmutableLongLongMap;
import com.gs.collections.api.map.primitive.LongLongMap;
import com.gs.collections.api.map.primitive.MutableLongLongMap;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.factory.primitive.LongLongMaps;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableLongLongMap
        implements MutableLongLongMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableLongLongMap map;

    UnmodifiableLongLongMap(MutableLongLongMap map)
    {
        this.map = map;
    }

    private boolean isAbsent(long result, long key)
    {
        return result == LongLongHashMap.EMPTY_VALUE && !this.containsKey(key);
    }

    private long getIfAbsentThrow(long key)
    {
        long result = this.map.get(key);
        if (this.isAbsent(result, key))
        {
            throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(long key, long value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(LongLongMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(long key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(long key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public long removeKeyIfAbsent(long key, long value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public long getIfAbsentPut(long key, long value)
    {
        return this.getIfAbsentThrow(key);
    }

    public long getIfAbsentPut(long key, LongFunction0 function)
    {
        return this.getIfAbsentThrow(key);
    }

    public long getIfAbsentPutWithKey(long key, LongToLongFunction function)
    {
        return this.getIfAbsentThrow(key);
    }

    public <P> long getIfAbsentPutWith(long key, LongFunction<? super P> function, P parameter)
    {
        return this.getIfAbsentThrow(key);
    }

    public long updateValue(long key, long initialValueIfAbsent, LongToLongFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public long get(long key)
    {
        return this.map.get(key);
    }

    public long getIfAbsent(long key, long ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public long getOrThrow(long key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(long key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(long value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(LongProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(LongProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(LongLongProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyLongIterable keysView()
    {
        return this.map.keysView();
    }

    public MutableLongLongMap select(LongLongPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableLongLongMap reject(LongLongPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public LongIterator longIterator()
    {
        return this.map.longIterator();
    }

    public void forEach(LongProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(LongPredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableLongCollection select(LongPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableLongCollection reject(LongPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public long sum()
    {
        return this.map.sum();
    }

    public long max()
    {
        return this.map.max();
    }

    public long maxIfEmpty(long defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public long min()
    {
        return this.map.min();
    }

    public long minIfEmpty(long defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public long[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableLongList toSortedList()
    {
        return this.map.toSortedList();
    }

    public long[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(long value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(long... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(LongIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableLongList toList()
    {
        return this.map.toList();
    }

    public MutableLongSet toSet()
    {
        return this.map.toSet();
    }

    public MutableLongBag toBag()
    {
        return this.map.toBag();
    }

    public LazyLongIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableLongLongMap withKeyValue(long key, long value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableLongLongMap withoutKey(long key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableLongLongMap withoutAllKeys(LongIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableLongLongMap asUnmodifiable()
    {
        return this;
    }

    public MutableLongLongMap asSynchronized()
    {
        return new SynchronizedLongLongMap(this);
    }

    public ImmutableLongLongMap toImmutable()
    {
        return LongLongMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableLongSet keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableLongCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }
}
