/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.ImmutableByteSet;
import com.gs.collections.api.set.primitive.ByteSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.ByteSets;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import net.jcip.annotations.Immutable;

/**
 * ImmutableByteEmptySet is an optimization for {@link ImmutableByteSet} of size 0.
 * This file was automatically generated from template file immutablePrimitiveEmptySet.stg.
 *
 * @since 4.0.
 */
@Immutable
final class ImmutableByteEmptySet implements ImmutableByteSet, Serializable
{
    private static final long serialVersionUID = 1L;

    static final ImmutableByteSet INSTANCE = new ImmutableByteEmptySet();

    private Object readResolve()
    {
        return INSTANCE;
    }

    public ImmutableByteSet newWith(byte element)
    {
        return new ImmutableByteSingletonSet(element);
    }

    public ImmutableByteSet newWithout(byte element)
    {
        return this;
    }

    public ImmutableByteSet newWithAll(ByteIterable elements)
    {
        return ByteSets.immutable.withAll(elements);
    }

    public ImmutableByteSet newWithoutAll(ByteIterable elements)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public boolean contains(byte value)
    {
        return false;
    }

    public boolean containsAll(ByteIterable source)
    {
        return source.isEmpty();
    }

    public boolean containsAll(byte... elements)
    {
        return elements.length == 0;
    }

    public void forEach(ByteProcedure procedure)
    {
    }

    public ImmutableByteSet select(BytePredicate predicate)
    {
        return this;
    }

    public ImmutableByteSet reject(BytePredicate predicate)
    {
        return this;
    }

    public <V> ImmutableSet<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return Sets.immutable.of();
    }

    public MutableByteList toList()
    {
        return new ByteArrayList();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return ifNone;
    }

    public int count(BytePredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return false;
    }

    public long sum()
    {
        return 0L;
    }

    public byte min()
    {
        throw new NoSuchElementException();
    }

    public byte max()
    {
        throw new NoSuchElementException();
    }

    public byte maxIfEmpty(byte defaultValue)
    {
        return defaultValue;
    }

    public byte minIfEmpty(byte defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public byte[] toSortedArray()
    {
        return new byte[0];
    }

    public MutableByteList toSortedList()
    {
        return new ByteArrayList();
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return true;
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ByteSet))
        {
            return false;
        }
        ByteSet set = (ByteSet) obj;
        return set.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    public MutableByteSet toSet()
    {
        return new ByteHashSet();
    }

    public MutableByteBag toBag()
    {
        return new ByteHashBag();
    }

    public ByteSet freeze()
    {
        return this;
    }

    public ImmutableByteSet toImmutable()
    {
        return this;
    }

    public LazyByteIterable asLazy()
    {
        return new LazyByteIterableAdapter(this);
    }

    public byte[] toArray()
    {
        return new byte[0];
    }

    @Override
    public String toString()
    {
        return "[]";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public ByteIterator byteIterator()
    {
        return new InternalByteIterator();
    }

    private static class InternalByteIterator implements ByteIterator
    {
        public boolean hasNext()
        {
            return false;
        }

        public byte next()
        {
            throw new NoSuchElementException();
        }
    }
}
