/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableCharSet;
import com.gs.collections.api.set.primitive.CharSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.collection.mutable.primitive.AbstractUnmodifiableCharCollection;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveSet.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableCharSet
        extends AbstractUnmodifiableCharCollection
        implements MutableCharSet
{
    private static final long serialVersionUID = 1L;

    UnmodifiableCharSet(MutableCharSet set)
    {
        super(set);
    }

    /**
     * This method will take a MutableCharSet and wrap it directly in a UnmodifiableCharSet.
     */
    public static UnmodifiableCharSet of(MutableCharSet set)
    {
        if (set == null)
        {
            throw new IllegalArgumentException("cannot create an UnmodifiableCharSet for null");
        }
        return new UnmodifiableCharSet(set);
    }

    private MutableCharSet getMutableCharSet()
    {
        return (MutableCharSet) this.getCharCollection();
    }

    @Override
    public UnmodifiableCharSet with(char element)
    {
        throw new UnsupportedOperationException("Cannot call with on an UnmodifiableCharSet");
    }

    @Override
    public UnmodifiableCharSet without(char element)
    {
        throw new UnsupportedOperationException("Cannot call without on an UnmodifiableCharSet");
    }

    @Override
    public UnmodifiableCharSet withAll(CharIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll on an UnmodifiableCharSet");
    }

    @Override
    public UnmodifiableCharSet withoutAll(CharIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll on an UnmodifiableCharSet");
    }

    @Override
    public MutableCharSet select(CharPredicate predicate)
    {
        return this.getMutableCharSet().select(predicate);
    }

    @Override
    public MutableCharSet reject(CharPredicate predicate)
    {
        return this.getMutableCharSet().reject(predicate);
    }

    @Override
    public <V> MutableSet<V> collect(CharToObjectFunction<? extends V> function)
    {
        return this.getMutableCharSet().collect(function);
    }

    @Override
    public boolean equals(Object otherSet)
    {
        return this.getMutableCharSet().equals(otherSet);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableCharSet().hashCode();
    }

    @Override
    public LazyCharIterable asLazy()
    {
        return new LazyCharIterableAdapter(this);
    }

    @Override
    public MutableCharSet asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableCharSet asSynchronized()
    {
        return new SynchronizedCharSet(this);
    }

    public CharSet freeze()
    {
        return this.getMutableCharSet().freeze();
    }

    @Override
    public ImmutableCharSet toImmutable()
    {
        return this.getMutableCharSet().toImmutable();
    }
}
