/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.factory.stack.primitive.ImmutableBooleanStackFactory;
import com.gs.collections.api.stack.primitive.ImmutableBooleanStack;

/**
 * ImmutableBooleanStackFactoryImpl is a factory implementation which creates instances of type {@link ImmutableBooleanStack}.
 * This file was automatically generated from template file immutablePrimitiveStackFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableBooleanStackFactoryImpl implements ImmutableBooleanStackFactory
{
    public ImmutableBooleanStack of()
    {
        return this.with();
    }

    public ImmutableBooleanStack with()
    {
        return ImmutableBooleanEmptyStack.INSTANCE;
    }

    public ImmutableBooleanStack of(boolean one)
    {
        return this.with(one);
    }

    public ImmutableBooleanStack with(boolean one)
    {
        return new ImmutableBooleanSingletonStack(one);
    }

    public ImmutableBooleanStack of(boolean... items)
    {
        return this.with(items);
    }

    public ImmutableBooleanStack with(boolean... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableBooleanArrayStack.newStackWith(items);
    }

    public ImmutableBooleanStack ofAll(BooleanIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableBooleanStack withAll(BooleanIterable items)
    {
        if (items instanceof ImmutableBooleanStack)
        {
            return (ImmutableBooleanStack) items;
        }
        return this.with(items.toArray());
    }

    public ImmutableBooleanStack ofAllReversed(BooleanIterable items)
    {
        return this.withAllReversed(items);
    }

    public ImmutableBooleanStack withAllReversed(BooleanIterable items)
    {
        if (items == null || items.isEmpty())
        {
            return this.with();
        }
        if (items.size() == 1)
        {
            return this.with(items.toArray());
        }
        return ImmutableBooleanArrayStack.newStackFromTopToBottom(items);
    }
}
