/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.FloatList;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.stack.ImmutableStack;
import com.gs.collections.api.stack.primitive.ImmutableFloatStack;
import com.gs.collections.api.stack.primitive.FloatStack;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.factory.primitive.FloatStacks;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import net.jcip.annotations.Immutable;

/**
 * ImmutableFloatEmptyStack is an optimization for {@link ImmutableFloatStack} of size 0.
 * This file was automatically generated from template file immutablePrimitiveEmptyStack.stg.
 */
@Immutable
final class ImmutableFloatEmptyStack implements ImmutableFloatStack, Serializable
{
    static final ImmutableFloatStack INSTANCE = new ImmutableFloatEmptyStack();
    private static final long serialVersionUID = 1L;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public FloatIterator floatIterator()
    {
        return new InternalFloatIterator();
    }

    public void forEach(FloatProcedure procedure)
    {
    }

    public int count(FloatPredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(FloatPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(FloatPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(FloatPredicate predicate)
    {
        return true;
    }

    public float peek()
    {
        throw new EmptyStackException();
    }

    public FloatList peek(int count)
    {
        this.checkNegativeCount(count);
        if (count == 0)
        {
            return new FloatArrayList(0);
        }
        throw new EmptyStackException();
    }

    public float peekAt(int index)
    {
        this.checkNegativeCount(index);
        throw new EmptyStackException();
    }

    public ImmutableFloatStack select(FloatPredicate predicate)
    {
        return this;
    }

    public ImmutableFloatStack reject(FloatPredicate predicate)
    {
        return this;
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableStack<V> collect(FloatToObjectFunction<? extends V> function)
    {
        return Stacks.immutable.of();
    }

    public double sum()
    {
        return 0;
    }

    public float max()
    {
        throw new NoSuchElementException();
    }

    public float maxIfEmpty(float defaultValue)
    {
        return defaultValue;
    }

    public float min()
    {
        throw new NoSuchElementException();
    }

    public float minIfEmpty(float defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public float[] toSortedArray()
    {
        return new float[0];
    }

    public MutableFloatList toSortedList()
    {
        return new FloatArrayList();
    }

    public float[] toArray()
    {
        return new float[0];
    }

    public boolean contains(float value)
    {
        return false;
    }

    public boolean containsAll(float... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(FloatIterable source)
    {
        return source.isEmpty();
    }

    public MutableFloatList toList()
    {
        return new FloatArrayList();
    }

    public MutableFloatSet toSet()
    {
        return new FloatHashSet();
    }

    public MutableFloatBag toBag()
    {
        return new FloatHashBag();
    }

    public LazyFloatIterable asLazy()
    {
        return new LazyFloatIterableAdapter(this);
    }

    public ImmutableFloatStack toImmutable()
    {
        return this;
    }

    public ImmutableFloatStack push(float element)
    {
        return FloatStacks.immutable.with(element);
    }

    public ImmutableFloatStack pop()
    {
        throw new EmptyStackException();
    }

    public ImmutableFloatStack pop(int count)
    {
        this.checkNegativeCount(count);
        if (count == 0)
        {
            return this;
        }
        throw new EmptyStackException();
    }

    private void checkNegativeCount(int count)
    {
        if (count < 0)
        {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    @Override
    public boolean equals(Object otherStack)
    {
        if (otherStack == this)
        {
            return true;
        }
        if (!(otherStack instanceof FloatStack))
        {
            return false;
        }
        FloatStack stack = (FloatStack) otherStack;
        return stack.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 1;
    }

    @Override
    public String toString()
    {
        return "[]";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    private static class InternalFloatIterator implements FloatIterator
    {
        public boolean hasNext()
        {
            return false;
        }

        public float next()
        {
            throw new NoSuchElementException();
        }
    }
}
