/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.factory.stack.primitive.ImmutableFloatStackFactory;
import com.gs.collections.api.stack.primitive.ImmutableFloatStack;

/**
 * ImmutableFloatStackFactoryImpl is a factory implementation which creates instances of type {@link ImmutableFloatStack}.
 * This file was automatically generated from template file immutablePrimitiveStackFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableFloatStackFactoryImpl implements ImmutableFloatStackFactory
{
    public ImmutableFloatStack of()
    {
        return this.with();
    }

    public ImmutableFloatStack with()
    {
        return ImmutableFloatEmptyStack.INSTANCE;
    }

    public ImmutableFloatStack of(float one)
    {
        return this.with(one);
    }

    public ImmutableFloatStack with(float one)
    {
        return new ImmutableFloatSingletonStack(one);
    }

    public ImmutableFloatStack of(float... items)
    {
        return this.with(items);
    }

    public ImmutableFloatStack with(float... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableFloatArrayStack.newStackWith(items);
    }

    public ImmutableFloatStack ofAll(FloatIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableFloatStack withAll(FloatIterable items)
    {
        if (items instanceof ImmutableFloatStack)
        {
            return (ImmutableFloatStack) items;
        }
        return this.with(items.toArray());
    }

    public ImmutableFloatStack ofAllReversed(FloatIterable items)
    {
        return this.withAllReversed(items);
    }

    public ImmutableFloatStack withAllReversed(FloatIterable items)
    {
        if (items == null || items.isEmpty())
        {
            return this.with();
        }
        if (items.size() == 1)
        {
            return this.with(items.toArray());
        }
        return ImmutableFloatArrayStack.newStackFromTopToBottom(items);
    }
}
