/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.factory.stack.primitive.ImmutableIntStackFactory;
import com.gs.collections.api.stack.primitive.ImmutableIntStack;

/**
 * ImmutableIntStackFactoryImpl is a factory implementation which creates instances of type {@link ImmutableIntStack}.
 * This file was automatically generated from template file immutablePrimitiveStackFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableIntStackFactoryImpl implements ImmutableIntStackFactory
{
    public ImmutableIntStack of()
    {
        return this.with();
    }

    public ImmutableIntStack with()
    {
        return ImmutableIntEmptyStack.INSTANCE;
    }

    public ImmutableIntStack of(int one)
    {
        return this.with(one);
    }

    public ImmutableIntStack with(int one)
    {
        return new ImmutableIntSingletonStack(one);
    }

    public ImmutableIntStack of(int... items)
    {
        return this.with(items);
    }

    public ImmutableIntStack with(int... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableIntArrayStack.newStackWith(items);
    }

    public ImmutableIntStack ofAll(IntIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableIntStack withAll(IntIterable items)
    {
        if (items instanceof ImmutableIntStack)
        {
            return (ImmutableIntStack) items;
        }
        return this.with(items.toArray());
    }

    public ImmutableIntStack ofAllReversed(IntIterable items)
    {
        return this.withAllReversed(items);
    }

    public ImmutableIntStack withAllReversed(IntIterable items)
    {
        if (items == null || items.isEmpty())
        {
            return this.with();
        }
        if (items.size() == 1)
        {
            return this.with(items.toArray());
        }
        return ImmutableIntArrayStack.newStackFromTopToBottom(items);
    }
}
