/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.LongList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.stack.ImmutableStack;
import com.gs.collections.api.stack.primitive.ImmutableLongStack;
import com.gs.collections.api.stack.primitive.LongStack;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.factory.primitive.LongStacks;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import net.jcip.annotations.Immutable;

/**
 * ImmutableLongEmptyStack is an optimization for {@link ImmutableLongStack} of size 0.
 * This file was automatically generated from template file immutablePrimitiveEmptyStack.stg.
 */
@Immutable
final class ImmutableLongEmptyStack implements ImmutableLongStack, Serializable
{
    static final ImmutableLongStack INSTANCE = new ImmutableLongEmptyStack();
    private static final long serialVersionUID = 1L;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public LongIterator longIterator()
    {
        return new InternalLongIterator();
    }

    public void forEach(LongProcedure procedure)
    {
    }

    public int count(LongPredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return true;
    }

    public long peek()
    {
        throw new EmptyStackException();
    }

    public LongList peek(int count)
    {
        this.checkNegativeCount(count);
        if (count == 0)
        {
            return new LongArrayList(0);
        }
        throw new EmptyStackException();
    }

    public long peekAt(int index)
    {
        this.checkNegativeCount(index);
        throw new EmptyStackException();
    }

    public ImmutableLongStack select(LongPredicate predicate)
    {
        return this;
    }

    public ImmutableLongStack reject(LongPredicate predicate)
    {
        return this;
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableStack<V> collect(LongToObjectFunction<? extends V> function)
    {
        return Stacks.immutable.of();
    }

    public long sum()
    {
        return 0;
    }

    public long max()
    {
        throw new NoSuchElementException();
    }

    public long maxIfEmpty(long defaultValue)
    {
        return defaultValue;
    }

    public long min()
    {
        throw new NoSuchElementException();
    }

    public long minIfEmpty(long defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public long[] toSortedArray()
    {
        return new long[0];
    }

    public MutableLongList toSortedList()
    {
        return new LongArrayList();
    }

    public long[] toArray()
    {
        return new long[0];
    }

    public boolean contains(long value)
    {
        return false;
    }

    public boolean containsAll(long... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(LongIterable source)
    {
        return source.isEmpty();
    }

    public MutableLongList toList()
    {
        return new LongArrayList();
    }

    public MutableLongSet toSet()
    {
        return new LongHashSet();
    }

    public MutableLongBag toBag()
    {
        return new LongHashBag();
    }

    public LazyLongIterable asLazy()
    {
        return new LazyLongIterableAdapter(this);
    }

    public ImmutableLongStack toImmutable()
    {
        return this;
    }

    public ImmutableLongStack push(long element)
    {
        return LongStacks.immutable.with(element);
    }

    public ImmutableLongStack pop()
    {
        throw new EmptyStackException();
    }

    public ImmutableLongStack pop(int count)
    {
        this.checkNegativeCount(count);
        if (count == 0)
        {
            return this;
        }
        throw new EmptyStackException();
    }

    private void checkNegativeCount(int count)
    {
        if (count < 0)
        {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    @Override
    public boolean equals(Object otherStack)
    {
        if (otherStack == this)
        {
            return true;
        }
        if (!(otherStack instanceof LongStack))
        {
            return false;
        }
        LongStack stack = (LongStack) otherStack;
        return stack.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 1;
    }

    @Override
    public String toString()
    {
        return "[]";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    private static class InternalLongIterator implements LongIterator
    {
        public boolean hasNext()
        {
            return false;
        }

        public long next()
        {
            throw new NoSuchElementException();
        }
    }
}
