/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.ByteBag;
import com.gs.collections.api.bag.primitive.ImmutableByteBag;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.impl.Counter;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.bag.mutable.primitive.SynchronizedByteBag;
import com.gs.collections.impl.bag.mutable.primitive.UnmodifiableByteBag;
import com.gs.collections.impl.block.factory.primitive.IntToIntFunctions;
import com.gs.collections.impl.factory.primitive.ByteBags;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.map.mutable.primitive.ByteIntHashMap;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class ByteHashBag
implements MutableByteBag,
Externalizable {
    private static final long serialVersionUID = 1L;
    private ByteIntHashMap items;
    private int size;

    public ByteHashBag() {
        this.items = new ByteIntHashMap();
    }

    public ByteHashBag(int size) {
        this.items = new ByteIntHashMap(size);
    }

    public ByteHashBag(ByteIterable iterable) {
        this();
        this.addAll(iterable);
    }

    public ByteHashBag(ByteHashBag bag) {
        this.items = new ByteIntHashMap(bag.sizeDistinct());
        bag.forEachWithOccurrences(new ByteIntProcedure(){

            public void value(byte item, int occurrences) {
                ByteHashBag.this.addOccurrences(item, occurrences);
            }
        });
    }

    public static ByteHashBag newBag(int size) {
        return new ByteHashBag(size);
    }

    public static ByteHashBag newBagWith(byte ... source) {
        ByteHashBag result = new ByteHashBag();
        result.addAll(source);
        return result;
    }

    public static ByteHashBag newBag(ByteIterable source) {
        if (source instanceof ByteHashBag) {
            return new ByteHashBag((ByteHashBag)source);
        }
        return new ByteHashBag(source);
    }

    public static ByteHashBag newBag(ByteBag source) {
        final ByteHashBag result = new ByteHashBag();
        source.forEachWithOccurrences(new ByteIntProcedure(){

            public void value(byte each, int occurrences) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean notEmpty() {
        return this.items.notEmpty();
    }

    public int size() {
        return this.size;
    }

    public int sizeDistinct() {
        return this.items.size();
    }

    public void clear() {
        this.items.clear();
        this.size = 0;
    }

    public ByteHashBag with(byte element) {
        this.add(element);
        return this;
    }

    public ByteHashBag with(byte element1, byte element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public ByteHashBag with(byte element1, byte element2, byte element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    public ByteHashBag withAll(ByteIterable iterable) {
        this.addAll(iterable);
        return this;
    }

    public ByteHashBag without(byte element) {
        this.remove(element);
        return this;
    }

    public ByteHashBag withoutAll(ByteIterable iterable) {
        this.removeAll(iterable);
        return this;
    }

    public boolean contains(byte value) {
        return this.items.containsKey(value);
    }

    public boolean containsAll(byte ... source) {
        for (byte each : source) {
            if (this.items.containsKey(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ByteIterable source) {
        return source.allSatisfy(new BytePredicate(){

            public boolean accept(byte each) {
                return ByteHashBag.this.contains(each);
            }
        });
    }

    public int occurrencesOf(byte item) {
        return this.items.get(item);
    }

    public void forEachWithOccurrences(ByteIntProcedure procedure) {
        this.items.forEachKeyValue(procedure);
    }

    public boolean add(byte item) {
        this.items.updateValue(item, 0, IntToIntFunctions.increment());
        ++this.size;
        return true;
    }

    public boolean remove(byte item) {
        int newValue = this.items.updateValue(item, 0, IntToIntFunctions.decrement());
        if (newValue <= 0) {
            this.items.removeKey(item);
            if (newValue == 0) {
                --this.size;
            }
            return newValue == 0;
        }
        --this.size;
        return true;
    }

    public boolean addAll(byte ... source) {
        if (source.length == 0) {
            return false;
        }
        for (byte each : source) {
            this.add(each);
        }
        return true;
    }

    public boolean addAll(ByteIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        if (source instanceof ByteBag) {
            ByteBag otherBag = (ByteBag)source;
            otherBag.forEachWithOccurrences(new ByteIntProcedure(){

                public void value(byte each, int occurrences) {
                    ByteHashBag.this.addOccurrences(each, occurrences);
                }
            });
        } else {
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                byte each = iterator.next();
                this.add(each);
            }
        }
        return true;
    }

    public boolean removeAll(byte ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (byte each : source) {
            int occurrences = this.items.removeKeyIfAbsent(each, 0);
            this.size -= occurrences;
        }
        return this.size() != oldSize;
    }

    public boolean removeAll(ByteIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof ByteBag) {
            ByteBag otherBag = (ByteBag)source;
            otherBag.forEachWithOccurrences(new ByteIntProcedure(){

                public void value(byte each, int occurrences) {
                    int oldOccurrences = ByteHashBag.this.items.removeKeyIfAbsent(each, 0);
                    ByteHashBag.this.size -= oldOccurrences;
                }
            });
        } else {
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                byte each = iterator.next();
                int occurrences = this.items.removeKeyIfAbsent(each, 0);
                this.size -= occurrences;
            }
        }
        return this.size() != oldSize;
    }

    public void addOccurrences(byte item, final int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot add a negative number of occurrences");
        }
        if (occurrences > 0) {
            this.items.updateValue(item, 0, new IntToIntFunction(){

                public int valueOf(int intParameter) {
                    return intParameter + occurrences;
                }
            });
            this.size += occurrences;
        }
    }

    public boolean removeOccurrences(byte item, final int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot remove a negative number of occurrences");
        }
        if (occurrences == 0) {
            return false;
        }
        int newValue = this.items.updateValue(item, 0, new IntToIntFunction(){

            public int valueOf(int intParameter) {
                return intParameter - occurrences;
            }
        });
        if (newValue <= 0) {
            this.size -= occurrences - newValue;
            this.items.removeKey(item);
            return newValue + occurrences != 0;
        }
        this.size -= occurrences;
        return true;
    }

    public void forEach(final ByteProcedure procedure) {
        this.items.forEachKeyValue(new ByteIntProcedure(){

            public void value(byte key, int occurrences) {
                for (int i = 0; i < occurrences; ++i) {
                    procedure.value(key);
                }
            }
        });
    }

    public MutableByteBag select(final BytePredicate predicate) {
        final ByteHashBag result = new ByteHashBag();
        this.forEachWithOccurrences(new ByteIntProcedure(){

            public void value(byte each, int occurrences) {
                if (predicate.accept(each)) {
                    result.addOccurrences(each, occurrences);
                }
            }
        });
        return result;
    }

    public MutableByteBag reject(final BytePredicate predicate) {
        final ByteHashBag result = new ByteHashBag();
        this.forEachWithOccurrences(new ByteIntProcedure(){

            public void value(byte each, int occurrences) {
                if (!predicate.accept(each)) {
                    result.addOccurrences(each, occurrences);
                }
            }
        });
        return result;
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        ByteIterator it = this.byteIterator();
        while (it.hasNext()) {
            result = function.valueOf(result, it.next());
        }
        return result;
    }

    public boolean equals(Object otherBag) {
        if (otherBag == this) {
            return true;
        }
        if (!(otherBag instanceof ByteBag)) {
            return false;
        }
        final ByteBag bag = (ByteBag)otherBag;
        if (this.sizeDistinct() != bag.sizeDistinct()) {
            return false;
        }
        return this.items.keysView().allSatisfy(new BytePredicate(){

            public boolean accept(byte key) {
                return ByteHashBag.this.occurrencesOf(key) == bag.occurrencesOf(key);
            }
        });
    }

    public int hashCode() {
        final Counter result = new Counter();
        this.forEachWithOccurrences(new ByteIntProcedure(){

            public void value(byte eachItem, int occurrences) {
                result.add(eachItem ^ occurrences);
            }
        });
        return result.getCount();
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(final Appendable appendable, String start, final String separator, String end) {
        final boolean[] firstItem = new boolean[]{true};
        try {
            appendable.append(start);
            this.items.forEachKeyValue(new ByteIntProcedure(){

                public void value(byte each, int occurrences) {
                    try {
                        for (int i = 0; i < occurrences; ++i) {
                            if (!firstItem[0]) {
                                appendable.append(separator);
                            }
                            appendable.append(String.valueOf(each));
                            firstItem[0] = false;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int count(final BytePredicate predicate) {
        final Counter result = new Counter();
        this.forEachWithOccurrences(new ByteIntProcedure(){

            public void value(byte each, int occurrences) {
                if (predicate.accept(each)) {
                    result.add(occurrences);
                }
            }
        });
        return result.getCount();
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return this.items.keysView().anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return this.items.keysView().allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return this.items.keysView().noneSatisfy(predicate);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return this.items.keysView().detectIfNone(predicate, ifNone);
    }

    public <V> MutableBag<V> collect(final ByteToObjectFunction<? extends V> function) {
        final HashBag result = HashBag.newBag(this.items.size());
        this.forEachWithOccurrences(new ByteIntProcedure(){

            public void value(byte each, int occurrences) {
                result.addOccurrences(function.valueOf(each), occurrences);
            }
        });
        return result;
    }

    public byte max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.items.keysView().max();
    }

    public byte min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.items.keysView().min();
    }

    public long sum() {
        final long[] result = new long[]{0L};
        this.forEachWithOccurrences(new ByteIntProcedure(){

            public void value(byte each, int occurrences) {
                result[0] = result[0] + (long)each * (long)occurrences;
            }
        });
        return result[0];
    }

    public byte minIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public byte maxIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        byte[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            byte first = sortedArray[middleIndex];
            byte second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public byte[] toArray() {
        final byte[] array = new byte[this.size()];
        final int[] index = new int[]{0};
        this.forEachWithOccurrences(new ByteIntProcedure(){

            public void value(byte each, int occurrences) {
                for (int i = 0; i < occurrences; ++i) {
                    array[index[0]] = each;
                    index[0] = index[0] + 1;
                }
            }
        });
        return array;
    }

    public byte[] toSortedArray() {
        byte[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableByteList toList() {
        return ByteArrayList.newList((ByteIterable)this);
    }

    public MutableByteList toSortedList() {
        return ByteArrayList.newList((ByteIterable)this).sortThis();
    }

    public MutableByteSet toSet() {
        return ByteHashSet.newSet((ByteIterable)this.items.keysView());
    }

    public MutableByteBag toBag() {
        return ByteHashBag.newBag((ByteBag)this);
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public MutableByteBag asUnmodifiable() {
        return new UnmodifiableByteBag(this);
    }

    public MutableByteBag asSynchronized() {
        return new SynchronizedByteBag(this);
    }

    public ImmutableByteBag toImmutable() {
        return ByteBags.immutable.withAll((ByteIterable)this);
    }

    public ByteIterator byteIterator() {
        return new InternalIterator();
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.items.size());
        try {
            this.items.forEachKeyValue(new ByteIntProcedure(){

                public void value(byte each, int occurrences) {
                    try {
                        out.writeByte(each);
                        out.writeInt(occurrences);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        this.items = new ByteIntHashMap(size);
        for (int i = 0; i < size; ++i) {
            this.addOccurrences(in.readByte(), in.readInt());
        }
    }

    private class InternalIterator
    implements ByteIterator {
        private final ByteIterator byteIterator;
        private byte currentItem;
        private int occurrences;

        private InternalIterator() {
            this.byteIterator = ByteHashBag.this.items.keysView().byteIterator();
        }

        public boolean hasNext() {
            return this.occurrences > 0 || this.byteIterator.hasNext();
        }

        public byte next() {
            if (this.occurrences == 0) {
                this.currentItem = this.byteIterator.next();
                this.occurrences = ByteHashBag.this.occurrencesOf(this.currentItem);
            }
            --this.occurrences;
            return this.currentItem;
        }
    }
}

