/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.mutable.sorted;

import com.gs.collections.api.bag.Bag;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.bag.sorted.ImmutableSortedBag;
import com.gs.collections.api.bag.sorted.MutableSortedBag;
import com.gs.collections.api.bag.sorted.SortedBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.sorted.MutableSortedMap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.partition.bag.sorted.PartitionMutableSortedBag;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.Counter;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.bag.mutable.sorted.UnmodifiableSortedBag;
import com.gs.collections.impl.block.factory.Predicates2;
import com.gs.collections.impl.block.procedure.CollectionAddProcedure;
import com.gs.collections.impl.block.procedure.MultimapEachPutProcedure;
import com.gs.collections.impl.block.procedure.MultimapPutProcedure;
import com.gs.collections.impl.block.procedure.checked.CheckedProcedure2;
import com.gs.collections.impl.collection.mutable.AbstractMutableCollection;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.map.sorted.mutable.TreeSortedMap;
import com.gs.collections.impl.multimap.bag.TreeBagMultimap;
import com.gs.collections.impl.partition.bag.sorted.PartitionTreeBag;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.utility.Iterate;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeBag<T>
extends AbstractMutableCollection<T>
implements Externalizable,
MutableSortedBag<T> {
    private static final Function0<Counter> NEW_COUNTER_BLOCK = new Function0<Counter>(){

        public Counter value() {
            return new Counter();
        }
    };
    private static final long serialVersionUID = 1L;
    private MutableSortedMap<T, Counter> items;
    private int size;

    public TreeBag() {
        this.items = TreeSortedMap.newMap();
    }

    private TreeBag(MutableSortedMap<T, Counter> map) {
        this.items = map;
        this.size = (int)map.valuesView().sumOfInt(Counter.TO_COUNT);
    }

    public TreeBag(Comparator<? super T> comparator) {
        this.items = TreeSortedMap.newMap(comparator);
    }

    public TreeBag(SortedBag<T> sortedBag) {
        this(sortedBag.comparator(), (Iterable<T>)sortedBag);
    }

    public TreeBag(Comparator<? super T> comparator, Iterable<? extends T> iterable) {
        this(comparator);
        this.addAllIterable(iterable);
    }

    public static <E> TreeBag<E> newBag() {
        return new TreeBag();
    }

    public static <E> TreeBag<E> newBag(Comparator<? super E> comparator) {
        return new TreeBag<E>(comparator);
    }

    public static <E> TreeBag<E> newBag(Iterable<? extends E> source) {
        if (source instanceof SortedBag) {
            return new TreeBag((SortedBag)source);
        }
        return Iterate.addAllTo(source, TreeBag.<E>newBag());
    }

    public static <E> TreeBag<E> newBag(Comparator<? super E> comparator, Iterable<? extends E> iterable) {
        return new TreeBag<E>(comparator, iterable);
    }

    public static <E> TreeBag<E> newBagWith(E ... elements) {
        return TreeBag.newBag(Arrays.asList(elements));
    }

    public static <E> TreeBag<E> newBagWith(Comparator<? super E> comparator, E ... elements) {
        return TreeBag.newBag(comparator, Arrays.asList(elements));
    }

    private static <T> int compare(SortedBag<T> bagA, SortedBag<T> bagB) {
        Iterator itrA = bagA.iterator();
        Iterator itrB = bagB.iterator();
        if (bagA.comparator() != null) {
            Comparator comparator = bagA.comparator();
            while (itrA.hasNext()) {
                if (itrB.hasNext()) {
                    int val = comparator.compare(itrA.next(), itrB.next());
                    if (val == 0) continue;
                    return val;
                }
                return 1;
            }
            return itrB.hasNext() ? -1 : 0;
        }
        while (itrA.hasNext()) {
            if (itrB.hasNext()) {
                int val = ((Comparable)itrA.next()).compareTo(itrB.next());
                if (val == 0) continue;
                return val;
            }
            return 1;
        }
        return itrB.hasNext() ? -1 : 0;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Bag)) {
            return false;
        }
        final Bag bag = (Bag)other;
        if (this.sizeDistinct() != bag.sizeDistinct()) {
            return false;
        }
        return this.items.keyValuesView().allSatisfy(new Predicate<Pair<T, Counter>>(){

            public boolean accept(Pair<T, Counter> each) {
                return bag.occurrencesOf(each.getOne()) == ((Counter)each.getTwo()).getCount();
            }
        });
    }

    public int sizeDistinct() {
        return this.items.size();
    }

    @Override
    public int hashCode() {
        final Counter counter = new Counter();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int count) {
                counter.add((each == null ? 0 : each.hashCode()) ^ count);
            }
        });
        return counter.getCount();
    }

    public void forEachWithOccurrences(final ObjectIntProcedure<? super T> procedure) {
        this.items.forEachKeyValue(new Procedure2<T, Counter>(){

            public void value(T item, Counter count) {
                procedure.value(item, count.getCount());
            }
        });
    }

    public MutableSortedBag<T> selectByOccurrences(final IntPredicate predicate) {
        MutableSortedMap map = this.items.select(new Predicate2<T, Counter>(){

            public boolean accept(T each, Counter occurrences) {
                return predicate.accept(occurrences.getCount());
            }
        });
        return new TreeBag<T>(map);
    }

    public int occurrencesOf(Object item) {
        Counter counter = (Counter)this.items.get(item);
        return counter == null ? 0 : counter.getCount();
    }

    public MutableMap<T, Integer> toMapOfItemToCount() {
        final UnifiedMap map = UnifiedMap.newMap(this.items.size());
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T item, int count) {
                map.put(item, (Object)count);
            }
        });
        return map;
    }

    public String toStringOfItemToCount() {
        return this.items.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean remove(Object item) {
        Counter counter = (Counter)this.items.get(item);
        if (counter != null) {
            if (counter.getCount() > 1) {
                counter.decrement();
            } else {
                this.items.remove(item);
            }
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.removeAllIterable(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.retainAllIterable(collection);
    }

    @Override
    public void clear() {
        this.items.clear();
        this.size = 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.items.containsKey(o);
    }

    public int compareTo(SortedBag<T> otherBag) {
        return TreeBag.compare(this, otherBag);
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeObject(this.comparator());
        out.writeInt(this.items.size());
        try {
            this.items.forEachKeyValue((Procedure2)new CheckedProcedure2<T, Counter>(){

                @Override
                public void safeValue(T object, Counter parameter) throws Exception {
                    out.writeObject(object);
                    out.writeInt(parameter.getCount());
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.items = new TreeSortedMap<T, Counter>((Comparator)in.readObject());
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.addOccurrences(in.readObject(), in.readInt());
        }
    }

    @Override
    public void forEach(final Procedure<? super T> procedure) {
        this.items.forEachKeyValue(new Procedure2<T, Counter>(){

            public void value(T key, Counter value) {
                for (int i = 0; i < value.getCount(); ++i) {
                    procedure.value(key);
                }
            }
        });
    }

    @Override
    public void forEachWithIndex(final ObjectIntProcedure<? super T> objectIntProcedure) {
        final Counter index = new Counter();
        this.items.forEachKeyValue(new Procedure2<T, Counter>(){

            public void value(T key, Counter value) {
                for (int i = 0; i < value.getCount(); ++i) {
                    objectIntProcedure.value(key, index.getCount());
                    index.increment();
                }
            }
        });
    }

    @Override
    public <P> void forEachWith(final Procedure2<? super T, ? super P> procedure, final P parameter) {
        this.items.forEachKeyValue(new Procedure2<T, Counter>(){

            public void value(T key, Counter value) {
                for (int i = 0; i < value.getCount(); ++i) {
                    procedure.value(key, parameter);
                }
            }
        });
    }

    @Override
    public Iterator<T> iterator() {
        return new InternalIterator();
    }

    public void addOccurrences(T item, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot add a negative number of occurrences");
        }
        if (occurrences > 0) {
            ((Counter)this.items.getIfAbsentPut(item, NEW_COUNTER_BLOCK)).add(occurrences);
            this.size += occurrences;
        }
    }

    public boolean removeOccurrences(Object item, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot remove a negative number of occurrences");
        }
        if (occurrences == 0) {
            return false;
        }
        Counter counter = (Counter)this.items.get(item);
        if (counter == null) {
            return false;
        }
        int startCount = counter.getCount();
        if (occurrences >= startCount) {
            this.items.remove(item);
            this.size -= startCount;
            return true;
        }
        counter.add(occurrences * -1);
        this.size -= occurrences;
        return true;
    }

    public TreeBag<T> without(T element) {
        this.remove(element);
        return this;
    }

    public TreeBag<T> withAll(Iterable<? extends T> iterable) {
        this.addAllIterable(iterable);
        return this;
    }

    public TreeBag<T> withoutAll(Iterable<? extends T> iterable) {
        this.removeAllIterable(iterable);
        return this;
    }

    public ImmutableSortedBag<T> toImmutable() {
        throw new UnsupportedOperationException("toImmutable not implemented yet!");
    }

    @Override
    public <P, V> MutableBag<V> collectWith(final Function2<? super T, ? super P, ? extends V> function, final P parameter) {
        final HashBag result = HashBag.newBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                result.addOccurrences(function.value(each, parameter), occurrences);
            }
        });
        return result;
    }

    public TreeBag<T> with(T element) {
        this.add(element);
        return this;
    }

    @Override
    public MutableSortedBag<T> newEmpty() {
        return TreeBag.newBag(this.items.comparator());
    }

    @Override
    public <P> MutableSortedBag<T> selectWith(final Predicate2<? super T, ? super P> predicate, final P parameter) {
        final TreeBag<T> result = TreeBag.newBag(this.comparator());
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                if (predicate.accept(each, parameter)) {
                    result.addOccurrences(each, occurrences);
                }
            }
        });
        return result;
    }

    @Override
    public <P> MutableSortedBag<T> rejectWith(final Predicate2<? super T, ? super P> predicate, final P parameter) {
        final TreeBag<T> result = TreeBag.newBag(this.comparator());
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                if (!predicate.accept(each, parameter)) {
                    result.addOccurrences(each, index);
                }
            }
        });
        return result;
    }

    @Override
    public void removeIf(Predicate<? super T> predicate) {
        MutableSet entries = this.items.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!predicate.accept(entry.getKey())) continue;
            this.size -= ((Counter)entry.getValue()).getCount();
            iterator.remove();
        }
    }

    @Override
    public <P> void removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        MutableSet entries = this.items.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!predicate.accept(entry.getKey(), parameter)) continue;
            this.size -= ((Counter)entry.getValue()).getCount();
            iterator.remove();
        }
    }

    @Override
    public <P> T detectWith(final Predicate2<? super T, ? super P> predicate, final P parameter) {
        return (T)this.items.keysView().detect(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(each, parameter);
            }
        });
    }

    @Override
    public <P> T detectWithIfNone(final Predicate2<? super T, ? super P> predicate, final P parameter, Function0<? extends T> function) {
        return (T)this.items.keysView().detectIfNone(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(each, parameter);
            }
        }, function);
    }

    @Override
    public <P> int countWith(final Predicate2<? super T, ? super P> predicate, final P parameter) {
        final Counter result = new Counter();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                if (predicate.accept(each, parameter)) {
                    result.add(occurrences);
                }
            }
        });
        return result.getCount();
    }

    @Override
    public <P> boolean anySatisfyWith(final Predicate2<? super T, ? super P> predicate, final P parameter) {
        return this.items.keysView().anySatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(each, parameter);
            }
        });
    }

    @Override
    public <P> boolean allSatisfyWith(final Predicate2<? super T, ? super P> predicate, final P parameter) {
        return this.items.keysView().allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(each, parameter);
            }
        });
    }

    @Override
    public UnmodifiableSortedBag<T> asUnmodifiable() {
        return UnmodifiableSortedBag.of(this);
    }

    @Override
    public MutableSortedBag<T> asSynchronized() {
        throw new UnsupportedOperationException("asSynchronized not implemented yet!");
    }

    @Override
    public boolean removeAllIterable(Iterable<?> iterable) {
        int oldSize = this.size;
        for (Object each : iterable) {
            Counter removed = (Counter)this.items.remove(each);
            if (removed == null) continue;
            this.size -= removed.getCount();
        }
        return this.size != oldSize;
    }

    @Override
    public boolean retainAllIterable(Iterable<?> iterable) {
        int oldSize = this.size;
        this.removeIfWith(Predicates2.notIn(), UnifiedSet.newSet(iterable));
        return this.size != oldSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public MutableSortedBag<T> reject(final Predicate<? super T> predicate) {
        final TreeBag<T> result = TreeBag.newBag(this.comparator());
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                if (!predicate.accept(each)) {
                    result.addOccurrences(each, index);
                }
            }
        });
        return result;
    }

    public PartitionMutableSortedBag<T> partition(final Predicate<? super T> predicate) {
        final PartitionTreeBag<T> result = new PartitionTreeBag<T>(this.comparator());
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                MutableSortedBag bucket = predicate.accept(each) ? result.getSelected() : result.getRejected();
                bucket.addOccurrences(each, index);
            }
        });
        return result;
    }

    public <S> MutableSortedBag<S> selectInstancesOf(final Class<S> clazz) {
        Comparator<T> comparator = this.comparator();
        final TreeBag<T> result = TreeBag.newBag(comparator);
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                if (clazz.isInstance(each)) {
                    result.addOccurrences(clazz.cast(each), occurrences);
                }
            }
        });
        return result;
    }

    public <V> TreeBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.groupBy(function, TreeBagMultimap.newMultimap(this.comparator()));
    }

    public <V> TreeBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.groupByEach(function, TreeBagMultimap.newMultimap(this.comparator()));
    }

    public MutableByteBag collectByte(final ByteFunction<? super T> byteFunction) {
        final ByteHashBag result = new ByteHashBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                result.addOccurrences(byteFunction.byteValueOf(each), occurrences);
            }
        });
        return result;
    }

    @Override
    public T getFirst() {
        return (T)this.items.keysView().getFirst();
    }

    public MutableBag<Pair<T, Integer>> zipWithIndex() {
        return this.zipWithIndex(HashBag.newBag());
    }

    @Override
    public T getLast() {
        return (T)this.items.keysView().getLast();
    }

    @Override
    public <V> MutableBag<V> collect(final Function<? super T, ? extends V> function) {
        final HashBag result = HashBag.newBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                result.addOccurrences(function.valueOf(each), occurrences);
            }
        });
        return result;
    }

    @Override
    public <V> MutableBag<V> flatCollect(final Function<? super T, ? extends Iterable<V>> function) {
        final HashBag result = HashBag.newBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, final int occurrences) {
                Iterable values = (Iterable)function.valueOf(each);
                Iterate.forEach(values, new Procedure<V>(){

                    public void value(V each) {
                        result.addOccurrences(each, occurrences);
                    }
                });
            }
        });
        return result;
    }

    @Override
    public <R extends Collection<T>> R select(final Predicate<? super T> predicate, final R target) {
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                if (predicate.accept(each)) {
                    for (int i = 0; i < occurrences; ++i) {
                        target.add(each);
                    }
                }
            }
        });
        return target;
    }

    @Override
    public <P, R extends Collection<T>> R selectWith(final Predicate2<? super T, ? super P> predicate, final P parameter, final R target) {
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                if (predicate.accept(each, parameter)) {
                    for (int i = 0; i < occurrences; ++i) {
                        target.add(each);
                    }
                }
            }
        });
        return target;
    }

    @Override
    public MutableSortedBag<T> select(final Predicate<? super T> predicate) {
        final TreeBag<T> result = TreeBag.newBag(this.comparator());
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                if (predicate.accept(each)) {
                    result.addOccurrences(each, occurrences);
                }
            }
        });
        return result;
    }

    @Override
    public <R extends Collection<T>> R reject(final Predicate<? super T> predicate, final R target) {
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                if (!predicate.accept(each)) {
                    for (int i = 0; i < occurrences; ++i) {
                        target.add(each);
                    }
                }
            }
        });
        return target;
    }

    @Override
    public <P, R extends Collection<T>> R rejectWith(final Predicate2<? super T, ? super P> predicate, final P parameter, final R target) {
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                if (!predicate.accept(each, parameter)) {
                    for (int i = 0; i < occurrences; ++i) {
                        target.add(each);
                    }
                }
            }
        });
        return target;
    }

    public MutableBooleanBag collectBoolean(final BooleanFunction<? super T> booleanFunction) {
        final BooleanHashBag result = new BooleanHashBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                result.addOccurrences(booleanFunction.booleanValueOf(each), occurrences);
            }
        });
        return result;
    }

    public MutableCharBag collectChar(final CharFunction<? super T> charFunction) {
        final CharHashBag result = new CharHashBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                result.addOccurrences(charFunction.charValueOf(each), occurrences);
            }
        });
        return result;
    }

    public MutableDoubleBag collectDouble(final DoubleFunction<? super T> doubleFunction) {
        final DoubleHashBag result = new DoubleHashBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                result.addOccurrences(doubleFunction.doubleValueOf(each), occurrences);
            }
        });
        return result;
    }

    public MutableFloatBag collectFloat(final FloatFunction<? super T> floatFunction) {
        final FloatHashBag result = new FloatHashBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                result.addOccurrences(floatFunction.floatValueOf(each), occurrences);
            }
        });
        return result;
    }

    public MutableIntBag collectInt(final IntFunction<? super T> intFunction) {
        final IntHashBag result = new IntHashBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                result.addOccurrences(intFunction.intValueOf(each), occurrences);
            }
        });
        return result;
    }

    public MutableLongBag collectLong(final LongFunction<? super T> longFunction) {
        final LongHashBag result = new LongHashBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                result.addOccurrences(longFunction.longValueOf(each), occurrences);
            }
        });
        return result;
    }

    public MutableShortBag collectShort(final ShortFunction<? super T> shortFunction) {
        final ShortHashBag result = new ShortHashBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                result.addOccurrences(shortFunction.shortValueOf(each), occurrences);
            }
        });
        return result;
    }

    @Override
    public <V> MutableBag<V> collectIf(final Predicate<? super T> predicate, final Function<? super T, ? extends V> function) {
        final HashBag result = HashBag.newBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                if (predicate.accept(each)) {
                    result.addOccurrences(function.valueOf(each), occurrences);
                }
            }
        });
        return result;
    }

    public <S> MutableBag<Pair<T, S>> zip(Iterable<S> that) {
        return this.zip(that, HashBag.newBag());
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return (T)this.items.keysView().detect(predicate);
    }

    @Override
    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        return (T)this.items.keysView().detectIfNone(predicate, function);
    }

    @Override
    public int count(final Predicate<? super T> predicate) {
        final Counter result = new Counter();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                if (predicate.accept(each)) {
                    result.add(occurrences);
                }
            }
        });
        return result.getCount();
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return this.items.keysView().anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return this.items.keysView().allSatisfy(predicate);
    }

    @Override
    public MutableList<T> toList() {
        return FastList.newList(this);
    }

    @Override
    public MutableSet<T> toSet() {
        UnifiedSet result = UnifiedSet.newSet(this.sizeDistinct());
        this.items.forEachKey(CollectionAddProcedure.on(result));
        return result;
    }

    @Override
    public MutableBag<T> toBag() {
        return HashBag.newBag(this);
    }

    @Override
    public T min(Comparator<? super T> comparator) {
        return (T)this.items.keysView().min(comparator);
    }

    @Override
    public T max(Comparator<? super T> comparator) {
        return (T)this.items.keysView().max(comparator);
    }

    @Override
    public T min() {
        return (T)this.items.keysView().min();
    }

    @Override
    public T max() {
        return (T)this.items.keysView().max();
    }

    @Override
    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        return (T)this.items.keysView().minBy(function);
    }

    @Override
    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        return (T)this.items.keysView().maxBy(function);
    }

    @Override
    public long sumOfInt(final IntFunction<? super T> function) {
        final long[] sum = new long[]{0L};
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                int intValue = function.intValueOf(each);
                sum[0] = sum[0] + (long)intValue * (long)occurrences;
            }
        });
        return sum[0];
    }

    @Override
    public double sumOfFloat(final FloatFunction<? super T> function) {
        final double[] sum = new double[]{0.0};
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                float floatValue = function.floatValueOf(each);
                sum[0] = sum[0] + (double)floatValue * (double)occurrences;
            }
        });
        return sum[0];
    }

    @Override
    public long sumOfLong(final LongFunction<? super T> function) {
        final long[] sum = new long[]{0L};
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                long longValue = function.longValueOf(each);
                sum[0] = sum[0] + longValue * (long)occurrences;
            }
        });
        return sum[0];
    }

    @Override
    public double sumOfDouble(final DoubleFunction<? super T> function) {
        final double[] sum = new double[]{0.0};
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                double doubleValue = function.doubleValueOf(each);
                sum[0] = sum[0] + doubleValue * (double)occurrences;
            }
        });
        return sum[0];
    }

    @Override
    public <V, R extends MutableMultimap<V, T>> R groupBy(Function<? super T, ? extends V> function, R target) {
        this.forEach(MultimapPutProcedure.on(target, function));
        return target;
    }

    @Override
    public <V, R extends MutableMultimap<V, T>> R groupByEach(Function<? super T, ? extends Iterable<V>> function, R target) {
        this.forEach(MultimapEachPutProcedure.on(target, function));
        return target;
    }

    public Comparator<? super T> comparator() {
        return this.items.comparator();
    }

    public TreeBag<T> with(T ... elements) {
        this.addAll(Arrays.asList(elements));
        return this;
    }

    public TreeBag<T> with(T element1, T element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    @Override
    public boolean add(T item) {
        Counter counter = (Counter)this.items.getIfAbsentPut(item, NEW_COUNTER_BLOCK);
        counter.increment();
        ++this.size;
        return true;
    }

    public TreeBag<T> with(T element1, T element2, T element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalIterator
    implements Iterator<T> {
        private int position;
        private boolean isCurrentKeySet;
        private int currentKeyPosition;
        private int currentKeyOccurrences;
        private Iterator<Pair<T, Counter>> keyValueIterator;
        private Pair<T, Counter> currentKeyValue;

        private InternalIterator() {
            this.keyValueIterator = TreeBag.this.items.keyValuesView().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.position != TreeBag.this.size;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.isCurrentKeySet = true;
            if (this.currentKeyPosition < this.currentKeyOccurrences) {
                ++this.currentKeyPosition;
                ++this.position;
                return this.currentKeyValue.getOne();
            }
            this.currentKeyValue = this.keyValueIterator.next();
            this.currentKeyPosition = 1;
            this.currentKeyOccurrences = ((Counter)this.currentKeyValue.getTwo()).getCount();
            ++this.position;
            return this.currentKeyValue.getOne();
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.position;
            TreeBag.this.remove(this.currentKeyValue.getOne());
            this.keyValueIterator = TreeBag.this.items.keyValuesView().iterator();
            --this.currentKeyOccurrences;
            --this.currentKeyPosition;
        }
    }
}

