/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.block.factory;

import com.gs.collections.api.block.HashingStrategy;
import com.gs.collections.api.block.function.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HashingStrategies {
    private static final HashingStrategy<?> DEFAULT_HASHING_STRATEGY = new DefaultStrategy();

    private HashingStrategies() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> HashingStrategy<T> defaultStrategy() {
        return DEFAULT_HASHING_STRATEGY;
    }

    public static <T> HashingStrategy<T> nullSafeHashingStrategy(HashingStrategy<T> nonNullSafeStrategy) {
        return new NullSafeHashingStrategy(nonNullSafeStrategy);
    }

    public static <T, V> HashingStrategy<T> fromFunction(Function<T, V> function) {
        return new FunctionHashingStrategy(function);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FunctionHashingStrategy<T, V>
    implements HashingStrategy<T> {
        private static final long serialVersionUID = 1L;
        private final Function<T, V> function;

        private FunctionHashingStrategy(Function<T, V> function) {
            this.function = function;
        }

        public int computeHashCode(T object) {
            return this.function.valueOf(object).hashCode();
        }

        public boolean equals(T object1, T object2) {
            return this.function.valueOf(object1).equals(this.function.valueOf(object2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NullSafeHashingStrategy<T>
    implements HashingStrategy<T> {
        private static final long serialVersionUID = 1L;
        private final HashingStrategy<T> nonNullSafeStrategy;

        private NullSafeHashingStrategy(HashingStrategy<T> nonNullSafeStrategy) {
            this.nonNullSafeStrategy = nonNullSafeStrategy;
        }

        public int computeHashCode(T object) {
            return object == null ? 0 : this.nonNullSafeStrategy.computeHashCode(object);
        }

        public boolean equals(T object1, T object2) {
            return object1 == null || object2 == null ? object1 == object2 : this.nonNullSafeStrategy.equals(object1, object2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultStrategy<T>
    implements HashingStrategy<T> {
        private static final long serialVersionUID = 1L;

        private DefaultStrategy() {
        }

        public int computeHashCode(T object) {
            return object.hashCode();
        }

        public boolean equals(T object1, T object2) {
            return object1.equals(object2);
        }
    }
}

