/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.block.factory.primitive;

import com.gs.collections.api.block.predicate.primitive.FloatPredicate;

public final class FloatPredicates {
    private FloatPredicates() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static FloatPredicate equal(float expected) {
        return new EqualsFloatPredicate(expected);
    }

    public static FloatPredicate equal(float expected, float delta) {
        return new EqualsWithDeltaFloatPredicate(expected, delta);
    }

    public static FloatPredicate lessThan(float expected) {
        return new LessThanFloatPredicate(expected);
    }

    public static FloatPredicate greaterThan(float expected) {
        return new GreaterThanFloatPredicate(expected);
    }

    public static FloatPredicate and(FloatPredicate one, FloatPredicate two) {
        return new AndFloatPredicate(one, two);
    }

    public static FloatPredicate or(FloatPredicate one, FloatPredicate two) {
        return new OrFloatPredicate(one, two);
    }

    public static FloatPredicate not(FloatPredicate negate) {
        return new NotFloatPredicate(negate);
    }

    private static final class NotFloatPredicate
    implements FloatPredicate {
        private static final long serialVersionUID = 1L;
        private final FloatPredicate negate;

        private NotFloatPredicate(FloatPredicate negate) {
            this.negate = negate;
        }

        public boolean accept(float actual) {
            return !this.negate.accept(actual);
        }
    }

    private static final class OrFloatPredicate
    implements FloatPredicate {
        private static final long serialVersionUID = 1L;
        private final FloatPredicate one;
        private final FloatPredicate two;

        private OrFloatPredicate(FloatPredicate one, FloatPredicate two) {
            this.one = one;
            this.two = two;
        }

        public boolean accept(float actual) {
            return this.one.accept(actual) || this.two.accept(actual);
        }
    }

    private static final class AndFloatPredicate
    implements FloatPredicate {
        private static final long serialVersionUID = 1L;
        private final FloatPredicate one;
        private final FloatPredicate two;

        private AndFloatPredicate(FloatPredicate one, FloatPredicate two) {
            this.one = one;
            this.two = two;
        }

        public boolean accept(float actual) {
            return this.one.accept(actual) && this.two.accept(actual);
        }
    }

    private static final class GreaterThanFloatPredicate
    implements FloatPredicate {
        private static final long serialVersionUID = 1L;
        private final float expected;

        private GreaterThanFloatPredicate(float expected) {
            this.expected = expected;
        }

        public boolean accept(float actual) {
            return actual > this.expected;
        }
    }

    private static final class LessThanFloatPredicate
    implements FloatPredicate {
        private static final long serialVersionUID = 1L;
        private final float expected;

        private LessThanFloatPredicate(float expected) {
            this.expected = expected;
        }

        public boolean accept(float actual) {
            return actual < this.expected;
        }
    }

    private static final class EqualsWithDeltaFloatPredicate
    implements FloatPredicate {
        private static final long serialVersionUID = 1L;
        private final float expected;
        private final float delta;

        private EqualsWithDeltaFloatPredicate(float expected, float delta) {
            this.expected = expected;
            this.delta = delta;
        }

        public boolean accept(float actual) {
            return Math.abs(this.expected - actual) <= this.delta;
        }
    }

    private static final class EqualsFloatPredicate
    implements FloatPredicate {
        private static final long serialVersionUID = 1L;
        private final float expected;

        private EqualsFloatPredicate(float expected) {
            this.expected = expected;
        }

        public boolean accept(float actual) {
            return Float.compare(actual, this.expected) == 0;
        }
    }
}

