/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.collection.mutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedBooleanCollection;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import java.io.Serializable;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbstractUnmodifiableBooleanCollection
implements MutableBooleanCollection,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableBooleanCollection collection;

    protected AbstractUnmodifiableBooleanCollection(MutableBooleanCollection collection) {
        this.collection = collection;
    }

    protected MutableBooleanCollection getBooleanCollection() {
        return this.collection;
    }

    public int size() {
        return this.collection.size();
    }

    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    public boolean notEmpty() {
        return this.collection.notEmpty();
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear on an unmodifiable collection");
    }

    public boolean contains(boolean value) {
        return this.collection.contains(value);
    }

    public boolean containsAll(boolean ... source) {
        return this.collection.containsAll(source);
    }

    public boolean containsAll(BooleanIterable source) {
        return this.collection.containsAll(source);
    }

    public boolean add(boolean newItem) {
        throw new UnsupportedOperationException("Cannot call add on an unmodifiable collection");
    }

    public boolean addAll(boolean ... source) {
        throw new UnsupportedOperationException("Cannot call addAll on an unmodifiable collection");
    }

    public boolean addAll(BooleanIterable source) {
        throw new UnsupportedOperationException("Cannot call addAll on an unmodifiable collection");
    }

    public boolean remove(boolean value) {
        throw new UnsupportedOperationException("Cannot call remove on an unmodifiable collection");
    }

    public boolean removeAll(BooleanIterable source) {
        throw new UnsupportedOperationException("Cannot call removeAll on an unmodifiable collection");
    }

    public boolean removeAll(boolean ... source) {
        throw new UnsupportedOperationException("Cannot call removeAll on an unmodifiable collection");
    }

    public BooleanIterator booleanIterator() {
        return this.collection.booleanIterator();
    }

    public void forEach(BooleanProcedure procedure) {
        this.collection.forEach(procedure);
    }

    public int count(BooleanPredicate predicate) {
        return this.collection.count(predicate);
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.collection.anySatisfy(predicate);
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.collection.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return this.collection.noneSatisfy(predicate);
    }

    public MutableBooleanCollection select(BooleanPredicate predicate) {
        return this.collection.select(predicate);
    }

    public MutableBooleanCollection reject(BooleanPredicate predicate) {
        return this.collection.reject(predicate);
    }

    public <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
        return this.collection.collect(function);
    }

    public MutableBooleanCollection with(boolean element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    public MutableBooleanCollection without(boolean element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    public MutableBooleanCollection withAll(BooleanIterable elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    public MutableBooleanCollection withoutAll(BooleanIterable elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public MutableBooleanCollection asUnmodifiable() {
        return this;
    }

    public MutableBooleanCollection asSynchronized() {
        return new SynchronizedBooleanCollection(this);
    }

    public ImmutableBooleanCollection toImmutable() {
        return this.collection.toImmutable();
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return this.collection.detectIfNone(predicate, ifNone);
    }

    public boolean[] toArray() {
        return this.collection.toArray();
    }

    public String toString() {
        return this.collection.toString();
    }

    public String makeString() {
        return this.collection.makeString();
    }

    public String makeString(String separator) {
        return this.collection.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.collection.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.collection.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.collection.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.collection.appendString(appendable, start, separator, end);
    }

    public MutableBooleanList toList() {
        return this.collection.toList();
    }

    public MutableBooleanSet toSet() {
        return this.collection.toSet();
    }

    public MutableBooleanBag toBag() {
        return this.collection.toBag();
    }
}

