/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.block.factory.primitive.IntPredicates;
import com.gs.collections.impl.lazy.primitive.CollectIntToObjectIterable;
import com.gs.collections.impl.lazy.primitive.SelectIntIterable;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class CollectIntIterable<T>
implements LazyIntIterable {
    private final LazyIterable<T> iterable;
    private final IntFunction<? super T> function;
    private final IntFunctionToProcedure intFunctionToProcedure = new IntFunctionToProcedure();

    public CollectIntIterable(LazyIterable<T> adapted, IntFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
    }

    public IntIterator intIterator() {
        return new IntIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectIntIterable.this.iterable.iterator();
            }

            public int next() {
                return CollectIntIterable.this.function.intValueOf(this.iterator.next());
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    public void forEach(IntProcedure procedure) {
        this.iterable.forEachWith((Procedure2)this.intFunctionToProcedure, (Object)procedure);
    }

    public int size() {
        return this.iterable.size();
    }

    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    public int count(final IntPredicate predicate) {
        return this.iterable.count(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectIntIterable.this.function.intValueOf(each));
            }
        });
    }

    public boolean anySatisfy(final IntPredicate predicate) {
        return this.iterable.anySatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectIntIterable.this.function.intValueOf(each));
            }
        });
    }

    public boolean allSatisfy(final IntPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectIntIterable.this.function.intValueOf(each));
            }
        });
    }

    public boolean noneSatisfy(final IntPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return !predicate.accept(CollectIntIterable.this.function.intValueOf(each));
            }
        });
    }

    public LazyIntIterable select(IntPredicate predicate) {
        return new SelectIntIterable((IntIterable)this, predicate);
    }

    public LazyIntIterable reject(IntPredicate predicate) {
        return new SelectIntIterable((IntIterable)this, IntPredicates.not(predicate));
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        IntIterator iterator = this.intIterator();
        while (iterator.hasNext()) {
            int next = iterator.next();
            if (!predicate.accept(next)) continue;
            return next;
        }
        return ifNone;
    }

    public <V> LazyIterable<V> collect(IntToObjectFunction<? extends V> function) {
        return new CollectIntToObjectIterable<V>((IntIterable)this, function);
    }

    public long sum() {
        return this.iterable.injectInto(0L, new LongObjectToLongFunction<T>(){

            public long longValueOf(long longValue, T each) {
                return longValue + (long)CollectIntIterable.this.function.intValueOf(each);
            }
        });
    }

    public int max() {
        IntIterator iterator = this.intIterator();
        int max = iterator.next();
        while (iterator.hasNext()) {
            max = Math.max(max, iterator.next());
        }
        return max;
    }

    public int min() {
        IntIterator iterator = this.intIterator();
        int min = iterator.next();
        while (iterator.hasNext()) {
            min = Math.min(min, iterator.next());
        }
        return min;
    }

    public int minIfEmpty(int defaultValue) {
        try {
            return this.min();
        }
        catch (NoSuchElementException noSuchElementException) {
            return defaultValue;
        }
    }

    public int maxIfEmpty(int defaultValue) {
        try {
            return this.max();
        }
        catch (NoSuchElementException noSuchElementException) {
            return defaultValue;
        }
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        int[] sortedArray = this.toSortedArray();
        int i = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            int first = sortedArray[i];
            int second = sortedArray[i - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[i];
    }

    public int[] toArray() {
        final int[] array = new int[this.size()];
        this.iterable.forEachWithIndex(new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                array[index] = CollectIntIterable.this.function.intValueOf(each);
            }
        });
        return array;
    }

    public int[] toSortedArray() {
        int[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        IntIterator iterator = this.intIterator();
        while (iterator.hasNext()) {
            result = function.valueOf(result, iterator.next());
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            IntIterator iterator = this.intIterator();
            if (iterator.hasNext()) {
                appendable.append(String.valueOf(iterator.next()));
                while (iterator.hasNext()) {
                    appendable.append(separator);
                    appendable.append(String.valueOf(iterator.next()));
                }
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableIntList toList() {
        return IntArrayList.newList((IntIterable)this);
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newList((IntIterable)this).sortThis();
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSet((IntIterable)this);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBag((IntIterable)this);
    }

    public LazyIntIterable asLazy() {
        return this;
    }

    public boolean contains(int value) {
        return this.anySatisfy(IntPredicates.equal(value));
    }

    public boolean containsAll(int ... source) {
        for (int value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(IntIterable source) {
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IntFunctionToProcedure
    implements Procedure2<T, IntProcedure> {
        private static final long serialVersionUID = -4133872659735979655L;

        private IntFunctionToProcedure() {
        }

        public void value(T each, IntProcedure parm) {
            parm.value(CollectIntIterable.this.function.intValueOf(each));
        }
    }
}

