/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.block.factory.primitive.BytePredicates;
import com.gs.collections.impl.lazy.primitive.CollectByteToObjectIterable;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectByteIterable
implements LazyByteIterable {
    private final ByteIterable delegate;
    private final BytePredicate predicate;

    public SelectByteIterable(ByteIterable delegate, BytePredicate predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    public ByteIterator byteIterator() {
        return new SelectByteIterator(this.delegate, this.predicate);
    }

    public void forEach(ByteProcedure procedure) {
        this.delegate.forEach((ByteProcedure)new IfByteProcedure(procedure));
    }

    public int size() {
        return this.delegate.count(this.predicate);
    }

    public boolean isEmpty() {
        return !this.byteIterator().hasNext();
    }

    public boolean notEmpty() {
        return this.byteIterator().hasNext();
    }

    public int count(BytePredicate predicate) {
        CountByteProcedure countByteProcedure = new CountByteProcedure(predicate);
        this.forEach(countByteProcedure);
        return countByteProcedure.getCount();
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return this.delegate.anySatisfy(BytePredicates.and(this.predicate, predicate));
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return this.noneSatisfy(BytePredicates.not(predicate));
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public LazyByteIterable select(BytePredicate predicate) {
        return new SelectByteIterable((ByteIterable)this, predicate);
    }

    public LazyByteIterable reject(BytePredicate predicate) {
        return new SelectByteIterable((ByteIterable)this, BytePredicates.not(predicate));
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        ByteIterator byteIterator = this.byteIterator();
        while (byteIterator.hasNext()) {
            byte item = byteIterator.next();
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public <V> LazyIterable<V> collect(ByteToObjectFunction<? extends V> function) {
        return new CollectByteToObjectIterable<V>((ByteIterable)this, function);
    }

    public long sum() {
        long sum = 0L;
        ByteIterator byteIterator = this.byteIterator();
        while (byteIterator.hasNext()) {
            sum += (long)byteIterator.next();
        }
        return sum;
    }

    public byte max() {
        ByteIterator byteIterator = this.byteIterator();
        byte max = byteIterator.next();
        while (byteIterator.hasNext()) {
            max = (byte)Math.max(max, byteIterator.next());
        }
        return max;
    }

    public byte min() {
        ByteIterator byteIterator = this.byteIterator();
        byte min = byteIterator.next();
        while (byteIterator.hasNext()) {
            min = (byte)Math.min(min, byteIterator.next());
        }
        return min;
    }

    public byte minIfEmpty(byte defaultValue) {
        try {
            return this.min();
        }
        catch (NoSuchElementException noSuchElementException) {
            return defaultValue;
        }
    }

    public byte maxIfEmpty(byte defaultValue) {
        try {
            return this.max();
        }
        catch (NoSuchElementException noSuchElementException) {
            return defaultValue;
        }
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        byte[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            byte first = sortedArray[middleIndex];
            byte second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public byte[] toSortedArray() {
        byte[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableByteList toSortedList() {
        return ByteArrayList.newList((ByteIterable)this).sortThis();
    }

    public byte[] toArray() {
        final byte[] array = new byte[this.size()];
        this.forEach(new ByteProcedure(){
            private int index = 0;

            public void value(byte each) {
                array[this.index++] = each;
            }
        });
        return array;
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        ByteIterator iterator = this.byteIterator();
        while (iterator.hasNext()) {
            result = function.valueOf(result, iterator.next());
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            ByteIterator iterator = this.byteIterator();
            if (iterator.hasNext()) {
                appendable.append(String.valueOf(iterator.next()));
                while (iterator.hasNext()) {
                    appendable.append(separator);
                    appendable.append(String.valueOf(iterator.next()));
                }
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean contains(byte value) {
        return this.anySatisfy(BytePredicates.equal(value));
    }

    public boolean containsAll(byte ... source) {
        for (byte value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public MutableByteList toList() {
        return ByteArrayList.newList((ByteIterable)this);
    }

    public MutableByteSet toSet() {
        return ByteHashSet.newSet((ByteIterable)this);
    }

    public MutableByteBag toBag() {
        return ByteHashBag.newBag((ByteIterable)this);
    }

    public LazyByteIterable asLazy() {
        return this;
    }

    private static final class SelectByteIterator
    implements ByteIterator {
        private final ByteIterator iterator;
        private final BytePredicate predicate;
        private byte next;
        private boolean verifiedHasNext = false;

        private SelectByteIterator(ByteIterable iterable, BytePredicate predicate) {
            this(iterable.byteIterator(), predicate);
        }

        private SelectByteIterator(ByteIterator iterator, BytePredicate predicate) {
            this.iterator = iterator;
            this.predicate = predicate;
        }

        public boolean hasNext() {
            if (this.verifiedHasNext) {
                return true;
            }
            while (this.iterator.hasNext()) {
                byte temp = this.iterator.next();
                if (!this.predicate.accept(temp)) continue;
                this.next = temp;
                this.verifiedHasNext = true;
                return true;
            }
            return false;
        }

        public byte next() {
            if (this.verifiedHasNext || this.hasNext()) {
                this.verifiedHasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }

    private final class IfByteProcedure
    implements ByteProcedure {
        private static final long serialVersionUID = 1L;
        private final ByteProcedure procedure;

        private IfByteProcedure(ByteProcedure procedure) {
            this.procedure = procedure;
        }

        public void value(byte each) {
            if (SelectByteIterable.this.predicate.accept(each)) {
                this.procedure.value(each);
            }
        }
    }

    private static final class CountByteProcedure
    implements ByteProcedure {
        private static final long serialVersionUID = 1L;
        private final BytePredicate predicate;
        private int counter = 0;

        private CountByteProcedure(BytePredicate predicate) {
            this.predicate = predicate;
        }

        public void value(byte each) {
            if (this.predicate.accept(each)) {
                ++this.counter;
            }
        }

        public int getCount() {
            return this.counter;
        }
    }
}

