/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.block.factory.primitive.FloatPredicates;
import com.gs.collections.impl.lazy.primitive.CollectFloatToObjectIterable;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectFloatIterable
implements LazyFloatIterable {
    private final FloatIterable delegate;
    private final FloatPredicate predicate;

    public SelectFloatIterable(FloatIterable delegate, FloatPredicate predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    public FloatIterator floatIterator() {
        return new SelectFloatIterator(this.delegate, this.predicate);
    }

    public void forEach(FloatProcedure procedure) {
        this.delegate.forEach((FloatProcedure)new IfFloatProcedure(procedure));
    }

    public int size() {
        return this.delegate.count(this.predicate);
    }

    public boolean isEmpty() {
        return !this.floatIterator().hasNext();
    }

    public boolean notEmpty() {
        return this.floatIterator().hasNext();
    }

    public int count(FloatPredicate predicate) {
        CountFloatProcedure countFloatProcedure = new CountFloatProcedure(predicate);
        this.forEach(countFloatProcedure);
        return countFloatProcedure.getCount();
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return this.delegate.anySatisfy(FloatPredicates.and(this.predicate, predicate));
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return this.noneSatisfy(FloatPredicates.not(predicate));
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public LazyFloatIterable select(FloatPredicate predicate) {
        return new SelectFloatIterable((FloatIterable)this, predicate);
    }

    public LazyFloatIterable reject(FloatPredicate predicate) {
        return new SelectFloatIterable((FloatIterable)this, FloatPredicates.not(predicate));
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        FloatIterator floatIterator = this.floatIterator();
        while (floatIterator.hasNext()) {
            float item = floatIterator.next();
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public <V> LazyIterable<V> collect(FloatToObjectFunction<? extends V> function) {
        return new CollectFloatToObjectIterable<V>((FloatIterable)this, function);
    }

    public double sum() {
        double sum = 0.0;
        FloatIterator floatIterator = this.floatIterator();
        while (floatIterator.hasNext()) {
            sum += (double)floatIterator.next();
        }
        return sum;
    }

    public float max() {
        FloatIterator floatIterator = this.floatIterator();
        float max = floatIterator.next();
        while (floatIterator.hasNext()) {
            max = Math.max(max, floatIterator.next());
        }
        return max;
    }

    public float min() {
        FloatIterator floatIterator = this.floatIterator();
        float min = floatIterator.next();
        while (floatIterator.hasNext()) {
            min = Math.min(min, floatIterator.next());
        }
        return min;
    }

    public float minIfEmpty(float defaultValue) {
        try {
            return this.min();
        }
        catch (NoSuchElementException noSuchElementException) {
            return defaultValue;
        }
    }

    public float maxIfEmpty(float defaultValue) {
        try {
            return this.max();
        }
        catch (NoSuchElementException noSuchElementException) {
            return defaultValue;
        }
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        float[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            float first = sortedArray[middleIndex];
            float second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public float[] toSortedArray() {
        float[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableFloatList toSortedList() {
        return FloatArrayList.newList((FloatIterable)this).sortThis();
    }

    public float[] toArray() {
        final float[] array = new float[this.size()];
        this.forEach(new FloatProcedure(){
            private int index = 0;

            public void value(float each) {
                array[this.index++] = each;
            }
        });
        return array;
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        FloatIterator iterator = this.floatIterator();
        while (iterator.hasNext()) {
            result = function.valueOf(result, iterator.next());
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            FloatIterator iterator = this.floatIterator();
            if (iterator.hasNext()) {
                appendable.append(String.valueOf(iterator.next()));
                while (iterator.hasNext()) {
                    appendable.append(separator);
                    appendable.append(String.valueOf(iterator.next()));
                }
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean contains(float value) {
        return this.anySatisfy(FloatPredicates.equal(value));
    }

    public boolean containsAll(float ... source) {
        for (float value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public MutableFloatList toList() {
        return FloatArrayList.newList((FloatIterable)this);
    }

    public MutableFloatSet toSet() {
        return FloatHashSet.newSet((FloatIterable)this);
    }

    public MutableFloatBag toBag() {
        return FloatHashBag.newBag((FloatIterable)this);
    }

    public LazyFloatIterable asLazy() {
        return this;
    }

    private static final class SelectFloatIterator
    implements FloatIterator {
        private final FloatIterator iterator;
        private final FloatPredicate predicate;
        private float next;
        private boolean verifiedHasNext = false;

        private SelectFloatIterator(FloatIterable iterable, FloatPredicate predicate) {
            this(iterable.floatIterator(), predicate);
        }

        private SelectFloatIterator(FloatIterator iterator, FloatPredicate predicate) {
            this.iterator = iterator;
            this.predicate = predicate;
        }

        public boolean hasNext() {
            if (this.verifiedHasNext) {
                return true;
            }
            while (this.iterator.hasNext()) {
                float temp = this.iterator.next();
                if (!this.predicate.accept(temp)) continue;
                this.next = temp;
                this.verifiedHasNext = true;
                return true;
            }
            return false;
        }

        public float next() {
            if (this.verifiedHasNext || this.hasNext()) {
                this.verifiedHasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }

    private final class IfFloatProcedure
    implements FloatProcedure {
        private static final long serialVersionUID = 1L;
        private final FloatProcedure procedure;

        private IfFloatProcedure(FloatProcedure procedure) {
            this.procedure = procedure;
        }

        public void value(float each) {
            if (SelectFloatIterable.this.predicate.accept(each)) {
                this.procedure.value(each);
            }
        }
    }

    private static final class CountFloatProcedure
    implements FloatProcedure {
        private static final long serialVersionUID = 1L;
        private final FloatPredicate predicate;
        private int counter = 0;

        private CountFloatProcedure(FloatPredicate predicate) {
            this.predicate = predicate;
        }

        public void value(float each) {
            if (this.predicate.accept(each)) {
                ++this.counter;
            }
        }

        public int getCount() {
            return this.counter;
        }
    }
}

