/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.immutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.api.list.primitive.BooleanList;
import com.gs.collections.api.list.primitive.ImmutableBooleanList;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.factory.primitive.BooleanLists;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableBooleanSingletonList
implements ImmutableBooleanList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean element1;

    ImmutableBooleanSingletonList(boolean element) {
        this.element1 = element;
    }

    public boolean get(int index) {
        if (index == 0) {
            return this.element1;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
    }

    public boolean getFirst() {
        return this.element1;
    }

    public boolean getLast() {
        return this.element1;
    }

    public int indexOf(boolean value) {
        return this.element1 == value ? 0 : -1;
    }

    public int lastIndexOf(boolean value) {
        return this.element1 == value ? 0 : -1;
    }

    public BooleanIterator booleanIterator() {
        return BooleanArrayList.newListWith(this.element1).booleanIterator();
    }

    public void forEach(BooleanProcedure procedure) {
        procedure.value(this.element1);
    }

    public int count(BooleanPredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !predicate.accept(this.element1);
    }

    public ImmutableBooleanList select(BooleanPredicate predicate) {
        return predicate.accept(this.element1) ? BooleanArrayList.newListWith(this.element1).toImmutable() : new BooleanArrayList().toImmutable();
    }

    public ImmutableBooleanList reject(BooleanPredicate predicate) {
        return predicate.accept(this.element1) ? new BooleanArrayList().toImmutable() : BooleanArrayList.newListWith(this.element1).toImmutable();
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public <V> ImmutableList<V> collect(BooleanToObjectFunction<? extends V> function) {
        return FastList.newListWith(function.valueOf(this.element1)).toImmutable();
    }

    public boolean[] toArray() {
        return new boolean[]{this.element1};
    }

    public boolean contains(boolean value) {
        return this.element1 == value;
    }

    public boolean containsAll(boolean ... source) {
        for (boolean value : source) {
            if (this.element1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(BooleanIterable source) {
        BooleanIterator iterator = source.booleanIterator();
        while (iterator.hasNext()) {
            if (this.element1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableBooleanList toList() {
        return BooleanArrayList.newListWith(this.element1);
    }

    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSetWith(this.element1);
    }

    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBagWith(this.element1);
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    public ImmutableBooleanList toImmutable() {
        return this;
    }

    public ImmutableBooleanList newWith(boolean element) {
        return BooleanLists.immutable.with(new boolean[]{this.element1, element});
    }

    public ImmutableBooleanList newWithout(boolean element) {
        return this.element1 == element ? BooleanLists.immutable.with() : this;
    }

    public ImmutableBooleanList newWithAll(BooleanIterable elements) {
        BooleanArrayList arrayList = BooleanArrayList.newListWith(this.element1);
        arrayList.addAll(elements);
        return arrayList.toImmutable();
    }

    public ImmutableBooleanList newWithoutAll(BooleanIterable elements) {
        return elements.contains(this.element1) ? BooleanLists.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1);
    }

    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof BooleanList)) {
            return false;
        }
        BooleanList list = (BooleanList)otherList;
        if (list.size() != 1) {
            return false;
        }
        return this.element1 == list.get(0);
    }

    public int hashCode() {
        return 31 + (this.element1 ? 1231 : 1237);
    }

    public String toString() {
        return "[" + this.element1 + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

