/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.api.list.primitive.CharList;
import com.gs.collections.api.list.primitive.ImmutableCharList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableCharEmptyList
implements ImmutableCharList,
Serializable {
    static final ImmutableCharList INSTANCE = new ImmutableCharEmptyList();
    private static final long serialVersionUID = 1L;

    ImmutableCharEmptyList() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public char get(int index) {
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
    }

    public char getFirst() {
        throw new IndexOutOfBoundsException("Index: 0, Size: 0");
    }

    public char getLast() {
        throw new IndexOutOfBoundsException("Index: 0, Size: 0");
    }

    public int indexOf(char value) {
        return -1;
    }

    public int lastIndexOf(char value) {
        return -1;
    }

    public CharIterator charIterator() {
        return new InternalCharIterator();
    }

    public void forEach(CharProcedure procedure) {
    }

    public int count(CharPredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return false;
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return true;
    }

    public ImmutableCharList select(CharPredicate predicate) {
        return this;
    }

    public ImmutableCharList reject(CharPredicate predicate) {
        return this;
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return ifNone;
    }

    public <V> ImmutableList<V> collect(CharToObjectFunction<? extends V> function) {
        return Lists.immutable.of();
    }

    public long sum() {
        return 0L;
    }

    public char max() {
        throw new NoSuchElementException();
    }

    public char maxIfEmpty(char defaultValue) {
        return defaultValue;
    }

    public char min() {
        throw new NoSuchElementException();
    }

    public char minIfEmpty(char defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public char[] toSortedArray() {
        return new char[0];
    }

    public MutableCharList toSortedList() {
        return new CharArrayList();
    }

    public long dotProduct(CharList list) {
        if (!list.isEmpty()) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        return 0L;
    }

    public char[] toArray() {
        return new char[0];
    }

    public boolean contains(char value) {
        return false;
    }

    public boolean containsAll(char ... source) {
        return source.length == 0;
    }

    public boolean containsAll(CharIterable source) {
        return source.isEmpty();
    }

    public MutableCharList toList() {
        return new CharArrayList();
    }

    public MutableCharSet toSet() {
        return new CharHashSet();
    }

    public MutableCharBag toBag() {
        return new CharHashBag();
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public ImmutableCharList toImmutable() {
        return this;
    }

    public ImmutableCharList newWith(char element) {
        return CharLists.immutable.with(element);
    }

    public ImmutableCharList newWithout(char element) {
        return this;
    }

    public ImmutableCharList newWithAll(CharIterable elements) {
        return CharLists.immutable.withAll(elements);
    }

    public ImmutableCharList newWithoutAll(CharIterable elements) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof CharList)) {
            return false;
        }
        CharList list = (CharList)otherList;
        return list.isEmpty();
    }

    public int hashCode() {
        return 1;
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class InternalCharIterator
    implements CharIterator {
        private InternalCharIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public char next() {
            throw new NoSuchElementException();
        }
    }
}

