/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.mutable;

import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.block.factory.Procedures;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.list.mutable.AbstractMutableList;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.parallel.ParallelIterate;
import com.gs.collections.impl.utility.Iterate;
import com.gs.collections.impl.utility.ListIterate;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeFastList<E>
extends AbstractMutableList<E>
implements Serializable {
    private static final Predicate2<FastList<?>, Object> REMOVE_PREDICATE = new Predicate2<FastList<?>, Object>(){

        public boolean accept(FastList<?> list, Object toRemove) {
            return list.remove(toRemove);
        }
    };
    private static final Procedure<FastList<?>> REVERSE_LIST_PROCEDURE = new Procedure<FastList<?>>(){

        public void value(FastList<?> each) {
            each.reverseThis();
        }
    };
    private static final long serialVersionUID = 1L;
    private final FastList<FastList<E>> lists = FastList.newList();

    @Override
    public MutableList<E> clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int size = 0;
        for (int i = this.lists.size() - 1; i >= 0; --i) {
            size += this.lists.get(i).size();
        }
        return size;
    }

    @Override
    public CompositeFastList<E> reverseThis() {
        ParallelIterate.forEach(this.lists, REVERSE_LIST_PROCEDURE);
        this.lists.reverseThis();
        return this;
    }

    @Override
    public void forEach(final Procedure<? super E> procedure) {
        this.lists.forEach((Procedure<FastList<E>>)new Procedure<FastList<E>>(){

            public void value(FastList<E> list) {
                list.forEach((Procedure)procedure);
            }
        });
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super E> objectIntProcedure) {
        this.lists.forEach(new ProcedureToInnerListObjectIntProcedure(objectIntProcedure));
    }

    @Override
    public void reverseForEach(final Procedure<? super E> procedure) {
        this.lists.reverseForEach(new Procedure<FastList<E>>(){

            public void value(FastList<E> each) {
                each.reverseForEach(procedure);
            }
        });
    }

    @Override
    public void forEach(int fromIndex, int toIndex, Procedure<? super E> procedure) {
        ListIterate.rangeCheck(fromIndex, toIndex, this.size());
        if (fromIndex > toIndex) {
            super.forEach(fromIndex, toIndex, procedure);
        } else {
            this.optimizedForwardForEach(procedure, fromIndex, toIndex);
        }
    }

    private void optimizedForwardForEach(Procedure<? super E> procedure, int fromIndex, int toIndex) {
        int size;
        ++toIndex;
        int outerIndex = 0;
        FastList<FastList<E>> fastList = this.lists;
        T[] items = fastList.items;
        while ((size = ((FastList)items[outerIndex]).size()) <= fromIndex) {
            fromIndex -= size;
            toIndex -= size;
            ++outerIndex;
        }
        while (true) {
            FastList list;
            int end;
            if (toIndex < (end = (list = (FastList)items[outerIndex++]).size())) {
                end = toIndex;
            }
            for (int j = fromIndex; j < end; ++j) {
                procedure.value(list.items[j]);
            }
            if ((toIndex -= end) == 0) {
                return;
            }
            fromIndex = 0;
        }
    }

    @Override
    public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super E> objectIntProcedure) {
        ListIterate.rangeCheck(fromIndex, toIndex, this.size());
        if (fromIndex > toIndex) {
            super.forEachWithIndex(fromIndex, toIndex, objectIntProcedure);
        } else {
            this.optimizedForwardForEach(Procedures.fromObjectIntProcedure(objectIntProcedure), fromIndex, toIndex);
        }
    }

    @Override
    public <P> void forEachWith(final Procedure2<? super E, ? super P> procedure2, final P parameter) {
        this.lists.forEach((Procedure<FastList<E>>)new Procedure<FastList<E>>(){

            public void value(FastList<E> list) {
                list.forEachWith(procedure2, parameter);
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.lists.allSatisfy(new Predicate<FastList<E>>(){

            public boolean accept(FastList<E> list) {
                return list.isEmpty();
            }
        });
    }

    @Override
    public boolean contains(final Object object) {
        return this.lists.anySatisfy(new Predicate<FastList<E>>(){

            public boolean accept(FastList<E> list) {
                return list.contains(object);
            }
        });
    }

    @Override
    public Iterator<E> iterator() {
        if (this.lists.isEmpty()) {
            return Collections.emptyList().iterator();
        }
        return new CompositeIterator(this.lists);
    }

    @Override
    public Object[] toArray() {
        final Object[] result = new Object[this.size()];
        this.forEachWithIndex((ObjectIntProcedure<? super E>)new ObjectIntProcedure<E>(){

            public void value(E each, int index) {
                result[index] = each;
            }
        });
        return result;
    }

    @Override
    public boolean add(E object) {
        if (this.lists.isEmpty()) {
            this.addComposited(FastList.newList());
        }
        Collection list = this.lists.getLast();
        return list.add(object);
    }

    @Override
    public boolean remove(Object object) {
        return this.lists.anySatisfyWith(REMOVE_PREDICATE, object);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        FastList collectionToAdd = collection instanceof FastList ? collection : new FastList(collection);
        this.addComposited(collectionToAdd);
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return Iterate.allSatisfy(collection, Predicates.in(this));
    }

    @Override
    public Object[] toArray(Object[] array) {
        int size = this.size();
        final Object[] result = array.length >= size ? array : (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        this.forEachWithIndex((ObjectIntProcedure<? super E>)new ObjectIntProcedure<E>(){

            public void value(E each, int index) {
                result[index] = each;
            }
        });
        if (result.length > size) {
            result[size] = null;
        }
        return result;
    }

    public void addComposited(Collection<? extends E> collection) {
        if (!(collection instanceof FastList)) {
            throw new IllegalArgumentException("CompositeFastList can only add FastLists");
        }
        this.lists.add((FastList)collection);
    }

    public boolean addAll(int index, Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.lists.forEach((Procedure<FastList<E>>)new Procedure<FastList<E>>(){

            public void value(FastList<E> object) {
                object.clear();
            }
        });
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        for (int i = this.lists.size() - 1; i >= 0; --i) {
            changed = this.lists.get(i).retainAll(collection) || changed;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (int i = this.lists.size() - 1; i >= 0; --i) {
            changed = this.lists.get(i).removeAll(collection) || changed;
        }
        return changed;
    }

    public E get(int index) {
        this.rangeCheck(index);
        int p = 0;
        int currentSize = this.lists.getFirst().size();
        while (index >= currentSize) {
            index -= currentSize;
            currentSize = this.lists.get(++p).size();
        }
        return (E)this.lists.get((int)p).items[index];
    }

    private void rangeCheck(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("No such element " + index + " size: " + this.size());
        }
    }

    public E set(int index, E element) {
        this.rangeCheck(index);
        int p = 0;
        int currentSize = this.lists.getFirst().size();
        while (index >= currentSize) {
            index -= currentSize;
            currentSize = this.lists.get(++p).size();
        }
        return this.lists.get(p).set(index, element);
    }

    public void add(int index, E element) {
        int localSize = this.size();
        if (index > localSize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + localSize);
        }
        int max = 0;
        for (int i = 0; i < this.lists.size(); ++i) {
            List list = (List)((Object)this.lists.get(i));
            int previousMax = max;
            if (index > (max += list.size())) continue;
            list.add(index - previousMax, element);
            return;
        }
    }

    public E remove(int index) {
        this.rangeCheck(index);
        int p = 0;
        int currentSize = this.lists.getFirst().size();
        while (index >= currentSize) {
            index -= currentSize;
            currentSize = this.lists.get(++p).size();
        }
        return this.lists.get(p).remove(index);
    }

    @Override
    public int indexOf(Object o) {
        int offset = 0;
        int listsSize = this.lists.size();
        for (int i = 0; i < listsSize; ++i) {
            MutableList list = this.lists.get(i);
            int index = list.indexOf(o);
            if (index > -1) {
                return index + offset;
            }
            offset += list.size();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int offset = this.size();
        for (int i = this.lists.size() - 1; i >= 0; --i) {
            MutableList list = this.lists.get(i);
            offset -= list.size();
            int index = list.lastIndexOf(o);
            if (index <= -1) continue;
            return index + offset;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (this.lists.size() == 1) {
            return this.lists.getFirst().listIterator(index);
        }
        if (this.lists.isEmpty()) {
            return Lists.immutable.of().listIterator(index);
        }
        this.flattenLists();
        return super.listIterator(index);
    }

    private void flattenLists() {
        FastList list = (FastList)this.toList();
        this.lists.clear();
        this.lists.add(list);
    }

    @Override
    protected void defaultSort(Comparator<? super E> comparator) {
        FastList list = comparator == null ? (FastList)this.toSortedList() : (FastList)this.toSortedList(comparator);
        this.lists.clear();
        this.lists.add(list);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof List)) {
            return false;
        }
        List otherList = (List)other;
        if (this.size() != otherList.size()) {
            return false;
        }
        Iterator<E> thisIterator = this.iterator();
        Iterator otherIterator = otherList.iterator();
        while (thisIterator.hasNext()) {
            Object otherObject;
            E thisObject = thisIterator.next();
            if (Comparators.nullSafeEquals(thisObject, otherObject = otherIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E item : this) {
            hashCode = 31 * hashCode + (item == null ? 0 : item.hashCode());
        }
        return hashCode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProcedureToInnerListObjectIntProcedure<E>
    implements Procedure<FastList<E>> {
        private static final long serialVersionUID = 1L;
        private int index;
        private final ObjectIntProcedure<? super E> objectIntProcedure;

        private ProcedureToInnerListObjectIntProcedure(ObjectIntProcedure<? super E> objectIntProcedure) {
            this.objectIntProcedure = objectIntProcedure;
        }

        public void value(FastList<E> list) {
            list.forEach((Procedure<E>)new Procedure<E>(){

                public void value(E object) {
                    ProcedureToInnerListObjectIntProcedure.this.objectIntProcedure.value(object, ProcedureToInnerListObjectIntProcedure.this.index);
                    ProcedureToInnerListObjectIntProcedure.this.index++;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CompositeIterator
    implements Iterator<E> {
        private final Iterator<E>[] iterators;
        private Iterator<E> currentIterator;
        private int currentIndex = 0;

        private CompositeIterator(FastList<FastList<E>> newLists) {
            this.iterators = new Iterator[newLists.size()];
            for (int i = 0; i < newLists.size(); ++i) {
                this.iterators[i] = newLists.get(i).iterator();
            }
            this.currentIterator = this.iterators[0];
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.currentIterator.hasNext()) {
                return true;
            }
            if (this.currentIndex < this.iterators.length - 1) {
                this.currentIterator = this.iterators[++this.currentIndex];
                return this.hasNext();
            }
            return false;
        }

        @Override
        public E next() {
            if (this.currentIterator.hasNext()) {
                return this.currentIterator.next();
            }
            if (this.currentIndex < this.iterators.length - 1) {
                this.currentIterator = this.iterators[++this.currentIndex];
                return this.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.currentIterator.remove();
        }
    }
}

