/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharLongPredicate;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.CharLongProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.CharLongMap;
import com.gs.collections.api.map.primitive.ImmutableCharLongMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.CharLongMaps;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.map.mutable.primitive.CharLongHashMap;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableCharLongSingletonMap
implements ImmutableCharLongMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final long EMPTY_VALUE = 0L;
    private final char key1;
    private final long value1;

    ImmutableCharLongSingletonMap(char key1, long value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public long get(char key) {
        return this.getIfAbsent(key, 0L);
    }

    public long getIfAbsent(char key, long ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public long getOrThrow(char key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(char key) {
        return this.key1 == key;
    }

    public boolean containsValue(long value) {
        return this.value1 == value;
    }

    public void forEachValue(LongProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(CharProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(CharLongProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyCharIterable keysView() {
        return CharLongHashMap.newWithKeysValues(this.key1, this.value1).keysView();
    }

    public ImmutableCharLongMap select(CharLongPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? CharLongHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new CharLongHashMap().toImmutable();
    }

    public ImmutableCharLongMap reject(CharLongPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new CharLongHashMap().toImmutable() : CharLongHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public ImmutableCharLongMap toImmutable() {
        return this;
    }

    public LongIterator longIterator() {
        return CharLongHashMap.newWithKeysValues(this.key1, this.value1).longIterator();
    }

    public void forEach(LongProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(LongPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum() {
        return this.value1;
    }

    public long min() {
        return this.value1;
    }

    public long max() {
        return this.value1;
    }

    public long maxIfEmpty(long defaultValue) {
        return this.value1;
    }

    public long minIfEmpty(long defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public long[] toSortedArray() {
        return new long[]{this.value1};
    }

    public MutableLongList toSortedList() {
        return LongArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableLongCollection select(LongPredicate predicate) {
        return predicate.accept(this.value1) ? LongArrayList.newListWith(this.value1).toImmutable() : new LongArrayList().toImmutable();
    }

    public ImmutableLongCollection reject(LongPredicate predicate) {
        return predicate.accept(this.value1) ? new LongArrayList().toImmutable() : LongArrayList.newListWith(this.value1).toImmutable();
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public long[] toArray() {
        return new long[]{this.value1};
    }

    public boolean contains(long value) {
        return this.value1 == value;
    }

    public boolean containsAll(long ... source) {
        for (long value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(LongIterable source) {
        LongIterator iterator = source.longIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableLongList toList() {
        return LongArrayList.newListWith(this.value1);
    }

    public MutableLongSet toSet() {
        return LongHashSet.newSetWith(this.value1);
    }

    public MutableLongBag toBag() {
        return LongHashBag.newBagWith(this.value1);
    }

    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter((LongIterable)this);
    }

    public ImmutableCharLongMap newWithKeyValue(char key, long value) {
        return CharLongMaps.immutable.withAll((CharLongMap)CharLongHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableCharLongMap newWithoutKey(char key) {
        return this.key1 == key ? CharLongMaps.immutable.with() : this;
    }

    public ImmutableCharLongMap newWithoutAllKeys(CharIterable keys) {
        return keys.contains(this.key1) ? CharLongMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableCharSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableLongCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharLongMap)) {
            return false;
        }
        CharLongMap map = (CharLongMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return this.key1 ^ (int)(this.value1 ^ this.value1 >>> 32);
    }

    public String toString() {
        return this.makeString("{", ", ", "}");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.key1));
            appendable.append("=");
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

