/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.predicate.primitive.CharObjectPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.CharObjectProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.primitive.CharObjectMap;
import com.gs.collections.api.map.primitive.ImmutableCharObjectMap;
import com.gs.collections.api.map.sorted.MutableSortedMap;
import com.gs.collections.api.multimap.Multimap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.partition.PartitionIterable;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.UnmodifiableIteratorAdapter;
import com.gs.collections.impl.block.procedure.MutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.PartitionProcedure;
import com.gs.collections.impl.factory.Bags;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.Maps;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.SortedMaps;
import com.gs.collections.impl.factory.SortedSets;
import com.gs.collections.impl.factory.primitive.BooleanLists;
import com.gs.collections.impl.factory.primitive.ByteLists;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.factory.primitive.FloatLists;
import com.gs.collections.impl.factory.primitive.IntLists;
import com.gs.collections.impl.factory.primitive.LongLists;
import com.gs.collections.impl.factory.primitive.ShortLists;
import com.gs.collections.impl.lazy.LazyIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.map.immutable.primitive.AbstractImmutableCharObjectMap;
import com.gs.collections.impl.map.immutable.primitive.ImmutableCharObjectEmptyMap;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.map.mutable.primitive.CharObjectHashMap;
import com.gs.collections.impl.multimap.list.FastListMultimap;
import com.gs.collections.impl.partition.list.PartitionFastList;
import com.gs.collections.impl.tuple.Tuples;
import com.gs.collections.impl.utility.Iterate;
import com.gs.collections.impl.utility.internal.IterableIterate;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableCharObjectSingletonMap<V>
extends AbstractImmutableCharObjectMap<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final char key1;
    private final V value1;

    ImmutableCharObjectSingletonMap(char key1, V value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public V get(char key) {
        return this.key1 == key ? (V)this.value1 : null;
    }

    public V getIfAbsent(char key, Function0<? extends V> ifAbsent) {
        return (V)(this.key1 == key ? this.value1 : ifAbsent.value());
    }

    public boolean containsKey(char key) {
        return this.key1 == key;
    }

    public boolean containsValue(Object value) {
        return ImmutableCharObjectSingletonMap.nullSafeEquals(this.value1, value);
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    public void forEachValue(Procedure<? super V> procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(CharProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(CharObjectProcedure<? super V> procedure) {
        procedure.value(this.key1, this.value1);
    }

    public ImmutableCharObjectMap<V> select(CharObjectPredicate<? super V> predicate) {
        return predicate.accept(this.key1, this.value1) ? CharObjectHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : ImmutableCharObjectEmptyMap.INSTANCE;
    }

    public ImmutableCharObjectMap<V> reject(CharObjectPredicate<? super V> predicate) {
        return predicate.accept(this.key1, this.value1) ? ImmutableCharObjectEmptyMap.INSTANCE : CharObjectHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableCharObjectMap<V> toImmutable() {
        return this;
    }

    public int size() {
        return 1;
    }

    public MutableCharSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public Collection<V> values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharObjectMap)) {
            return false;
        }
        CharObjectMap map = (CharObjectMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && ImmutableCharObjectSingletonMap.nullSafeEquals(this.value1, map.get(this.key1));
    }

    public int hashCode() {
        return this.key1 ^ (this.value1 == null ? 0 : this.value1.hashCode());
    }

    public String toString() {
        return this.makeString("{", ", ", "}");
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public V getFirst() {
        return this.value1;
    }

    public V getLast() {
        return this.value1;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public boolean containsAllIterable(Iterable<?> source) {
        Iterator<?> iterator = source.iterator();
        while (iterator.hasNext()) {
            if (ImmutableCharObjectSingletonMap.nullSafeEquals(this.value1, iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(Collection<?> source) {
        return this.containsAllIterable(source);
    }

    public boolean containsAllArguments(Object ... elements) {
        for (Object item : elements) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public ImmutableCollection<V> select(Predicate<? super V> predicate) {
        return predicate.accept(this.value1) ? Lists.immutable.with(this.value1) : Lists.immutable.with();
    }

    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target) {
        if (predicate.accept(this.value1)) {
            target.add(this.value1);
        }
        return target;
    }

    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        if (predicate.accept(this.value1, parameter)) {
            targetCollection.add(this.value1);
        }
        return targetCollection;
    }

    public ImmutableCollection<V> reject(Predicate<? super V> predicate) {
        return predicate.accept(this.value1) ? Lists.immutable.with() : Lists.immutable.with(this.value1);
    }

    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target) {
        if (predicate.accept(this.value1)) {
            target.add(this.value1);
        }
        return target;
    }

    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        if (!predicate.accept(this.value1, parameter)) {
            targetCollection.add(this.value1);
        }
        return targetCollection;
    }

    public PartitionIterable<V> partition(Predicate<? super V> predicate) {
        PartitionFastList partitionMutableList = new PartitionFastList();
        this.forEach(new PartitionProcedure<V>(predicate, partitionMutableList));
        return partitionMutableList;
    }

    public <S> RichIterable<S> selectInstancesOf(Class<S> clazz) {
        if (clazz.isInstance(this.value1)) {
            Lists.immutable.with(this.value1);
        }
        return Lists.immutable.with();
    }

    public <V1> ImmutableCollection<V1> collect(Function<? super V, ? extends V1> function) {
        return Lists.immutable.with(function.valueOf(this.value1));
    }

    public ImmutableBooleanCollection collectBoolean(BooleanFunction<? super V> booleanFunction) {
        return BooleanLists.immutable.with(booleanFunction.booleanValueOf(this.value1));
    }

    public ImmutableByteCollection collectByte(ByteFunction<? super V> byteFunction) {
        return ByteLists.immutable.with(byteFunction.byteValueOf(this.value1));
    }

    public ImmutableCharCollection collectChar(CharFunction<? super V> charFunction) {
        return CharLists.immutable.with(charFunction.charValueOf(this.value1));
    }

    public ImmutableDoubleCollection collectDouble(DoubleFunction<? super V> doubleFunction) {
        return DoubleLists.immutable.with(doubleFunction.doubleValueOf(this.value1));
    }

    public ImmutableFloatCollection collectFloat(FloatFunction<? super V> floatFunction) {
        return FloatLists.immutable.with(floatFunction.floatValueOf(this.value1));
    }

    public ImmutableIntCollection collectInt(IntFunction<? super V> intFunction) {
        return IntLists.immutable.with(intFunction.intValueOf(this.value1));
    }

    public ImmutableLongCollection collectLong(LongFunction<? super V> longFunction) {
        return LongLists.immutable.with(longFunction.longValueOf(this.value1));
    }

    public ImmutableShortCollection collectShort(ShortFunction<? super V> shortFunction) {
        return ShortLists.immutable.with(shortFunction.shortValueOf(this.value1));
    }

    public <V1> RichIterable<V1> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends V1> function) {
        return predicate.accept(this.value1) ? Lists.immutable.with(function.valueOf(this.value1)) : Lists.immutable.with();
    }

    public <V1> RichIterable<V1> flatCollect(Function<? super V, ? extends Iterable<V1>> function) {
        return Lists.immutable.withAll((Iterable)function.valueOf(this.value1));
    }

    public V detect(Predicate<? super V> predicate) {
        return predicate.accept(this.value1) ? (V)this.value1 : null;
    }

    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        return (V)(predicate.accept(this.value1) ? this.value1 : function.value());
    }

    public int count(Predicate<? super V> predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public boolean anySatisfy(Predicate<? super V> predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(Predicate<? super V> predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(Predicate<? super V> predicate) {
        return !predicate.accept(this.value1);
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function) {
        return (IV)function.value(injectedValue, this.value1);
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function) {
        return function.intValueOf(injectedValue, this.value1);
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function) {
        return function.longValueOf(injectedValue, this.value1);
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function) {
        return function.floatValueOf(injectedValue, this.value1);
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function) {
        return function.doubleValueOf(injectedValue, this.value1);
    }

    public MutableList<V> toList() {
        return Lists.mutable.with(new Object[]{this.value1});
    }

    public MutableList<V> toSortedList() {
        return Lists.mutable.with(new Object[]{this.value1});
    }

    public MutableList<V> toSortedList(Comparator<? super V> comparator) {
        return Lists.mutable.with(new Object[]{this.value1});
    }

    public MutableSet<V> toSet() {
        return Sets.mutable.with(new Object[]{this.value1});
    }

    public MutableSortedSet<V> toSortedSet() {
        return SortedSets.mutable.with(new Object[]{this.value1});
    }

    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator) {
        return SortedSets.mutable.with(new Object[]{this.value1});
    }

    public MutableBag<V> toBag() {
        return Bags.mutable.with(new Object[]{this.value1});
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return Maps.mutable.with(keyFunction.valueOf(this.value1), valueFunction.valueOf(this.value1));
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return SortedMaps.mutable.with(keyFunction.valueOf(this.value1), valueFunction.valueOf(this.value1));
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return SortedMaps.mutable.with(keyFunction.valueOf(this.value1), valueFunction.valueOf(this.value1));
    }

    public LazyIterable<V> asLazy() {
        return new LazyIterableAdapter<Object>(FastList.newListWith(this.value1));
    }

    public Object[] toArray() {
        return new Object[]{this.value1};
    }

    public <T> T[] toArray(T[] a) {
        return new Object[]{this.value1};
    }

    public V min(Comparator<? super V> comparator) {
        return this.value1;
    }

    public V max(Comparator<? super V> comparator) {
        return this.value1;
    }

    public V min() {
        return this.value1;
    }

    public V max() {
        return this.value1;
    }

    public long sumOfInt(IntFunction<? super V> function) {
        return function.intValueOf(this.value1);
    }

    public double sumOfFloat(FloatFunction<? super V> function) {
        return function.floatValueOf(this.value1);
    }

    public long sumOfLong(LongFunction<? super V> function) {
        return function.longValueOf(this.value1);
    }

    public double sumOfDouble(DoubleFunction<? super V> function) {
        return function.doubleValueOf(this.value1);
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.key1));
            appendable.append("=");
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <V1> Multimap<V1, V> groupBy(Function<? super V, ? extends V1> function) {
        return new FastListMultimap(Tuples.pair(function.valueOf(this.value1), this.value1));
    }

    public <V1> Multimap<V1, V> groupByEach(Function<? super V, ? extends Iterable<V1>> function) {
        return this.groupByEach(function, FastListMultimap.newMultimap());
    }

    public <S> RichIterable<Pair<V, S>> zip(Iterable<S> that) {
        return (RichIterable)this.zip(that, FastList.newList());
    }

    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target) {
        return IterableIterate.zip(this, that, target);
    }

    public RichIterable<Pair<V, Integer>> zipWithIndex() {
        return (RichIterable)this.zipWithIndex(FastList.newList());
    }

    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target) {
        return IterableIterate.zipWithIndex(this, target);
    }

    public RichIterable<RichIterable<V>> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.of();
        result.add(FastList.newListWith(this.value1));
        return result;
    }

    public <K, V1> MapIterable<K, V1> aggregateInPlaceBy(Function<? super V, ? extends K> groupBy, Function0<? extends V1> zeroValueFactory, Procedure2<? super V1, ? super V> mutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new MutatingAggregationProcedure<V, K, V1>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    public <K, V1> MapIterable<K, V1> aggregateBy(Function<? super V, ? extends K> groupBy, Function0<? extends V1> zeroValueFactory, Function2<? super V1, ? super V, ? extends V1> nonMutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new NonMutatingAggregationProcedure<V, K, V1>(map, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map;
    }

    public <V1, R extends MutableMultimap<V1, V>> R groupByEach(Function<? super V, ? extends Iterable<V1>> function, R target) {
        return IterableIterate.groupByEach(this, function, target);
    }

    public <V1, R extends MutableMultimap<V1, V>> R groupBy(Function<? super V, ? extends V1> function, R target) {
        target.put(function.valueOf(this.value1), this.value1);
        return target;
    }

    public <V1 extends Comparable<? super V1>> V maxBy(Function<? super V, ? extends V1> function) {
        return this.value1;
    }

    public <V1 extends Comparable<? super V1>> V minBy(Function<? super V, ? extends V1> function) {
        return this.value1;
    }

    public <V1 extends Comparable<? super V1>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends V1> function) {
        return SortedSets.mutable.with(new Object[]{this.value1});
    }

    public <V1 extends Comparable<? super V1>> MutableList<V> toSortedListBy(Function<? super V, ? extends V1> function) {
        return Lists.mutable.of(new Object[]{this.value1});
    }

    public <V1, R extends Collection<V1>> R flatCollect(Function<? super V, ? extends Iterable<V1>> function, R target) {
        Iterate.addAllTo((Iterable)function.valueOf(this.value1), target);
        return target;
    }

    public <V1, R extends Collection<V1>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends V1> function, R target) {
        if (predicate.accept(this.value1)) {
            target.add((Object)function.valueOf(this.value1));
        }
        return target;
    }

    public <P, V1, R extends Collection<V1>> R collectWith(Function2<? super V, ? super P, ? extends V1> function, P parameter, R targetCollection) {
        targetCollection.add((Object)function.value(this.value1, parameter));
        return targetCollection;
    }

    public <V1, R extends Collection<V1>> R collect(Function<? super V, ? extends V1> function, R target) {
        target.add((Object)function.valueOf(this.value1));
        return target;
    }

    public ImmutableCharObjectMap<V> newWithKeyValue(char key, V value) {
        return CharObjectHashMap.newWithKeysValues(this.key1, this.value1, key, value).toImmutable();
    }

    public ImmutableCharObjectMap<V> newWithoutKey(char key) {
        return this.key1 == key ? ImmutableCharObjectEmptyMap.INSTANCE : this;
    }

    public ImmutableCharObjectMap<V> newWithoutAllKeys(CharIterable keys) {
        return keys.contains(this.key1) ? ImmutableCharObjectEmptyMap.INSTANCE : this;
    }

    public void forEach(Procedure<? super V> procedure) {
        procedure.value(this.value1);
    }

    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        objectIntProcedure.value(this.value1, 1);
    }

    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        procedure.value(this.value1, parameter);
    }

    public Iterator<V> iterator() {
        return new UnmodifiableIteratorAdapter<V>(CharObjectHashMap.newWithKeysValues(this.key1, this.value1).iterator());
    }

    private Object writeReplace() {
        return new AbstractImmutableCharObjectMap.ImmutableCharObjectMapSerializationProxy(this);
    }
}

