/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.DoubleBytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleByteProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.map.primitive.DoubleByteMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleByteMap;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.DoubleByteMaps;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.map.mutable.primitive.DoubleByteHashMap;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableDoubleByteSingletonMap
implements ImmutableDoubleByteMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_VALUE = 0;
    private final double key1;
    private final byte value1;

    ImmutableDoubleByteSingletonMap(double key1, byte value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public byte get(double key) {
        return this.getIfAbsent(key, (byte)0);
    }

    public byte getIfAbsent(double key, byte ifAbsent) {
        return Double.compare(this.key1, key) == 0 ? this.value1 : ifAbsent;
    }

    public byte getOrThrow(double key) {
        if (Double.compare(this.key1, key) == 0) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(double key) {
        return Double.compare(this.key1, key) == 0;
    }

    public boolean containsValue(byte value) {
        return this.value1 == value;
    }

    public void forEachValue(ByteProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(DoubleProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(DoubleByteProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyDoubleIterable keysView() {
        return DoubleByteHashMap.newWithKeysValues(this.key1, this.value1).keysView();
    }

    public ImmutableDoubleByteMap select(DoubleBytePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? DoubleByteHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new DoubleByteHashMap().toImmutable();
    }

    public ImmutableDoubleByteMap reject(DoubleBytePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new DoubleByteHashMap().toImmutable() : DoubleByteHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public ImmutableDoubleByteMap toImmutable() {
        return this;
    }

    public ByteIterator byteIterator() {
        return DoubleByteHashMap.newWithKeysValues(this.key1, this.value1).byteIterator();
    }

    public void forEach(ByteProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(BytePredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum() {
        return this.value1;
    }

    public byte min() {
        return this.value1;
    }

    public byte max() {
        return this.value1;
    }

    public byte maxIfEmpty(byte defaultValue) {
        return this.value1;
    }

    public byte minIfEmpty(byte defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public byte[] toSortedArray() {
        return new byte[]{this.value1};
    }

    public MutableByteList toSortedList() {
        return ByteArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableByteCollection select(BytePredicate predicate) {
        return predicate.accept(this.value1) ? ByteArrayList.newListWith(this.value1).toImmutable() : new ByteArrayList().toImmutable();
    }

    public ImmutableByteCollection reject(BytePredicate predicate) {
        return predicate.accept(this.value1) ? new ByteArrayList().toImmutable() : ByteArrayList.newListWith(this.value1).toImmutable();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public byte[] toArray() {
        return new byte[]{this.value1};
    }

    public boolean contains(byte value) {
        return this.value1 == value;
    }

    public boolean containsAll(byte ... source) {
        for (byte value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableByteList toList() {
        return ByteArrayList.newListWith(this.value1);
    }

    public MutableByteSet toSet() {
        return ByteHashSet.newSetWith(this.value1);
    }

    public MutableByteBag toBag() {
        return ByteHashBag.newBagWith(this.value1);
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public ImmutableDoubleByteMap newWithKeyValue(double key, byte value) {
        return DoubleByteMaps.immutable.withAll((DoubleByteMap)DoubleByteHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableDoubleByteMap newWithoutKey(double key) {
        return Double.compare(this.key1, key) == 0 ? DoubleByteMaps.immutable.with() : this;
    }

    public ImmutableDoubleByteMap newWithoutAllKeys(DoubleIterable keys) {
        return keys.contains(this.key1) ? DoubleByteMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableDoubleSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableByteCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DoubleByteMap)) {
            return false;
        }
        DoubleByteMap map = (DoubleByteMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.key1) ^ Double.doubleToLongBits(this.key1) >>> 32) ^ this.value1;
    }

    public String toString() {
        return this.makeString("{", ", ", "}");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.key1));
            appendable.append("=");
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

