/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.IntBooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.IntBooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.map.primitive.ImmutableIntBooleanMap;
import com.gs.collections.api.map.primitive.IntBooleanMap;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.IntBooleanMaps;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.map.mutable.primitive.IntBooleanHashMap;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableIntBooleanSingletonMap
implements ImmutableIntBooleanMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean EMPTY_VALUE = false;
    private final int key1;
    private final boolean value1;

    ImmutableIntBooleanSingletonMap(int key1, boolean value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public boolean get(int key) {
        return this.getIfAbsent(key, false);
    }

    public boolean getIfAbsent(int key, boolean ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public boolean getOrThrow(int key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(int key) {
        return this.key1 == key;
    }

    public boolean containsValue(boolean value) {
        return this.value1 == value;
    }

    public void forEachValue(BooleanProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(IntProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(IntBooleanProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyIntIterable keysView() {
        return IntBooleanHashMap.newWithKeysValues(this.key1, this.value1).keysView();
    }

    public ImmutableIntBooleanMap select(IntBooleanPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? IntBooleanHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new IntBooleanHashMap().toImmutable();
    }

    public ImmutableIntBooleanMap reject(IntBooleanPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new IntBooleanHashMap().toImmutable() : IntBooleanHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public ImmutableIntBooleanMap toImmutable() {
        return this;
    }

    public BooleanIterator booleanIterator() {
        return IntBooleanHashMap.newWithKeysValues(this.key1, this.value1).booleanIterator();
    }

    public void forEach(BooleanProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(BooleanPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableBooleanCollection select(BooleanPredicate predicate) {
        return predicate.accept(this.value1) ? BooleanArrayList.newListWith(this.value1).toImmutable() : new BooleanArrayList().toImmutable();
    }

    public ImmutableBooleanCollection reject(BooleanPredicate predicate) {
        return predicate.accept(this.value1) ? new BooleanArrayList().toImmutable() : BooleanArrayList.newListWith(this.value1).toImmutable();
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public boolean[] toArray() {
        return new boolean[]{this.value1};
    }

    public boolean contains(boolean value) {
        return this.value1 == value;
    }

    public boolean containsAll(boolean ... source) {
        for (boolean value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(BooleanIterable source) {
        BooleanIterator iterator = source.booleanIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableBooleanList toList() {
        return BooleanArrayList.newListWith(this.value1);
    }

    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSetWith(this.value1);
    }

    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBagWith(this.value1);
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    public ImmutableIntBooleanMap newWithKeyValue(int key, boolean value) {
        return IntBooleanMaps.immutable.withAll((IntBooleanMap)IntBooleanHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableIntBooleanMap newWithoutKey(int key) {
        return this.key1 == key ? IntBooleanMaps.immutable.with() : this;
    }

    public ImmutableIntBooleanMap newWithoutAllKeys(IntIterable keys) {
        return keys.contains(this.key1) ? IntBooleanMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableIntSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableBooleanCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntBooleanMap)) {
            return false;
        }
        IntBooleanMap map = (IntBooleanMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return this.key1 ^ (this.value1 ? 1231 : 1237);
    }

    public String toString() {
        return this.makeString("{", ", ", "}");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.key1));
            appendable.append("=");
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

