/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.predicate.primitive.IntDoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.IntDoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.ImmutableIntDoubleMap;
import com.gs.collections.api.map.primitive.IntDoubleMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.IntDoubleMaps;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.map.mutable.primitive.IntDoubleHashMap;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableIntDoubleSingletonMap
implements ImmutableIntDoubleMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_VALUE = 0.0;
    private final int key1;
    private final double value1;

    ImmutableIntDoubleSingletonMap(int key1, double value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public double get(int key) {
        return this.getIfAbsent(key, 0.0);
    }

    public double getIfAbsent(int key, double ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public double getOrThrow(int key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(int key) {
        return this.key1 == key;
    }

    public boolean containsValue(double value) {
        return Double.compare(this.value1, value) == 0;
    }

    public void forEachValue(DoubleProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(IntProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(IntDoubleProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyIntIterable keysView() {
        return IntDoubleHashMap.newWithKeysValues(this.key1, this.value1).keysView();
    }

    public ImmutableIntDoubleMap select(IntDoublePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? IntDoubleHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new IntDoubleHashMap().toImmutable();
    }

    public ImmutableIntDoubleMap reject(IntDoublePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new IntDoubleHashMap().toImmutable() : IntDoubleHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public ImmutableIntDoubleMap toImmutable() {
        return this;
    }

    public DoubleIterator doubleIterator() {
        return IntDoubleHashMap.newWithKeysValues(this.key1, this.value1).doubleIterator();
    }

    public void forEach(DoubleProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(DoublePredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public double sum() {
        return this.value1;
    }

    public double min() {
        return this.value1;
    }

    public double max() {
        return this.value1;
    }

    public double maxIfEmpty(double defaultValue) {
        return this.value1;
    }

    public double minIfEmpty(double defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public double[] toSortedArray() {
        return new double[]{this.value1};
    }

    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableDoubleCollection select(DoublePredicate predicate) {
        return predicate.accept(this.value1) ? DoubleArrayList.newListWith(this.value1).toImmutable() : new DoubleArrayList().toImmutable();
    }

    public ImmutableDoubleCollection reject(DoublePredicate predicate) {
        return predicate.accept(this.value1) ? new DoubleArrayList().toImmutable() : DoubleArrayList.newListWith(this.value1).toImmutable();
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public double[] toArray() {
        return new double[]{this.value1};
    }

    public boolean contains(double value) {
        return Double.compare(this.value1, value) == 0;
    }

    public boolean containsAll(double ... source) {
        for (double value : source) {
            if (Double.compare(this.value1, value) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(DoubleIterable source) {
        DoubleIterator iterator = source.doubleIterator();
        while (iterator.hasNext()) {
            if (Double.compare(this.value1, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    public MutableDoubleList toList() {
        return DoubleArrayList.newListWith(this.value1);
    }

    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSetWith(this.value1);
    }

    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBagWith(this.value1);
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public ImmutableIntDoubleMap newWithKeyValue(int key, double value) {
        return IntDoubleMaps.immutable.withAll((IntDoubleMap)IntDoubleHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableIntDoubleMap newWithoutKey(int key) {
        return this.key1 == key ? IntDoubleMaps.immutable.with() : this;
    }

    public ImmutableIntDoubleMap newWithoutAllKeys(IntIterable keys) {
        return keys.contains(this.key1) ? IntDoubleMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableIntSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableDoubleCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntDoubleMap)) {
            return false;
        }
        IntDoubleMap map = (IntDoubleMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && Double.compare(this.value1, map.getOrThrow(this.key1)) == 0;
    }

    public int hashCode() {
        return this.key1 ^ (int)(Double.doubleToLongBits(this.value1) ^ Double.doubleToLongBits(this.value1) >>> 32);
    }

    public String toString() {
        return this.makeString("{", ", ", "}");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.key1));
            appendable.append("=");
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

