/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntLongPredicate;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.IntLongProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.ImmutableIntLongMap;
import com.gs.collections.api.map.primitive.IntLongMap;
import com.gs.collections.api.map.primitive.MutableIntLongMap;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedIntLongProcedure;
import com.gs.collections.impl.map.mutable.primitive.IntLongHashMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableIntLongHashMap
implements ImmutableIntLongMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableIntLongMap delegate;

    ImmutableIntLongHashMap(IntLongMap delegate) {
        this.delegate = new IntLongHashMap(delegate);
    }

    public long get(int key) {
        return this.delegate.get(key);
    }

    public long getIfAbsent(int key, long ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public long getOrThrow(int key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(int key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(long value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(LongProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(IntProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(IntLongProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyIntIterable keysView() {
        return this.delegate.keysView();
    }

    public ImmutableIntLongMap select(IntLongPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableIntLongMap reject(IntLongPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return ((IntLongHashMap)this.delegate).injectInto(injectedValue, function);
    }

    public ImmutableIntLongMap toImmutable() {
        return this;
    }

    public LongIterator longIterator() {
        return this.delegate.longIterator();
    }

    public void forEach(LongProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(LongPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableLongCollection select(LongPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongCollection reject(LongPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum() {
        return this.delegate.sum();
    }

    public long max() {
        return this.delegate.max();
    }

    public long maxIfEmpty(long defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public long min() {
        return this.delegate.min();
    }

    public long minIfEmpty(long defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public long[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableLongList toSortedList() {
        return this.delegate.toSortedList();
    }

    public long[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(long value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(long ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(LongIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableLongList toList() {
        return this.delegate.toList();
    }

    public MutableLongSet toSet() {
        return this.delegate.toSet();
    }

    public MutableLongBag toBag() {
        return this.delegate.toBag();
    }

    public LazyLongIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableIntLongMap newWithKeyValue(int key, long value) {
        IntLongHashMap map = new IntLongHashMap(this.size() + 1);
        map.putAll((IntLongMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableIntLongMap newWithoutKey(int key) {
        IntLongHashMap map = new IntLongHashMap(this.size());
        map.putAll((IntLongMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableIntLongMap newWithoutAllKeys(IntIterable keys) {
        IntLongHashMap map = new IntLongHashMap(this.size());
        map.putAll((IntLongMap)this);
        IntIterator iterator = keys.intIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableIntSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableLongCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableIntLongMapSerializationProxy((IntLongMap)this);
    }

    protected static class ImmutableIntLongMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private IntLongMap map;

        public ImmutableIntLongMapSerializationProxy() {
        }

        protected ImmutableIntLongMapSerializationProxy(IntLongMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((IntLongProcedure)new CheckedIntLongProcedure(){

                    public void safeValue(int key, long value) throws IOException {
                        out.writeInt(key);
                        out.writeLong(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            IntLongHashMap deserializedMap = new IntLongHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readInt(), in.readLong());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

