/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongLongPredicate;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongLongProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.ImmutableLongLongMap;
import com.gs.collections.api.map.primitive.LongLongMap;
import com.gs.collections.api.map.primitive.MutableLongLongMap;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedLongLongProcedure;
import com.gs.collections.impl.map.mutable.primitive.LongLongHashMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableLongLongHashMap
implements ImmutableLongLongMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableLongLongMap delegate;

    ImmutableLongLongHashMap(LongLongMap delegate) {
        this.delegate = new LongLongHashMap(delegate);
    }

    public long get(long key) {
        return this.delegate.get(key);
    }

    public long getIfAbsent(long key, long ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public long getOrThrow(long key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(long key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(long value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(LongProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(LongProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(LongLongProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyLongIterable keysView() {
        return this.delegate.keysView();
    }

    public ImmutableLongLongMap select(LongLongPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongLongMap reject(LongLongPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return ((LongLongHashMap)this.delegate).injectInto(injectedValue, function);
    }

    public ImmutableLongLongMap toImmutable() {
        return this;
    }

    public LongIterator longIterator() {
        return this.delegate.longIterator();
    }

    public void forEach(LongProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(LongPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableLongCollection select(LongPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongCollection reject(LongPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum() {
        return this.delegate.sum();
    }

    public long max() {
        return this.delegate.max();
    }

    public long maxIfEmpty(long defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public long min() {
        return this.delegate.min();
    }

    public long minIfEmpty(long defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public long[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableLongList toSortedList() {
        return this.delegate.toSortedList();
    }

    public long[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(long value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(long ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(LongIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableLongList toList() {
        return this.delegate.toList();
    }

    public MutableLongSet toSet() {
        return this.delegate.toSet();
    }

    public MutableLongBag toBag() {
        return this.delegate.toBag();
    }

    public LazyLongIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableLongLongMap newWithKeyValue(long key, long value) {
        LongLongHashMap map = new LongLongHashMap(this.size() + 1);
        map.putAll((LongLongMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableLongLongMap newWithoutKey(long key) {
        LongLongHashMap map = new LongLongHashMap(this.size());
        map.putAll((LongLongMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableLongLongMap newWithoutAllKeys(LongIterable keys) {
        LongLongHashMap map = new LongLongHashMap(this.size());
        map.putAll((LongLongMap)this);
        LongIterator iterator = keys.longIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableLongSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableLongCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableLongLongMapSerializationProxy((LongLongMap)this);
    }

    protected static class ImmutableLongLongMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private LongLongMap map;

        public ImmutableLongLongMapSerializationProxy() {
        }

        protected ImmutableLongLongMapSerializationProxy(LongLongMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((LongLongProcedure)new CheckedLongLongProcedure(){

                    public void safeValue(long key, long value) throws IOException {
                        out.writeLong(key);
                        out.writeLong(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            LongLongHashMap deserializedMap = new LongLongHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readLong(), in.readLong());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

