/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortBooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortBooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.map.primitive.ImmutableShortBooleanMap;
import com.gs.collections.api.map.primitive.ShortBooleanMap;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.ShortBooleanMaps;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.map.mutable.primitive.ShortBooleanHashMap;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableShortBooleanSingletonMap
implements ImmutableShortBooleanMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean EMPTY_VALUE = false;
    private final short key1;
    private final boolean value1;

    ImmutableShortBooleanSingletonMap(short key1, boolean value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public boolean get(short key) {
        return this.getIfAbsent(key, false);
    }

    public boolean getIfAbsent(short key, boolean ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public boolean getOrThrow(short key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(short key) {
        return this.key1 == key;
    }

    public boolean containsValue(boolean value) {
        return this.value1 == value;
    }

    public void forEachValue(BooleanProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(ShortProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ShortBooleanProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyShortIterable keysView() {
        return ShortBooleanHashMap.newWithKeysValues(this.key1, this.value1).keysView();
    }

    public ImmutableShortBooleanMap select(ShortBooleanPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? ShortBooleanHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new ShortBooleanHashMap().toImmutable();
    }

    public ImmutableShortBooleanMap reject(ShortBooleanPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new ShortBooleanHashMap().toImmutable() : ShortBooleanHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public ImmutableShortBooleanMap toImmutable() {
        return this;
    }

    public BooleanIterator booleanIterator() {
        return ShortBooleanHashMap.newWithKeysValues(this.key1, this.value1).booleanIterator();
    }

    public void forEach(BooleanProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(BooleanPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableBooleanCollection select(BooleanPredicate predicate) {
        return predicate.accept(this.value1) ? BooleanArrayList.newListWith(this.value1).toImmutable() : new BooleanArrayList().toImmutable();
    }

    public ImmutableBooleanCollection reject(BooleanPredicate predicate) {
        return predicate.accept(this.value1) ? new BooleanArrayList().toImmutable() : BooleanArrayList.newListWith(this.value1).toImmutable();
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public boolean[] toArray() {
        return new boolean[]{this.value1};
    }

    public boolean contains(boolean value) {
        return this.value1 == value;
    }

    public boolean containsAll(boolean ... source) {
        for (boolean value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(BooleanIterable source) {
        BooleanIterator iterator = source.booleanIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableBooleanList toList() {
        return BooleanArrayList.newListWith(this.value1);
    }

    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSetWith(this.value1);
    }

    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBagWith(this.value1);
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    public ImmutableShortBooleanMap newWithKeyValue(short key, boolean value) {
        return ShortBooleanMaps.immutable.withAll((ShortBooleanMap)ShortBooleanHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableShortBooleanMap newWithoutKey(short key) {
        return this.key1 == key ? ShortBooleanMaps.immutable.with() : this;
    }

    public ImmutableShortBooleanMap newWithoutAllKeys(ShortIterable keys) {
        return keys.contains(this.key1) ? ShortBooleanMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableShortSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableBooleanCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShortBooleanMap)) {
            return false;
        }
        ShortBooleanMap map = (ShortBooleanMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return this.key1 ^ (this.value1 ? 1231 : 1237);
    }

    public String toString() {
        return this.makeString("{", ", ", "}");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.key1));
            appendable.append("=");
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

