/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortFloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortFloatProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.ImmutableShortFloatMap;
import com.gs.collections.api.map.primitive.MutableShortFloatMap;
import com.gs.collections.api.map.primitive.ShortFloatMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedShortFloatProcedure;
import com.gs.collections.impl.map.mutable.primitive.ShortFloatHashMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableShortFloatHashMap
implements ImmutableShortFloatMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableShortFloatMap delegate;

    ImmutableShortFloatHashMap(ShortFloatMap delegate) {
        this.delegate = new ShortFloatHashMap(delegate);
    }

    public float get(short key) {
        return this.delegate.get(key);
    }

    public float getIfAbsent(short key, float ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public float getOrThrow(short key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(short key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(float value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(FloatProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(ShortProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ShortFloatProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyShortIterable keysView() {
        return this.delegate.keysView();
    }

    public ImmutableShortFloatMap select(ShortFloatPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableShortFloatMap reject(ShortFloatPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return ((ShortFloatHashMap)this.delegate).injectInto(injectedValue, function);
    }

    public ImmutableShortFloatMap toImmutable() {
        return this;
    }

    public FloatIterator floatIterator() {
        return this.delegate.floatIterator();
    }

    public void forEach(FloatProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(FloatPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableFloatCollection select(FloatPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableFloatCollection reject(FloatPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(FloatToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public double sum() {
        return this.delegate.sum();
    }

    public float max() {
        return this.delegate.max();
    }

    public float maxIfEmpty(float defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public float min() {
        return this.delegate.min();
    }

    public float minIfEmpty(float defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public float[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableFloatList toSortedList() {
        return this.delegate.toSortedList();
    }

    public float[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(float value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(float ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(FloatIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableFloatList toList() {
        return this.delegate.toList();
    }

    public MutableFloatSet toSet() {
        return this.delegate.toSet();
    }

    public MutableFloatBag toBag() {
        return this.delegate.toBag();
    }

    public LazyFloatIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableShortFloatMap newWithKeyValue(short key, float value) {
        ShortFloatHashMap map = new ShortFloatHashMap(this.size() + 1);
        map.putAll((ShortFloatMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableShortFloatMap newWithoutKey(short key) {
        ShortFloatHashMap map = new ShortFloatHashMap(this.size());
        map.putAll((ShortFloatMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableShortFloatMap newWithoutAllKeys(ShortIterable keys) {
        ShortFloatHashMap map = new ShortFloatHashMap(this.size());
        map.putAll((ShortFloatMap)this);
        ShortIterator iterator = keys.shortIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableShortSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableFloatCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableShortFloatMapSerializationProxy((ShortFloatMap)this);
    }

    protected static class ImmutableShortFloatMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ShortFloatMap map;

        public ImmutableShortFloatMapSerializationProxy() {
        }

        protected ImmutableShortFloatMapSerializationProxy(ShortFloatMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((ShortFloatProcedure)new CheckedShortFloatProcedure(){

                    public void safeValue(short key, float value) throws IOException {
                        out.writeShort(key);
                        out.writeFloat(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ShortFloatHashMap deserializedMap = new ShortFloatHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readShort(), in.readFloat());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

