/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.ByteToDoubleFunction;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction0;
import com.gs.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ByteDoublePredicate;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteDoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.ByteDoubleMap;
import com.gs.collections.api.map.primitive.ImmutableByteDoubleMap;
import com.gs.collections.api.map.primitive.MutableByteDoubleMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ByteSet;
import com.gs.collections.api.set.primitive.ImmutableByteSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.block.factory.primitive.BytePredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedDoubleCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.ByteDoubleMaps;
import com.gs.collections.impl.factory.primitive.ByteSets;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.lazy.primitive.CollectByteToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectByteIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedByteDoubleMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableByteDoubleMap;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedByteSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteDoubleHashMap
implements MutableByteDoubleMap,
Externalizable {
    static final double EMPTY_VALUE = 0.0;
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_KEY = 0;
    private static final byte REMOVED_KEY = 1;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private byte[] keys;
    private double[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public ByteDoubleHashMap() {
        this.allocateTable(16);
    }

    public ByteDoubleHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public ByteDoubleHashMap(ByteDoubleMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static ByteDoubleHashMap newWithKeysValues(byte key1, double value1) {
        return new ByteDoubleHashMap(1).withKeyValue(key1, value1);
    }

    public static ByteDoubleHashMap newWithKeysValues(byte key1, double value1, byte key2, double value2) {
        return new ByteDoubleHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static ByteDoubleHashMap newWithKeysValues(byte key1, double value1, byte key2, double value2, byte key3, double value3) {
        return new ByteDoubleHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static ByteDoubleHashMap newWithKeysValues(byte key1, double value1, byte key2, double value2, byte key3, double value3, byte key4, double value4) {
        return new ByteDoubleHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteDoubleMap)) {
            return false;
        }
        ByteDoubleMap other = (ByteDoubleMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey((byte)0) || other.containsKey((byte)1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey((byte)0) || Double.compare(this.sentinelValues.zeroValue, other.getOrThrow((byte)0)) != 0)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey((byte)1) || Double.compare(this.sentinelValues.oneValue, other.getOrThrow((byte)1)) != 0)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte key = this.keys[i];
            if (!ByteDoubleHashMap.isNonSentinel(key) || other.containsKey(key) && Double.compare(this.values[i], other.getOrThrow(key)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ (int)(Double.doubleToLongBits(this.sentinelValues.zeroValue) ^ Double.doubleToLongBits(this.sentinelValues.zeroValue) >>> 32);
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ (int)(Double.doubleToLongBits(this.sentinelValues.oneValue) ^ Double.doubleToLongBits(this.sentinelValues.oneValue) >>> 32);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ (int)(Double.doubleToLongBits(this.values[i]) ^ Double.doubleToLongBits(this.values[i]) >>> 32);
        }
        return result;
    }

    public String toString() {
        return this.makeString("{", ", ", "}");
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(0)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                byte key = this.keys[i];
                if (!ByteDoubleHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DoubleIterator doubleIterator() {
        return new InternalDoubleIterator();
    }

    public double[] toArray() {
        double[] array = new double[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(double value) {
        return this.containsValue(value);
    }

    public boolean containsAll(double ... source) {
        for (double each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(DoubleIterable source) {
        return source.allSatisfy(new DoublePredicate(){

            public boolean accept(double value) {
                return ByteDoubleHashMap.this.contains(value);
            }
        });
    }

    public void forEach(DoubleProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableDoubleCollection select(DoublePredicate predicate) {
        DoubleArrayList result = new DoubleArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableDoubleCollection reject(DoublePredicate predicate) {
        DoubleArrayList result = new DoubleArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public double detectIfNone(DoublePredicate predicate, double value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(DoublePredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectDoubleToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableDoubleList toList() {
        return DoubleArrayList.newList((DoubleIterable)this);
    }

    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSet((DoubleIterable)this);
    }

    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBag((DoubleIterable)this);
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, (byte)0);
        Arrays.fill(this.values, 0.0);
    }

    public void put(byte key, double value) {
        if (ByteDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (ByteDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = value;
            return;
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public void putAll(ByteDoubleMap map) {
        map.forEachKeyValue(new ByteDoubleProcedure(){

            public void value(byte key, double value) {
                ByteDoubleHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(byte key) {
        if (ByteDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0.0;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (ByteDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0.0;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            this.values[index] = 0.0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(byte key) {
        this.removeKey(key);
    }

    public double removeKeyIfAbsent(byte key, double value) {
        if (ByteDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            double oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0.0;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (ByteDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            double oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0.0;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            double oldValue = this.values[index];
            this.values[index] = 0.0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public double getIfAbsentPut(byte key, double value) {
        if (ByteDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (ByteDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public double getIfAbsentPut(byte key, DoubleFunction0 function) {
        double value;
        if (ByteDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value2 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value3 = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (ByteDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value4 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value5 = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.value();
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public <P> double getIfAbsentPutWith(byte key, DoubleFunction<? super P> function, P parameter) {
        double value;
        if (ByteDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value2 = function.doubleValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value3 = function.doubleValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (ByteDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value4 = function.doubleValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value5 = function.doubleValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.doubleValueOf(parameter);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public double getIfAbsentPutWithKey(byte key, ByteToDoubleFunction function) {
        double value;
        if (ByteDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value2 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value3 = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (ByteDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value4 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value5 = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(key);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public double updateValue(byte key, double initialValueIfAbsent, DoubleToDoubleFunction function) {
        double value;
        if (ByteDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(initialValueIfAbsent);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public ByteDoubleHashMap withKeyValue(byte key1, double value1) {
        this.put(key1, value1);
        return this;
    }

    public ByteDoubleHashMap withKeysValues(byte key1, double value1, byte key2, double value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ByteDoubleHashMap withKeysValues(byte key1, double value1, byte key2, double value2, byte key3, double value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ByteDoubleHashMap withKeysValues(byte key1, double value1, byte key2, double value2, byte key3, double value3, byte key4, double value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ByteDoubleHashMap withoutKey(byte key) {
        this.removeKey(key);
        return this;
    }

    public ByteDoubleHashMap withoutAllKeys(ByteIterable keys) {
        keys.forEach(new ByteProcedure(){

            public void value(byte key) {
                ByteDoubleHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableByteDoubleMap asUnmodifiable() {
        return new UnmodifiableByteDoubleMap(this);
    }

    public MutableByteDoubleMap asSynchronized() {
        return new SynchronizedByteDoubleMap(this);
    }

    public ImmutableByteDoubleMap toImmutable() {
        return ByteDoubleMaps.immutable.ofAll((ByteDoubleMap)this);
    }

    public double get(byte key) {
        return this.getIfAbsent(key, 0.0);
    }

    public double getIfAbsent(byte key, double ifAbsent) {
        if (ByteDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public double getOrThrow(byte key) {
        if (ByteDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (ByteDoubleHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(byte key) {
        if (ByteDoubleHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (ByteDoubleHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(double value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(this.keys[i]) || Double.compare(this.values[i], value) != 0) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(DoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(ByteProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((byte)0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((byte)1);
            }
        }
        for (byte key : this.keys) {
            if (!ByteDoubleHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(ByteDoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((byte)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((byte)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyByteIterable keysView() {
        return new KeysView();
    }

    public ByteDoubleHashMap select(ByteDoublePredicate predicate) {
        ByteDoubleHashMap result = new ByteDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept((byte)0, this.sentinelValues.zeroValue)) {
                result.put((byte)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept((byte)1, this.sentinelValues.oneValue)) {
                result.put((byte)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public ByteDoubleHashMap reject(ByteDoublePredicate predicate) {
        ByteDoubleHashMap result = new ByteDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept((byte)0, this.sentinelValues.zeroValue)) {
                result.put((byte)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept((byte)1, this.sentinelValues.oneValue)) {
                result.put((byte)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public double sum() {
        double result = 0.0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.values[i];
        }
        return result;
    }

    public double max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        DoubleIterator iterator = this.doubleIterator();
        double max = iterator.next();
        while (iterator.hasNext()) {
            double value = iterator.next();
            if (Double.compare(max, value) >= 0) continue;
            max = value;
        }
        return max;
    }

    public double maxIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public double min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        DoubleIterator iterator = this.doubleIterator();
        double min = iterator.next();
        while (iterator.hasNext()) {
            double value = iterator.next();
            if (Double.compare(value, min) >= 0) continue;
            min = value;
        }
        return min;
    }

    public double minIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        double[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            double first = sortedArray[middleIndex];
            double second = sortedArray[middleIndex - 1];
            return (first + second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public double[] toSortedArray() {
        double[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newList((DoubleIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeByte(0);
                out.writeDouble(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeByte(1);
                out.writeDouble(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeByte(this.keys[i]);
            out.writeDouble(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readByte(), in.readDouble());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        byte[] old = this.keys;
        double[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ByteDoubleHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(byte element) {
        int index = this.spread(element);
        byte keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(byte element) {
        return element & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new byte[sizeToAllocate];
        this.values = new double[sizeToAllocate];
    }

    private static boolean isEmptyKey(byte key) {
        return key == 0;
    }

    private static boolean isRemovedKey(byte key) {
        return key == 1;
    }

    private static boolean isNonSentinel(byte key) {
        return !ByteDoubleHashMap.isEmptyKey(key) && !ByteDoubleHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableByteSet keySet() {
        return new KeySet();
    }

    public MutableDoubleCollection values() {
        return new ValuesCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableDoubleCollection {
        private ValuesCollection() {
        }

        public void clear() {
            ByteDoubleHashMap.this.clear();
        }

        public MutableDoubleCollection select(DoublePredicate predicate) {
            return ByteDoubleHashMap.this.select(predicate);
        }

        public MutableDoubleCollection reject(DoublePredicate predicate) {
            return ByteDoubleHashMap.this.reject(predicate);
        }

        public double detectIfNone(DoublePredicate predicate, double ifNone) {
            return ByteDoubleHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
            return ByteDoubleHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
            return ByteDoubleHashMap.this.injectInto(injectedValue, function);
        }

        public double sum() {
            return ByteDoubleHashMap.this.sum();
        }

        public double max() {
            return ByteDoubleHashMap.this.max();
        }

        public double maxIfEmpty(double defaultValue) {
            return ByteDoubleHashMap.this.maxIfEmpty(defaultValue);
        }

        public double min() {
            return ByteDoubleHashMap.this.min();
        }

        public double minIfEmpty(double defaultValue) {
            return ByteDoubleHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return ByteDoubleHashMap.this.average();
        }

        public double median() {
            return ByteDoubleHashMap.this.median();
        }

        public double[] toSortedArray() {
            return ByteDoubleHashMap.this.toSortedArray();
        }

        public MutableDoubleList toSortedList() {
            return ByteDoubleHashMap.this.toSortedList();
        }

        public MutableDoubleCollection with(double element) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleCollection without(double element) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleCollection withAll(DoubleIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleCollection withoutAll(DoubleIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleCollection asUnmodifiable() {
            return UnmodifiableDoubleCollection.of(this);
        }

        public MutableDoubleCollection asSynchronized() {
            return SynchronizedDoubleCollection.of(this);
        }

        public ImmutableDoubleCollection toImmutable() {
            return DoubleLists.immutable.withAll((DoubleIterable)this);
        }

        public boolean contains(double value) {
            return ByteDoubleHashMap.this.containsValue(value);
        }

        public boolean containsAll(double ... source) {
            return ByteDoubleHashMap.this.containsAll(source);
        }

        public boolean containsAll(DoubleIterable source) {
            return ByteDoubleHashMap.this.containsAll(source);
        }

        public MutableDoubleList toList() {
            return ByteDoubleHashMap.this.toList();
        }

        public MutableDoubleSet toSet() {
            return ByteDoubleHashMap.this.toSet();
        }

        public MutableDoubleBag toBag() {
            return ByteDoubleHashMap.this.toBag();
        }

        public LazyDoubleIterable asLazy() {
            return new LazyDoubleIterableAdapter((DoubleIterable)this);
        }

        public boolean isEmpty() {
            return ByteDoubleHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ByteDoubleHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ByteDoubleHashMap.this.sentinelValues != null) {
                    if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(ByteDoubleHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (ByteDoubleHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(ByteDoubleHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < ByteDoubleHashMap.this.keys.length; ++i) {
                    byte key = ByteDoubleHashMap.this.keys[i];
                    if (!ByteDoubleHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ByteDoubleHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public DoubleIterator doubleIterator() {
            return ByteDoubleHashMap.this.doubleIterator();
        }

        public void forEach(DoubleProcedure procedure) {
            ByteDoubleHashMap.this.forEach(procedure);
        }

        public int count(DoublePredicate predicate) {
            return ByteDoubleHashMap.this.count(predicate);
        }

        public boolean anySatisfy(DoublePredicate predicate) {
            return ByteDoubleHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(DoublePredicate predicate) {
            return ByteDoubleHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(DoublePredicate predicate) {
            return ByteDoubleHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(double element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(double ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(DoubleIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(double item) {
            int oldSize = ByteDoubleHashMap.this.size();
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey && Double.compare(item, ByteDoubleHashMap.this.sentinelValues.zeroValue) == 0) {
                    ByteDoubleHashMap.this.removeKey((byte)0);
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey && Double.compare(item, ByteDoubleHashMap.this.sentinelValues.oneValue) == 0) {
                    ByteDoubleHashMap.this.removeKey((byte)1);
                }
            }
            for (int i = 0; i < ByteDoubleHashMap.this.keys.length; ++i) {
                if (!ByteDoubleHashMap.isNonSentinel(ByteDoubleHashMap.this.keys[i]) || Double.compare(item, ByteDoubleHashMap.this.values[i]) != 0) continue;
                ByteDoubleHashMap.this.removeKey(ByteDoubleHashMap.this.keys[i]);
            }
            return oldSize != ByteDoubleHashMap.this.size();
        }

        public boolean removeAll(DoubleIterable source) {
            int oldSize = ByteDoubleHashMap.this.size();
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != ByteDoubleHashMap.this.size();
        }

        public boolean removeAll(double ... source) {
            int oldSize = ByteDoubleHashMap.this.size();
            for (double item : source) {
                this.remove(item);
            }
            return oldSize != ByteDoubleHashMap.this.size();
        }

        public int size() {
            return ByteDoubleHashMap.this.size();
        }

        public double[] toArray() {
            return ByteDoubleHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableByteSet {
        private KeySet() {
        }

        public ByteIterator byteIterator() {
            return new KeySetIterator();
        }

        public void forEach(ByteProcedure procedure) {
            ByteDoubleHashMap.this.forEachKey(procedure);
        }

        public int count(BytePredicate predicate) {
            int count = 0;
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    ++count;
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    ++count;
                }
            }
            for (byte key : ByteDoubleHashMap.this.keys) {
                if (!ByteDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(BytePredicate predicate) {
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return true;
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return true;
                }
            }
            for (byte key : ByteDoubleHashMap.this.keys) {
                if (!ByteDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(BytePredicate predicate) {
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((byte)0)) {
                    return false;
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey && !predicate.accept((byte)1)) {
                    return false;
                }
            }
            for (byte key : ByteDoubleHashMap.this.keys) {
                if (!ByteDoubleHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(BytePredicate predicate) {
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return false;
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return false;
                }
            }
            for (byte key : ByteDoubleHashMap.this.keys) {
                if (!ByteDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(byte element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(byte ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(ByteIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(byte key) {
            int oldSize = ByteDoubleHashMap.this.size();
            ByteDoubleHashMap.this.removeKey(key);
            return oldSize != ByteDoubleHashMap.this.size();
        }

        public boolean removeAll(ByteIterable source) {
            int oldSize = ByteDoubleHashMap.this.size();
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                ByteDoubleHashMap.this.removeKey(iterator.next());
            }
            return oldSize != ByteDoubleHashMap.this.size();
        }

        public boolean removeAll(byte ... source) {
            int oldSize = ByteDoubleHashMap.this.size();
            for (byte item : source) {
                ByteDoubleHashMap.this.removeKey(item);
            }
            return oldSize != ByteDoubleHashMap.this.size();
        }

        public void clear() {
            ByteDoubleHashMap.this.clear();
        }

        public MutableByteSet select(BytePredicate predicate) {
            ByteHashSet result = new ByteHashSet();
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    result.add((byte)0);
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    result.add((byte)1);
                }
            }
            for (byte key : ByteDoubleHashMap.this.keys) {
                if (!ByteDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableByteSet reject(BytePredicate predicate) {
            ByteHashSet result = new ByteHashSet();
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((byte)0)) {
                    result.add((byte)0);
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey && !predicate.accept((byte)1)) {
                    result.add((byte)1);
                }
            }
            for (byte key : ByteDoubleHashMap.this.keys) {
                if (!ByteDoubleHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableByteSet with(byte element) {
            throw new UnsupportedOperationException();
        }

        public MutableByteSet without(byte element) {
            throw new UnsupportedOperationException();
        }

        public MutableByteSet withAll(ByteIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableByteSet withoutAll(ByteIterable elements) {
            throw new UnsupportedOperationException();
        }

        public byte detectIfNone(BytePredicate predicate, byte ifNone) {
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return 0;
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return 1;
                }
            }
            for (byte key : ByteDoubleHashMap.this.keys) {
                if (!ByteDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(ByteToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf((byte)0));
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf((byte)1));
                }
            }
            for (byte key : ByteDoubleHashMap.this.keys) {
                if (!ByteDoubleHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableByteSet asUnmodifiable() {
            return UnmodifiableByteSet.of(this);
        }

        public MutableByteSet asSynchronized() {
            return SynchronizedByteSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (byte key : ByteDoubleHashMap.this.keys) {
                if (!ByteDoubleHashMap.isNonSentinel(key)) continue;
                sum += (long)key;
            }
            return sum;
        }

        public byte max() {
            if (ByteDoubleHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            byte max = 0;
            boolean isMaxSet = false;
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0;
                    isMaxSet = true;
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < 1)) {
                    max = 1;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < ByteDoubleHashMap.this.keys.length; ++i) {
                if (!ByteDoubleHashMap.isNonSentinel(ByteDoubleHashMap.this.keys[i]) || isMaxSet && max >= ByteDoubleHashMap.this.keys[i]) continue;
                max = ByteDoubleHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public byte maxIfEmpty(byte defaultValue) {
            if (ByteDoubleHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public byte min() {
            if (ByteDoubleHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            byte min = 0;
            boolean isMinSet = false;
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0;
                    isMinSet = true;
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey && (!isMinSet || 1 < min)) {
                    min = 1;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < ByteDoubleHashMap.this.keys.length; ++i) {
                if (!ByteDoubleHashMap.isNonSentinel(ByteDoubleHashMap.this.keys[i]) || isMinSet && ByteDoubleHashMap.this.keys[i] >= min) continue;
                min = ByteDoubleHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public byte minIfEmpty(byte defaultValue) {
            if (ByteDoubleHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            byte[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                byte first = sortedArray[middleIndex];
                byte second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public byte[] toSortedArray() {
            byte[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableByteList toSortedList() {
            return ByteArrayList.newList((ByteIterable)this).sortThis();
        }

        public byte[] toArray() {
            int size = ByteDoubleHashMap.this.size();
            final byte[] result = new byte[size];
            ByteDoubleHashMap.this.forEachKey(new ByteProcedure(){
                private int index;

                public void value(byte each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(byte value) {
            return ByteDoubleHashMap.this.containsKey(value);
        }

        public boolean containsAll(byte ... source) {
            for (byte item : source) {
                if (ByteDoubleHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(ByteIterable source) {
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                if (ByteDoubleHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableByteList toList() {
            return ByteArrayList.newList((ByteIterable)this);
        }

        public MutableByteSet toSet() {
            return ByteHashSet.newSet((ByteIterable)this);
        }

        public MutableByteBag toBag() {
            return ByteHashBag.newBag((ByteIterable)this);
        }

        public LazyByteIterable asLazy() {
            return new LazyByteIterableAdapter((ByteIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, (byte)0);
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, (byte)1);
                }
            }
            for (int i = 0; i < ByteDoubleHashMap.this.keys.length; ++i) {
                if (!ByteDoubleHashMap.isNonSentinel(ByteDoubleHashMap.this.keys[i])) continue;
                result = function.valueOf(result, ByteDoubleHashMap.this.keys[i]);
            }
            return result;
        }

        public ByteSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableByteSet toImmutable() {
            return ByteSets.immutable.withAll((ByteIterable)this);
        }

        public int size() {
            return ByteDoubleHashMap.this.size();
        }

        public boolean isEmpty() {
            return ByteDoubleHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ByteDoubleHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ByteSet)) {
                return false;
            }
            ByteSet other = (ByteSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < ByteDoubleHashMap.this.keys.length; ++i) {
                if (!ByteDoubleHashMap.isNonSentinel(ByteDoubleHashMap.this.keys[i])) continue;
                result += ByteDoubleHashMap.this.keys[i];
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ByteDoubleHashMap.this.sentinelValues != null) {
                    if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (ByteDoubleHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (byte key : ByteDoubleHashMap.this.keys) {
                    if (!ByteDoubleHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements ByteIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < ByteDoubleHashMap.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ByteDoubleHashMap.this.containsKey((byte)0)) {
                    return 0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ByteDoubleHashMap.this.containsKey((byte)1)) {
                    return 1;
                }
            }
            byte[] keys = ByteDoubleHashMap.this.keys;
            while (!ByteDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            byte result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyByteIterable {
        private KeysView() {
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public int size() {
            return ByteDoubleHashMap.this.size();
        }

        public boolean isEmpty() {
            return ByteDoubleHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ByteDoubleHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ByteDoubleHashMap.this.sentinelValues != null) {
                    if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (ByteDoubleHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (byte key : ByteDoubleHashMap.this.keys) {
                    if (!ByteDoubleHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ByteIterator byteIterator() {
            return new KeySetIterator();
        }

        public boolean contains(byte key) {
            return ByteDoubleHashMap.this.containsKey(key);
        }

        public boolean containsAll(byte ... keys) {
            for (byte key : keys) {
                if (ByteDoubleHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(ByteIterable source) {
            return source.allSatisfy(new BytePredicate(){

                public boolean accept(byte key) {
                    return ByteDoubleHashMap.this.containsKey(key);
                }
            });
        }

        public void forEach(ByteProcedure procedure) {
            ByteDoubleHashMap.this.forEachKey(procedure);
        }

        public int count(BytePredicate predicate) {
            int count = 0;
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    ++count;
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    ++count;
                }
            }
            for (byte key : ByteDoubleHashMap.this.keys) {
                if (!ByteDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(BytePredicate predicate) {
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return true;
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return true;
                }
            }
            for (byte key : ByteDoubleHashMap.this.keys) {
                if (!ByteDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(BytePredicate predicate) {
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((byte)0)) {
                    return false;
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey && !predicate.accept((byte)1)) {
                    return false;
                }
            }
            for (byte key : ByteDoubleHashMap.this.keys) {
                if (!ByteDoubleHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(BytePredicate predicate) {
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return false;
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return false;
                }
            }
            for (byte key : ByteDoubleHashMap.this.keys) {
                if (!ByteDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public LazyByteIterable select(BytePredicate predicate) {
            return new SelectByteIterable((ByteIterable)this, predicate);
        }

        public LazyByteIterable reject(BytePredicate predicate) {
            return new SelectByteIterable((ByteIterable)this, BytePredicates.not(predicate));
        }

        public byte detectIfNone(BytePredicate predicate, byte value) {
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return 0;
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return 1;
                }
            }
            for (byte key : ByteDoubleHashMap.this.keys) {
                if (!ByteDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(ByteToObjectFunction<? extends V> function) {
            return new CollectByteToObjectIterable<V>((ByteIterable)this, function);
        }

        public long sum() {
            long result = 0L;
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0L;
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (byte key : ByteDoubleHashMap.this.keys) {
                if (!ByteDoubleHashMap.isNonSentinel(key)) continue;
                result += (long)key;
            }
            return result;
        }

        public byte max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            ByteIterator iterator = this.byteIterator();
            byte max = iterator.next();
            while (iterator.hasNext()) {
                byte value = iterator.next();
                if (max >= value) continue;
                max = value;
            }
            return max;
        }

        public byte min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            ByteIterator iterator = this.byteIterator();
            byte min = iterator.next();
            while (iterator.hasNext()) {
                byte value = iterator.next();
                if (value >= min) continue;
                min = value;
            }
            return min;
        }

        public byte minIfEmpty(byte defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public byte maxIfEmpty(byte defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            byte[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                byte first = sortedArray[middleIndex];
                byte second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public byte[] toSortedArray() {
            byte[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public byte[] toArray() {
            int size = ByteDoubleHashMap.this.size();
            final byte[] result = new byte[size];
            ByteDoubleHashMap.this.forEachKey(new ByteProcedure(){
                private int index;

                public void value(byte each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (ByteDoubleHashMap.this.sentinelValues != null) {
                if (ByteDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, (byte)0);
                }
                if (ByteDoubleHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, (byte)1);
                }
            }
            for (int i = 0; i < ByteDoubleHashMap.this.keys.length; ++i) {
                if (!ByteDoubleHashMap.isNonSentinel(ByteDoubleHashMap.this.keys[i])) continue;
                result = function.valueOf(result, ByteDoubleHashMap.this.keys[i]);
            }
            return result;
        }

        public MutableByteList toList() {
            return ByteArrayList.newList((ByteIterable)this);
        }

        public MutableByteList toSortedList() {
            return ByteArrayList.newList((ByteIterable)this).sortThis();
        }

        public MutableByteSet toSet() {
            return ByteHashSet.newSet((ByteIterable)this);
        }

        public MutableByteBag toBag() {
            return ByteHashBag.newBag((ByteIterable)this);
        }

        public LazyByteIterable asLazy() {
            return this;
        }
    }

    private class InternalDoubleIterator
    implements DoubleIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalDoubleIterator() {
        }

        public boolean hasNext() {
            return this.count < ByteDoubleHashMap.this.size();
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ByteDoubleHashMap.this.containsKey((byte)0)) {
                    return ByteDoubleHashMap.this.get((byte)0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ByteDoubleHashMap.this.containsKey((byte)1)) {
                    return ByteDoubleHashMap.this.get((byte)1);
                }
            }
            byte[] keys = ByteDoubleHashMap.this.keys;
            while (!ByteDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            double result = ByteDoubleHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private double zeroValue;
        private double oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(double value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && Double.compare(this.zeroValue, value) == 0;
            boolean valueEqualsOneValue = this.containsOneKey && Double.compare(this.oneValue, value) == 0;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

