/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.predicate.primitive.ByteObjectPredicate;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ByteObjectProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.primitive.ByteObjectMap;
import com.gs.collections.api.map.primitive.ImmutableByteObjectMap;
import com.gs.collections.api.map.primitive.MutableByteObjectMap;
import com.gs.collections.api.map.sorted.MutableSortedMap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.partition.list.PartitionMutableList;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ByteSet;
import com.gs.collections.api.set.primitive.ImmutableByteSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.block.procedure.MapCollectProcedure;
import com.gs.collections.impl.block.procedure.MutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.PartitionProcedure;
import com.gs.collections.impl.block.procedure.SelectInstancesOfProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectBooleanProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectByteProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectCharProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectDoubleProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectFloatProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectIntProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectLongProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectShortProcedure;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.ByteObjectMaps;
import com.gs.collections.impl.factory.primitive.ByteSets;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedByteObjectMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableByteObjectMap;
import com.gs.collections.impl.map.sorted.mutable.TreeSortedMap;
import com.gs.collections.impl.multimap.list.FastListMultimap;
import com.gs.collections.impl.partition.list.PartitionFastList;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedByteSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import com.gs.collections.impl.utility.Iterate;
import com.gs.collections.impl.utility.LazyIterate;
import com.gs.collections.impl.utility.internal.IterableIterate;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteObjectHashMap<V>
implements MutableByteObjectMap<V>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final byte EMPTY_KEY = 0;
    private static final byte REMOVED_KEY = 1;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private byte[] keys;
    private V[] values;
    private SentinelValues<V> sentinelValues;
    private int occupiedWithData;
    private int occupiedWithSentinels;

    public ByteObjectHashMap() {
        this.allocateTable(16);
    }

    public ByteObjectHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public ByteObjectHashMap(ByteObjectMap<? extends V> map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static <V> ByteObjectHashMap<V> newMap() {
        return new ByteObjectHashMap<V>();
    }

    public static <V> ByteObjectHashMap<V> newWithKeysValues(byte key, V value) {
        return new ByteObjectHashMap<V>(1).withKeyValue(key, (Object)value);
    }

    public static <V> ByteObjectHashMap<V> newWithKeysValues(byte key1, V value1, byte key2, V value2) {
        return new ByteObjectHashMap<V>(2).withKeysValues(key1, value1, key2, value2);
    }

    public static <V> ByteObjectHashMap<V> newWithKeysValues(byte key1, V value1, byte key2, V value2, byte key3, V value3) {
        return new ByteObjectHashMap<V>(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteObjectMap)) {
            return false;
        }
        ByteObjectMap other = (ByteObjectMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey((byte)0) || other.containsKey((byte)1)) {
                return false;
            }
        } else {
            if (!(!((SentinelValues)this.sentinelValues).containsZeroKey || other.containsKey((byte)0) && ByteObjectHashMap.nullSafeEquals(((SentinelValues)this.sentinelValues).zeroValue, other.get((byte)0)))) {
                return false;
            }
            if (!(!((SentinelValues)this.sentinelValues).containsOneKey || other.containsKey((byte)1) && ByteObjectHashMap.nullSafeEquals(((SentinelValues)this.sentinelValues).oneValue, other.get((byte)1)))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte key = this.keys[i];
            if (!ByteObjectHashMap.isNonSentinel(key) || other.containsKey(key) && ByteObjectHashMap.nullSafeEquals(this.values[i], other.get(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result += 0 ^ (((SentinelValues)this.sentinelValues).zeroValue == null ? 0 : ((SentinelValues)this.sentinelValues).zeroValue.hashCode());
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result += 1 ^ (((SentinelValues)this.sentinelValues).oneValue == null ? 0 : ((SentinelValues)this.sentinelValues).oneValue.hashCode());
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ (this.values[i] == null ? 0 : this.values[i].hashCode());
        }
        return result;
    }

    public String toString() {
        return this.makeString("{", ", ", "}");
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                    appendable.append(String.valueOf(0)).append("=").append(String.valueOf(((SentinelValues)this.sentinelValues).zeroValue));
                    first = false;
                }
                if (((SentinelValues)this.sentinelValues).containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1)).append("=").append(String.valueOf(((SentinelValues)this.sentinelValues).oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                byte key = this.keys[i];
                if (!ByteObjectHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<V> iterator() {
        return new InternalIterator();
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result[index++] = ((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result[index++] = ((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result[index++] = this.values[i];
        }
        return result;
    }

    public <T> T[] toArray(T[] a) {
        int size = this.size();
        final Object[] result = a.length < size ? (Object[])Array.newInstance(a.getClass().getComponentType(), size) : a;
        this.forEachWithIndex(new ObjectIntProcedure<Object>(){

            public void value(Object each, int index) {
                result[index] = each;
            }
        });
        if (result.length > size) {
            result[size] = null;
        }
        return result;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public boolean containsAllIterable(Iterable<?> source) {
        for (Object item : source) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(Collection<?> source) {
        return this.containsAllIterable(source);
    }

    public boolean containsAllArguments(Object ... elements) {
        for (Object item : elements) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public void forEach(Procedure<? super V> procedure) {
        this.forEachValue(procedure);
    }

    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        int index = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                objectIntProcedure.value(((SentinelValues)this.sentinelValues).zeroValue, index++);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                objectIntProcedure.value(((SentinelValues)this.sentinelValues).oneValue, index++);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            objectIntProcedure.value(this.values[i], index++);
        }
    }

    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value(((SentinelValues)this.sentinelValues).zeroValue, parameter);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value(((SentinelValues)this.sentinelValues).oneValue, parameter);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i], parameter);
        }
    }

    public void forEachValue(Procedure<? super V> procedure) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(ByteProcedure procedure) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value((byte)0);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value((byte)1);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    public void forEachKeyValue(ByteObjectProcedure<? super V> procedure) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value((byte)0, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value((byte)1, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public ByteObjectHashMap<V> select(ByteObjectPredicate<? super V> predicate) {
        ByteObjectHashMap<Object> result = ByteObjectHashMap.newMap();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept((byte)0, ((SentinelValues)this.sentinelValues).zeroValue)) {
                result.put((byte)0, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept((byte)1, ((SentinelValues)this.sentinelValues).oneValue)) {
                result.put((byte)1, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public ByteObjectHashMap<V> reject(ByteObjectPredicate<? super V> predicate) {
        ByteObjectHashMap<Object> result = ByteObjectHashMap.newMap();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept((byte)0, ((SentinelValues)this.sentinelValues).zeroValue)) {
                result.put((byte)0, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept((byte)1, ((SentinelValues)this.sentinelValues).oneValue)) {
                result.put((byte)1, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public MutableCollection<V> select(Predicate<? super V> predicate) {
        FastList result = FastList.newList();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                result.add(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                result.add(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            target.add(this.values[i]);
        }
        return target;
    }

    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            targetCollection.add(this.values[i]);
        }
        return targetCollection;
    }

    public MutableCollection<V> reject(Predicate<? super V> predicate) {
        FastList result = FastList.newList();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                result.add(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                result.add(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            target.add(this.values[i]);
        }
        return target;
    }

    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i], parameter)) continue;
            targetCollection.add(this.values[i]);
        }
        return targetCollection;
    }

    public PartitionMutableList<V> partition(Predicate<? super V> predicate) {
        PartitionFastList partitionMutableList = new PartitionFastList();
        this.forEach(new PartitionProcedure<V>(predicate, partitionMutableList));
        return partitionMutableList;
    }

    public <S> MutableList<S> selectInstancesOf(Class<S> clazz) {
        FastList result = FastList.newList(this.size());
        this.forEach(new SelectInstancesOfProcedure<S>(clazz, result));
        result.trimToSize();
        return result;
    }

    public <V1> MutableCollection<V1> collect(Function<? super V, ? extends V1> function) {
        return this.collect(function, FastList.newList(this.size()));
    }

    public MutableBooleanCollection collectBoolean(BooleanFunction<? super V> booleanFunction) {
        BooleanArrayList result = new BooleanArrayList(this.size());
        this.forEach(new CollectBooleanProcedure<V>(booleanFunction, (MutableBooleanCollection)result));
        return result;
    }

    public MutableByteCollection collectByte(ByteFunction<? super V> byteFunction) {
        ByteArrayList result = new ByteArrayList(this.size());
        this.forEach(new CollectByteProcedure<V>(byteFunction, (MutableByteCollection)result));
        return result;
    }

    public MutableCharCollection collectChar(CharFunction<? super V> charFunction) {
        CharArrayList result = new CharArrayList(this.size());
        this.forEach(new CollectCharProcedure<V>(charFunction, (MutableCharCollection)result));
        return result;
    }

    public MutableDoubleCollection collectDouble(DoubleFunction<? super V> doubleFunction) {
        DoubleArrayList result = new DoubleArrayList(this.size());
        this.forEach(new CollectDoubleProcedure<V>(doubleFunction, (MutableDoubleCollection)result));
        return result;
    }

    public MutableFloatCollection collectFloat(FloatFunction<? super V> floatFunction) {
        FloatArrayList result = new FloatArrayList(this.size());
        this.forEach(new CollectFloatProcedure<V>(floatFunction, (MutableFloatCollection)result));
        return result;
    }

    public MutableIntCollection collectInt(IntFunction<? super V> intFunction) {
        IntArrayList result = new IntArrayList(this.size());
        this.forEach(new CollectIntProcedure<V>(intFunction, (MutableIntCollection)result));
        return result;
    }

    public MutableLongCollection collectLong(LongFunction<? super V> longFunction) {
        LongArrayList result = new LongArrayList(this.size());
        this.forEach(new CollectLongProcedure<V>(longFunction, (MutableLongCollection)result));
        return result;
    }

    public MutableShortCollection collectShort(ShortFunction<? super V> shortFunction) {
        ShortArrayList result = new ShortArrayList(this.size());
        this.forEach(new CollectShortProcedure<V>(shortFunction, (MutableShortCollection)result));
        return result;
    }

    public <P, V1, R extends Collection<V1>> R collectWith(Function2<? super V, ? super P, ? extends V1> function, P parameter, R targetCollection) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                targetCollection.add((Object)function.value(((SentinelValues)this.sentinelValues).zeroValue, parameter));
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                targetCollection.add((Object)function.value(((SentinelValues)this.sentinelValues).oneValue, parameter));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            targetCollection.add((Object)function.value(this.values[i], parameter));
        }
        return targetCollection;
    }

    public <V1, R extends Collection<V1>> R collect(Function<? super V, ? extends V1> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                target.add((Object)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue));
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                target.add((Object)function.valueOf(((SentinelValues)this.sentinelValues).oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            target.add((Object)function.valueOf(this.values[i]));
        }
        return target;
    }

    public <V1> MutableList<V1> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends V1> function) {
        return this.collectIf(predicate, function, FastList.newList());
    }

    public <V1, R extends Collection<V1>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends V1> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                target.add((Object)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue));
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                target.add((Object)function.valueOf(((SentinelValues)this.sentinelValues).oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            target.add((Object)function.valueOf(this.values[i]));
        }
        return target;
    }

    public <V1> MutableList<V1> flatCollect(Function<? super V, ? extends Iterable<V1>> function) {
        return this.flatCollect(function, FastList.newList());
    }

    public <V1, R extends Collection<V1>> R flatCollect(Function<? super V, ? extends Iterable<V1>> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                Iterate.addAllTo((Iterable)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue), target);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                Iterate.addAllTo((Iterable)function.valueOf(((SentinelValues)this.sentinelValues).oneValue), target);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            Iterate.addAllTo((Iterable)function.valueOf(this.values[i]), target);
        }
        return target;
    }

    public V detect(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return null;
    }

    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return (V)function.value();
    }

    public int count(Predicate<? super V> predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                ++count;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return true;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return false;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return false;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.value(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.value(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.value(result, this.values[i]);
        }
        return result;
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function) {
        int result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.intValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.intValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.intValueOf(result, this.values[i]);
        }
        return result;
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function) {
        long result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.longValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.longValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.longValueOf(result, this.values[i]);
        }
        return result;
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function) {
        float result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.floatValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.floatValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.floatValueOf(result, this.values[i]);
        }
        return result;
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function) {
        double result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.doubleValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.doubleValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.doubleValueOf(result, this.values[i]);
        }
        return result;
    }

    public <S> MutableList<Pair<V, S>> zip(Iterable<S> that) {
        return this.zip(that, FastList.newList());
    }

    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target) {
        return IterableIterate.zip(this, that, target);
    }

    public MutableList<Pair<V, Integer>> zipWithIndex() {
        return this.zipWithIndex(FastList.newList());
    }

    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target) {
        return IterableIterate.zipWithIndex(this, target);
    }

    public RichIterable<RichIterable<V>> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        Iterator<V> iterator = this.iterator();
        MutableList result = Lists.mutable.of();
        while (iterator.hasNext()) {
            FastList batch = FastList.newList();
            for (int i = 0; i < size && iterator.hasNext(); ++i) {
                batch.add(iterator.next());
            }
            result.add(batch);
        }
        return result;
    }

    public <K, V1> MutableMap<K, V1> aggregateInPlaceBy(Function<? super V, ? extends K> groupBy, Function0<? extends V1> zeroValueFactory, Procedure2<? super V1, ? super V> mutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new MutatingAggregationProcedure<V, K, V1>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    public <K, V1> MutableMap<K, V1> aggregateBy(Function<? super V, ? extends K> groupBy, Function0<? extends V1> zeroValueFactory, Function2<? super V1, ? super V, ? extends V1> nonMutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new NonMutatingAggregationProcedure<V, K, V1>(map, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map;
    }

    public <V1> MutableMultimap<V1, V> groupBy(Function<? super V, ? extends V1> function) {
        return this.groupBy(function, FastListMultimap.newMultimap());
    }

    public <V1, R extends MutableMultimap<V1, V>> R groupBy(Function<? super V, ? extends V1> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                target.put(function.valueOf(((SentinelValues)this.sentinelValues).zeroValue), ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                target.put(function.valueOf(((SentinelValues)this.sentinelValues).oneValue), ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            target.put(function.valueOf(this.values[i]), this.values[i]);
        }
        return target;
    }

    public <V1> MutableMultimap<V1, V> groupByEach(Function<? super V, ? extends Iterable<V1>> function) {
        return this.groupByEach(function, FastListMultimap.newMultimap());
    }

    public <V1, R extends MutableMultimap<V1, V>> R groupByEach(Function<? super V, ? extends Iterable<V1>> function, R target) {
        return IterableIterate.groupByEach(this, function, target);
    }

    public V getFirst() {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            return this.values[i];
        }
        return null;
    }

    public V getLast() {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            return this.values[i];
        }
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public MutableList<V> toList() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public MutableList<V> toSortedList() {
        return this.toList().sortThis();
    }

    public MutableList<V> toSortedList(Comparator<? super V> comparator) {
        return this.toList().sortThis(comparator);
    }

    public <V1 extends Comparable<? super V1>> MutableList<V> toSortedListBy(Function<? super V, ? extends V1> function) {
        return this.toList().sortThis(Comparators.byFunction(function));
    }

    /*
     * Exception decompiling
     */
    public MutableSet<V> toSet() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public MutableSortedSet<V> toSortedSet() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public <V1 extends Comparable<? super V1>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends V1> function) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public MutableBag<V> toBag() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new MapCollectProcedure<V, NK, NV>(map, keyFunction, valueFunction));
        return map;
    }

    /*
     * Exception decompiling
     */
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        TreeSortedMap sortedMap = TreeSortedMap.newMap(comparator);
        this.forEach(new MapCollectProcedure<V, NK, NV>(sortedMap, keyFunction, valueFunction));
        return sortedMap;
    }

    public LazyIterable<V> asLazy() {
        return LazyIterate.adapt(this);
    }

    public V min(Comparator<? super V> comparator) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object min = null;
        boolean isMinSet = false;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                min = ((SentinelValues)this.sentinelValues).zeroValue;
                isMinSet = true;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && (!isMinSet || comparator.compare(min, ((SentinelValues)this.sentinelValues).oneValue) > 0)) {
                min = ((SentinelValues)this.sentinelValues).oneValue;
                isMinSet = true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || isMinSet && comparator.compare(min, this.values[i]) <= 0) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return (V)min;
    }

    public V max(Comparator<? super V> comparator) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object max = null;
        boolean isMaxSet = false;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                max = ((SentinelValues)this.sentinelValues).zeroValue;
                isMaxSet = true;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && (!isMaxSet || comparator.compare(max, ((SentinelValues)this.sentinelValues).oneValue) < 0)) {
                max = ((SentinelValues)this.sentinelValues).oneValue;
                isMaxSet = true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || isMaxSet && comparator.compare(max, this.values[i]) >= 0) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return (V)max;
    }

    /*
     * Exception decompiling
     */
    public V min() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public V max() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <V1 extends Comparable<? super V1>> V maxBy(Function<? super V, ? extends V1> function) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object max = null;
        boolean isMaxSet = false;
        Comparable maxValue = null;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                max = ((SentinelValues)this.sentinelValues).zeroValue;
                isMaxSet = true;
                maxValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                Comparable nextValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
                if (!isMaxSet || nextValue.compareTo(maxValue) > 0) {
                    max = ((SentinelValues)this.sentinelValues).oneValue;
                    isMaxSet = true;
                    maxValue = nextValue;
                }
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            V next = this.values[i];
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (isMaxSet && nextValue.compareTo(maxValue) <= 0) continue;
            max = next;
            isMaxSet = true;
            maxValue = nextValue;
        }
        return (V)max;
    }

    public <V1 extends Comparable<? super V1>> V minBy(Function<? super V, ? extends V1> function) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object min = null;
        boolean isMinSet = false;
        Comparable minValue = null;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                min = ((SentinelValues)this.sentinelValues).zeroValue;
                isMinSet = true;
                minValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                Comparable nextValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
                if (!isMinSet || nextValue.compareTo(minValue) < 0) {
                    min = ((SentinelValues)this.sentinelValues).oneValue;
                    isMinSet = true;
                    minValue = nextValue;
                }
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            V next = this.values[i];
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (isMinSet && nextValue.compareTo(minValue) >= 0) continue;
            min = next;
            isMinSet = true;
            minValue = nextValue;
        }
        return (V)min;
    }

    public long sumOfInt(IntFunction<? super V> function) {
        long sum = 0L;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                sum += (long)function.intValueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                sum += (long)function.intValueOf(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            sum += (long)function.intValueOf(this.values[i]);
        }
        return sum;
    }

    public double sumOfFloat(FloatFunction<? super V> function) {
        double sum = 0.0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                sum += (double)function.floatValueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                sum += (double)function.floatValueOf(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            sum += (double)function.floatValueOf(this.values[i]);
        }
        return sum;
    }

    public long sumOfLong(LongFunction<? super V> function) {
        long sum = 0L;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                sum += function.longValueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                sum += function.longValueOf(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            sum += function.longValueOf(this.values[i]);
        }
        return sum;
    }

    public double sumOfDouble(DoubleFunction<? super V> function) {
        double sum = 0.0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                sum += function.doubleValueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                sum += function.doubleValueOf(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            sum += function.doubleValueOf(this.values[i]);
        }
        return sum;
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, (byte)0);
        Arrays.fill(this.values, null);
    }

    public V put(byte key, V value) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).zeroValue;
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return (V)oldValue;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).oneValue;
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return (V)oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            V oldValue = this.values[index];
            this.values[index] = value;
            return oldValue;
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return null;
    }

    public void putAll(ByteObjectMap<? extends V> map) {
        map.forEachKeyValue(new ByteObjectProcedure<V>(){

            public void value(byte key, V value) {
                ByteObjectHashMap.this.put(key, value);
            }
        });
    }

    public boolean containsKey(byte key) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && ((SentinelValues)this.sentinelValues).containsZeroKey;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && ((SentinelValues)this.sentinelValues).containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(Object value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !ByteObjectHashMap.nullSafeEquals(this.values[i], value)) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public V get(byte key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public V getIfAbsent(byte key, Function0<? extends V> ifAbsent) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)ifAbsent.value();
            }
            return (V)((SentinelValues)this.sentinelValues).zeroValue;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)ifAbsent.value();
            }
            return (V)((SentinelValues)this.sentinelValues).oneValue;
        }
        int index = this.probe(key);
        if (this.keys[this.probe(key)] == key) {
            return this.values[index];
        }
        return (V)ifAbsent.value();
    }

    public V getIfAbsentPut(byte key, V value) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return value;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public V getIfAbsentPut(byte key, Function0<? extends V> function) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.value();
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return (V)value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            Object value = function.value();
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return (V)value;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.value();
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return (V)value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            Object value = function.value();
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return (V)value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        Object value = function.value();
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return (V)value;
    }

    public <P> V getIfAbsentPutWith(byte key, Function<? super P, ? extends V> function, P parameter) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.valueOf(parameter);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return (V)value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            Object value = function.valueOf(parameter);
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return (V)value;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.valueOf(parameter);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return (V)value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            Object value = function.valueOf(parameter);
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return (V)value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        Object value = function.valueOf(parameter);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return (V)value;
    }

    public V getIfAbsentPutWithKey(byte key, ByteToObjectFunction<? extends V> function) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return (V)value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            Object value = function.valueOf(key);
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return (V)value;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return (V)value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            Object value = function.valueOf(key);
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return (V)value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        Object value = function.valueOf(key);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return (V)value;
    }

    public V updateValue(byte key, Function0<? extends V> factory, Function<? super V, ? extends V> function) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.valueOf(factory.value());
            } else if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                ((SentinelValues)this.sentinelValues).zeroValue = function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
            } else {
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.valueOf(factory.value());
            }
            return (V)((SentinelValues)this.sentinelValues).zeroValue;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.valueOf(factory.value());
            } else if (((SentinelValues)this.sentinelValues).containsOneKey) {
                ((SentinelValues)this.sentinelValues).oneValue = function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
            } else {
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.valueOf(factory.value());
            }
            return (V)((SentinelValues)this.sentinelValues).oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        Object value = function.valueOf(factory.value());
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return (V)value;
    }

    public <P> V updateValueWith(byte key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.value(factory.value(), parameter);
            } else if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                ((SentinelValues)this.sentinelValues).zeroValue = function.value(((SentinelValues)this.sentinelValues).zeroValue, parameter);
            } else {
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.value(factory.value(), parameter);
            }
            return (V)((SentinelValues)this.sentinelValues).zeroValue;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.value(factory.value(), parameter);
            } else if (((SentinelValues)this.sentinelValues).containsOneKey) {
                ((SentinelValues)this.sentinelValues).oneValue = function.value(((SentinelValues)this.sentinelValues).oneValue, parameter);
            } else {
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.value(factory.value(), parameter);
            }
            return (V)((SentinelValues)this.sentinelValues).oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.value(this.values[index], parameter);
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        Object value = function.value(factory.value(), parameter);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return (V)value;
    }

    public V removeKey(byte key) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsZeroKey) {
                return null;
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).zeroValue;
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                ((SentinelValues)this.sentinelValues).containsZeroKey = false;
                ((SentinelValues)this.sentinelValues).zeroValue = null;
            } else {
                this.sentinelValues = null;
            }
            return (V)oldValue;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsOneKey) {
                return null;
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).oneValue;
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                ((SentinelValues)this.sentinelValues).containsOneKey = false;
                ((SentinelValues)this.sentinelValues).oneValue = null;
            } else {
                this.sentinelValues = null;
            }
            return (V)oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            V oldValue = this.values[index];
            this.values[index] = null;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return null;
    }

    public V remove(byte key) {
        return this.removeKey(key);
    }

    public ByteObjectHashMap<V> withKeyValue(byte key, V value) {
        this.put(key, value);
        return this;
    }

    public MutableByteObjectMap<V> withoutKey(byte key) {
        this.removeKey(key);
        return this;
    }

    public MutableByteObjectMap<V> withoutAllKeys(ByteIterable keys) {
        ByteIterator iterator = keys.byteIterator();
        while (iterator.hasNext()) {
            byte item = iterator.next();
            this.removeKey(item);
        }
        return this;
    }

    public ByteObjectHashMap<V> withKeysValues(byte key1, V value1, byte key2, V value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ByteObjectHashMap<V> withKeysValues(byte key1, V value1, byte key2, V value2, byte key3, V value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ByteObjectHashMap<V> withKeysValues(byte key1, V value1, byte key2, V value2, byte key3, V value3, byte key4, V value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public MutableByteObjectMap<V> asUnmodifiable() {
        return new UnmodifiableByteObjectMap(this);
    }

    public MutableByteObjectMap<V> asSynchronized() {
        return new SynchronizedByteObjectMap(this);
    }

    public ImmutableByteObjectMap<V> toImmutable() {
        return ByteObjectMaps.immutable.withAll((ByteObjectMap)this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                out.writeByte(0);
                out.writeObject(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                out.writeByte(1);
                out.writeObject(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeByte(this.keys[i]);
            out.writeObject(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readByte(), in.readObject());
        }
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    public MutableByteSet keySet() {
        return new KeySet();
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        byte[] old = this.keys;
        V[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(byte element) {
        int index = this.spread(element);
        byte keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(byte element) {
        return element & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new byte[sizeToAllocate];
        this.values = new Object[sizeToAllocate];
    }

    private static boolean isEmptyKey(byte key) {
        return key == 0;
    }

    private static boolean isRemovedKey(byte key) {
        return key == 1;
    }

    private static boolean isNonSentinel(byte key) {
        return !ByteObjectHashMap.isEmptyKey(key) && !ByteObjectHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public Collection<V> values() {
        return new ValuesCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ValuesCollection
    implements Collection<V> {
        protected ValuesCollection() {
        }

        @Override
        public boolean add(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ByteObjectHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return ByteObjectHashMap.this.containsValue(o);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return Iterate.allSatisfy(collection, Predicates.in(this));
        }

        @Override
        public boolean isEmpty() {
            return ByteObjectHashMap.this.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return ByteObjectHashMap.this.iterator();
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    if (it.next() != null) continue;
                    it.remove();
                    return true;
                }
            } else {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    Object o2 = it.next();
                    if (o != o2 && !o2.equals(o)) continue;
                    it.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object obj : collection) {
                if (!this.remove(obj)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            Iterator e = this.iterator();
            while (e.hasNext()) {
                if (collection.contains(e.next())) continue;
                e.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public int size() {
            return ByteObjectHashMap.this.size();
        }

        @Override
        public Object[] toArray() {
            return ByteObjectHashMap.this.toArray();
        }

        @Override
        public <T> T[] toArray(T[] result) {
            return ByteObjectHashMap.this.toArray(result);
        }
    }

    private class KeysSetIterator
    implements ByteIterator {
        private int count;
        private int position;
        private boolean handledZeroKey;
        private boolean handledOneKey;

        private KeysSetIterator() {
        }

        public boolean hasNext() {
            return this.count != ByteObjectHashMap.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            if (!this.handledZeroKey) {
                this.handledZeroKey = true;
                if (ByteObjectHashMap.this.containsKey((byte)0)) {
                    return 0;
                }
            }
            if (!this.handledOneKey) {
                this.handledOneKey = true;
                if (ByteObjectHashMap.this.containsKey((byte)1)) {
                    return 1;
                }
            }
            byte[] keys = ByteObjectHashMap.this.keys;
            while (!ByteObjectHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            byte result = ByteObjectHashMap.this.keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableByteSet {
        private KeySet() {
        }

        public ByteIterator byteIterator() {
            return new KeysSetIterator();
        }

        public void forEach(ByteProcedure procedure) {
            ByteObjectHashMap.this.forEachKey(procedure);
        }

        public int count(BytePredicate predicate) {
            int count = 0;
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    ++count;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    ++count;
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(BytePredicate predicate) {
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return true;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return true;
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(BytePredicate predicate) {
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((byte)0)) {
                    return false;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey && !predicate.accept((byte)1)) {
                    return false;
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(BytePredicate predicate) {
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return false;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return false;
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(byte element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(byte ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(ByteIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(byte key) {
            int oldSize = ByteObjectHashMap.this.size();
            ByteObjectHashMap.this.removeKey(key);
            return oldSize != ByteObjectHashMap.this.size();
        }

        public boolean removeAll(ByteIterable source) {
            int oldSize = ByteObjectHashMap.this.size();
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                ByteObjectHashMap.this.removeKey(iterator.next());
            }
            return oldSize != ByteObjectHashMap.this.size();
        }

        public boolean removeAll(byte ... source) {
            int oldSize = ByteObjectHashMap.this.size();
            for (byte item : source) {
                ByteObjectHashMap.this.removeKey(item);
            }
            return oldSize != ByteObjectHashMap.this.size();
        }

        public void clear() {
            ByteObjectHashMap.this.clear();
        }

        public MutableByteSet select(BytePredicate predicate) {
            ByteHashSet result = new ByteHashSet();
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    result.add((byte)0);
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    result.add((byte)1);
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableByteSet reject(BytePredicate predicate) {
            ByteHashSet result = new ByteHashSet();
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((byte)0)) {
                    result.add((byte)0);
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey && !predicate.accept((byte)1)) {
                    result.add((byte)1);
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableByteSet with(byte element) {
            throw new UnsupportedOperationException();
        }

        public MutableByteSet without(byte element) {
            throw new UnsupportedOperationException();
        }

        public MutableByteSet withAll(ByteIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableByteSet withoutAll(ByteIterable elements) {
            throw new UnsupportedOperationException();
        }

        public byte detectIfNone(BytePredicate predicate, byte ifNone) {
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return 0;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return 1;
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(ByteToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf((byte)0));
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf((byte)1));
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableByteSet asUnmodifiable() {
            return UnmodifiableByteSet.of(this);
        }

        public MutableByteSet asSynchronized() {
            return SynchronizedByteSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key)) continue;
                sum += (long)key;
            }
            return sum;
        }

        public byte max() {
            if (ByteObjectHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            byte max = 0;
            boolean isMaxSet = false;
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0;
                    isMaxSet = true;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < 1)) {
                    max = 1;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < ByteObjectHashMap.this.keys.length; ++i) {
                if (!ByteObjectHashMap.isNonSentinel(ByteObjectHashMap.this.keys[i]) || isMaxSet && max >= ByteObjectHashMap.this.keys[i]) continue;
                max = ByteObjectHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public byte maxIfEmpty(byte defaultValue) {
            if (ByteObjectHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public byte min() {
            if (ByteObjectHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            byte min = 0;
            boolean isMinSet = false;
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0;
                    isMinSet = true;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey && (!isMinSet || 1 < min)) {
                    min = 1;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < ByteObjectHashMap.this.keys.length; ++i) {
                if (!ByteObjectHashMap.isNonSentinel(ByteObjectHashMap.this.keys[i]) || isMinSet && ByteObjectHashMap.this.keys[i] >= min) continue;
                min = ByteObjectHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public byte minIfEmpty(byte defaultValue) {
            if (ByteObjectHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (ByteObjectHashMap.this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (ByteObjectHashMap.this.isEmpty()) {
                throw new ArithmeticException();
            }
            byte[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                byte first = sortedArray[middleIndex];
                byte second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public byte[] toSortedArray() {
            byte[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableByteList toSortedList() {
            return ByteArrayList.newList((ByteIterable)this).sortThis();
        }

        public byte[] toArray() {
            int size = ByteObjectHashMap.this.size();
            final byte[] result = new byte[size];
            ByteObjectHashMap.this.forEachKey(new ByteProcedure(){
                private int index;

                public void value(byte each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(byte value) {
            return ByteObjectHashMap.this.containsKey(value);
        }

        public boolean containsAll(byte ... source) {
            for (byte item : source) {
                if (ByteObjectHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(ByteIterable source) {
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                if (ByteObjectHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableByteList toList() {
            return ByteArrayList.newList((ByteIterable)this);
        }

        public MutableByteSet toSet() {
            return ByteHashSet.newSet((ByteIterable)this);
        }

        public MutableByteBag toBag() {
            return ByteHashBag.newBag((ByteIterable)this);
        }

        public LazyByteIterable asLazy() {
            return new LazyByteIterableAdapter((ByteIterable)this);
        }

        public ByteSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableByteSet toImmutable() {
            return ByteSets.immutable.withAll((ByteIterable)this);
        }

        public int size() {
            return ByteObjectHashMap.this.size();
        }

        public boolean isEmpty() {
            return ByteObjectHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ByteObjectHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ByteSet)) {
                return false;
            }
            ByteSet other = (ByteSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < ByteObjectHashMap.this.keys.length; ++i) {
                if (!ByteObjectHashMap.isNonSentinel(ByteObjectHashMap.this.keys[i])) continue;
                result += ByteObjectHashMap.this.keys[i];
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ByteObjectHashMap.this.sentinelValues != null) {
                    if (ByteObjectHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (ByteObjectHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (byte key : ByteObjectHashMap.this.keys) {
                    if (!ByteObjectHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalIterator
    implements Iterator<V> {
        private int count;
        private int position;
        private byte currentKey;
        private boolean isCurrentKeySet;
        private boolean handledZeroKey;
        private boolean handledOneKey;

        private InternalIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count != ByteObjectHashMap.this.size();
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            if (!this.handledZeroKey) {
                this.handledZeroKey = true;
                if (ByteObjectHashMap.this.containsKey((byte)0)) {
                    this.currentKey = 0;
                    this.isCurrentKeySet = true;
                    return ByteObjectHashMap.this.sentinelValues.zeroValue;
                }
            }
            if (!this.handledOneKey) {
                this.handledOneKey = true;
                if (ByteObjectHashMap.this.containsKey((byte)1)) {
                    this.currentKey = 1;
                    this.isCurrentKeySet = true;
                    return ByteObjectHashMap.this.sentinelValues.oneValue;
                }
            }
            byte[] keys = ByteObjectHashMap.this.keys;
            while (!ByteObjectHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.currentKey = ByteObjectHashMap.this.keys[this.position];
            this.isCurrentKeySet = true;
            Object result = ByteObjectHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (ByteObjectHashMap.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                ((ByteObjectHashMap)ByteObjectHashMap.this).keys[index] = 1;
                ((ByteObjectHashMap)ByteObjectHashMap.this).values[index] = null;
                ByteObjectHashMap.this.occupiedWithData--;
                ByteObjectHashMap.this.occupiedWithSentinels++;
                if (ByteObjectHashMap.this.occupiedWithSentinels > ByteObjectHashMap.this.maxOccupiedWithSentinels()) {
                    ByteObjectHashMap.this.rehash();
                }
            } else {
                ByteObjectHashMap.this.removeKey(this.currentKey);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SentinelValues<V> {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private V zeroValue;
        private V oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(V value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && ByteObjectHashMap.nullSafeEquals(this.zeroValue, value);
            boolean valueEqualsOneValue = this.containsOneKey && ByteObjectHashMap.nullSafeEquals(this.oneValue, value);
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

