/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.predicate.primitive.CharObjectPredicate;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.CharObjectProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.primitive.CharObjectMap;
import com.gs.collections.api.map.primitive.ImmutableCharObjectMap;
import com.gs.collections.api.map.primitive.MutableCharObjectMap;
import com.gs.collections.api.map.sorted.MutableSortedMap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.partition.list.PartitionMutableList;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.CharSet;
import com.gs.collections.api.set.primitive.ImmutableCharSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.block.procedure.MapCollectProcedure;
import com.gs.collections.impl.block.procedure.MutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.PartitionProcedure;
import com.gs.collections.impl.block.procedure.SelectInstancesOfProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectBooleanProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectByteProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectCharProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectDoubleProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectFloatProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectIntProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectLongProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectShortProcedure;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.CharObjectMaps;
import com.gs.collections.impl.factory.primitive.CharSets;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedCharObjectMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableCharObjectMap;
import com.gs.collections.impl.map.sorted.mutable.TreeSortedMap;
import com.gs.collections.impl.multimap.list.FastListMultimap;
import com.gs.collections.impl.partition.list.PartitionFastList;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedCharSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import com.gs.collections.impl.utility.Iterate;
import com.gs.collections.impl.utility.LazyIterate;
import com.gs.collections.impl.utility.internal.IterableIterate;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharObjectHashMap<V>
implements MutableCharObjectMap<V>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final char EMPTY_KEY = '\u0000';
    private static final char REMOVED_KEY = '\u0001';
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private char[] keys;
    private V[] values;
    private SentinelValues<V> sentinelValues;
    private int occupiedWithData;
    private int occupiedWithSentinels;

    public CharObjectHashMap() {
        this.allocateTable(16);
    }

    public CharObjectHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public CharObjectHashMap(CharObjectMap<? extends V> map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static <V> CharObjectHashMap<V> newMap() {
        return new CharObjectHashMap<V>();
    }

    public static <V> CharObjectHashMap<V> newWithKeysValues(char key, V value) {
        return new CharObjectHashMap<V>(1).withKeyValue(key, (Object)value);
    }

    public static <V> CharObjectHashMap<V> newWithKeysValues(char key1, V value1, char key2, V value2) {
        return new CharObjectHashMap<V>(2).withKeysValues(key1, value1, key2, value2);
    }

    public static <V> CharObjectHashMap<V> newWithKeysValues(char key1, V value1, char key2, V value2, char key3, V value3) {
        return new CharObjectHashMap<V>(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharObjectMap)) {
            return false;
        }
        CharObjectMap other = (CharObjectMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey('\u0000') || other.containsKey('\u0001')) {
                return false;
            }
        } else {
            if (!(!((SentinelValues)this.sentinelValues).containsZeroKey || other.containsKey('\u0000') && CharObjectHashMap.nullSafeEquals(((SentinelValues)this.sentinelValues).zeroValue, other.get('\u0000')))) {
                return false;
            }
            if (!(!((SentinelValues)this.sentinelValues).containsOneKey || other.containsKey('\u0001') && CharObjectHashMap.nullSafeEquals(((SentinelValues)this.sentinelValues).oneValue, other.get('\u0001')))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            char key = this.keys[i];
            if (!CharObjectHashMap.isNonSentinel(key) || other.containsKey(key) && CharObjectHashMap.nullSafeEquals(this.values[i], other.get(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result += 0 ^ (((SentinelValues)this.sentinelValues).zeroValue == null ? 0 : ((SentinelValues)this.sentinelValues).zeroValue.hashCode());
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result += 1 ^ (((SentinelValues)this.sentinelValues).oneValue == null ? 0 : ((SentinelValues)this.sentinelValues).oneValue.hashCode());
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ (this.values[i] == null ? 0 : this.values[i].hashCode());
        }
        return result;
    }

    public String toString() {
        return this.makeString("{", ", ", "}");
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                    appendable.append(String.valueOf('\u0000')).append("=").append(String.valueOf(((SentinelValues)this.sentinelValues).zeroValue));
                    first = false;
                }
                if (((SentinelValues)this.sentinelValues).containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf('\u0001')).append("=").append(String.valueOf(((SentinelValues)this.sentinelValues).oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                char key = this.keys[i];
                if (!CharObjectHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<V> iterator() {
        return new InternalIterator();
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result[index++] = ((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result[index++] = ((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result[index++] = this.values[i];
        }
        return result;
    }

    public <T> T[] toArray(T[] a) {
        int size = this.size();
        final Object[] result = a.length < size ? (Object[])Array.newInstance(a.getClass().getComponentType(), size) : a;
        this.forEachWithIndex(new ObjectIntProcedure<Object>(){

            public void value(Object each, int index) {
                result[index] = each;
            }
        });
        if (result.length > size) {
            result[size] = null;
        }
        return result;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public boolean containsAllIterable(Iterable<?> source) {
        for (Object item : source) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(Collection<?> source) {
        return this.containsAllIterable(source);
    }

    public boolean containsAllArguments(Object ... elements) {
        for (Object item : elements) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public void forEach(Procedure<? super V> procedure) {
        this.forEachValue(procedure);
    }

    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        int index = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                objectIntProcedure.value(((SentinelValues)this.sentinelValues).zeroValue, index++);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                objectIntProcedure.value(((SentinelValues)this.sentinelValues).oneValue, index++);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            objectIntProcedure.value(this.values[i], index++);
        }
    }

    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value(((SentinelValues)this.sentinelValues).zeroValue, parameter);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value(((SentinelValues)this.sentinelValues).oneValue, parameter);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i], parameter);
        }
    }

    public void forEachValue(Procedure<? super V> procedure) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(CharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value('\u0000');
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value('\u0001');
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    public void forEachKeyValue(CharObjectProcedure<? super V> procedure) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value('\u0000', ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value('\u0001', ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public CharObjectHashMap<V> select(CharObjectPredicate<? super V> predicate) {
        CharObjectHashMap<Object> result = CharObjectHashMap.newMap();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept('\u0000', ((SentinelValues)this.sentinelValues).zeroValue)) {
                result.put('\u0000', ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept('\u0001', ((SentinelValues)this.sentinelValues).oneValue)) {
                result.put('\u0001', ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public CharObjectHashMap<V> reject(CharObjectPredicate<? super V> predicate) {
        CharObjectHashMap<Object> result = CharObjectHashMap.newMap();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept('\u0000', ((SentinelValues)this.sentinelValues).zeroValue)) {
                result.put('\u0000', ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept('\u0001', ((SentinelValues)this.sentinelValues).oneValue)) {
                result.put('\u0001', ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public MutableCollection<V> select(Predicate<? super V> predicate) {
        FastList result = FastList.newList();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                result.add(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                result.add(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            target.add(this.values[i]);
        }
        return target;
    }

    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            targetCollection.add(this.values[i]);
        }
        return targetCollection;
    }

    public MutableCollection<V> reject(Predicate<? super V> predicate) {
        FastList result = FastList.newList();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                result.add(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                result.add(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            target.add(this.values[i]);
        }
        return target;
    }

    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i], parameter)) continue;
            targetCollection.add(this.values[i]);
        }
        return targetCollection;
    }

    public PartitionMutableList<V> partition(Predicate<? super V> predicate) {
        PartitionFastList partitionMutableList = new PartitionFastList();
        this.forEach(new PartitionProcedure<V>(predicate, partitionMutableList));
        return partitionMutableList;
    }

    public <S> MutableList<S> selectInstancesOf(Class<S> clazz) {
        FastList result = FastList.newList(this.size());
        this.forEach(new SelectInstancesOfProcedure<S>(clazz, result));
        result.trimToSize();
        return result;
    }

    public <V1> MutableCollection<V1> collect(Function<? super V, ? extends V1> function) {
        return this.collect(function, FastList.newList(this.size()));
    }

    public MutableBooleanCollection collectBoolean(BooleanFunction<? super V> booleanFunction) {
        BooleanArrayList result = new BooleanArrayList(this.size());
        this.forEach(new CollectBooleanProcedure<V>(booleanFunction, (MutableBooleanCollection)result));
        return result;
    }

    public MutableByteCollection collectByte(ByteFunction<? super V> byteFunction) {
        ByteArrayList result = new ByteArrayList(this.size());
        this.forEach(new CollectByteProcedure<V>(byteFunction, (MutableByteCollection)result));
        return result;
    }

    public MutableCharCollection collectChar(CharFunction<? super V> charFunction) {
        CharArrayList result = new CharArrayList(this.size());
        this.forEach(new CollectCharProcedure<V>(charFunction, (MutableCharCollection)result));
        return result;
    }

    public MutableDoubleCollection collectDouble(DoubleFunction<? super V> doubleFunction) {
        DoubleArrayList result = new DoubleArrayList(this.size());
        this.forEach(new CollectDoubleProcedure<V>(doubleFunction, (MutableDoubleCollection)result));
        return result;
    }

    public MutableFloatCollection collectFloat(FloatFunction<? super V> floatFunction) {
        FloatArrayList result = new FloatArrayList(this.size());
        this.forEach(new CollectFloatProcedure<V>(floatFunction, (MutableFloatCollection)result));
        return result;
    }

    public MutableIntCollection collectInt(IntFunction<? super V> intFunction) {
        IntArrayList result = new IntArrayList(this.size());
        this.forEach(new CollectIntProcedure<V>(intFunction, (MutableIntCollection)result));
        return result;
    }

    public MutableLongCollection collectLong(LongFunction<? super V> longFunction) {
        LongArrayList result = new LongArrayList(this.size());
        this.forEach(new CollectLongProcedure<V>(longFunction, (MutableLongCollection)result));
        return result;
    }

    public MutableShortCollection collectShort(ShortFunction<? super V> shortFunction) {
        ShortArrayList result = new ShortArrayList(this.size());
        this.forEach(new CollectShortProcedure<V>(shortFunction, (MutableShortCollection)result));
        return result;
    }

    public <P, V1, R extends Collection<V1>> R collectWith(Function2<? super V, ? super P, ? extends V1> function, P parameter, R targetCollection) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                targetCollection.add((Object)function.value(((SentinelValues)this.sentinelValues).zeroValue, parameter));
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                targetCollection.add((Object)function.value(((SentinelValues)this.sentinelValues).oneValue, parameter));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            targetCollection.add((Object)function.value(this.values[i], parameter));
        }
        return targetCollection;
    }

    public <V1, R extends Collection<V1>> R collect(Function<? super V, ? extends V1> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                target.add((Object)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue));
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                target.add((Object)function.valueOf(((SentinelValues)this.sentinelValues).oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            target.add((Object)function.valueOf(this.values[i]));
        }
        return target;
    }

    public <V1> MutableList<V1> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends V1> function) {
        return this.collectIf(predicate, function, FastList.newList());
    }

    public <V1, R extends Collection<V1>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends V1> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                target.add((Object)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue));
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                target.add((Object)function.valueOf(((SentinelValues)this.sentinelValues).oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            target.add((Object)function.valueOf(this.values[i]));
        }
        return target;
    }

    public <V1> MutableList<V1> flatCollect(Function<? super V, ? extends Iterable<V1>> function) {
        return this.flatCollect(function, FastList.newList());
    }

    public <V1, R extends Collection<V1>> R flatCollect(Function<? super V, ? extends Iterable<V1>> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                Iterate.addAllTo((Iterable)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue), target);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                Iterate.addAllTo((Iterable)function.valueOf(((SentinelValues)this.sentinelValues).oneValue), target);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            Iterate.addAllTo((Iterable)function.valueOf(this.values[i]), target);
        }
        return target;
    }

    public V detect(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return null;
    }

    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return (V)function.value();
    }

    public int count(Predicate<? super V> predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                ++count;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return true;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return false;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return false;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.value(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.value(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.value(result, this.values[i]);
        }
        return result;
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function) {
        int result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.intValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.intValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.intValueOf(result, this.values[i]);
        }
        return result;
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function) {
        long result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.longValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.longValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.longValueOf(result, this.values[i]);
        }
        return result;
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function) {
        float result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.floatValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.floatValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.floatValueOf(result, this.values[i]);
        }
        return result;
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function) {
        double result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.doubleValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.doubleValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.doubleValueOf(result, this.values[i]);
        }
        return result;
    }

    public <S> MutableList<Pair<V, S>> zip(Iterable<S> that) {
        return this.zip(that, FastList.newList());
    }

    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target) {
        return IterableIterate.zip(this, that, target);
    }

    public MutableList<Pair<V, Integer>> zipWithIndex() {
        return this.zipWithIndex(FastList.newList());
    }

    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target) {
        return IterableIterate.zipWithIndex(this, target);
    }

    public RichIterable<RichIterable<V>> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        Iterator<V> iterator = this.iterator();
        MutableList result = Lists.mutable.of();
        while (iterator.hasNext()) {
            FastList batch = FastList.newList();
            for (int i = 0; i < size && iterator.hasNext(); ++i) {
                batch.add(iterator.next());
            }
            result.add(batch);
        }
        return result;
    }

    public <K, V1> MutableMap<K, V1> aggregateInPlaceBy(Function<? super V, ? extends K> groupBy, Function0<? extends V1> zeroValueFactory, Procedure2<? super V1, ? super V> mutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new MutatingAggregationProcedure<V, K, V1>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    public <K, V1> MutableMap<K, V1> aggregateBy(Function<? super V, ? extends K> groupBy, Function0<? extends V1> zeroValueFactory, Function2<? super V1, ? super V, ? extends V1> nonMutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new NonMutatingAggregationProcedure<V, K, V1>(map, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map;
    }

    public <V1> MutableMultimap<V1, V> groupBy(Function<? super V, ? extends V1> function) {
        return this.groupBy(function, FastListMultimap.newMultimap());
    }

    public <V1, R extends MutableMultimap<V1, V>> R groupBy(Function<? super V, ? extends V1> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                target.put(function.valueOf(((SentinelValues)this.sentinelValues).zeroValue), ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                target.put(function.valueOf(((SentinelValues)this.sentinelValues).oneValue), ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            target.put(function.valueOf(this.values[i]), this.values[i]);
        }
        return target;
    }

    public <V1> MutableMultimap<V1, V> groupByEach(Function<? super V, ? extends Iterable<V1>> function) {
        return this.groupByEach(function, FastListMultimap.newMultimap());
    }

    public <V1, R extends MutableMultimap<V1, V>> R groupByEach(Function<? super V, ? extends Iterable<V1>> function, R target) {
        return IterableIterate.groupByEach(this, function, target);
    }

    public V getFirst() {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            return this.values[i];
        }
        return null;
    }

    public V getLast() {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            return this.values[i];
        }
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public MutableList<V> toList() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public MutableList<V> toSortedList() {
        return this.toList().sortThis();
    }

    public MutableList<V> toSortedList(Comparator<? super V> comparator) {
        return this.toList().sortThis(comparator);
    }

    public <V1 extends Comparable<? super V1>> MutableList<V> toSortedListBy(Function<? super V, ? extends V1> function) {
        return this.toList().sortThis(Comparators.byFunction(function));
    }

    /*
     * Exception decompiling
     */
    public MutableSet<V> toSet() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public MutableSortedSet<V> toSortedSet() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public <V1 extends Comparable<? super V1>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends V1> function) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public MutableBag<V> toBag() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new MapCollectProcedure<V, NK, NV>(map, keyFunction, valueFunction));
        return map;
    }

    /*
     * Exception decompiling
     */
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        TreeSortedMap sortedMap = TreeSortedMap.newMap(comparator);
        this.forEach(new MapCollectProcedure<V, NK, NV>(sortedMap, keyFunction, valueFunction));
        return sortedMap;
    }

    public LazyIterable<V> asLazy() {
        return LazyIterate.adapt(this);
    }

    public V min(Comparator<? super V> comparator) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object min = null;
        boolean isMinSet = false;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                min = ((SentinelValues)this.sentinelValues).zeroValue;
                isMinSet = true;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && (!isMinSet || comparator.compare(min, ((SentinelValues)this.sentinelValues).oneValue) > 0)) {
                min = ((SentinelValues)this.sentinelValues).oneValue;
                isMinSet = true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || isMinSet && comparator.compare(min, this.values[i]) <= 0) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return (V)min;
    }

    public V max(Comparator<? super V> comparator) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object max = null;
        boolean isMaxSet = false;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                max = ((SentinelValues)this.sentinelValues).zeroValue;
                isMaxSet = true;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && (!isMaxSet || comparator.compare(max, ((SentinelValues)this.sentinelValues).oneValue) < 0)) {
                max = ((SentinelValues)this.sentinelValues).oneValue;
                isMaxSet = true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || isMaxSet && comparator.compare(max, this.values[i]) >= 0) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return (V)max;
    }

    /*
     * Exception decompiling
     */
    public V min() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public V max() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <V1 extends Comparable<? super V1>> V maxBy(Function<? super V, ? extends V1> function) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object max = null;
        boolean isMaxSet = false;
        Comparable maxValue = null;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                max = ((SentinelValues)this.sentinelValues).zeroValue;
                isMaxSet = true;
                maxValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                Comparable nextValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
                if (!isMaxSet || nextValue.compareTo(maxValue) > 0) {
                    max = ((SentinelValues)this.sentinelValues).oneValue;
                    isMaxSet = true;
                    maxValue = nextValue;
                }
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            V next = this.values[i];
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (isMaxSet && nextValue.compareTo(maxValue) <= 0) continue;
            max = next;
            isMaxSet = true;
            maxValue = nextValue;
        }
        return (V)max;
    }

    public <V1 extends Comparable<? super V1>> V minBy(Function<? super V, ? extends V1> function) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object min = null;
        boolean isMinSet = false;
        Comparable minValue = null;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                min = ((SentinelValues)this.sentinelValues).zeroValue;
                isMinSet = true;
                minValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                Comparable nextValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
                if (!isMinSet || nextValue.compareTo(minValue) < 0) {
                    min = ((SentinelValues)this.sentinelValues).oneValue;
                    isMinSet = true;
                    minValue = nextValue;
                }
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            V next = this.values[i];
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (isMinSet && nextValue.compareTo(minValue) >= 0) continue;
            min = next;
            isMinSet = true;
            minValue = nextValue;
        }
        return (V)min;
    }

    public long sumOfInt(IntFunction<? super V> function) {
        long sum = 0L;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                sum += (long)function.intValueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                sum += (long)function.intValueOf(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            sum += (long)function.intValueOf(this.values[i]);
        }
        return sum;
    }

    public double sumOfFloat(FloatFunction<? super V> function) {
        double sum = 0.0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                sum += (double)function.floatValueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                sum += (double)function.floatValueOf(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            sum += (double)function.floatValueOf(this.values[i]);
        }
        return sum;
    }

    public long sumOfLong(LongFunction<? super V> function) {
        long sum = 0L;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                sum += function.longValueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                sum += function.longValueOf(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            sum += function.longValueOf(this.values[i]);
        }
        return sum;
    }

    public double sumOfDouble(DoubleFunction<? super V> function) {
        double sum = 0.0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                sum += function.doubleValueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                sum += function.doubleValueOf(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            sum += function.doubleValueOf(this.values[i]);
        }
        return sum;
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, '\u0000');
        Arrays.fill(this.values, null);
    }

    public V put(char key, V value) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).zeroValue;
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return (V)oldValue;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).oneValue;
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return (V)oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            V oldValue = this.values[index];
            this.values[index] = value;
            return oldValue;
        }
        if (this.keys[index] == '\u0001') {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return null;
    }

    public void putAll(CharObjectMap<? extends V> map) {
        map.forEachKeyValue(new CharObjectProcedure<V>(){

            public void value(char key, V value) {
                CharObjectHashMap.this.put(key, value);
            }
        });
    }

    public boolean containsKey(char key) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && ((SentinelValues)this.sentinelValues).containsZeroKey;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && ((SentinelValues)this.sentinelValues).containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(Object value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !CharObjectHashMap.nullSafeEquals(this.values[i], value)) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public V get(char key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public V getIfAbsent(char key, Function0<? extends V> ifAbsent) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)ifAbsent.value();
            }
            return (V)((SentinelValues)this.sentinelValues).zeroValue;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)ifAbsent.value();
            }
            return (V)((SentinelValues)this.sentinelValues).oneValue;
        }
        int index = this.probe(key);
        if (this.keys[this.probe(key)] == key) {
            return this.values[index];
        }
        return (V)ifAbsent.value();
    }

    public V getIfAbsentPut(char key, V value) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return value;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == '\u0001') {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public V getIfAbsentPut(char key, Function0<? extends V> function) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.value();
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return (V)value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            Object value = function.value();
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return (V)value;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.value();
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return (V)value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            Object value = function.value();
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return (V)value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == '\u0001') {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        Object value = function.value();
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return (V)value;
    }

    public <P> V getIfAbsentPutWith(char key, Function<? super P, ? extends V> function, P parameter) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.valueOf(parameter);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return (V)value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            Object value = function.valueOf(parameter);
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return (V)value;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.valueOf(parameter);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return (V)value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            Object value = function.valueOf(parameter);
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return (V)value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == '\u0001') {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        Object value = function.valueOf(parameter);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return (V)value;
    }

    public V getIfAbsentPutWithKey(char key, CharToObjectFunction<? extends V> function) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return (V)value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            Object value = function.valueOf(key);
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return (V)value;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return (V)value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            Object value = function.valueOf(key);
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return (V)value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == '\u0001') {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        Object value = function.valueOf(key);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return (V)value;
    }

    public V updateValue(char key, Function0<? extends V> factory, Function<? super V, ? extends V> function) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.valueOf(factory.value());
            } else if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                ((SentinelValues)this.sentinelValues).zeroValue = function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
            } else {
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.valueOf(factory.value());
            }
            return (V)((SentinelValues)this.sentinelValues).zeroValue;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.valueOf(factory.value());
            } else if (((SentinelValues)this.sentinelValues).containsOneKey) {
                ((SentinelValues)this.sentinelValues).oneValue = function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
            } else {
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.valueOf(factory.value());
            }
            return (V)((SentinelValues)this.sentinelValues).oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        if (this.keys[index] == '\u0001') {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        Object value = function.valueOf(factory.value());
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return (V)value;
    }

    public <P> V updateValueWith(char key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.value(factory.value(), parameter);
            } else if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                ((SentinelValues)this.sentinelValues).zeroValue = function.value(((SentinelValues)this.sentinelValues).zeroValue, parameter);
            } else {
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.value(factory.value(), parameter);
            }
            return (V)((SentinelValues)this.sentinelValues).zeroValue;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.value(factory.value(), parameter);
            } else if (((SentinelValues)this.sentinelValues).containsOneKey) {
                ((SentinelValues)this.sentinelValues).oneValue = function.value(((SentinelValues)this.sentinelValues).oneValue, parameter);
            } else {
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.value(factory.value(), parameter);
            }
            return (V)((SentinelValues)this.sentinelValues).oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.value(this.values[index], parameter);
            return this.values[index];
        }
        if (this.keys[index] == '\u0001') {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        Object value = function.value(factory.value(), parameter);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return (V)value;
    }

    public V removeKey(char key) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsZeroKey) {
                return null;
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).zeroValue;
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                ((SentinelValues)this.sentinelValues).containsZeroKey = false;
                ((SentinelValues)this.sentinelValues).zeroValue = null;
            } else {
                this.sentinelValues = null;
            }
            return (V)oldValue;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsOneKey) {
                return null;
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).oneValue;
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                ((SentinelValues)this.sentinelValues).containsOneKey = false;
                ((SentinelValues)this.sentinelValues).oneValue = null;
            } else {
                this.sentinelValues = null;
            }
            return (V)oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = '\u0001';
            V oldValue = this.values[index];
            this.values[index] = null;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return null;
    }

    public V remove(char key) {
        return this.removeKey(key);
    }

    public CharObjectHashMap<V> withKeyValue(char key, V value) {
        this.put(key, value);
        return this;
    }

    public MutableCharObjectMap<V> withoutKey(char key) {
        this.removeKey(key);
        return this;
    }

    public MutableCharObjectMap<V> withoutAllKeys(CharIterable keys) {
        CharIterator iterator = keys.charIterator();
        while (iterator.hasNext()) {
            char item = iterator.next();
            this.removeKey(item);
        }
        return this;
    }

    public CharObjectHashMap<V> withKeysValues(char key1, V value1, char key2, V value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public CharObjectHashMap<V> withKeysValues(char key1, V value1, char key2, V value2, char key3, V value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public CharObjectHashMap<V> withKeysValues(char key1, V value1, char key2, V value2, char key3, V value3, char key4, V value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public MutableCharObjectMap<V> asUnmodifiable() {
        return new UnmodifiableCharObjectMap(this);
    }

    public MutableCharObjectMap<V> asSynchronized() {
        return new SynchronizedCharObjectMap(this);
    }

    public ImmutableCharObjectMap<V> toImmutable() {
        return CharObjectMaps.immutable.withAll((CharObjectMap)this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                out.writeChar(0);
                out.writeObject(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                out.writeChar(1);
                out.writeObject(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeChar(this.keys[i]);
            out.writeObject(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readChar(), in.readObject());
        }
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    public MutableCharSet keySet() {
        return new KeySet();
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        char[] old = this.keys;
        V[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!CharObjectHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(char element) {
        int index = this.spread(element);
        char keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == '\u0000') {
            return index;
        }
        int removedIndex = keyAtIndex == '\u0001' ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == '\u0001') {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == '\u0000') break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(char element) {
        int code = element;
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new char[sizeToAllocate];
        this.values = new Object[sizeToAllocate];
    }

    private static boolean isEmptyKey(char key) {
        return key == '\u0000';
    }

    private static boolean isRemovedKey(char key) {
        return key == '\u0001';
    }

    private static boolean isNonSentinel(char key) {
        return !CharObjectHashMap.isEmptyKey(key) && !CharObjectHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public Collection<V> values() {
        return new ValuesCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ValuesCollection
    implements Collection<V> {
        protected ValuesCollection() {
        }

        @Override
        public boolean add(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            CharObjectHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return CharObjectHashMap.this.containsValue(o);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return Iterate.allSatisfy(collection, Predicates.in(this));
        }

        @Override
        public boolean isEmpty() {
            return CharObjectHashMap.this.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return CharObjectHashMap.this.iterator();
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    if (it.next() != null) continue;
                    it.remove();
                    return true;
                }
            } else {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    Object o2 = it.next();
                    if (o != o2 && !o2.equals(o)) continue;
                    it.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object obj : collection) {
                if (!this.remove(obj)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            Iterator e = this.iterator();
            while (e.hasNext()) {
                if (collection.contains(e.next())) continue;
                e.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public int size() {
            return CharObjectHashMap.this.size();
        }

        @Override
        public Object[] toArray() {
            return CharObjectHashMap.this.toArray();
        }

        @Override
        public <T> T[] toArray(T[] result) {
            return CharObjectHashMap.this.toArray(result);
        }
    }

    private class KeysSetIterator
    implements CharIterator {
        private int count;
        private int position;
        private boolean handledZeroKey;
        private boolean handledOneKey;

        private KeysSetIterator() {
        }

        public boolean hasNext() {
            return this.count != CharObjectHashMap.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            if (!this.handledZeroKey) {
                this.handledZeroKey = true;
                if (CharObjectHashMap.this.containsKey('\u0000')) {
                    return '\u0000';
                }
            }
            if (!this.handledOneKey) {
                this.handledOneKey = true;
                if (CharObjectHashMap.this.containsKey('\u0001')) {
                    return '\u0001';
                }
            }
            char[] keys = CharObjectHashMap.this.keys;
            while (!CharObjectHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            char result = CharObjectHashMap.this.keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableCharSet {
        private KeySet() {
        }

        public CharIterator charIterator() {
            return new KeysSetIterator();
        }

        public void forEach(CharProcedure procedure) {
            CharObjectHashMap.this.forEachKey(procedure);
        }

        public int count(CharPredicate predicate) {
            int count = 0;
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    ++count;
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    ++count;
                }
            }
            for (char key : CharObjectHashMap.this.keys) {
                if (!CharObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(CharPredicate predicate) {
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return true;
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return true;
                }
            }
            for (char key : CharObjectHashMap.this.keys) {
                if (!CharObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(CharPredicate predicate) {
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey && !predicate.accept('\u0000')) {
                    return false;
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey && !predicate.accept('\u0001')) {
                    return false;
                }
            }
            for (char key : CharObjectHashMap.this.keys) {
                if (!CharObjectHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(CharPredicate predicate) {
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return false;
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return false;
                }
            }
            for (char key : CharObjectHashMap.this.keys) {
                if (!CharObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(char element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(char ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(CharIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(char key) {
            int oldSize = CharObjectHashMap.this.size();
            CharObjectHashMap.this.removeKey(key);
            return oldSize != CharObjectHashMap.this.size();
        }

        public boolean removeAll(CharIterable source) {
            int oldSize = CharObjectHashMap.this.size();
            CharIterator iterator = source.charIterator();
            while (iterator.hasNext()) {
                CharObjectHashMap.this.removeKey(iterator.next());
            }
            return oldSize != CharObjectHashMap.this.size();
        }

        public boolean removeAll(char ... source) {
            int oldSize = CharObjectHashMap.this.size();
            for (char item : source) {
                CharObjectHashMap.this.removeKey(item);
            }
            return oldSize != CharObjectHashMap.this.size();
        }

        public void clear() {
            CharObjectHashMap.this.clear();
        }

        public MutableCharSet select(CharPredicate predicate) {
            CharHashSet result = new CharHashSet();
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    result.add('\u0000');
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    result.add('\u0001');
                }
            }
            for (char key : CharObjectHashMap.this.keys) {
                if (!CharObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableCharSet reject(CharPredicate predicate) {
            CharHashSet result = new CharHashSet();
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey && !predicate.accept('\u0000')) {
                    result.add('\u0000');
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey && !predicate.accept('\u0001')) {
                    result.add('\u0001');
                }
            }
            for (char key : CharObjectHashMap.this.keys) {
                if (!CharObjectHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableCharSet with(char element) {
            throw new UnsupportedOperationException();
        }

        public MutableCharSet without(char element) {
            throw new UnsupportedOperationException();
        }

        public MutableCharSet withAll(CharIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableCharSet withoutAll(CharIterable elements) {
            throw new UnsupportedOperationException();
        }

        public char detectIfNone(CharPredicate predicate, char ifNone) {
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return '\u0000';
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return '\u0001';
                }
            }
            for (char key : CharObjectHashMap.this.keys) {
                if (!CharObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(CharToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf('\u0000'));
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf('\u0001'));
                }
            }
            for (char key : CharObjectHashMap.this.keys) {
                if (!CharObjectHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableCharSet asUnmodifiable() {
            return UnmodifiableCharSet.of(this);
        }

        public MutableCharSet asSynchronized() {
            return SynchronizedCharSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (char key : CharObjectHashMap.this.keys) {
                if (!CharObjectHashMap.isNonSentinel(key)) continue;
                sum += (long)key;
            }
            return sum;
        }

        public char max() {
            if (CharObjectHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            char max = '\u0000';
            boolean isMaxSet = false;
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey) {
                    max = '\u0000';
                    isMaxSet = true;
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < '\u0001')) {
                    max = '\u0001';
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < CharObjectHashMap.this.keys.length; ++i) {
                if (!CharObjectHashMap.isNonSentinel(CharObjectHashMap.this.keys[i]) || isMaxSet && max >= CharObjectHashMap.this.keys[i]) continue;
                max = CharObjectHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public char maxIfEmpty(char defaultValue) {
            if (CharObjectHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public char min() {
            if (CharObjectHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            char min = '\u0000';
            boolean isMinSet = false;
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey) {
                    min = '\u0000';
                    isMinSet = true;
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey && (!isMinSet || '\u0001' < min)) {
                    min = '\u0001';
                    isMinSet = true;
                }
            }
            for (int i = 0; i < CharObjectHashMap.this.keys.length; ++i) {
                if (!CharObjectHashMap.isNonSentinel(CharObjectHashMap.this.keys[i]) || isMinSet && CharObjectHashMap.this.keys[i] >= min) continue;
                min = CharObjectHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public char minIfEmpty(char defaultValue) {
            if (CharObjectHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (CharObjectHashMap.this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (CharObjectHashMap.this.isEmpty()) {
                throw new ArithmeticException();
            }
            char[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                char first = sortedArray[middleIndex];
                char second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public char[] toSortedArray() {
            char[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableCharList toSortedList() {
            return CharArrayList.newList((CharIterable)this).sortThis();
        }

        public char[] toArray() {
            int size = CharObjectHashMap.this.size();
            final char[] result = new char[size];
            CharObjectHashMap.this.forEachKey(new CharProcedure(){
                private int index;

                public void value(char each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(char value) {
            return CharObjectHashMap.this.containsKey(value);
        }

        public boolean containsAll(char ... source) {
            for (char item : source) {
                if (CharObjectHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(CharIterable source) {
            CharIterator iterator = source.charIterator();
            while (iterator.hasNext()) {
                if (CharObjectHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableCharList toList() {
            return CharArrayList.newList((CharIterable)this);
        }

        public MutableCharSet toSet() {
            return CharHashSet.newSet((CharIterable)this);
        }

        public MutableCharBag toBag() {
            return CharHashBag.newBag((CharIterable)this);
        }

        public LazyCharIterable asLazy() {
            return new LazyCharIterableAdapter((CharIterable)this);
        }

        public CharSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableCharSet toImmutable() {
            return CharSets.immutable.withAll((CharIterable)this);
        }

        public int size() {
            return CharObjectHashMap.this.size();
        }

        public boolean isEmpty() {
            return CharObjectHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return CharObjectHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CharSet)) {
                return false;
            }
            CharSet other = (CharSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < CharObjectHashMap.this.keys.length; ++i) {
                if (!CharObjectHashMap.isNonSentinel(CharObjectHashMap.this.keys[i])) continue;
                result += CharObjectHashMap.this.keys[i];
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (CharObjectHashMap.this.sentinelValues != null) {
                    if (CharObjectHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf('\u0000'));
                        first = false;
                    }
                    if (CharObjectHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf('\u0001'));
                        first = false;
                    }
                }
                for (char key : CharObjectHashMap.this.keys) {
                    if (!CharObjectHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalIterator
    implements Iterator<V> {
        private int count;
        private int position;
        private char currentKey;
        private boolean isCurrentKeySet;
        private boolean handledZeroKey;
        private boolean handledOneKey;

        private InternalIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count != CharObjectHashMap.this.size();
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            if (!this.handledZeroKey) {
                this.handledZeroKey = true;
                if (CharObjectHashMap.this.containsKey('\u0000')) {
                    this.currentKey = '\u0000';
                    this.isCurrentKeySet = true;
                    return CharObjectHashMap.this.sentinelValues.zeroValue;
                }
            }
            if (!this.handledOneKey) {
                this.handledOneKey = true;
                if (CharObjectHashMap.this.containsKey('\u0001')) {
                    this.currentKey = '\u0001';
                    this.isCurrentKeySet = true;
                    return CharObjectHashMap.this.sentinelValues.oneValue;
                }
            }
            char[] keys = CharObjectHashMap.this.keys;
            while (!CharObjectHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.currentKey = CharObjectHashMap.this.keys[this.position];
            this.isCurrentKeySet = true;
            Object result = CharObjectHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (CharObjectHashMap.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                ((CharObjectHashMap)CharObjectHashMap.this).keys[index] = '\u0001';
                ((CharObjectHashMap)CharObjectHashMap.this).values[index] = null;
                CharObjectHashMap.this.occupiedWithData--;
                CharObjectHashMap.this.occupiedWithSentinels++;
                if (CharObjectHashMap.this.occupiedWithSentinels > CharObjectHashMap.this.maxOccupiedWithSentinels()) {
                    CharObjectHashMap.this.rehash();
                }
            } else {
                CharObjectHashMap.this.removeKey(this.currentKey);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SentinelValues<V> {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private V zeroValue;
        private V oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(V value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && CharObjectHashMap.nullSafeEquals(this.zeroValue, value);
            boolean valueEqualsOneValue = this.containsOneKey && CharObjectHashMap.nullSafeEquals(this.oneValue, value);
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

