/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction0;
import com.gs.collections.api.block.function.primitive.BooleanToBooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.FloatToBooleanFunction;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatBooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatBooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.FloatBooleanMap;
import com.gs.collections.api.map.primitive.ImmutableFloatBooleanMap;
import com.gs.collections.api.map.primitive.MutableFloatBooleanMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.FloatSet;
import com.gs.collections.api.set.primitive.ImmutableFloatSet;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.block.factory.primitive.FloatPredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedBooleanCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.BooleanLists;
import com.gs.collections.impl.factory.primitive.FloatBooleanMaps;
import com.gs.collections.impl.factory.primitive.FloatSets;
import com.gs.collections.impl.lazy.primitive.CollectFloatToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectFloatIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedFloatBooleanMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableFloatBooleanMap;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedFloatSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.BitSet;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatBooleanHashMap
implements MutableFloatBooleanMap,
Externalizable {
    static final boolean EMPTY_VALUE = false;
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_KEY = 0.0f;
    private static final float REMOVED_KEY = 1.0f;
    private static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private int occupied;
    private int maxSize;
    private float[] keys;
    private BitSet values;
    private float loadFactor = 0.5f;
    private SentinelValues sentinelValues;

    public FloatBooleanHashMap() {
        this.allocate(16);
    }

    public FloatBooleanHashMap(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public FloatBooleanHashMap(FloatBooleanMap map) {
        this(Math.max(map.size(), 8), 0.5f);
        this.putAll(map);
    }

    public FloatBooleanHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        this.loadFactor = loadFactor;
        this.init(this.fastCeil((float)initialCapacity / loadFactor));
    }

    public MutableFloatBooleanMap asUnmodifiable() {
        return new UnmodifiableFloatBooleanMap(this);
    }

    public MutableFloatBooleanMap asSynchronized() {
        return new SynchronizedFloatBooleanMap(this);
    }

    public ImmutableFloatBooleanMap toImmutable() {
        return FloatBooleanMaps.immutable.withAll((FloatBooleanMap)this);
    }

    public static FloatBooleanHashMap newWithKeysValues(float key1, boolean value1) {
        return new FloatBooleanHashMap(1).withKeyValue(key1, value1);
    }

    public static FloatBooleanHashMap newWithKeysValues(float key1, boolean value1, float key2, boolean value2) {
        return new FloatBooleanHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static FloatBooleanHashMap newWithKeysValues(float key1, boolean value1, float key2, boolean value2, float key3, boolean value3) {
        return new FloatBooleanHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static FloatBooleanHashMap newWithKeysValues(float key1, boolean value1, float key2, boolean value2, float key3, boolean value3, float key4, boolean value4) {
        return new FloatBooleanHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public FloatBooleanHashMap withKeyValue(float key1, boolean value1) {
        this.put(key1, value1);
        return this;
    }

    public FloatBooleanHashMap withKeysValues(float key1, boolean value1, float key2, boolean value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public FloatBooleanHashMap withKeysValues(float key1, boolean value1, float key2, boolean value2, float key3, boolean value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public FloatBooleanHashMap withKeysValues(float key1, boolean value1, float key2, boolean value2, float key3, boolean value3, float key4, boolean value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public FloatBooleanHashMap withoutKey(float key) {
        this.removeKey(key);
        return this;
    }

    public FloatBooleanHashMap withoutAllKeys(FloatIterable keys) {
        keys.forEach(new FloatProcedure(){

            public void value(float key) {
                FloatBooleanHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    private int init(int initialCapacity) {
        int capacity;
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        return this.allocate(capacity);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    private static boolean isEmptyKey(float key) {
        return Float.compare(key, 0.0f) == 0;
    }

    private static boolean isRemovedKey(float key) {
        return Float.compare(key, 1.0f) == 0;
    }

    private static boolean isNonSentinel(float key) {
        return !FloatBooleanHashMap.isEmptyKey(key) && !FloatBooleanHashMap.isRemovedKey(key);
    }

    private int allocate(int capacity) {
        this.allocateTable(capacity);
        this.computeMaxSize(capacity);
        return capacity;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new float[sizeToAllocate];
        this.values = new BitSet(sizeToAllocate);
    }

    private void computeMaxSize(int capacity) {
        this.maxSize = Math.min(capacity - 1, (int)((float)capacity * this.loadFactor));
    }

    public int size() {
        return this.occupied + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupied == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupied != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    private void rehash() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        float[] old = this.keys;
        BitSet oldValues = this.values;
        this.allocate(newCapacity);
        this.occupied = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!FloatBooleanHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues.get(i));
        }
    }

    int probe(float element) {
        int index = this.spread(element);
        float keyAtIndex = this.keys[index];
        if (Float.compare(keyAtIndex, element) == 0 || Float.compare(keyAtIndex, 0.0f) == 0) {
            return index;
        }
        int removedIndex = Float.compare(keyAtIndex, 1.0f) == 0 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (Float.compare(this.keys[nextIndex &= this.keys.length - 1], element) == 0) {
                return nextIndex;
            }
            if (Float.compare(this.keys[nextIndex], 1.0f) == 0) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (Float.compare(this.keys[nextIndex], 0.0f) == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(float element) {
        int code = Float.floatToIntBits(element);
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.keys.length - 1;
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupied = 0;
        Arrays.fill(this.keys, 0.0f);
        this.values.clear();
    }

    public void put(float key, boolean value) {
        if (FloatBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (FloatBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.values.set(index, value);
            return;
        }
        this.keys[index] = key;
        this.values.set(index, value);
        ++this.occupied;
        if (this.occupied > this.maxSize) {
            this.rehash();
        }
    }

    public void putAll(FloatBooleanMap map) {
        map.forEachKeyValue(new FloatBooleanProcedure(){

            public void value(float key, boolean value) {
                FloatBooleanHashMap.this.put(key, value);
            }
        });
    }

    public boolean containsKey(float key) {
        if (FloatBooleanHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (FloatBooleanHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return Float.compare(this.keys[this.probe(key)], key) == 0;
    }

    public boolean containsValue(boolean value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatBooleanHashMap.isNonSentinel(this.keys[i]) || this.values.get(i) != value) continue;
            return true;
        }
        return false;
    }

    public boolean contains(boolean value) {
        return this.containsValue(value);
    }

    public boolean containsAll(boolean ... source) {
        for (boolean each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(BooleanIterable source) {
        return source.allSatisfy(new BooleanPredicate(){

            public boolean accept(boolean value) {
                return FloatBooleanHashMap.this.contains(value);
            }
        });
    }

    public boolean get(float key) {
        return this.getIfAbsent(key, false);
    }

    public boolean getIfAbsent(float key, boolean ifAbsent) {
        if (FloatBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (FloatBooleanHashMap.isNonSentinel(this.keys[index])) {
            return this.values.get(index);
        }
        return ifAbsent;
    }

    public boolean getOrThrow(float key) {
        if (FloatBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (FloatBooleanHashMap.isNonSentinel(this.keys[index])) {
            return this.values.get(index);
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean getIfAbsentPut(float key, boolean value) {
        if (FloatBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (FloatBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values.get(index);
        }
        this.keys[index] = key;
        ++this.occupied;
        this.values.set(index, value);
        return value;
    }

    public boolean getIfAbsentPut(float key, BooleanFunction0 function) {
        if (FloatBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            boolean value = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (FloatBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            boolean value = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values.get(index);
        }
        this.keys[index] = key;
        ++this.occupied;
        boolean value = function.value();
        this.values.set(index, value);
        return value;
    }

    public <P> boolean getIfAbsentPutWith(float key, BooleanFunction<? super P> function, P parameter) {
        if (FloatBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.booleanValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            boolean value = function.booleanValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (FloatBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.booleanValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            boolean value = function.booleanValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values.get(index);
        }
        this.keys[index] = key;
        ++this.occupied;
        boolean value = function.booleanValueOf(parameter);
        this.values.set(index, value);
        return value;
    }

    public boolean getIfAbsentPutWithKey(float key, FloatToBooleanFunction function) {
        if (FloatBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            boolean value = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (FloatBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            boolean value = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values.get(index);
        }
        this.keys[index] = key;
        ++this.occupied;
        boolean value = function.valueOf(key);
        this.values.set(index, value);
        return value;
    }

    public boolean updateValue(float key, boolean initialValueIfAbsent, BooleanToBooleanFunction function) {
        if (FloatBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.values.set(index, function.valueOf(this.values.get(index)));
        } else {
            this.keys[index] = key;
            ++this.occupied;
            this.values.set(index, function.valueOf(initialValueIfAbsent));
        }
        return this.values.get(index);
    }

    public void removeKey(float key) {
        if (FloatBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = false;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (FloatBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = false;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0f;
            --this.occupied;
            this.values.set(index, false);
        }
    }

    public void remove(float key) {
        this.removeKey(key);
    }

    public boolean removeKeyIfAbsent(float key, boolean value) {
        if (FloatBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            boolean oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = false;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (FloatBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            boolean oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = false;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0f;
            --this.occupied;
            boolean oldValue = this.values.get(index);
            this.values.set(index, false);
            return oldValue;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FloatBooleanMap)) {
            return false;
        }
        FloatBooleanMap other = (FloatBooleanMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0.0f) || other.containsKey(1.0f)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0.0f) || this.sentinelValues.zeroValue != other.getOrThrow(0.0f))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1.0f) || this.sentinelValues.oneValue != other.getOrThrow(1.0f))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            float key = this.keys[i];
            if (!FloatBooleanHashMap.isNonSentinel(key) || other.containsKey(key) && this.values.get(i) == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += Float.floatToIntBits(0.0f) ^ (this.sentinelValues.zeroValue ? 1231 : 1237);
            }
            if (this.sentinelValues.containsOneKey) {
                result += Float.floatToIntBits(1.0f) ^ (this.sentinelValues.oneValue ? 1231 : 1237);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            result += Float.floatToIntBits(this.keys[i]) ^ (this.values.get(i) ? 1231 : 1237);
        }
        return result;
    }

    public String toString() {
        return this.makeString("{", ", ", "}");
    }

    public BooleanIterator booleanIterator() {
        return new InternalBooleanIterator();
    }

    public void forEach(BooleanProcedure procedure) {
        this.forEachValue(procedure);
    }

    public void forEachValue(BooleanProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values.get(i));
        }
    }

    public void forEachKey(FloatProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0f);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0f);
            }
        }
        for (float key : this.keys) {
            if (!FloatBooleanHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(FloatBooleanProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values.get(i));
        }
    }

    public FloatBooleanHashMap select(FloatBooleanPredicate predicate) {
        FloatBooleanHashMap result = new FloatBooleanHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0.0f, this.sentinelValues.zeroValue)) {
                result.put(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1.0f, this.sentinelValues.oneValue)) {
                result.put(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values.get(i))) continue;
            result.put(this.keys[i], this.values.get(i));
        }
        return result;
    }

    public FloatBooleanHashMap reject(FloatBooleanPredicate predicate) {
        FloatBooleanHashMap result = new FloatBooleanHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0.0f, this.sentinelValues.zeroValue)) {
                result.put(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1.0f, this.sentinelValues.oneValue)) {
                result.put(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatBooleanHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values.get(i))) continue;
            result.put(this.keys[i], this.values.get(i));
        }
        return result;
    }

    public <V> V injectInto(V injectedValue, ObjectBooleanToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values.get(i));
        }
        return result;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(0.0f)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1.0f)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                float key = this.keys[i];
                if (!FloatBooleanHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values.get(i)));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableBooleanCollection select(BooleanPredicate predicate) {
        BooleanArrayList result = new BooleanArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            result.add(this.values.get(i));
        }
        return result;
    }

    public MutableBooleanCollection reject(BooleanPredicate predicate) {
        BooleanArrayList result = new BooleanArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatBooleanHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values.get(i))) continue;
            result.add(this.values.get(i));
        }
        return result;
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            return this.values.get(i);
        }
        return value;
    }

    public <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values.get(i)));
        }
        return target;
    }

    public int count(BooleanPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatBooleanHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public boolean[] toArray() {
        boolean[] array = new boolean[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values.get(i);
            ++index;
        }
        return array;
    }

    public MutableBooleanList toList() {
        return BooleanArrayList.newList((BooleanIterable)this);
    }

    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSet((BooleanIterable)this);
    }

    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBag((BooleanIterable)this);
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    public LazyFloatIterable keysView() {
        return new KeysView();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        out.writeFloat(this.loadFactor);
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeFloat(0.0f);
                out.writeBoolean(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeFloat(1.0f);
                out.writeBoolean(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeFloat(this.keys[i]);
            out.writeBoolean(this.values.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        this.loadFactor = in.readFloat();
        this.init(Math.max((int)((float)size / this.loadFactor) + 1, 8));
        for (int i = 0; i < size; ++i) {
            this.put(in.readFloat(), in.readBoolean());
        }
    }

    public MutableFloatSet keySet() {
        return new KeySet();
    }

    public MutableBooleanCollection values() {
        return new ValuesCollection();
    }

    private class KeySetIterator
    implements FloatIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < FloatBooleanHashMap.this.size();
        }

        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (FloatBooleanHashMap.this.containsKey(0.0f)) {
                    return 0.0f;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (FloatBooleanHashMap.this.containsKey(1.0f)) {
                    return 1.0f;
                }
            }
            float[] keys = FloatBooleanHashMap.this.keys;
            while (!FloatBooleanHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            float result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableBooleanCollection {
        private ValuesCollection() {
        }

        public void clear() {
            FloatBooleanHashMap.this.clear();
        }

        public MutableBooleanCollection select(BooleanPredicate predicate) {
            return FloatBooleanHashMap.this.select(predicate);
        }

        public MutableBooleanCollection reject(BooleanPredicate predicate) {
            return FloatBooleanHashMap.this.reject(predicate);
        }

        public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
            return FloatBooleanHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
            return FloatBooleanHashMap.this.collect(function);
        }

        public MutableBooleanCollection with(boolean element) {
            throw new UnsupportedOperationException();
        }

        public MutableBooleanCollection without(boolean element) {
            throw new UnsupportedOperationException();
        }

        public MutableBooleanCollection withAll(BooleanIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableBooleanCollection withoutAll(BooleanIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableBooleanCollection asSynchronized() {
            return SynchronizedBooleanCollection.of(this);
        }

        public MutableBooleanCollection asUnmodifiable() {
            return UnmodifiableBooleanCollection.of(this);
        }

        public ImmutableBooleanCollection toImmutable() {
            return BooleanLists.immutable.withAll((BooleanIterable)this);
        }

        public boolean contains(boolean value) {
            return FloatBooleanHashMap.this.containsValue(value);
        }

        public boolean containsAll(boolean ... source) {
            return FloatBooleanHashMap.this.containsAll(source);
        }

        public boolean containsAll(BooleanIterable source) {
            return FloatBooleanHashMap.this.containsAll(source);
        }

        public MutableBooleanList toList() {
            return FloatBooleanHashMap.this.toList();
        }

        public MutableBooleanSet toSet() {
            return FloatBooleanHashMap.this.toSet();
        }

        public MutableBooleanBag toBag() {
            return FloatBooleanHashMap.this.toBag();
        }

        public LazyBooleanIterable asLazy() {
            return new LazyBooleanIterableAdapter((BooleanIterable)this);
        }

        public <V> V injectInto(V injectedValue, ObjectBooleanToObjectFunction<? super V, ? extends V> function) {
            return FloatBooleanHashMap.this.injectInto(injectedValue, function);
        }

        public boolean isEmpty() {
            return FloatBooleanHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return FloatBooleanHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (FloatBooleanHashMap.this.sentinelValues != null) {
                    if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(FloatBooleanHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (FloatBooleanHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(FloatBooleanHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < FloatBooleanHashMap.this.keys.length; ++i) {
                    float key = FloatBooleanHashMap.this.keys[i];
                    if (!FloatBooleanHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(FloatBooleanHashMap.this.values.get(i)));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public BooleanIterator booleanIterator() {
            return FloatBooleanHashMap.this.booleanIterator();
        }

        public void forEach(BooleanProcedure procedure) {
            FloatBooleanHashMap.this.forEach(procedure);
        }

        public int count(BooleanPredicate predicate) {
            return FloatBooleanHashMap.this.count(predicate);
        }

        public boolean anySatisfy(BooleanPredicate predicate) {
            return FloatBooleanHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(BooleanPredicate predicate) {
            return FloatBooleanHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(BooleanPredicate predicate) {
            return FloatBooleanHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(boolean element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(boolean ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(BooleanIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(boolean item) {
            int oldSize = FloatBooleanHashMap.this.size();
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey && item == FloatBooleanHashMap.this.sentinelValues.zeroValue) {
                    FloatBooleanHashMap.this.removeKey(0.0f);
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey && item == FloatBooleanHashMap.this.sentinelValues.oneValue) {
                    FloatBooleanHashMap.this.removeKey(1.0f);
                }
            }
            for (int i = 0; i < FloatBooleanHashMap.this.keys.length; ++i) {
                if (!FloatBooleanHashMap.isNonSentinel(FloatBooleanHashMap.this.keys[i]) || item != FloatBooleanHashMap.this.values.get(i)) continue;
                FloatBooleanHashMap.this.removeKey(FloatBooleanHashMap.this.keys[i]);
            }
            return oldSize != FloatBooleanHashMap.this.size();
        }

        public boolean removeAll(BooleanIterable source) {
            int oldSize = FloatBooleanHashMap.this.size();
            BooleanIterator iterator = source.booleanIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != FloatBooleanHashMap.this.size();
        }

        public boolean removeAll(boolean ... source) {
            int oldSize = FloatBooleanHashMap.this.size();
            for (boolean item : source) {
                this.remove(item);
            }
            return oldSize != FloatBooleanHashMap.this.size();
        }

        public int size() {
            return FloatBooleanHashMap.this.size();
        }

        public boolean[] toArray() {
            return FloatBooleanHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableFloatSet {
        private KeySet() {
        }

        public FloatIterator floatIterator() {
            return new KeySetIterator();
        }

        public void forEach(FloatProcedure procedure) {
            FloatBooleanHashMap.this.forEachKey(procedure);
        }

        public int count(FloatPredicate predicate) {
            int count = 0;
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    ++count;
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    ++count;
                }
            }
            for (float key : FloatBooleanHashMap.this.keys) {
                if (!FloatBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(FloatPredicate predicate) {
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return true;
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return true;
                }
            }
            for (float key : FloatBooleanHashMap.this.keys) {
                if (!FloatBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(FloatPredicate predicate) {
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0f)) {
                    return false;
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0f)) {
                    return false;
                }
            }
            for (float key : FloatBooleanHashMap.this.keys) {
                if (!FloatBooleanHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(FloatPredicate predicate) {
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return false;
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return false;
                }
            }
            for (float key : FloatBooleanHashMap.this.keys) {
                if (!FloatBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(float element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(float ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(FloatIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(float key) {
            int oldSize = FloatBooleanHashMap.this.size();
            FloatBooleanHashMap.this.removeKey(key);
            return oldSize != FloatBooleanHashMap.this.size();
        }

        public boolean removeAll(FloatIterable source) {
            int oldSize = FloatBooleanHashMap.this.size();
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                FloatBooleanHashMap.this.removeKey(iterator.next());
            }
            return oldSize != FloatBooleanHashMap.this.size();
        }

        public boolean removeAll(float ... source) {
            int oldSize = FloatBooleanHashMap.this.size();
            for (float item : source) {
                FloatBooleanHashMap.this.removeKey(item);
            }
            return oldSize != FloatBooleanHashMap.this.size();
        }

        public void clear() {
            FloatBooleanHashMap.this.clear();
        }

        public MutableFloatSet select(FloatPredicate predicate) {
            FloatHashSet result = new FloatHashSet();
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    result.add(0.0f);
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    result.add(1.0f);
                }
            }
            for (float key : FloatBooleanHashMap.this.keys) {
                if (!FloatBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableFloatSet reject(FloatPredicate predicate) {
            FloatHashSet result = new FloatHashSet();
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0f)) {
                    result.add(0.0f);
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0f)) {
                    result.add(1.0f);
                }
            }
            for (float key : FloatBooleanHashMap.this.keys) {
                if (!FloatBooleanHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableFloatSet with(float element) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatSet without(float element) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatSet withAll(FloatIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatSet withoutAll(FloatIterable elements) {
            throw new UnsupportedOperationException();
        }

        public float detectIfNone(FloatPredicate predicate, float ifNone) {
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return 0.0f;
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return 1.0f;
                }
            }
            for (float key : FloatBooleanHashMap.this.keys) {
                if (!FloatBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0.0f));
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1.0f));
                }
            }
            for (float key : FloatBooleanHashMap.this.keys) {
                if (!FloatBooleanHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableFloatSet asUnmodifiable() {
            return UnmodifiableFloatSet.of(this);
        }

        public MutableFloatSet asSynchronized() {
            return SynchronizedFloatSet.of(this);
        }

        public double sum() {
            double sum = 0.0;
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0.0;
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey) {
                    sum += 1.0;
                }
            }
            for (float key : FloatBooleanHashMap.this.keys) {
                if (!FloatBooleanHashMap.isNonSentinel(key)) continue;
                sum += (double)key;
            }
            return sum;
        }

        public float max() {
            if (FloatBooleanHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            float max = 0.0f;
            boolean isMaxSet = false;
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0.0f;
                    isMaxSet = true;
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || Float.compare(max, 1.0f) < 0)) {
                    max = 1.0f;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < FloatBooleanHashMap.this.keys.length; ++i) {
                if (!FloatBooleanHashMap.isNonSentinel(FloatBooleanHashMap.this.keys[i]) || isMaxSet && Float.compare(max, FloatBooleanHashMap.this.keys[i]) >= 0) continue;
                max = FloatBooleanHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public float maxIfEmpty(float defaultValue) {
            if (FloatBooleanHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public float min() {
            if (FloatBooleanHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            float min = 0.0f;
            boolean isMinSet = false;
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0.0f;
                    isMinSet = true;
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey && (!isMinSet || Float.compare(1.0f, min) < 0)) {
                    min = 1.0f;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < FloatBooleanHashMap.this.keys.length; ++i) {
                if (!FloatBooleanHashMap.isNonSentinel(FloatBooleanHashMap.this.keys[i]) || isMinSet && Float.compare(FloatBooleanHashMap.this.keys[i], min) >= 0) continue;
                min = FloatBooleanHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public float minIfEmpty(float defaultValue) {
            if (FloatBooleanHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            float[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                float first = sortedArray[middleIndex];
                float second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public float[] toSortedArray() {
            float[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableFloatList toSortedList() {
            return FloatArrayList.newList((FloatIterable)this).sortThis();
        }

        public float[] toArray() {
            int size = FloatBooleanHashMap.this.size();
            final float[] result = new float[size];
            FloatBooleanHashMap.this.forEachKey(new FloatProcedure(){
                private int index;

                public void value(float each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(float value) {
            return FloatBooleanHashMap.this.containsKey(value);
        }

        public boolean containsAll(float ... source) {
            for (float item : source) {
                if (FloatBooleanHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(FloatIterable source) {
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                if (FloatBooleanHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableFloatList toList() {
            return FloatArrayList.newList((FloatIterable)this);
        }

        public MutableFloatSet toSet() {
            return FloatHashSet.newSet((FloatIterable)this);
        }

        public MutableFloatBag toBag() {
            return FloatHashBag.newBag((FloatIterable)this);
        }

        public LazyFloatIterable asLazy() {
            return new LazyFloatIterableAdapter((FloatIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0.0f);
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1.0f);
                }
            }
            for (int i = 0; i < FloatBooleanHashMap.this.keys.length; ++i) {
                if (!FloatBooleanHashMap.isNonSentinel(FloatBooleanHashMap.this.keys[i])) continue;
                result = function.valueOf(result, FloatBooleanHashMap.this.keys[i]);
            }
            return result;
        }

        public FloatSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableFloatSet toImmutable() {
            return FloatSets.immutable.withAll((FloatIterable)this);
        }

        public int size() {
            return FloatBooleanHashMap.this.size();
        }

        public boolean isEmpty() {
            return FloatBooleanHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return FloatBooleanHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FloatSet)) {
                return false;
            }
            FloatSet other = (FloatSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result += Float.floatToIntBits(0.0f);
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result += Float.floatToIntBits(1.0f);
                }
            }
            for (int i = 0; i < FloatBooleanHashMap.this.keys.length; ++i) {
                if (!FloatBooleanHashMap.isNonSentinel(FloatBooleanHashMap.this.keys[i])) continue;
                result += Float.floatToIntBits(FloatBooleanHashMap.this.keys[i]);
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (FloatBooleanHashMap.this.sentinelValues != null) {
                    if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0.0f));
                        first = false;
                    }
                    if (FloatBooleanHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1.0f));
                        first = false;
                    }
                }
                for (float key : FloatBooleanHashMap.this.keys) {
                    if (!FloatBooleanHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyFloatIterable {
        private KeysView() {
        }

        public boolean isEmpty() {
            return FloatBooleanHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return FloatBooleanHashMap.this.notEmpty();
        }

        public int size() {
            return FloatBooleanHashMap.this.size();
        }

        public boolean contains(float key) {
            return FloatBooleanHashMap.this.containsKey(key);
        }

        public boolean containsAll(float ... keys) {
            for (float key : keys) {
                if (FloatBooleanHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(FloatIterable source) {
            return source.allSatisfy(new FloatPredicate(){

                public boolean accept(float key) {
                    return FloatBooleanHashMap.this.containsKey(key);
                }
            });
        }

        public FloatIterator floatIterator() {
            return new KeySetIterator();
        }

        public void forEach(FloatProcedure procedure) {
            FloatBooleanHashMap.this.forEachKey(procedure);
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (FloatBooleanHashMap.this.sentinelValues != null) {
                    if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0.0f));
                        first = false;
                    }
                    if (FloatBooleanHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1.0f));
                        first = false;
                    }
                }
                for (float key : FloatBooleanHashMap.this.keys) {
                    if (!FloatBooleanHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public int count(FloatPredicate predicate) {
            int count = 0;
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    ++count;
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    ++count;
                }
            }
            for (float key : FloatBooleanHashMap.this.keys) {
                if (!FloatBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(FloatPredicate predicate) {
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return true;
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return true;
                }
            }
            for (float key : FloatBooleanHashMap.this.keys) {
                if (!FloatBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(FloatPredicate predicate) {
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0f)) {
                    return false;
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0f)) {
                    return false;
                }
            }
            for (float key : FloatBooleanHashMap.this.keys) {
                if (!FloatBooleanHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(FloatPredicate predicate) {
            return !this.anySatisfy(predicate);
        }

        public LazyFloatIterable select(FloatPredicate predicate) {
            return new SelectFloatIterable((FloatIterable)this, predicate);
        }

        public LazyFloatIterable reject(FloatPredicate predicate) {
            return new SelectFloatIterable((FloatIterable)this, FloatPredicates.not(predicate));
        }

        public float detectIfNone(FloatPredicate predicate, float value) {
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return 0.0f;
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return 1.0f;
                }
            }
            for (float key : FloatBooleanHashMap.this.keys) {
                if (!FloatBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(FloatToObjectFunction<? extends V> function) {
            return new CollectFloatToObjectIterable<V>((FloatIterable)this, function);
        }

        public double sum() {
            double result = 0.0;
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0.0;
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result += 1.0;
                }
            }
            for (float key : FloatBooleanHashMap.this.keys) {
                if (!FloatBooleanHashMap.isNonSentinel(key)) continue;
                result += (double)key;
            }
            return result;
        }

        public float max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            FloatIterator iterator = this.floatIterator();
            float max = iterator.next();
            while (iterator.hasNext()) {
                float value = iterator.next();
                if (Float.compare(max, value) >= 0) continue;
                max = value;
            }
            return max;
        }

        public float min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            FloatIterator iterator = this.floatIterator();
            float min = iterator.next();
            while (iterator.hasNext()) {
                float value = iterator.next();
                if (Float.compare(value, min) >= 0) continue;
                min = value;
            }
            return min;
        }

        public float minIfEmpty(float defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public float maxIfEmpty(float defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            float[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                float first = sortedArray[middleIndex];
                float second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public float[] toSortedArray() {
            float[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public float[] toArray() {
            int size = FloatBooleanHashMap.this.size();
            final float[] result = new float[size];
            FloatBooleanHashMap.this.forEachKey(new FloatProcedure(){
                private int index;

                public void value(float each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (FloatBooleanHashMap.this.sentinelValues != null) {
                if (FloatBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0.0f);
                }
                if (FloatBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1.0f);
                }
            }
            for (int i = 0; i < FloatBooleanHashMap.this.keys.length; ++i) {
                if (!FloatBooleanHashMap.isNonSentinel(FloatBooleanHashMap.this.keys[i])) continue;
                result = function.valueOf(result, FloatBooleanHashMap.this.keys[i]);
            }
            return result;
        }

        public MutableFloatList toList() {
            return FloatArrayList.newList((FloatIterable)this);
        }

        public MutableFloatList toSortedList() {
            return FloatArrayList.newList((FloatIterable)this).sortThis();
        }

        public MutableFloatSet toSet() {
            return FloatHashSet.newSet((FloatIterable)this);
        }

        public MutableFloatBag toBag() {
            return FloatHashBag.newBag((FloatIterable)this);
        }

        public LazyFloatIterable asLazy() {
            return this;
        }
    }

    private class InternalBooleanIterator
    implements BooleanIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalBooleanIterator() {
        }

        public boolean hasNext() {
            return this.count < FloatBooleanHashMap.this.size();
        }

        public boolean next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (FloatBooleanHashMap.this.containsKey(0.0f)) {
                    return FloatBooleanHashMap.this.sentinelValues.zeroValue;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (FloatBooleanHashMap.this.containsKey(1.0f)) {
                    return FloatBooleanHashMap.this.sentinelValues.oneValue;
                }
            }
            float[] keys = FloatBooleanHashMap.this.keys;
            while (!FloatBooleanHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            boolean result = FloatBooleanHashMap.this.values.get(this.position);
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private boolean zeroValue;
        private boolean oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(boolean value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

