/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction0;
import com.gs.collections.api.block.function.primitive.CharToCharFunction;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.FloatToCharFunction;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatCharPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatCharProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.FloatCharMap;
import com.gs.collections.api.map.primitive.ImmutableFloatCharMap;
import com.gs.collections.api.map.primitive.MutableFloatCharMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.FloatSet;
import com.gs.collections.api.set.primitive.ImmutableFloatSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.block.factory.primitive.FloatPredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedCharCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.factory.primitive.FloatCharMaps;
import com.gs.collections.impl.factory.primitive.FloatSets;
import com.gs.collections.impl.lazy.primitive.CollectFloatToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectFloatIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedFloatCharMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableFloatCharMap;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedFloatSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatCharHashMap
implements MutableFloatCharMap,
Externalizable {
    static final char EMPTY_VALUE = '\u0000';
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_KEY = 0.0f;
    private static final float REMOVED_KEY = 1.0f;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private float[] keys;
    private char[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public FloatCharHashMap() {
        this.allocateTable(16);
    }

    public FloatCharHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public FloatCharHashMap(FloatCharMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static FloatCharHashMap newWithKeysValues(float key1, char value1) {
        return new FloatCharHashMap(1).withKeyValue(key1, value1);
    }

    public static FloatCharHashMap newWithKeysValues(float key1, char value1, float key2, char value2) {
        return new FloatCharHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static FloatCharHashMap newWithKeysValues(float key1, char value1, float key2, char value2, float key3, char value3) {
        return new FloatCharHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static FloatCharHashMap newWithKeysValues(float key1, char value1, float key2, char value2, float key3, char value3, float key4, char value4) {
        return new FloatCharHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FloatCharMap)) {
            return false;
        }
        FloatCharMap other = (FloatCharMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0.0f) || other.containsKey(1.0f)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0.0f) || this.sentinelValues.zeroValue != other.getOrThrow(0.0f))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1.0f) || this.sentinelValues.oneValue != other.getOrThrow(1.0f))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            float key = this.keys[i];
            if (!FloatCharHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += Float.floatToIntBits(0.0f) ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += Float.floatToIntBits(1.0f) ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatCharHashMap.isNonSentinel(this.keys[i])) continue;
            result += Float.floatToIntBits(this.keys[i]) ^ this.values[i];
        }
        return result;
    }

    public String toString() {
        return this.makeString("{", ", ", "}");
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(0.0f)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1.0f)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                float key = this.keys[i];
                if (!FloatCharHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CharIterator charIterator() {
        return new InternalCharIterator();
    }

    public char[] toArray() {
        char[] array = new char[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatCharHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(char value) {
        return this.containsValue(value);
    }

    public boolean containsAll(char ... source) {
        for (char each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(CharIterable source) {
        return source.allSatisfy(new CharPredicate(){

            public boolean accept(char value) {
                return FloatCharHashMap.this.contains(value);
            }
        });
    }

    public void forEach(CharProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableCharCollection select(CharPredicate predicate) {
        CharArrayList result = new CharArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableCharCollection reject(CharPredicate predicate) {
        CharArrayList result = new CharArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatCharHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatCharHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public char detectIfNone(CharPredicate predicate, char value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(CharPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(CharPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(CharPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatCharHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectCharToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatCharHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableCharList toList() {
        return CharArrayList.newList((CharIterable)this);
    }

    public MutableCharSet toSet() {
        return CharHashSet.newSet((CharIterable)this);
    }

    public MutableCharBag toBag() {
        return CharHashBag.newBag((CharIterable)this);
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, 0.0f);
        Arrays.fill(this.values, '\u0000');
    }

    public void put(float key, char value) {
        if (FloatCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (FloatCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.values[index] = value;
            return;
        }
        if (Float.compare(this.keys[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public void putAll(FloatCharMap map) {
        map.forEachKeyValue(new FloatCharProcedure(){

            public void value(float key, char value) {
                FloatCharHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(float key) {
        if (FloatCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = '\u0000';
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (FloatCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = '\u0000';
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0f;
            this.values[index] = '\u0000';
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(float key) {
        this.removeKey(key);
    }

    public char removeKeyIfAbsent(float key, char value) {
        if (FloatCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            char oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = '\u0000';
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (FloatCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            char oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = '\u0000';
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0f;
            char oldValue = this.values[index];
            this.values[index] = '\u0000';
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public char getIfAbsentPut(float key, char value) {
        if (FloatCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (FloatCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        if (Float.compare(this.keys[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public char getIfAbsentPut(float key, CharFunction0 function) {
        char value;
        if (FloatCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value2 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value3 = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (FloatCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value4 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value5 = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        if (Float.compare(this.keys[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.value();
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public <P> char getIfAbsentPutWith(float key, CharFunction<? super P> function, P parameter) {
        char value;
        if (FloatCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value2 = function.charValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value3 = function.charValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (FloatCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value4 = function.charValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value5 = function.charValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        if (Float.compare(this.keys[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.charValueOf(parameter);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public char getIfAbsentPutWithKey(float key, FloatToCharFunction function) {
        char value;
        if (FloatCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value2 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value3 = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (FloatCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value4 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value5 = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        if (Float.compare(this.keys[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(key);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public char updateValue(float key, char initialValueIfAbsent, CharToCharFunction function) {
        char value;
        if (FloatCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        if (Float.compare(this.keys[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(initialValueIfAbsent);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public FloatCharHashMap withKeyValue(float key1, char value1) {
        this.put(key1, value1);
        return this;
    }

    public FloatCharHashMap withKeysValues(float key1, char value1, float key2, char value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public FloatCharHashMap withKeysValues(float key1, char value1, float key2, char value2, float key3, char value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public FloatCharHashMap withKeysValues(float key1, char value1, float key2, char value2, float key3, char value3, float key4, char value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public FloatCharHashMap withoutKey(float key) {
        this.removeKey(key);
        return this;
    }

    public FloatCharHashMap withoutAllKeys(FloatIterable keys) {
        keys.forEach(new FloatProcedure(){

            public void value(float key) {
                FloatCharHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableFloatCharMap asUnmodifiable() {
        return new UnmodifiableFloatCharMap(this);
    }

    public MutableFloatCharMap asSynchronized() {
        return new SynchronizedFloatCharMap(this);
    }

    public ImmutableFloatCharMap toImmutable() {
        return FloatCharMaps.immutable.ofAll((FloatCharMap)this);
    }

    public char get(float key) {
        return this.getIfAbsent(key, '\u0000');
    }

    public char getIfAbsent(float key, char ifAbsent) {
        if (FloatCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public char getOrThrow(float key) {
        if (FloatCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (FloatCharHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(float key) {
        if (FloatCharHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (FloatCharHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return Float.compare(this.keys[this.probe(key)], key) == 0;
    }

    public boolean containsValue(char value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!FloatCharHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(CharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatCharHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(FloatProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0f);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0f);
            }
        }
        for (float key : this.keys) {
            if (!FloatCharHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(FloatCharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatCharHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyFloatIterable keysView() {
        return new KeysView();
    }

    public FloatCharHashMap select(FloatCharPredicate predicate) {
        FloatCharHashMap result = new FloatCharHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0.0f, this.sentinelValues.zeroValue)) {
                result.put(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1.0f, this.sentinelValues.oneValue)) {
                result.put(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public FloatCharHashMap reject(FloatCharPredicate predicate) {
        FloatCharHashMap result = new FloatCharHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0.0f, this.sentinelValues.zeroValue)) {
                result.put(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1.0f, this.sentinelValues.oneValue)) {
                result.put(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatCharHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (long)this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (long)this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatCharHashMap.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    public char max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        CharIterator iterator = this.charIterator();
        char max = iterator.next();
        while (iterator.hasNext()) {
            char value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public char maxIfEmpty(char defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public char min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        CharIterator iterator = this.charIterator();
        char min = iterator.next();
        while (iterator.hasNext()) {
            char value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public char minIfEmpty(char defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        char[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            char first = sortedArray[middleIndex];
            char second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public char[] toSortedArray() {
        char[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableCharList toSortedList() {
        return CharArrayList.newList((CharIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeFloat(0.0f);
                out.writeChar(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeFloat(1.0f);
                out.writeChar(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatCharHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeFloat(this.keys[i]);
            out.writeChar(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readFloat(), in.readChar());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        float[] old = this.keys;
        char[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!FloatCharHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(float element) {
        int index = this.spread(element);
        float keyAtIndex = this.keys[index];
        if (Float.compare(keyAtIndex, element) == 0 || Float.compare(keyAtIndex, 0.0f) == 0) {
            return index;
        }
        int removedIndex = Float.compare(keyAtIndex, 1.0f) == 0 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (Float.compare(this.keys[nextIndex &= this.keys.length - 1], element) == 0) {
                return nextIndex;
            }
            if (Float.compare(this.keys[nextIndex], 1.0f) == 0) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (Float.compare(this.keys[nextIndex], 0.0f) == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(float element) {
        int code = Float.floatToIntBits(element);
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new float[sizeToAllocate];
        this.values = new char[sizeToAllocate];
    }

    private static boolean isEmptyKey(float key) {
        return Float.compare(key, 0.0f) == 0;
    }

    private static boolean isRemovedKey(float key) {
        return Float.compare(key, 1.0f) == 0;
    }

    private static boolean isNonSentinel(float key) {
        return !FloatCharHashMap.isEmptyKey(key) && !FloatCharHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableFloatSet keySet() {
        return new KeySet();
    }

    public MutableCharCollection values() {
        return new ValuesCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableCharCollection {
        private ValuesCollection() {
        }

        public void clear() {
            FloatCharHashMap.this.clear();
        }

        public MutableCharCollection select(CharPredicate predicate) {
            return FloatCharHashMap.this.select(predicate);
        }

        public MutableCharCollection reject(CharPredicate predicate) {
            return FloatCharHashMap.this.reject(predicate);
        }

        public char detectIfNone(CharPredicate predicate, char ifNone) {
            return FloatCharHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
            return FloatCharHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
            return FloatCharHashMap.this.injectInto(injectedValue, function);
        }

        public long sum() {
            return FloatCharHashMap.this.sum();
        }

        public char max() {
            return FloatCharHashMap.this.max();
        }

        public char maxIfEmpty(char defaultValue) {
            return FloatCharHashMap.this.maxIfEmpty(defaultValue);
        }

        public char min() {
            return FloatCharHashMap.this.min();
        }

        public char minIfEmpty(char defaultValue) {
            return FloatCharHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return FloatCharHashMap.this.average();
        }

        public double median() {
            return FloatCharHashMap.this.median();
        }

        public char[] toSortedArray() {
            return FloatCharHashMap.this.toSortedArray();
        }

        public MutableCharList toSortedList() {
            return FloatCharHashMap.this.toSortedList();
        }

        public MutableCharCollection with(char element) {
            throw new UnsupportedOperationException();
        }

        public MutableCharCollection without(char element) {
            throw new UnsupportedOperationException();
        }

        public MutableCharCollection withAll(CharIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableCharCollection withoutAll(CharIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableCharCollection asUnmodifiable() {
            return UnmodifiableCharCollection.of(this);
        }

        public MutableCharCollection asSynchronized() {
            return SynchronizedCharCollection.of(this);
        }

        public ImmutableCharCollection toImmutable() {
            return CharLists.immutable.withAll((CharIterable)this);
        }

        public boolean contains(char value) {
            return FloatCharHashMap.this.containsValue(value);
        }

        public boolean containsAll(char ... source) {
            return FloatCharHashMap.this.containsAll(source);
        }

        public boolean containsAll(CharIterable source) {
            return FloatCharHashMap.this.containsAll(source);
        }

        public MutableCharList toList() {
            return FloatCharHashMap.this.toList();
        }

        public MutableCharSet toSet() {
            return FloatCharHashMap.this.toSet();
        }

        public MutableCharBag toBag() {
            return FloatCharHashMap.this.toBag();
        }

        public LazyCharIterable asLazy() {
            return new LazyCharIterableAdapter((CharIterable)this);
        }

        public boolean isEmpty() {
            return FloatCharHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return FloatCharHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (FloatCharHashMap.this.sentinelValues != null) {
                    if (FloatCharHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(FloatCharHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (FloatCharHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(FloatCharHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < FloatCharHashMap.this.keys.length; ++i) {
                    float key = FloatCharHashMap.this.keys[i];
                    if (!FloatCharHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(FloatCharHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public CharIterator charIterator() {
            return FloatCharHashMap.this.charIterator();
        }

        public void forEach(CharProcedure procedure) {
            FloatCharHashMap.this.forEach(procedure);
        }

        public int count(CharPredicate predicate) {
            return FloatCharHashMap.this.count(predicate);
        }

        public boolean anySatisfy(CharPredicate predicate) {
            return FloatCharHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(CharPredicate predicate) {
            return FloatCharHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(CharPredicate predicate) {
            return FloatCharHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(char element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(char ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(CharIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(char item) {
            int oldSize = FloatCharHashMap.this.size();
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey && item == FloatCharHashMap.this.sentinelValues.zeroValue) {
                    FloatCharHashMap.this.removeKey(0.0f);
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey && item == FloatCharHashMap.this.sentinelValues.oneValue) {
                    FloatCharHashMap.this.removeKey(1.0f);
                }
            }
            for (int i = 0; i < FloatCharHashMap.this.keys.length; ++i) {
                if (!FloatCharHashMap.isNonSentinel(FloatCharHashMap.this.keys[i]) || item != FloatCharHashMap.this.values[i]) continue;
                FloatCharHashMap.this.removeKey(FloatCharHashMap.this.keys[i]);
            }
            return oldSize != FloatCharHashMap.this.size();
        }

        public boolean removeAll(CharIterable source) {
            int oldSize = FloatCharHashMap.this.size();
            CharIterator iterator = source.charIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != FloatCharHashMap.this.size();
        }

        public boolean removeAll(char ... source) {
            int oldSize = FloatCharHashMap.this.size();
            for (char item : source) {
                this.remove(item);
            }
            return oldSize != FloatCharHashMap.this.size();
        }

        public int size() {
            return FloatCharHashMap.this.size();
        }

        public char[] toArray() {
            return FloatCharHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableFloatSet {
        private KeySet() {
        }

        public FloatIterator floatIterator() {
            return new KeySetIterator();
        }

        public void forEach(FloatProcedure procedure) {
            FloatCharHashMap.this.forEachKey(procedure);
        }

        public int count(FloatPredicate predicate) {
            int count = 0;
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    ++count;
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    ++count;
                }
            }
            for (float key : FloatCharHashMap.this.keys) {
                if (!FloatCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(FloatPredicate predicate) {
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return true;
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return true;
                }
            }
            for (float key : FloatCharHashMap.this.keys) {
                if (!FloatCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(FloatPredicate predicate) {
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0f)) {
                    return false;
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0f)) {
                    return false;
                }
            }
            for (float key : FloatCharHashMap.this.keys) {
                if (!FloatCharHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(FloatPredicate predicate) {
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return false;
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return false;
                }
            }
            for (float key : FloatCharHashMap.this.keys) {
                if (!FloatCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(float element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(float ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(FloatIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(float key) {
            int oldSize = FloatCharHashMap.this.size();
            FloatCharHashMap.this.removeKey(key);
            return oldSize != FloatCharHashMap.this.size();
        }

        public boolean removeAll(FloatIterable source) {
            int oldSize = FloatCharHashMap.this.size();
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                FloatCharHashMap.this.removeKey(iterator.next());
            }
            return oldSize != FloatCharHashMap.this.size();
        }

        public boolean removeAll(float ... source) {
            int oldSize = FloatCharHashMap.this.size();
            for (float item : source) {
                FloatCharHashMap.this.removeKey(item);
            }
            return oldSize != FloatCharHashMap.this.size();
        }

        public void clear() {
            FloatCharHashMap.this.clear();
        }

        public MutableFloatSet select(FloatPredicate predicate) {
            FloatHashSet result = new FloatHashSet();
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    result.add(0.0f);
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    result.add(1.0f);
                }
            }
            for (float key : FloatCharHashMap.this.keys) {
                if (!FloatCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableFloatSet reject(FloatPredicate predicate) {
            FloatHashSet result = new FloatHashSet();
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0f)) {
                    result.add(0.0f);
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0f)) {
                    result.add(1.0f);
                }
            }
            for (float key : FloatCharHashMap.this.keys) {
                if (!FloatCharHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableFloatSet with(float element) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatSet without(float element) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatSet withAll(FloatIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatSet withoutAll(FloatIterable elements) {
            throw new UnsupportedOperationException();
        }

        public float detectIfNone(FloatPredicate predicate, float ifNone) {
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return 0.0f;
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return 1.0f;
                }
            }
            for (float key : FloatCharHashMap.this.keys) {
                if (!FloatCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0.0f));
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1.0f));
                }
            }
            for (float key : FloatCharHashMap.this.keys) {
                if (!FloatCharHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableFloatSet asUnmodifiable() {
            return UnmodifiableFloatSet.of(this);
        }

        public MutableFloatSet asSynchronized() {
            return SynchronizedFloatSet.of(this);
        }

        public double sum() {
            double sum = 0.0;
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0.0;
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey) {
                    sum += 1.0;
                }
            }
            for (float key : FloatCharHashMap.this.keys) {
                if (!FloatCharHashMap.isNonSentinel(key)) continue;
                sum += (double)key;
            }
            return sum;
        }

        public float max() {
            if (FloatCharHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            float max = 0.0f;
            boolean isMaxSet = false;
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0.0f;
                    isMaxSet = true;
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || Float.compare(max, 1.0f) < 0)) {
                    max = 1.0f;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < FloatCharHashMap.this.keys.length; ++i) {
                if (!FloatCharHashMap.isNonSentinel(FloatCharHashMap.this.keys[i]) || isMaxSet && Float.compare(max, FloatCharHashMap.this.keys[i]) >= 0) continue;
                max = FloatCharHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public float maxIfEmpty(float defaultValue) {
            if (FloatCharHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public float min() {
            if (FloatCharHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            float min = 0.0f;
            boolean isMinSet = false;
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0.0f;
                    isMinSet = true;
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey && (!isMinSet || Float.compare(1.0f, min) < 0)) {
                    min = 1.0f;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < FloatCharHashMap.this.keys.length; ++i) {
                if (!FloatCharHashMap.isNonSentinel(FloatCharHashMap.this.keys[i]) || isMinSet && Float.compare(FloatCharHashMap.this.keys[i], min) >= 0) continue;
                min = FloatCharHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public float minIfEmpty(float defaultValue) {
            if (FloatCharHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            float[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                float first = sortedArray[middleIndex];
                float second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public float[] toSortedArray() {
            float[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableFloatList toSortedList() {
            return FloatArrayList.newList((FloatIterable)this).sortThis();
        }

        public float[] toArray() {
            int size = FloatCharHashMap.this.size();
            final float[] result = new float[size];
            FloatCharHashMap.this.forEachKey(new FloatProcedure(){
                private int index;

                public void value(float each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(float value) {
            return FloatCharHashMap.this.containsKey(value);
        }

        public boolean containsAll(float ... source) {
            for (float item : source) {
                if (FloatCharHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(FloatIterable source) {
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                if (FloatCharHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableFloatList toList() {
            return FloatArrayList.newList((FloatIterable)this);
        }

        public MutableFloatSet toSet() {
            return FloatHashSet.newSet((FloatIterable)this);
        }

        public MutableFloatBag toBag() {
            return FloatHashBag.newBag((FloatIterable)this);
        }

        public LazyFloatIterable asLazy() {
            return new LazyFloatIterableAdapter((FloatIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0.0f);
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1.0f);
                }
            }
            for (int i = 0; i < FloatCharHashMap.this.keys.length; ++i) {
                if (!FloatCharHashMap.isNonSentinel(FloatCharHashMap.this.keys[i])) continue;
                result = function.valueOf(result, FloatCharHashMap.this.keys[i]);
            }
            return result;
        }

        public FloatSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableFloatSet toImmutable() {
            return FloatSets.immutable.withAll((FloatIterable)this);
        }

        public int size() {
            return FloatCharHashMap.this.size();
        }

        public boolean isEmpty() {
            return FloatCharHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return FloatCharHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FloatSet)) {
                return false;
            }
            FloatSet other = (FloatSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey) {
                    result += Float.floatToIntBits(0.0f);
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey) {
                    result += Float.floatToIntBits(1.0f);
                }
            }
            for (int i = 0; i < FloatCharHashMap.this.keys.length; ++i) {
                if (!FloatCharHashMap.isNonSentinel(FloatCharHashMap.this.keys[i])) continue;
                result += Float.floatToIntBits(FloatCharHashMap.this.keys[i]);
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (FloatCharHashMap.this.sentinelValues != null) {
                    if (FloatCharHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0.0f));
                        first = false;
                    }
                    if (FloatCharHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1.0f));
                        first = false;
                    }
                }
                for (float key : FloatCharHashMap.this.keys) {
                    if (!FloatCharHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements FloatIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < FloatCharHashMap.this.size();
        }

        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (FloatCharHashMap.this.containsKey(0.0f)) {
                    return 0.0f;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (FloatCharHashMap.this.containsKey(1.0f)) {
                    return 1.0f;
                }
            }
            float[] keys = FloatCharHashMap.this.keys;
            while (!FloatCharHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            float result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyFloatIterable {
        private KeysView() {
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public int size() {
            return FloatCharHashMap.this.size();
        }

        public boolean isEmpty() {
            return FloatCharHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return FloatCharHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (FloatCharHashMap.this.sentinelValues != null) {
                    if (FloatCharHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0.0f));
                        first = false;
                    }
                    if (FloatCharHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1.0f));
                        first = false;
                    }
                }
                for (float key : FloatCharHashMap.this.keys) {
                    if (!FloatCharHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public FloatIterator floatIterator() {
            return new KeySetIterator();
        }

        public boolean contains(float key) {
            return FloatCharHashMap.this.containsKey(key);
        }

        public boolean containsAll(float ... keys) {
            for (float key : keys) {
                if (FloatCharHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(FloatIterable source) {
            return source.allSatisfy(new FloatPredicate(){

                public boolean accept(float key) {
                    return FloatCharHashMap.this.containsKey(key);
                }
            });
        }

        public void forEach(FloatProcedure procedure) {
            FloatCharHashMap.this.forEachKey(procedure);
        }

        public int count(FloatPredicate predicate) {
            int count = 0;
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    ++count;
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    ++count;
                }
            }
            for (float key : FloatCharHashMap.this.keys) {
                if (!FloatCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(FloatPredicate predicate) {
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return true;
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return true;
                }
            }
            for (float key : FloatCharHashMap.this.keys) {
                if (!FloatCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(FloatPredicate predicate) {
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0f)) {
                    return false;
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0f)) {
                    return false;
                }
            }
            for (float key : FloatCharHashMap.this.keys) {
                if (!FloatCharHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(FloatPredicate predicate) {
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return false;
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return false;
                }
            }
            for (float key : FloatCharHashMap.this.keys) {
                if (!FloatCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public LazyFloatIterable select(FloatPredicate predicate) {
            return new SelectFloatIterable((FloatIterable)this, predicate);
        }

        public LazyFloatIterable reject(FloatPredicate predicate) {
            return new SelectFloatIterable((FloatIterable)this, FloatPredicates.not(predicate));
        }

        public float detectIfNone(FloatPredicate predicate, float value) {
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return 0.0f;
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return 1.0f;
                }
            }
            for (float key : FloatCharHashMap.this.keys) {
                if (!FloatCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(FloatToObjectFunction<? extends V> function) {
            return new CollectFloatToObjectIterable<V>((FloatIterable)this, function);
        }

        public double sum() {
            double result = 0.0;
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0.0;
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey) {
                    result += 1.0;
                }
            }
            for (float key : FloatCharHashMap.this.keys) {
                if (!FloatCharHashMap.isNonSentinel(key)) continue;
                result += (double)key;
            }
            return result;
        }

        public float max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            FloatIterator iterator = this.floatIterator();
            float max = iterator.next();
            while (iterator.hasNext()) {
                float value = iterator.next();
                if (Float.compare(max, value) >= 0) continue;
                max = value;
            }
            return max;
        }

        public float min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            FloatIterator iterator = this.floatIterator();
            float min = iterator.next();
            while (iterator.hasNext()) {
                float value = iterator.next();
                if (Float.compare(value, min) >= 0) continue;
                min = value;
            }
            return min;
        }

        public float minIfEmpty(float defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public float maxIfEmpty(float defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            float[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                float first = sortedArray[middleIndex];
                float second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public float[] toSortedArray() {
            float[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public float[] toArray() {
            int size = FloatCharHashMap.this.size();
            final float[] result = new float[size];
            FloatCharHashMap.this.forEachKey(new FloatProcedure(){
                private int index;

                public void value(float each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (FloatCharHashMap.this.sentinelValues != null) {
                if (FloatCharHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0.0f);
                }
                if (FloatCharHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1.0f);
                }
            }
            for (int i = 0; i < FloatCharHashMap.this.keys.length; ++i) {
                if (!FloatCharHashMap.isNonSentinel(FloatCharHashMap.this.keys[i])) continue;
                result = function.valueOf(result, FloatCharHashMap.this.keys[i]);
            }
            return result;
        }

        public MutableFloatList toList() {
            return FloatArrayList.newList((FloatIterable)this);
        }

        public MutableFloatList toSortedList() {
            return FloatArrayList.newList((FloatIterable)this).sortThis();
        }

        public MutableFloatSet toSet() {
            return FloatHashSet.newSet((FloatIterable)this);
        }

        public MutableFloatBag toBag() {
            return FloatHashBag.newBag((FloatIterable)this);
        }

        public LazyFloatIterable asLazy() {
            return this;
        }
    }

    private class InternalCharIterator
    implements CharIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalCharIterator() {
        }

        public boolean hasNext() {
            return this.count < FloatCharHashMap.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (FloatCharHashMap.this.containsKey(0.0f)) {
                    return FloatCharHashMap.this.get(0.0f);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (FloatCharHashMap.this.containsKey(1.0f)) {
                    return FloatCharHashMap.this.get(1.0f);
                }
            }
            float[] keys = FloatCharHashMap.this.keys;
            while (!FloatCharHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            char result = FloatCharHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private char zeroValue;
        private char oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(char value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

