/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction0;
import com.gs.collections.api.block.function.primitive.FloatToFloatFunction;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatFloatPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatFloatProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.FloatFloatMap;
import com.gs.collections.api.map.primitive.ImmutableFloatFloatMap;
import com.gs.collections.api.map.primitive.MutableFloatFloatMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.FloatSet;
import com.gs.collections.api.set.primitive.ImmutableFloatSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.block.factory.primitive.FloatPredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedFloatCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.FloatFloatMaps;
import com.gs.collections.impl.factory.primitive.FloatLists;
import com.gs.collections.impl.factory.primitive.FloatSets;
import com.gs.collections.impl.lazy.primitive.CollectFloatToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectFloatIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedFloatFloatMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableFloatFloatMap;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedFloatSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatFloatHashMap
implements MutableFloatFloatMap,
Externalizable {
    static final float EMPTY_VALUE = 0.0f;
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_KEY = 0.0f;
    private static final float REMOVED_KEY = 1.0f;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private float[] keys;
    private float[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public FloatFloatHashMap() {
        this.allocateTable(16);
    }

    public FloatFloatHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public FloatFloatHashMap(FloatFloatMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static FloatFloatHashMap newWithKeysValues(float key1, float value1) {
        return new FloatFloatHashMap(1).withKeyValue(key1, value1);
    }

    public static FloatFloatHashMap newWithKeysValues(float key1, float value1, float key2, float value2) {
        return new FloatFloatHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static FloatFloatHashMap newWithKeysValues(float key1, float value1, float key2, float value2, float key3, float value3) {
        return new FloatFloatHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static FloatFloatHashMap newWithKeysValues(float key1, float value1, float key2, float value2, float key3, float value3, float key4, float value4) {
        return new FloatFloatHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FloatFloatMap)) {
            return false;
        }
        FloatFloatMap other = (FloatFloatMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0.0f) || other.containsKey(1.0f)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0.0f) || Float.compare(this.sentinelValues.zeroValue, other.getOrThrow(0.0f)) != 0)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1.0f) || Float.compare(this.sentinelValues.oneValue, other.getOrThrow(1.0f)) != 0)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            float key = this.keys[i];
            if (!FloatFloatHashMap.isNonSentinel(key) || other.containsKey(key) && Float.compare(this.values[i], other.getOrThrow(key)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += Float.floatToIntBits(0.0f) ^ Float.floatToIntBits(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result += Float.floatToIntBits(1.0f) ^ Float.floatToIntBits(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(this.keys[i])) continue;
            result += Float.floatToIntBits(this.keys[i]) ^ Float.floatToIntBits(this.values[i]);
        }
        return result;
    }

    public String toString() {
        return this.makeString("{", ", ", "}");
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(0.0f)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1.0f)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                float key = this.keys[i];
                if (!FloatFloatHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FloatIterator floatIterator() {
        return new InternalFloatIterator();
    }

    public float[] toArray() {
        float[] array = new float[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(float value) {
        return this.containsValue(value);
    }

    public boolean containsAll(float ... source) {
        for (float each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(FloatIterable source) {
        return source.allSatisfy(new FloatPredicate(){

            public boolean accept(float value) {
                return FloatFloatHashMap.this.contains(value);
            }
        });
    }

    public void forEach(FloatProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableFloatCollection select(FloatPredicate predicate) {
        FloatArrayList result = new FloatArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableFloatCollection reject(FloatPredicate predicate) {
        FloatArrayList result = new FloatArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public float detectIfNone(FloatPredicate predicate, float value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(FloatPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectFloatToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableFloatList toList() {
        return FloatArrayList.newList((FloatIterable)this);
    }

    public MutableFloatSet toSet() {
        return FloatHashSet.newSet((FloatIterable)this);
    }

    public MutableFloatBag toBag() {
        return FloatHashBag.newBag((FloatIterable)this);
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, 0.0f);
        Arrays.fill(this.values, 0.0f);
    }

    public void put(float key, float value) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.values[index] = value;
            return;
        }
        if (Float.compare(this.keys[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public void putAll(FloatFloatMap map) {
        map.forEachKeyValue(new FloatFloatProcedure(){

            public void value(float key, float value) {
                FloatFloatHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(float key) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0.0f;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0.0f;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0f;
            this.values[index] = 0.0f;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(float key) {
        this.removeKey(key);
    }

    public float removeKeyIfAbsent(float key, float value) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            float oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0.0f;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            float oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0.0f;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0f;
            float oldValue = this.values[index];
            this.values[index] = 0.0f;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public float getIfAbsentPut(float key, float value) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        if (Float.compare(this.keys[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public float getIfAbsentPut(float key, FloatFunction0 function) {
        float value;
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                float value2 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            float value3 = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                float value4 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            float value5 = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        if (Float.compare(this.keys[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.value();
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public <P> float getIfAbsentPutWith(float key, FloatFunction<? super P> function, P parameter) {
        float value;
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                float value2 = function.floatValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            float value3 = function.floatValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                float value4 = function.floatValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            float value5 = function.floatValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        if (Float.compare(this.keys[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.floatValueOf(parameter);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public float getIfAbsentPutWithKey(float key, FloatToFloatFunction function) {
        float value;
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                float value2 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            float value3 = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                float value4 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            float value5 = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        if (Float.compare(this.keys[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(key);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public float updateValue(float key, float initialValueIfAbsent, FloatToFloatFunction function) {
        float value;
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        if (Float.compare(this.keys[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(initialValueIfAbsent);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public FloatFloatHashMap withKeyValue(float key1, float value1) {
        this.put(key1, value1);
        return this;
    }

    public FloatFloatHashMap withKeysValues(float key1, float value1, float key2, float value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public FloatFloatHashMap withKeysValues(float key1, float value1, float key2, float value2, float key3, float value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public FloatFloatHashMap withKeysValues(float key1, float value1, float key2, float value2, float key3, float value3, float key4, float value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public FloatFloatHashMap withoutKey(float key) {
        this.removeKey(key);
        return this;
    }

    public FloatFloatHashMap withoutAllKeys(FloatIterable keys) {
        keys.forEach(new FloatProcedure(){

            public void value(float key) {
                FloatFloatHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableFloatFloatMap asUnmodifiable() {
        return new UnmodifiableFloatFloatMap(this);
    }

    public MutableFloatFloatMap asSynchronized() {
        return new SynchronizedFloatFloatMap(this);
    }

    public ImmutableFloatFloatMap toImmutable() {
        return FloatFloatMaps.immutable.ofAll((FloatFloatMap)this);
    }

    public float get(float key) {
        return this.getIfAbsent(key, 0.0f);
    }

    public float getIfAbsent(float key, float ifAbsent) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public float getOrThrow(float key) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (FloatFloatHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(float key) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return Float.compare(this.keys[this.probe(key)], key) == 0;
    }

    public boolean containsValue(float value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(this.keys[i]) || Float.compare(this.values[i], value) != 0) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(FloatProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(FloatProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0f);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0f);
            }
        }
        for (float key : this.keys) {
            if (!FloatFloatHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(FloatFloatProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyFloatIterable keysView() {
        return new KeysView();
    }

    public FloatFloatHashMap select(FloatFloatPredicate predicate) {
        FloatFloatHashMap result = new FloatFloatHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0.0f, this.sentinelValues.zeroValue)) {
                result.put(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1.0f, this.sentinelValues.oneValue)) {
                result.put(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public FloatFloatHashMap reject(FloatFloatPredicate predicate) {
        FloatFloatHashMap result = new FloatFloatHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0.0f, this.sentinelValues.zeroValue)) {
                result.put(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1.0f, this.sentinelValues.oneValue)) {
                result.put(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public double sum() {
        double result = 0.0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (double)this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (double)this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(this.keys[i])) continue;
            result += (double)this.values[i];
        }
        return result;
    }

    public float max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        FloatIterator iterator = this.floatIterator();
        float max = iterator.next();
        while (iterator.hasNext()) {
            float value = iterator.next();
            if (Float.compare(max, value) >= 0) continue;
            max = value;
        }
        return max;
    }

    public float maxIfEmpty(float defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public float min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        FloatIterator iterator = this.floatIterator();
        float min = iterator.next();
        while (iterator.hasNext()) {
            float value = iterator.next();
            if (Float.compare(value, min) >= 0) continue;
            min = value;
        }
        return min;
    }

    public float minIfEmpty(float defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        float[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            float first = sortedArray[middleIndex];
            float second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public float[] toSortedArray() {
        float[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableFloatList toSortedList() {
        return FloatArrayList.newList((FloatIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeFloat(0.0f);
                out.writeFloat(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeFloat(1.0f);
                out.writeFloat(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeFloat(this.keys[i]);
            out.writeFloat(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readFloat(), in.readFloat());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        float[] old = this.keys;
        float[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!FloatFloatHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(float element) {
        int index = this.spread(element);
        float keyAtIndex = this.keys[index];
        if (Float.compare(keyAtIndex, element) == 0 || Float.compare(keyAtIndex, 0.0f) == 0) {
            return index;
        }
        int removedIndex = Float.compare(keyAtIndex, 1.0f) == 0 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (Float.compare(this.keys[nextIndex &= this.keys.length - 1], element) == 0) {
                return nextIndex;
            }
            if (Float.compare(this.keys[nextIndex], 1.0f) == 0) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (Float.compare(this.keys[nextIndex], 0.0f) == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(float element) {
        int code = Float.floatToIntBits(element);
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new float[sizeToAllocate];
        this.values = new float[sizeToAllocate];
    }

    private static boolean isEmptyKey(float key) {
        return Float.compare(key, 0.0f) == 0;
    }

    private static boolean isRemovedKey(float key) {
        return Float.compare(key, 1.0f) == 0;
    }

    private static boolean isNonSentinel(float key) {
        return !FloatFloatHashMap.isEmptyKey(key) && !FloatFloatHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableFloatSet keySet() {
        return new KeySet();
    }

    public MutableFloatCollection values() {
        return new ValuesCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableFloatCollection {
        private ValuesCollection() {
        }

        public void clear() {
            FloatFloatHashMap.this.clear();
        }

        public MutableFloatCollection select(FloatPredicate predicate) {
            return FloatFloatHashMap.this.select(predicate);
        }

        public MutableFloatCollection reject(FloatPredicate predicate) {
            return FloatFloatHashMap.this.reject(predicate);
        }

        public float detectIfNone(FloatPredicate predicate, float ifNone) {
            return FloatFloatHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function) {
            return FloatFloatHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
            return FloatFloatHashMap.this.injectInto(injectedValue, function);
        }

        public double sum() {
            return FloatFloatHashMap.this.sum();
        }

        public float max() {
            return FloatFloatHashMap.this.max();
        }

        public float maxIfEmpty(float defaultValue) {
            return FloatFloatHashMap.this.maxIfEmpty(defaultValue);
        }

        public float min() {
            return FloatFloatHashMap.this.min();
        }

        public float minIfEmpty(float defaultValue) {
            return FloatFloatHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return FloatFloatHashMap.this.average();
        }

        public double median() {
            return FloatFloatHashMap.this.median();
        }

        public float[] toSortedArray() {
            return FloatFloatHashMap.this.toSortedArray();
        }

        public MutableFloatList toSortedList() {
            return FloatFloatHashMap.this.toSortedList();
        }

        public MutableFloatCollection with(float element) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatCollection without(float element) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatCollection withAll(FloatIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatCollection withoutAll(FloatIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatCollection asUnmodifiable() {
            return UnmodifiableFloatCollection.of(this);
        }

        public MutableFloatCollection asSynchronized() {
            return SynchronizedFloatCollection.of(this);
        }

        public ImmutableFloatCollection toImmutable() {
            return FloatLists.immutable.withAll((FloatIterable)this);
        }

        public boolean contains(float value) {
            return FloatFloatHashMap.this.containsValue(value);
        }

        public boolean containsAll(float ... source) {
            return FloatFloatHashMap.this.containsAll(source);
        }

        public boolean containsAll(FloatIterable source) {
            return FloatFloatHashMap.this.containsAll(source);
        }

        public MutableFloatList toList() {
            return FloatFloatHashMap.this.toList();
        }

        public MutableFloatSet toSet() {
            return FloatFloatHashMap.this.toSet();
        }

        public MutableFloatBag toBag() {
            return FloatFloatHashMap.this.toBag();
        }

        public LazyFloatIterable asLazy() {
            return new LazyFloatIterableAdapter((FloatIterable)this);
        }

        public boolean isEmpty() {
            return FloatFloatHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return FloatFloatHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (FloatFloatHashMap.this.sentinelValues != null) {
                    if (FloatFloatHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(FloatFloatHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (FloatFloatHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(FloatFloatHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < FloatFloatHashMap.this.keys.length; ++i) {
                    float key = FloatFloatHashMap.this.keys[i];
                    if (!FloatFloatHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(FloatFloatHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public FloatIterator floatIterator() {
            return FloatFloatHashMap.this.floatIterator();
        }

        public void forEach(FloatProcedure procedure) {
            FloatFloatHashMap.this.forEach(procedure);
        }

        public int count(FloatPredicate predicate) {
            return FloatFloatHashMap.this.count(predicate);
        }

        public boolean anySatisfy(FloatPredicate predicate) {
            return FloatFloatHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(FloatPredicate predicate) {
            return FloatFloatHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(FloatPredicate predicate) {
            return FloatFloatHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(float element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(float ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(FloatIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(float item) {
            int oldSize = FloatFloatHashMap.this.size();
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey && Float.compare(item, FloatFloatHashMap.this.sentinelValues.zeroValue) == 0) {
                    FloatFloatHashMap.this.removeKey(0.0f);
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey && Float.compare(item, FloatFloatHashMap.this.sentinelValues.oneValue) == 0) {
                    FloatFloatHashMap.this.removeKey(1.0f);
                }
            }
            for (int i = 0; i < FloatFloatHashMap.this.keys.length; ++i) {
                if (!FloatFloatHashMap.isNonSentinel(FloatFloatHashMap.this.keys[i]) || Float.compare(item, FloatFloatHashMap.this.values[i]) != 0) continue;
                FloatFloatHashMap.this.removeKey(FloatFloatHashMap.this.keys[i]);
            }
            return oldSize != FloatFloatHashMap.this.size();
        }

        public boolean removeAll(FloatIterable source) {
            int oldSize = FloatFloatHashMap.this.size();
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != FloatFloatHashMap.this.size();
        }

        public boolean removeAll(float ... source) {
            int oldSize = FloatFloatHashMap.this.size();
            for (float item : source) {
                this.remove(item);
            }
            return oldSize != FloatFloatHashMap.this.size();
        }

        public int size() {
            return FloatFloatHashMap.this.size();
        }

        public float[] toArray() {
            return FloatFloatHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableFloatSet {
        private KeySet() {
        }

        public FloatIterator floatIterator() {
            return new KeySetIterator();
        }

        public void forEach(FloatProcedure procedure) {
            FloatFloatHashMap.this.forEachKey(procedure);
        }

        public int count(FloatPredicate predicate) {
            int count = 0;
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    ++count;
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    ++count;
                }
            }
            for (float key : FloatFloatHashMap.this.keys) {
                if (!FloatFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(FloatPredicate predicate) {
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return true;
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return true;
                }
            }
            for (float key : FloatFloatHashMap.this.keys) {
                if (!FloatFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(FloatPredicate predicate) {
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0f)) {
                    return false;
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0f)) {
                    return false;
                }
            }
            for (float key : FloatFloatHashMap.this.keys) {
                if (!FloatFloatHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(FloatPredicate predicate) {
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return false;
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return false;
                }
            }
            for (float key : FloatFloatHashMap.this.keys) {
                if (!FloatFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(float element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(float ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(FloatIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(float key) {
            int oldSize = FloatFloatHashMap.this.size();
            FloatFloatHashMap.this.removeKey(key);
            return oldSize != FloatFloatHashMap.this.size();
        }

        public boolean removeAll(FloatIterable source) {
            int oldSize = FloatFloatHashMap.this.size();
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                FloatFloatHashMap.this.removeKey(iterator.next());
            }
            return oldSize != FloatFloatHashMap.this.size();
        }

        public boolean removeAll(float ... source) {
            int oldSize = FloatFloatHashMap.this.size();
            for (float item : source) {
                FloatFloatHashMap.this.removeKey(item);
            }
            return oldSize != FloatFloatHashMap.this.size();
        }

        public void clear() {
            FloatFloatHashMap.this.clear();
        }

        public MutableFloatSet select(FloatPredicate predicate) {
            FloatHashSet result = new FloatHashSet();
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    result.add(0.0f);
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    result.add(1.0f);
                }
            }
            for (float key : FloatFloatHashMap.this.keys) {
                if (!FloatFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableFloatSet reject(FloatPredicate predicate) {
            FloatHashSet result = new FloatHashSet();
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0f)) {
                    result.add(0.0f);
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0f)) {
                    result.add(1.0f);
                }
            }
            for (float key : FloatFloatHashMap.this.keys) {
                if (!FloatFloatHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableFloatSet with(float element) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatSet without(float element) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatSet withAll(FloatIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatSet withoutAll(FloatIterable elements) {
            throw new UnsupportedOperationException();
        }

        public float detectIfNone(FloatPredicate predicate, float ifNone) {
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return 0.0f;
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return 1.0f;
                }
            }
            for (float key : FloatFloatHashMap.this.keys) {
                if (!FloatFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0.0f));
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1.0f));
                }
            }
            for (float key : FloatFloatHashMap.this.keys) {
                if (!FloatFloatHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableFloatSet asUnmodifiable() {
            return UnmodifiableFloatSet.of(this);
        }

        public MutableFloatSet asSynchronized() {
            return SynchronizedFloatSet.of(this);
        }

        public double sum() {
            double sum = 0.0;
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0.0;
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey) {
                    sum += 1.0;
                }
            }
            for (float key : FloatFloatHashMap.this.keys) {
                if (!FloatFloatHashMap.isNonSentinel(key)) continue;
                sum += (double)key;
            }
            return sum;
        }

        public float max() {
            if (FloatFloatHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            float max = 0.0f;
            boolean isMaxSet = false;
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0.0f;
                    isMaxSet = true;
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || Float.compare(max, 1.0f) < 0)) {
                    max = 1.0f;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < FloatFloatHashMap.this.keys.length; ++i) {
                if (!FloatFloatHashMap.isNonSentinel(FloatFloatHashMap.this.keys[i]) || isMaxSet && Float.compare(max, FloatFloatHashMap.this.keys[i]) >= 0) continue;
                max = FloatFloatHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public float maxIfEmpty(float defaultValue) {
            if (FloatFloatHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public float min() {
            if (FloatFloatHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            float min = 0.0f;
            boolean isMinSet = false;
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0.0f;
                    isMinSet = true;
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey && (!isMinSet || Float.compare(1.0f, min) < 0)) {
                    min = 1.0f;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < FloatFloatHashMap.this.keys.length; ++i) {
                if (!FloatFloatHashMap.isNonSentinel(FloatFloatHashMap.this.keys[i]) || isMinSet && Float.compare(FloatFloatHashMap.this.keys[i], min) >= 0) continue;
                min = FloatFloatHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public float minIfEmpty(float defaultValue) {
            if (FloatFloatHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            float[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                float first = sortedArray[middleIndex];
                float second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public float[] toSortedArray() {
            float[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableFloatList toSortedList() {
            return FloatArrayList.newList((FloatIterable)this).sortThis();
        }

        public float[] toArray() {
            int size = FloatFloatHashMap.this.size();
            final float[] result = new float[size];
            FloatFloatHashMap.this.forEachKey(new FloatProcedure(){
                private int index;

                public void value(float each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(float value) {
            return FloatFloatHashMap.this.containsKey(value);
        }

        public boolean containsAll(float ... source) {
            for (float item : source) {
                if (FloatFloatHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(FloatIterable source) {
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                if (FloatFloatHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableFloatList toList() {
            return FloatArrayList.newList((FloatIterable)this);
        }

        public MutableFloatSet toSet() {
            return FloatHashSet.newSet((FloatIterable)this);
        }

        public MutableFloatBag toBag() {
            return FloatHashBag.newBag((FloatIterable)this);
        }

        public LazyFloatIterable asLazy() {
            return new LazyFloatIterableAdapter((FloatIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0.0f);
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1.0f);
                }
            }
            for (int i = 0; i < FloatFloatHashMap.this.keys.length; ++i) {
                if (!FloatFloatHashMap.isNonSentinel(FloatFloatHashMap.this.keys[i])) continue;
                result = function.valueOf(result, FloatFloatHashMap.this.keys[i]);
            }
            return result;
        }

        public FloatSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableFloatSet toImmutable() {
            return FloatSets.immutable.withAll((FloatIterable)this);
        }

        public int size() {
            return FloatFloatHashMap.this.size();
        }

        public boolean isEmpty() {
            return FloatFloatHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return FloatFloatHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FloatSet)) {
                return false;
            }
            FloatSet other = (FloatSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey) {
                    result += Float.floatToIntBits(0.0f);
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey) {
                    result += Float.floatToIntBits(1.0f);
                }
            }
            for (int i = 0; i < FloatFloatHashMap.this.keys.length; ++i) {
                if (!FloatFloatHashMap.isNonSentinel(FloatFloatHashMap.this.keys[i])) continue;
                result += Float.floatToIntBits(FloatFloatHashMap.this.keys[i]);
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (FloatFloatHashMap.this.sentinelValues != null) {
                    if (FloatFloatHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0.0f));
                        first = false;
                    }
                    if (FloatFloatHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1.0f));
                        first = false;
                    }
                }
                for (float key : FloatFloatHashMap.this.keys) {
                    if (!FloatFloatHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements FloatIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < FloatFloatHashMap.this.size();
        }

        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (FloatFloatHashMap.this.containsKey(0.0f)) {
                    return 0.0f;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (FloatFloatHashMap.this.containsKey(1.0f)) {
                    return 1.0f;
                }
            }
            float[] keys = FloatFloatHashMap.this.keys;
            while (!FloatFloatHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            float result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyFloatIterable {
        private KeysView() {
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public int size() {
            return FloatFloatHashMap.this.size();
        }

        public boolean isEmpty() {
            return FloatFloatHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return FloatFloatHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (FloatFloatHashMap.this.sentinelValues != null) {
                    if (FloatFloatHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0.0f));
                        first = false;
                    }
                    if (FloatFloatHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1.0f));
                        first = false;
                    }
                }
                for (float key : FloatFloatHashMap.this.keys) {
                    if (!FloatFloatHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public FloatIterator floatIterator() {
            return new KeySetIterator();
        }

        public boolean contains(float key) {
            return FloatFloatHashMap.this.containsKey(key);
        }

        public boolean containsAll(float ... keys) {
            for (float key : keys) {
                if (FloatFloatHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(FloatIterable source) {
            return source.allSatisfy(new FloatPredicate(){

                public boolean accept(float key) {
                    return FloatFloatHashMap.this.containsKey(key);
                }
            });
        }

        public void forEach(FloatProcedure procedure) {
            FloatFloatHashMap.this.forEachKey(procedure);
        }

        public int count(FloatPredicate predicate) {
            int count = 0;
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    ++count;
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    ++count;
                }
            }
            for (float key : FloatFloatHashMap.this.keys) {
                if (!FloatFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(FloatPredicate predicate) {
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return true;
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return true;
                }
            }
            for (float key : FloatFloatHashMap.this.keys) {
                if (!FloatFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(FloatPredicate predicate) {
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0f)) {
                    return false;
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0f)) {
                    return false;
                }
            }
            for (float key : FloatFloatHashMap.this.keys) {
                if (!FloatFloatHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(FloatPredicate predicate) {
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return false;
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return false;
                }
            }
            for (float key : FloatFloatHashMap.this.keys) {
                if (!FloatFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public LazyFloatIterable select(FloatPredicate predicate) {
            return new SelectFloatIterable((FloatIterable)this, predicate);
        }

        public LazyFloatIterable reject(FloatPredicate predicate) {
            return new SelectFloatIterable((FloatIterable)this, FloatPredicates.not(predicate));
        }

        public float detectIfNone(FloatPredicate predicate, float value) {
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return 0.0f;
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return 1.0f;
                }
            }
            for (float key : FloatFloatHashMap.this.keys) {
                if (!FloatFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(FloatToObjectFunction<? extends V> function) {
            return new CollectFloatToObjectIterable<V>((FloatIterable)this, function);
        }

        public double sum() {
            double result = 0.0;
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0.0;
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey) {
                    result += 1.0;
                }
            }
            for (float key : FloatFloatHashMap.this.keys) {
                if (!FloatFloatHashMap.isNonSentinel(key)) continue;
                result += (double)key;
            }
            return result;
        }

        public float max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            FloatIterator iterator = this.floatIterator();
            float max = iterator.next();
            while (iterator.hasNext()) {
                float value = iterator.next();
                if (Float.compare(max, value) >= 0) continue;
                max = value;
            }
            return max;
        }

        public float min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            FloatIterator iterator = this.floatIterator();
            float min = iterator.next();
            while (iterator.hasNext()) {
                float value = iterator.next();
                if (Float.compare(value, min) >= 0) continue;
                min = value;
            }
            return min;
        }

        public float minIfEmpty(float defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public float maxIfEmpty(float defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            float[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                float first = sortedArray[middleIndex];
                float second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public float[] toSortedArray() {
            float[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public float[] toArray() {
            int size = FloatFloatHashMap.this.size();
            final float[] result = new float[size];
            FloatFloatHashMap.this.forEachKey(new FloatProcedure(){
                private int index;

                public void value(float each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (FloatFloatHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0.0f);
                }
                if (FloatFloatHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1.0f);
                }
            }
            for (int i = 0; i < FloatFloatHashMap.this.keys.length; ++i) {
                if (!FloatFloatHashMap.isNonSentinel(FloatFloatHashMap.this.keys[i])) continue;
                result = function.valueOf(result, FloatFloatHashMap.this.keys[i]);
            }
            return result;
        }

        public MutableFloatList toList() {
            return FloatArrayList.newList((FloatIterable)this);
        }

        public MutableFloatList toSortedList() {
            return FloatArrayList.newList((FloatIterable)this).sortThis();
        }

        public MutableFloatSet toSet() {
            return FloatHashSet.newSet((FloatIterable)this);
        }

        public MutableFloatBag toBag() {
            return FloatHashBag.newBag((FloatIterable)this);
        }

        public LazyFloatIterable asLazy() {
            return this;
        }
    }

    private class InternalFloatIterator
    implements FloatIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalFloatIterator() {
        }

        public boolean hasNext() {
            return this.count < FloatFloatHashMap.this.size();
        }

        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (FloatFloatHashMap.this.containsKey(0.0f)) {
                    return FloatFloatHashMap.this.get(0.0f);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (FloatFloatHashMap.this.containsKey(1.0f)) {
                    return FloatFloatHashMap.this.get(1.0f);
                }
            }
            float[] keys = FloatFloatHashMap.this.keys;
            while (!FloatFloatHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            float result = FloatFloatHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private float zeroValue;
        private float oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(float value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && Float.compare(this.zeroValue, value) == 0;
            boolean valueEqualsOneValue = this.containsOneKey && Float.compare(this.oneValue, value) == 0;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

