/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction0;
import com.gs.collections.api.block.function.primitive.BooleanToBooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.IntToBooleanFunction;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.IntBooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.IntBooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.ImmutableIntBooleanMap;
import com.gs.collections.api.map.primitive.IntBooleanMap;
import com.gs.collections.api.map.primitive.MutableIntBooleanMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableIntSet;
import com.gs.collections.api.set.primitive.IntSet;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.block.factory.primitive.IntPredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedBooleanCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.BooleanLists;
import com.gs.collections.impl.factory.primitive.IntBooleanMaps;
import com.gs.collections.impl.factory.primitive.IntSets;
import com.gs.collections.impl.lazy.primitive.CollectIntToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectIntIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedIntBooleanMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableIntBooleanMap;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedIntSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.BitSet;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntBooleanHashMap
implements MutableIntBooleanMap,
Externalizable {
    static final boolean EMPTY_VALUE = false;
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_KEY = 0;
    private static final int REMOVED_KEY = 1;
    private static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private int occupied;
    private int maxSize;
    private int[] keys;
    private BitSet values;
    private float loadFactor = 0.5f;
    private SentinelValues sentinelValues;

    public IntBooleanHashMap() {
        this.allocate(16);
    }

    public IntBooleanHashMap(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public IntBooleanHashMap(IntBooleanMap map) {
        this(Math.max(map.size(), 8), 0.5f);
        this.putAll(map);
    }

    public IntBooleanHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        this.loadFactor = loadFactor;
        this.init(this.fastCeil((float)initialCapacity / loadFactor));
    }

    public MutableIntBooleanMap asUnmodifiable() {
        return new UnmodifiableIntBooleanMap(this);
    }

    public MutableIntBooleanMap asSynchronized() {
        return new SynchronizedIntBooleanMap(this);
    }

    public ImmutableIntBooleanMap toImmutable() {
        return IntBooleanMaps.immutable.withAll((IntBooleanMap)this);
    }

    public static IntBooleanHashMap newWithKeysValues(int key1, boolean value1) {
        return new IntBooleanHashMap(1).withKeyValue(key1, value1);
    }

    public static IntBooleanHashMap newWithKeysValues(int key1, boolean value1, int key2, boolean value2) {
        return new IntBooleanHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static IntBooleanHashMap newWithKeysValues(int key1, boolean value1, int key2, boolean value2, int key3, boolean value3) {
        return new IntBooleanHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static IntBooleanHashMap newWithKeysValues(int key1, boolean value1, int key2, boolean value2, int key3, boolean value3, int key4, boolean value4) {
        return new IntBooleanHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public IntBooleanHashMap withKeyValue(int key1, boolean value1) {
        this.put(key1, value1);
        return this;
    }

    public IntBooleanHashMap withKeysValues(int key1, boolean value1, int key2, boolean value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public IntBooleanHashMap withKeysValues(int key1, boolean value1, int key2, boolean value2, int key3, boolean value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public IntBooleanHashMap withKeysValues(int key1, boolean value1, int key2, boolean value2, int key3, boolean value3, int key4, boolean value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public IntBooleanHashMap withoutKey(int key) {
        this.removeKey(key);
        return this;
    }

    public IntBooleanHashMap withoutAllKeys(IntIterable keys) {
        keys.forEach(new IntProcedure(){

            public void value(int key) {
                IntBooleanHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    private int init(int initialCapacity) {
        int capacity;
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        return this.allocate(capacity);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    private static boolean isEmptyKey(int key) {
        return key == 0;
    }

    private static boolean isRemovedKey(int key) {
        return key == 1;
    }

    private static boolean isNonSentinel(int key) {
        return !IntBooleanHashMap.isEmptyKey(key) && !IntBooleanHashMap.isRemovedKey(key);
    }

    private int allocate(int capacity) {
        this.allocateTable(capacity);
        this.computeMaxSize(capacity);
        return capacity;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new int[sizeToAllocate];
        this.values = new BitSet(sizeToAllocate);
    }

    private void computeMaxSize(int capacity) {
        this.maxSize = Math.min(capacity - 1, (int)((float)capacity * this.loadFactor));
    }

    public int size() {
        return this.occupied + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupied == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupied != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    private void rehash() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        int[] old = this.keys;
        BitSet oldValues = this.values;
        this.allocate(newCapacity);
        this.occupied = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues.get(i));
        }
    }

    int probe(int element) {
        int index = this.spread(element);
        int keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(int element) {
        int code = element;
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.keys.length - 1;
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupied = 0;
        Arrays.fill(this.keys, 0);
        this.values.clear();
    }

    public void put(int key, boolean value) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values.set(index, value);
            return;
        }
        this.keys[index] = key;
        this.values.set(index, value);
        ++this.occupied;
        if (this.occupied > this.maxSize) {
            this.rehash();
        }
    }

    public void putAll(IntBooleanMap map) {
        map.forEachKeyValue(new IntBooleanProcedure(){

            public void value(int key, boolean value) {
                IntBooleanHashMap.this.put(key, value);
            }
        });
    }

    public boolean containsKey(int key) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(boolean value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i]) || this.values.get(i) != value) continue;
            return true;
        }
        return false;
    }

    public boolean contains(boolean value) {
        return this.containsValue(value);
    }

    public boolean containsAll(boolean ... source) {
        for (boolean each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(BooleanIterable source) {
        return source.allSatisfy(new BooleanPredicate(){

            public boolean accept(boolean value) {
                return IntBooleanHashMap.this.contains(value);
            }
        });
    }

    public boolean get(int key) {
        return this.getIfAbsent(key, false);
    }

    public boolean getIfAbsent(int key, boolean ifAbsent) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (IntBooleanHashMap.isNonSentinel(this.keys[index])) {
            return this.values.get(index);
        }
        return ifAbsent;
    }

    public boolean getOrThrow(int key) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (IntBooleanHashMap.isNonSentinel(this.keys[index])) {
            return this.values.get(index);
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean getIfAbsentPut(int key, boolean value) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        this.keys[index] = key;
        ++this.occupied;
        this.values.set(index, value);
        return value;
    }

    public boolean getIfAbsentPut(int key, BooleanFunction0 function) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            boolean value = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            boolean value = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        this.keys[index] = key;
        ++this.occupied;
        boolean value = function.value();
        this.values.set(index, value);
        return value;
    }

    public <P> boolean getIfAbsentPutWith(int key, BooleanFunction<? super P> function, P parameter) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.booleanValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            boolean value = function.booleanValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.booleanValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            boolean value = function.booleanValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        this.keys[index] = key;
        ++this.occupied;
        boolean value = function.booleanValueOf(parameter);
        this.values.set(index, value);
        return value;
    }

    public boolean getIfAbsentPutWithKey(int key, IntToBooleanFunction function) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            boolean value = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            boolean value = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        this.keys[index] = key;
        ++this.occupied;
        boolean value = function.valueOf(key);
        this.values.set(index, value);
        return value;
    }

    public boolean updateValue(int key, boolean initialValueIfAbsent, BooleanToBooleanFunction function) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values.set(index, function.valueOf(this.values.get(index)));
        } else {
            this.keys[index] = key;
            ++this.occupied;
            this.values.set(index, function.valueOf(initialValueIfAbsent));
        }
        return this.values.get(index);
    }

    public void removeKey(int key) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = false;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = false;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            --this.occupied;
            this.values.set(index, false);
        }
    }

    public void remove(int key) {
        this.removeKey(key);
    }

    public boolean removeKeyIfAbsent(int key, boolean value) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            boolean oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = false;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            boolean oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = false;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            --this.occupied;
            boolean oldValue = this.values.get(index);
            this.values.set(index, false);
            return oldValue;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntBooleanMap)) {
            return false;
        }
        IntBooleanMap other = (IntBooleanMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0) || other.containsKey(1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0) || this.sentinelValues.zeroValue != other.getOrThrow(0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1) || this.sentinelValues.oneValue != other.getOrThrow(1))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            if (!IntBooleanHashMap.isNonSentinel(key) || other.containsKey(key) && this.values.get(i) == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ (this.sentinelValues.zeroValue ? 1231 : 1237);
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ (this.sentinelValues.oneValue ? 1231 : 1237);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ (this.values.get(i) ? 1231 : 1237);
        }
        return result;
    }

    public String toString() {
        return this.makeString("{", ", ", "}");
    }

    public BooleanIterator booleanIterator() {
        return new InternalBooleanIterator();
    }

    public void forEach(BooleanProcedure procedure) {
        this.forEachValue(procedure);
    }

    public void forEachValue(BooleanProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values.get(i));
        }
    }

    public void forEachKey(IntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1);
            }
        }
        for (int key : this.keys) {
            if (!IntBooleanHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(IntBooleanProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values.get(i));
        }
    }

    public IntBooleanHashMap select(IntBooleanPredicate predicate) {
        IntBooleanHashMap result = new IntBooleanHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0, this.sentinelValues.zeroValue)) {
                result.put(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1, this.sentinelValues.oneValue)) {
                result.put(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values.get(i))) continue;
            result.put(this.keys[i], this.values.get(i));
        }
        return result;
    }

    public IntBooleanHashMap reject(IntBooleanPredicate predicate) {
        IntBooleanHashMap result = new IntBooleanHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0, this.sentinelValues.zeroValue)) {
                result.put(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1, this.sentinelValues.oneValue)) {
                result.put(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values.get(i))) continue;
            result.put(this.keys[i], this.values.get(i));
        }
        return result;
    }

    public <V> V injectInto(V injectedValue, ObjectBooleanToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values.get(i));
        }
        return result;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(0)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                int key = this.keys[i];
                if (!IntBooleanHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values.get(i)));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableBooleanCollection select(BooleanPredicate predicate) {
        BooleanArrayList result = new BooleanArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            result.add(this.values.get(i));
        }
        return result;
    }

    public MutableBooleanCollection reject(BooleanPredicate predicate) {
        BooleanArrayList result = new BooleanArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values.get(i))) continue;
            result.add(this.values.get(i));
        }
        return result;
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            return this.values.get(i);
        }
        return value;
    }

    public <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values.get(i)));
        }
        return target;
    }

    public int count(BooleanPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public boolean[] toArray() {
        boolean[] array = new boolean[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values.get(i);
            ++index;
        }
        return array;
    }

    public MutableBooleanList toList() {
        return BooleanArrayList.newList((BooleanIterable)this);
    }

    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSet((BooleanIterable)this);
    }

    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBag((BooleanIterable)this);
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    public LazyIntIterable keysView() {
        return new KeysView();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        out.writeFloat(this.loadFactor);
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeInt(0);
                out.writeBoolean(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeInt(1);
                out.writeBoolean(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeInt(this.keys[i]);
            out.writeBoolean(this.values.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        this.loadFactor = in.readFloat();
        this.init(Math.max((int)((float)size / this.loadFactor) + 1, 8));
        for (int i = 0; i < size; ++i) {
            this.put(in.readInt(), in.readBoolean());
        }
    }

    public MutableIntSet keySet() {
        return new KeySet();
    }

    public MutableBooleanCollection values() {
        return new ValuesCollection();
    }

    private class KeySetIterator
    implements IntIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < IntBooleanHashMap.this.size();
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntBooleanHashMap.this.containsKey(0)) {
                    return 0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntBooleanHashMap.this.containsKey(1)) {
                    return 1;
                }
            }
            int[] keys = IntBooleanHashMap.this.keys;
            while (!IntBooleanHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            int result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableBooleanCollection {
        private ValuesCollection() {
        }

        public void clear() {
            IntBooleanHashMap.this.clear();
        }

        public MutableBooleanCollection select(BooleanPredicate predicate) {
            return IntBooleanHashMap.this.select(predicate);
        }

        public MutableBooleanCollection reject(BooleanPredicate predicate) {
            return IntBooleanHashMap.this.reject(predicate);
        }

        public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
            return IntBooleanHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
            return IntBooleanHashMap.this.collect(function);
        }

        public MutableBooleanCollection with(boolean element) {
            throw new UnsupportedOperationException();
        }

        public MutableBooleanCollection without(boolean element) {
            throw new UnsupportedOperationException();
        }

        public MutableBooleanCollection withAll(BooleanIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableBooleanCollection withoutAll(BooleanIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableBooleanCollection asSynchronized() {
            return SynchronizedBooleanCollection.of(this);
        }

        public MutableBooleanCollection asUnmodifiable() {
            return UnmodifiableBooleanCollection.of(this);
        }

        public ImmutableBooleanCollection toImmutable() {
            return BooleanLists.immutable.withAll((BooleanIterable)this);
        }

        public boolean contains(boolean value) {
            return IntBooleanHashMap.this.containsValue(value);
        }

        public boolean containsAll(boolean ... source) {
            return IntBooleanHashMap.this.containsAll(source);
        }

        public boolean containsAll(BooleanIterable source) {
            return IntBooleanHashMap.this.containsAll(source);
        }

        public MutableBooleanList toList() {
            return IntBooleanHashMap.this.toList();
        }

        public MutableBooleanSet toSet() {
            return IntBooleanHashMap.this.toSet();
        }

        public MutableBooleanBag toBag() {
            return IntBooleanHashMap.this.toBag();
        }

        public LazyBooleanIterable asLazy() {
            return new LazyBooleanIterableAdapter((BooleanIterable)this);
        }

        public <V> V injectInto(V injectedValue, ObjectBooleanToObjectFunction<? super V, ? extends V> function) {
            return IntBooleanHashMap.this.injectInto(injectedValue, function);
        }

        public boolean isEmpty() {
            return IntBooleanHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return IntBooleanHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (IntBooleanHashMap.this.sentinelValues != null) {
                    if (IntBooleanHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(IntBooleanHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (IntBooleanHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(IntBooleanHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < IntBooleanHashMap.this.keys.length; ++i) {
                    int key = IntBooleanHashMap.this.keys[i];
                    if (!IntBooleanHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(IntBooleanHashMap.this.values.get(i)));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public BooleanIterator booleanIterator() {
            return IntBooleanHashMap.this.booleanIterator();
        }

        public void forEach(BooleanProcedure procedure) {
            IntBooleanHashMap.this.forEach(procedure);
        }

        public int count(BooleanPredicate predicate) {
            return IntBooleanHashMap.this.count(predicate);
        }

        public boolean anySatisfy(BooleanPredicate predicate) {
            return IntBooleanHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(BooleanPredicate predicate) {
            return IntBooleanHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(BooleanPredicate predicate) {
            return IntBooleanHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(boolean element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(boolean ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(BooleanIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(boolean item) {
            int oldSize = IntBooleanHashMap.this.size();
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey && item == IntBooleanHashMap.this.sentinelValues.zeroValue) {
                    IntBooleanHashMap.this.removeKey(0);
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey && item == IntBooleanHashMap.this.sentinelValues.oneValue) {
                    IntBooleanHashMap.this.removeKey(1);
                }
            }
            for (int i = 0; i < IntBooleanHashMap.this.keys.length; ++i) {
                if (!IntBooleanHashMap.isNonSentinel(IntBooleanHashMap.this.keys[i]) || item != IntBooleanHashMap.this.values.get(i)) continue;
                IntBooleanHashMap.this.removeKey(IntBooleanHashMap.this.keys[i]);
            }
            return oldSize != IntBooleanHashMap.this.size();
        }

        public boolean removeAll(BooleanIterable source) {
            int oldSize = IntBooleanHashMap.this.size();
            BooleanIterator iterator = source.booleanIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != IntBooleanHashMap.this.size();
        }

        public boolean removeAll(boolean ... source) {
            int oldSize = IntBooleanHashMap.this.size();
            for (boolean item : source) {
                this.remove(item);
            }
            return oldSize != IntBooleanHashMap.this.size();
        }

        public int size() {
            return IntBooleanHashMap.this.size();
        }

        public boolean[] toArray() {
            return IntBooleanHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableIntSet {
        private KeySet() {
        }

        public IntIterator intIterator() {
            return new KeySetIterator();
        }

        public void forEach(IntProcedure procedure) {
            IntBooleanHashMap.this.forEachKey(procedure);
        }

        public int count(IntPredicate predicate) {
            int count = 0;
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    ++count;
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    ++count;
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(IntPredicate predicate) {
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return true;
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return true;
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(IntPredicate predicate) {
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0)) {
                    return false;
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1)) {
                    return false;
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(IntPredicate predicate) {
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return false;
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return false;
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(int element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(IntIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(int key) {
            int oldSize = IntBooleanHashMap.this.size();
            IntBooleanHashMap.this.removeKey(key);
            return oldSize != IntBooleanHashMap.this.size();
        }

        public boolean removeAll(IntIterable source) {
            int oldSize = IntBooleanHashMap.this.size();
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                IntBooleanHashMap.this.removeKey(iterator.next());
            }
            return oldSize != IntBooleanHashMap.this.size();
        }

        public boolean removeAll(int ... source) {
            int oldSize = IntBooleanHashMap.this.size();
            for (int item : source) {
                IntBooleanHashMap.this.removeKey(item);
            }
            return oldSize != IntBooleanHashMap.this.size();
        }

        public void clear() {
            IntBooleanHashMap.this.clear();
        }

        public MutableIntSet select(IntPredicate predicate) {
            IntHashSet result = new IntHashSet();
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    result.add(0);
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    result.add(1);
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableIntSet reject(IntPredicate predicate) {
            IntHashSet result = new IntHashSet();
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0)) {
                    result.add(0);
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1)) {
                    result.add(1);
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableIntSet with(int element) {
            throw new UnsupportedOperationException();
        }

        public MutableIntSet without(int element) {
            throw new UnsupportedOperationException();
        }

        public MutableIntSet withAll(IntIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableIntSet withoutAll(IntIterable elements) {
            throw new UnsupportedOperationException();
        }

        public int detectIfNone(IntPredicate predicate, int ifNone) {
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return 0;
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return 1;
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(IntToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0));
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1));
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableIntSet asUnmodifiable() {
            return UnmodifiableIntSet.of(this);
        }

        public MutableIntSet asSynchronized() {
            return SynchronizedIntSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key)) continue;
                sum += (long)key;
            }
            return sum;
        }

        public int max() {
            if (IntBooleanHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            int max = 0;
            boolean isMaxSet = false;
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0;
                    isMaxSet = true;
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < 1)) {
                    max = 1;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < IntBooleanHashMap.this.keys.length; ++i) {
                if (!IntBooleanHashMap.isNonSentinel(IntBooleanHashMap.this.keys[i]) || isMaxSet && max >= IntBooleanHashMap.this.keys[i]) continue;
                max = IntBooleanHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public int maxIfEmpty(int defaultValue) {
            if (IntBooleanHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public int min() {
            if (IntBooleanHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            int min = 0;
            boolean isMinSet = false;
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0;
                    isMinSet = true;
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey && (!isMinSet || 1 < min)) {
                    min = 1;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < IntBooleanHashMap.this.keys.length; ++i) {
                if (!IntBooleanHashMap.isNonSentinel(IntBooleanHashMap.this.keys[i]) || isMinSet && IntBooleanHashMap.this.keys[i] >= min) continue;
                min = IntBooleanHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public int minIfEmpty(int defaultValue) {
            if (IntBooleanHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            int[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                int first = sortedArray[middleIndex];
                int second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public int[] toSortedArray() {
            int[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableIntList toSortedList() {
            return IntArrayList.newList((IntIterable)this).sortThis();
        }

        public int[] toArray() {
            int size = IntBooleanHashMap.this.size();
            final int[] result = new int[size];
            IntBooleanHashMap.this.forEachKey(new IntProcedure(){
                private int index;

                public void value(int each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(int value) {
            return IntBooleanHashMap.this.containsKey(value);
        }

        public boolean containsAll(int ... source) {
            for (int item : source) {
                if (IntBooleanHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(IntIterable source) {
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                if (IntBooleanHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableIntList toList() {
            return IntArrayList.newList((IntIterable)this);
        }

        public MutableIntSet toSet() {
            return IntHashSet.newSet((IntIterable)this);
        }

        public MutableIntBag toBag() {
            return IntHashBag.newBag((IntIterable)this);
        }

        public LazyIntIterable asLazy() {
            return new LazyIntIterableAdapter((IntIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0);
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1);
                }
            }
            for (int i = 0; i < IntBooleanHashMap.this.keys.length; ++i) {
                if (!IntBooleanHashMap.isNonSentinel(IntBooleanHashMap.this.keys[i])) continue;
                result = function.valueOf(result, IntBooleanHashMap.this.keys[i]);
            }
            return result;
        }

        public IntSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableIntSet toImmutable() {
            return IntSets.immutable.withAll((IntIterable)this);
        }

        public int size() {
            return IntBooleanHashMap.this.size();
        }

        public boolean isEmpty() {
            return IntBooleanHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return IntBooleanHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IntSet)) {
                return false;
            }
            IntSet other = (IntSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < IntBooleanHashMap.this.keys.length; ++i) {
                if (!IntBooleanHashMap.isNonSentinel(IntBooleanHashMap.this.keys[i])) continue;
                result += IntBooleanHashMap.this.keys[i];
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (IntBooleanHashMap.this.sentinelValues != null) {
                    if (IntBooleanHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (IntBooleanHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (int key : IntBooleanHashMap.this.keys) {
                    if (!IntBooleanHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyIntIterable {
        private KeysView() {
        }

        public boolean isEmpty() {
            return IntBooleanHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return IntBooleanHashMap.this.notEmpty();
        }

        public int size() {
            return IntBooleanHashMap.this.size();
        }

        public boolean contains(int key) {
            return IntBooleanHashMap.this.containsKey(key);
        }

        public boolean containsAll(int ... keys) {
            for (int key : keys) {
                if (IntBooleanHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(IntIterable source) {
            return source.allSatisfy(new IntPredicate(){

                public boolean accept(int key) {
                    return IntBooleanHashMap.this.containsKey(key);
                }
            });
        }

        public IntIterator intIterator() {
            return new KeySetIterator();
        }

        public void forEach(IntProcedure procedure) {
            IntBooleanHashMap.this.forEachKey(procedure);
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (IntBooleanHashMap.this.sentinelValues != null) {
                    if (IntBooleanHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (IntBooleanHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (int key : IntBooleanHashMap.this.keys) {
                    if (!IntBooleanHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public int count(IntPredicate predicate) {
            int count = 0;
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    ++count;
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    ++count;
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(IntPredicate predicate) {
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return true;
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return true;
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(IntPredicate predicate) {
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0)) {
                    return false;
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1)) {
                    return false;
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(IntPredicate predicate) {
            return !this.anySatisfy(predicate);
        }

        public LazyIntIterable select(IntPredicate predicate) {
            return new SelectIntIterable((IntIterable)this, predicate);
        }

        public LazyIntIterable reject(IntPredicate predicate) {
            return new SelectIntIterable((IntIterable)this, IntPredicates.not(predicate));
        }

        public int detectIfNone(IntPredicate predicate, int value) {
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return 0;
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return 1;
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(IntToObjectFunction<? extends V> function) {
            return new CollectIntToObjectIterable<V>((IntIterable)this, function);
        }

        public long sum() {
            long result = 0L;
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0L;
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key)) continue;
                result += (long)key;
            }
            return result;
        }

        public int max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            IntIterator iterator = this.intIterator();
            int max = iterator.next();
            while (iterator.hasNext()) {
                int value = iterator.next();
                if (max >= value) continue;
                max = value;
            }
            return max;
        }

        public int min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            IntIterator iterator = this.intIterator();
            int min = iterator.next();
            while (iterator.hasNext()) {
                int value = iterator.next();
                if (value >= min) continue;
                min = value;
            }
            return min;
        }

        public int minIfEmpty(int defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public int maxIfEmpty(int defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            int[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                int first = sortedArray[middleIndex];
                int second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public int[] toSortedArray() {
            int[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public int[] toArray() {
            int size = IntBooleanHashMap.this.size();
            final int[] result = new int[size];
            IntBooleanHashMap.this.forEachKey(new IntProcedure(){
                private int index;

                public void value(int each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0);
                }
                if (IntBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1);
                }
            }
            for (int i = 0; i < IntBooleanHashMap.this.keys.length; ++i) {
                if (!IntBooleanHashMap.isNonSentinel(IntBooleanHashMap.this.keys[i])) continue;
                result = function.valueOf(result, IntBooleanHashMap.this.keys[i]);
            }
            return result;
        }

        public MutableIntList toList() {
            return IntArrayList.newList((IntIterable)this);
        }

        public MutableIntList toSortedList() {
            return IntArrayList.newList((IntIterable)this).sortThis();
        }

        public MutableIntSet toSet() {
            return IntHashSet.newSet((IntIterable)this);
        }

        public MutableIntBag toBag() {
            return IntHashBag.newBag((IntIterable)this);
        }

        public LazyIntIterable asLazy() {
            return this;
        }
    }

    private class InternalBooleanIterator
    implements BooleanIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalBooleanIterator() {
        }

        public boolean hasNext() {
            return this.count < IntBooleanHashMap.this.size();
        }

        public boolean next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntBooleanHashMap.this.containsKey(0)) {
                    return IntBooleanHashMap.this.sentinelValues.zeroValue;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntBooleanHashMap.this.containsKey(1)) {
                    return IntBooleanHashMap.this.sentinelValues.oneValue;
                }
            }
            int[] keys = IntBooleanHashMap.this.keys;
            while (!IntBooleanHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            boolean result = IntBooleanHashMap.this.values.get(this.position);
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private boolean zeroValue;
        private boolean oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(boolean value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

