/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction0;
import com.gs.collections.api.block.function.primitive.CharToCharFunction;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.IntToCharFunction;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.predicate.primitive.IntCharPredicate;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.IntCharProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.ImmutableIntCharMap;
import com.gs.collections.api.map.primitive.IntCharMap;
import com.gs.collections.api.map.primitive.MutableIntCharMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableIntSet;
import com.gs.collections.api.set.primitive.IntSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.block.factory.primitive.IntPredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedCharCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.factory.primitive.IntCharMaps;
import com.gs.collections.impl.factory.primitive.IntSets;
import com.gs.collections.impl.lazy.primitive.CollectIntToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectIntIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedIntCharMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableIntCharMap;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedIntSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntCharHashMap
implements MutableIntCharMap,
Externalizable {
    static final char EMPTY_VALUE = '\u0000';
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_KEY = 0;
    private static final int REMOVED_KEY = 1;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private int[] keys;
    private char[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public IntCharHashMap() {
        this.allocateTable(16);
    }

    public IntCharHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public IntCharHashMap(IntCharMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static IntCharHashMap newWithKeysValues(int key1, char value1) {
        return new IntCharHashMap(1).withKeyValue(key1, value1);
    }

    public static IntCharHashMap newWithKeysValues(int key1, char value1, int key2, char value2) {
        return new IntCharHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static IntCharHashMap newWithKeysValues(int key1, char value1, int key2, char value2, int key3, char value3) {
        return new IntCharHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static IntCharHashMap newWithKeysValues(int key1, char value1, int key2, char value2, int key3, char value3, int key4, char value4) {
        return new IntCharHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntCharMap)) {
            return false;
        }
        IntCharMap other = (IntCharMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0) || other.containsKey(1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0) || this.sentinelValues.zeroValue != other.getOrThrow(0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1) || this.sentinelValues.oneValue != other.getOrThrow(1))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            if (!IntCharHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += '\u0000' ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += '\u0001' ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntCharHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ this.values[i];
        }
        return result;
    }

    public String toString() {
        return this.makeString("{", ", ", "}");
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(0)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                int key = this.keys[i];
                if (!IntCharHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CharIterator charIterator() {
        return new InternalCharIterator();
    }

    public char[] toArray() {
        char[] array = new char[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntCharHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(char value) {
        return this.containsValue(value);
    }

    public boolean containsAll(char ... source) {
        for (char each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(CharIterable source) {
        return source.allSatisfy(new CharPredicate(){

            public boolean accept(char value) {
                return IntCharHashMap.this.contains(value);
            }
        });
    }

    public void forEach(CharProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableCharCollection select(CharPredicate predicate) {
        CharArrayList result = new CharArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableCharCollection reject(CharPredicate predicate) {
        CharArrayList result = new CharArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntCharHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntCharHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public char detectIfNone(CharPredicate predicate, char value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(CharPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(CharPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(CharPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntCharHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectCharToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntCharHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableCharList toList() {
        return CharArrayList.newList((CharIterable)this);
    }

    public MutableCharSet toSet() {
        return CharHashSet.newSet((CharIterable)this);
    }

    public MutableCharBag toBag() {
        return CharHashBag.newBag((CharIterable)this);
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, '\u0000');
    }

    public void put(int key, char value) {
        if (IntCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (IntCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = value;
            return;
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public void putAll(IntCharMap map) {
        map.forEachKeyValue(new IntCharProcedure(){

            public void value(int key, char value) {
                IntCharHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(int key) {
        if (IntCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = '\u0000';
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (IntCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = '\u0000';
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            this.values[index] = '\u0000';
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(int key) {
        this.removeKey(key);
    }

    public char removeKeyIfAbsent(int key, char value) {
        if (IntCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            char oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = '\u0000';
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (IntCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            char oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = '\u0000';
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            char oldValue = this.values[index];
            this.values[index] = '\u0000';
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public char getIfAbsentPut(int key, char value) {
        if (IntCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (IntCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public char getIfAbsentPut(int key, CharFunction0 function) {
        char value;
        if (IntCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value2 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value3 = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (IntCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value4 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value5 = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.value();
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public <P> char getIfAbsentPutWith(int key, CharFunction<? super P> function, P parameter) {
        char value;
        if (IntCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value2 = function.charValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value3 = function.charValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (IntCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value4 = function.charValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value5 = function.charValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.charValueOf(parameter);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public char getIfAbsentPutWithKey(int key, IntToCharFunction function) {
        char value;
        if (IntCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value2 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value3 = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (IntCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value4 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value5 = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(key);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public char updateValue(int key, char initialValueIfAbsent, CharToCharFunction function) {
        char value;
        if (IntCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(initialValueIfAbsent);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public IntCharHashMap withKeyValue(int key1, char value1) {
        this.put(key1, value1);
        return this;
    }

    public IntCharHashMap withKeysValues(int key1, char value1, int key2, char value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public IntCharHashMap withKeysValues(int key1, char value1, int key2, char value2, int key3, char value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public IntCharHashMap withKeysValues(int key1, char value1, int key2, char value2, int key3, char value3, int key4, char value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public IntCharHashMap withoutKey(int key) {
        this.removeKey(key);
        return this;
    }

    public IntCharHashMap withoutAllKeys(IntIterable keys) {
        keys.forEach(new IntProcedure(){

            public void value(int key) {
                IntCharHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableIntCharMap asUnmodifiable() {
        return new UnmodifiableIntCharMap(this);
    }

    public MutableIntCharMap asSynchronized() {
        return new SynchronizedIntCharMap(this);
    }

    public ImmutableIntCharMap toImmutable() {
        return IntCharMaps.immutable.ofAll((IntCharMap)this);
    }

    public char get(int key) {
        return this.getIfAbsent(key, '\u0000');
    }

    public char getIfAbsent(int key, char ifAbsent) {
        if (IntCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public char getOrThrow(int key) {
        if (IntCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (IntCharHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(int key) {
        if (IntCharHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (IntCharHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(char value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!IntCharHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(CharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntCharHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(IntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1);
            }
        }
        for (int key : this.keys) {
            if (!IntCharHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(IntCharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntCharHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyIntIterable keysView() {
        return new KeysView();
    }

    public IntCharHashMap select(IntCharPredicate predicate) {
        IntCharHashMap result = new IntCharHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0, this.sentinelValues.zeroValue)) {
                result.put(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1, this.sentinelValues.oneValue)) {
                result.put(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public IntCharHashMap reject(IntCharPredicate predicate) {
        IntCharHashMap result = new IntCharHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0, this.sentinelValues.zeroValue)) {
                result.put(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1, this.sentinelValues.oneValue)) {
                result.put(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntCharHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (long)this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (long)this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntCharHashMap.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    public char max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        CharIterator iterator = this.charIterator();
        char max = iterator.next();
        while (iterator.hasNext()) {
            char value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public char maxIfEmpty(char defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public char min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        CharIterator iterator = this.charIterator();
        char min = iterator.next();
        while (iterator.hasNext()) {
            char value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public char minIfEmpty(char defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        char[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            char first = sortedArray[middleIndex];
            char second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public char[] toSortedArray() {
        char[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableCharList toSortedList() {
        return CharArrayList.newList((CharIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeInt(0);
                out.writeChar(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeInt(1);
                out.writeChar(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntCharHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeInt(this.keys[i]);
            out.writeChar(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readInt(), in.readChar());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        int[] old = this.keys;
        char[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!IntCharHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(int element) {
        int index = this.spread(element);
        int keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(int element) {
        int code = element;
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new int[sizeToAllocate];
        this.values = new char[sizeToAllocate];
    }

    private static boolean isEmptyKey(int key) {
        return key == 0;
    }

    private static boolean isRemovedKey(int key) {
        return key == 1;
    }

    private static boolean isNonSentinel(int key) {
        return !IntCharHashMap.isEmptyKey(key) && !IntCharHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableIntSet keySet() {
        return new KeySet();
    }

    public MutableCharCollection values() {
        return new ValuesCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableCharCollection {
        private ValuesCollection() {
        }

        public void clear() {
            IntCharHashMap.this.clear();
        }

        public MutableCharCollection select(CharPredicate predicate) {
            return IntCharHashMap.this.select(predicate);
        }

        public MutableCharCollection reject(CharPredicate predicate) {
            return IntCharHashMap.this.reject(predicate);
        }

        public char detectIfNone(CharPredicate predicate, char ifNone) {
            return IntCharHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
            return IntCharHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
            return IntCharHashMap.this.injectInto(injectedValue, function);
        }

        public long sum() {
            return IntCharHashMap.this.sum();
        }

        public char max() {
            return IntCharHashMap.this.max();
        }

        public char maxIfEmpty(char defaultValue) {
            return IntCharHashMap.this.maxIfEmpty(defaultValue);
        }

        public char min() {
            return IntCharHashMap.this.min();
        }

        public char minIfEmpty(char defaultValue) {
            return IntCharHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return IntCharHashMap.this.average();
        }

        public double median() {
            return IntCharHashMap.this.median();
        }

        public char[] toSortedArray() {
            return IntCharHashMap.this.toSortedArray();
        }

        public MutableCharList toSortedList() {
            return IntCharHashMap.this.toSortedList();
        }

        public MutableCharCollection with(char element) {
            throw new UnsupportedOperationException();
        }

        public MutableCharCollection without(char element) {
            throw new UnsupportedOperationException();
        }

        public MutableCharCollection withAll(CharIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableCharCollection withoutAll(CharIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableCharCollection asUnmodifiable() {
            return UnmodifiableCharCollection.of(this);
        }

        public MutableCharCollection asSynchronized() {
            return SynchronizedCharCollection.of(this);
        }

        public ImmutableCharCollection toImmutable() {
            return CharLists.immutable.withAll((CharIterable)this);
        }

        public boolean contains(char value) {
            return IntCharHashMap.this.containsValue(value);
        }

        public boolean containsAll(char ... source) {
            return IntCharHashMap.this.containsAll(source);
        }

        public boolean containsAll(CharIterable source) {
            return IntCharHashMap.this.containsAll(source);
        }

        public MutableCharList toList() {
            return IntCharHashMap.this.toList();
        }

        public MutableCharSet toSet() {
            return IntCharHashMap.this.toSet();
        }

        public MutableCharBag toBag() {
            return IntCharHashMap.this.toBag();
        }

        public LazyCharIterable asLazy() {
            return new LazyCharIterableAdapter((CharIterable)this);
        }

        public boolean isEmpty() {
            return IntCharHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return IntCharHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (IntCharHashMap.this.sentinelValues != null) {
                    if (IntCharHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(IntCharHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (IntCharHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(IntCharHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < IntCharHashMap.this.keys.length; ++i) {
                    int key = IntCharHashMap.this.keys[i];
                    if (!IntCharHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(IntCharHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public CharIterator charIterator() {
            return IntCharHashMap.this.charIterator();
        }

        public void forEach(CharProcedure procedure) {
            IntCharHashMap.this.forEach(procedure);
        }

        public int count(CharPredicate predicate) {
            return IntCharHashMap.this.count(predicate);
        }

        public boolean anySatisfy(CharPredicate predicate) {
            return IntCharHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(CharPredicate predicate) {
            return IntCharHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(CharPredicate predicate) {
            return IntCharHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(char element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(char ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(CharIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(char item) {
            int oldSize = IntCharHashMap.this.size();
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey && item == IntCharHashMap.this.sentinelValues.zeroValue) {
                    IntCharHashMap.this.removeKey(0);
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey && item == IntCharHashMap.this.sentinelValues.oneValue) {
                    IntCharHashMap.this.removeKey(1);
                }
            }
            for (int i = 0; i < IntCharHashMap.this.keys.length; ++i) {
                if (!IntCharHashMap.isNonSentinel(IntCharHashMap.this.keys[i]) || item != IntCharHashMap.this.values[i]) continue;
                IntCharHashMap.this.removeKey(IntCharHashMap.this.keys[i]);
            }
            return oldSize != IntCharHashMap.this.size();
        }

        public boolean removeAll(CharIterable source) {
            int oldSize = IntCharHashMap.this.size();
            CharIterator iterator = source.charIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != IntCharHashMap.this.size();
        }

        public boolean removeAll(char ... source) {
            int oldSize = IntCharHashMap.this.size();
            for (char item : source) {
                this.remove(item);
            }
            return oldSize != IntCharHashMap.this.size();
        }

        public int size() {
            return IntCharHashMap.this.size();
        }

        public char[] toArray() {
            return IntCharHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableIntSet {
        private KeySet() {
        }

        public IntIterator intIterator() {
            return new KeySetIterator();
        }

        public void forEach(IntProcedure procedure) {
            IntCharHashMap.this.forEachKey(procedure);
        }

        public int count(IntPredicate predicate) {
            int count = 0;
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    ++count;
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    ++count;
                }
            }
            for (int key : IntCharHashMap.this.keys) {
                if (!IntCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(IntPredicate predicate) {
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return true;
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return true;
                }
            }
            for (int key : IntCharHashMap.this.keys) {
                if (!IntCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(IntPredicate predicate) {
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0)) {
                    return false;
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1)) {
                    return false;
                }
            }
            for (int key : IntCharHashMap.this.keys) {
                if (!IntCharHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(IntPredicate predicate) {
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return false;
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return false;
                }
            }
            for (int key : IntCharHashMap.this.keys) {
                if (!IntCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(int element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(IntIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(int key) {
            int oldSize = IntCharHashMap.this.size();
            IntCharHashMap.this.removeKey(key);
            return oldSize != IntCharHashMap.this.size();
        }

        public boolean removeAll(IntIterable source) {
            int oldSize = IntCharHashMap.this.size();
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                IntCharHashMap.this.removeKey(iterator.next());
            }
            return oldSize != IntCharHashMap.this.size();
        }

        public boolean removeAll(int ... source) {
            int oldSize = IntCharHashMap.this.size();
            for (int item : source) {
                IntCharHashMap.this.removeKey(item);
            }
            return oldSize != IntCharHashMap.this.size();
        }

        public void clear() {
            IntCharHashMap.this.clear();
        }

        public MutableIntSet select(IntPredicate predicate) {
            IntHashSet result = new IntHashSet();
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    result.add(0);
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    result.add(1);
                }
            }
            for (int key : IntCharHashMap.this.keys) {
                if (!IntCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableIntSet reject(IntPredicate predicate) {
            IntHashSet result = new IntHashSet();
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0)) {
                    result.add(0);
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1)) {
                    result.add(1);
                }
            }
            for (int key : IntCharHashMap.this.keys) {
                if (!IntCharHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableIntSet with(int element) {
            throw new UnsupportedOperationException();
        }

        public MutableIntSet without(int element) {
            throw new UnsupportedOperationException();
        }

        public MutableIntSet withAll(IntIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableIntSet withoutAll(IntIterable elements) {
            throw new UnsupportedOperationException();
        }

        public int detectIfNone(IntPredicate predicate, int ifNone) {
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return 0;
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return 1;
                }
            }
            for (int key : IntCharHashMap.this.keys) {
                if (!IntCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(IntToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0));
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1));
                }
            }
            for (int key : IntCharHashMap.this.keys) {
                if (!IntCharHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableIntSet asUnmodifiable() {
            return UnmodifiableIntSet.of(this);
        }

        public MutableIntSet asSynchronized() {
            return SynchronizedIntSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (int key : IntCharHashMap.this.keys) {
                if (!IntCharHashMap.isNonSentinel(key)) continue;
                sum += (long)key;
            }
            return sum;
        }

        public int max() {
            if (IntCharHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            int max = 0;
            boolean isMaxSet = false;
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0;
                    isMaxSet = true;
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < 1)) {
                    max = 1;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < IntCharHashMap.this.keys.length; ++i) {
                if (!IntCharHashMap.isNonSentinel(IntCharHashMap.this.keys[i]) || isMaxSet && max >= IntCharHashMap.this.keys[i]) continue;
                max = IntCharHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public int maxIfEmpty(int defaultValue) {
            if (IntCharHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public int min() {
            if (IntCharHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            int min = 0;
            boolean isMinSet = false;
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0;
                    isMinSet = true;
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey && (!isMinSet || 1 < min)) {
                    min = 1;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < IntCharHashMap.this.keys.length; ++i) {
                if (!IntCharHashMap.isNonSentinel(IntCharHashMap.this.keys[i]) || isMinSet && IntCharHashMap.this.keys[i] >= min) continue;
                min = IntCharHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public int minIfEmpty(int defaultValue) {
            if (IntCharHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            int[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                int first = sortedArray[middleIndex];
                int second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public int[] toSortedArray() {
            int[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableIntList toSortedList() {
            return IntArrayList.newList((IntIterable)this).sortThis();
        }

        public int[] toArray() {
            int size = IntCharHashMap.this.size();
            final int[] result = new int[size];
            IntCharHashMap.this.forEachKey(new IntProcedure(){
                private int index;

                public void value(int each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(int value) {
            return IntCharHashMap.this.containsKey(value);
        }

        public boolean containsAll(int ... source) {
            for (int item : source) {
                if (IntCharHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(IntIterable source) {
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                if (IntCharHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableIntList toList() {
            return IntArrayList.newList((IntIterable)this);
        }

        public MutableIntSet toSet() {
            return IntHashSet.newSet((IntIterable)this);
        }

        public MutableIntBag toBag() {
            return IntHashBag.newBag((IntIterable)this);
        }

        public LazyIntIterable asLazy() {
            return new LazyIntIterableAdapter((IntIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0);
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1);
                }
            }
            for (int i = 0; i < IntCharHashMap.this.keys.length; ++i) {
                if (!IntCharHashMap.isNonSentinel(IntCharHashMap.this.keys[i])) continue;
                result = function.valueOf(result, IntCharHashMap.this.keys[i]);
            }
            return result;
        }

        public IntSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableIntSet toImmutable() {
            return IntSets.immutable.withAll((IntIterable)this);
        }

        public int size() {
            return IntCharHashMap.this.size();
        }

        public boolean isEmpty() {
            return IntCharHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return IntCharHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IntSet)) {
                return false;
            }
            IntSet other = (IntSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < IntCharHashMap.this.keys.length; ++i) {
                if (!IntCharHashMap.isNonSentinel(IntCharHashMap.this.keys[i])) continue;
                result += IntCharHashMap.this.keys[i];
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (IntCharHashMap.this.sentinelValues != null) {
                    if (IntCharHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (IntCharHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (int key : IntCharHashMap.this.keys) {
                    if (!IntCharHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements IntIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < IntCharHashMap.this.size();
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntCharHashMap.this.containsKey(0)) {
                    return 0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntCharHashMap.this.containsKey(1)) {
                    return 1;
                }
            }
            int[] keys = IntCharHashMap.this.keys;
            while (!IntCharHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            int result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyIntIterable {
        private KeysView() {
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public int size() {
            return IntCharHashMap.this.size();
        }

        public boolean isEmpty() {
            return IntCharHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return IntCharHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (IntCharHashMap.this.sentinelValues != null) {
                    if (IntCharHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (IntCharHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (int key : IntCharHashMap.this.keys) {
                    if (!IntCharHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public IntIterator intIterator() {
            return new KeySetIterator();
        }

        public boolean contains(int key) {
            return IntCharHashMap.this.containsKey(key);
        }

        public boolean containsAll(int ... keys) {
            for (int key : keys) {
                if (IntCharHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(IntIterable source) {
            return source.allSatisfy(new IntPredicate(){

                public boolean accept(int key) {
                    return IntCharHashMap.this.containsKey(key);
                }
            });
        }

        public void forEach(IntProcedure procedure) {
            IntCharHashMap.this.forEachKey(procedure);
        }

        public int count(IntPredicate predicate) {
            int count = 0;
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    ++count;
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    ++count;
                }
            }
            for (int key : IntCharHashMap.this.keys) {
                if (!IntCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(IntPredicate predicate) {
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return true;
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return true;
                }
            }
            for (int key : IntCharHashMap.this.keys) {
                if (!IntCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(IntPredicate predicate) {
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0)) {
                    return false;
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1)) {
                    return false;
                }
            }
            for (int key : IntCharHashMap.this.keys) {
                if (!IntCharHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(IntPredicate predicate) {
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return false;
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return false;
                }
            }
            for (int key : IntCharHashMap.this.keys) {
                if (!IntCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public LazyIntIterable select(IntPredicate predicate) {
            return new SelectIntIterable((IntIterable)this, predicate);
        }

        public LazyIntIterable reject(IntPredicate predicate) {
            return new SelectIntIterable((IntIterable)this, IntPredicates.not(predicate));
        }

        public int detectIfNone(IntPredicate predicate, int value) {
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return 0;
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return 1;
                }
            }
            for (int key : IntCharHashMap.this.keys) {
                if (!IntCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(IntToObjectFunction<? extends V> function) {
            return new CollectIntToObjectIterable<V>((IntIterable)this, function);
        }

        public long sum() {
            long result = 0L;
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0L;
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int key : IntCharHashMap.this.keys) {
                if (!IntCharHashMap.isNonSentinel(key)) continue;
                result += (long)key;
            }
            return result;
        }

        public int max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            IntIterator iterator = this.intIterator();
            int max = iterator.next();
            while (iterator.hasNext()) {
                int value = iterator.next();
                if (max >= value) continue;
                max = value;
            }
            return max;
        }

        public int min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            IntIterator iterator = this.intIterator();
            int min = iterator.next();
            while (iterator.hasNext()) {
                int value = iterator.next();
                if (value >= min) continue;
                min = value;
            }
            return min;
        }

        public int minIfEmpty(int defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public int maxIfEmpty(int defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            int[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                int first = sortedArray[middleIndex];
                int second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public int[] toSortedArray() {
            int[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public int[] toArray() {
            int size = IntCharHashMap.this.size();
            final int[] result = new int[size];
            IntCharHashMap.this.forEachKey(new IntProcedure(){
                private int index;

                public void value(int each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (IntCharHashMap.this.sentinelValues != null) {
                if (IntCharHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0);
                }
                if (IntCharHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1);
                }
            }
            for (int i = 0; i < IntCharHashMap.this.keys.length; ++i) {
                if (!IntCharHashMap.isNonSentinel(IntCharHashMap.this.keys[i])) continue;
                result = function.valueOf(result, IntCharHashMap.this.keys[i]);
            }
            return result;
        }

        public MutableIntList toList() {
            return IntArrayList.newList((IntIterable)this);
        }

        public MutableIntList toSortedList() {
            return IntArrayList.newList((IntIterable)this).sortThis();
        }

        public MutableIntSet toSet() {
            return IntHashSet.newSet((IntIterable)this);
        }

        public MutableIntBag toBag() {
            return IntHashBag.newBag((IntIterable)this);
        }

        public LazyIntIterable asLazy() {
            return this;
        }
    }

    private class InternalCharIterator
    implements CharIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalCharIterator() {
        }

        public boolean hasNext() {
            return this.count < IntCharHashMap.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntCharHashMap.this.containsKey(0)) {
                    return IntCharHashMap.this.get(0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntCharHashMap.this.containsKey(1)) {
                    return IntCharHashMap.this.get(1);
                }
            }
            int[] keys = IntCharHashMap.this.keys;
            while (!IntCharHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            char result = IntCharHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private char zeroValue;
        private char oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(char value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

