/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction0;
import com.gs.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.IntToDoubleFunction;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.predicate.primitive.IntDoublePredicate;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.IntDoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.ImmutableIntDoubleMap;
import com.gs.collections.api.map.primitive.IntDoubleMap;
import com.gs.collections.api.map.primitive.MutableIntDoubleMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableIntSet;
import com.gs.collections.api.set.primitive.IntSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.block.factory.primitive.IntPredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedDoubleCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.factory.primitive.IntDoubleMaps;
import com.gs.collections.impl.factory.primitive.IntSets;
import com.gs.collections.impl.lazy.primitive.CollectIntToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectIntIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedIntDoubleMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableIntDoubleMap;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedIntSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntDoubleHashMap
implements MutableIntDoubleMap,
Externalizable {
    static final double EMPTY_VALUE = 0.0;
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_KEY = 0;
    private static final int REMOVED_KEY = 1;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private int[] keys;
    private double[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public IntDoubleHashMap() {
        this.allocateTable(16);
    }

    public IntDoubleHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public IntDoubleHashMap(IntDoubleMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static IntDoubleHashMap newWithKeysValues(int key1, double value1) {
        return new IntDoubleHashMap(1).withKeyValue(key1, value1);
    }

    public static IntDoubleHashMap newWithKeysValues(int key1, double value1, int key2, double value2) {
        return new IntDoubleHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static IntDoubleHashMap newWithKeysValues(int key1, double value1, int key2, double value2, int key3, double value3) {
        return new IntDoubleHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static IntDoubleHashMap newWithKeysValues(int key1, double value1, int key2, double value2, int key3, double value3, int key4, double value4) {
        return new IntDoubleHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntDoubleMap)) {
            return false;
        }
        IntDoubleMap other = (IntDoubleMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0) || other.containsKey(1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0) || Double.compare(this.sentinelValues.zeroValue, other.getOrThrow(0)) != 0)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1) || Double.compare(this.sentinelValues.oneValue, other.getOrThrow(1)) != 0)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            if (!IntDoubleHashMap.isNonSentinel(key) || other.containsKey(key) && Double.compare(this.values[i], other.getOrThrow(key)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ (int)(Double.doubleToLongBits(this.sentinelValues.zeroValue) ^ Double.doubleToLongBits(this.sentinelValues.zeroValue) >>> 32);
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ (int)(Double.doubleToLongBits(this.sentinelValues.oneValue) ^ Double.doubleToLongBits(this.sentinelValues.oneValue) >>> 32);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ (int)(Double.doubleToLongBits(this.values[i]) ^ Double.doubleToLongBits(this.values[i]) >>> 32);
        }
        return result;
    }

    public String toString() {
        return this.makeString("{", ", ", "}");
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(0)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                int key = this.keys[i];
                if (!IntDoubleHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DoubleIterator doubleIterator() {
        return new InternalDoubleIterator();
    }

    public double[] toArray() {
        double[] array = new double[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(double value) {
        return this.containsValue(value);
    }

    public boolean containsAll(double ... source) {
        for (double each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(DoubleIterable source) {
        return source.allSatisfy(new DoublePredicate(){

            public boolean accept(double value) {
                return IntDoubleHashMap.this.contains(value);
            }
        });
    }

    public void forEach(DoubleProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableDoubleCollection select(DoublePredicate predicate) {
        DoubleArrayList result = new DoubleArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableDoubleCollection reject(DoublePredicate predicate) {
        DoubleArrayList result = new DoubleArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public double detectIfNone(DoublePredicate predicate, double value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(DoublePredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectDoubleToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableDoubleList toList() {
        return DoubleArrayList.newList((DoubleIterable)this);
    }

    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSet((DoubleIterable)this);
    }

    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBag((DoubleIterable)this);
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, 0.0);
    }

    public void put(int key, double value) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = value;
            return;
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public void putAll(IntDoubleMap map) {
        map.forEachKeyValue(new IntDoubleProcedure(){

            public void value(int key, double value) {
                IntDoubleHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(int key) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0.0;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0.0;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            this.values[index] = 0.0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(int key) {
        this.removeKey(key);
    }

    public double removeKeyIfAbsent(int key, double value) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            double oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0.0;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            double oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0.0;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            double oldValue = this.values[index];
            this.values[index] = 0.0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public double getIfAbsentPut(int key, double value) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public double getIfAbsentPut(int key, DoubleFunction0 function) {
        double value;
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value2 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value3 = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value4 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value5 = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.value();
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public <P> double getIfAbsentPutWith(int key, DoubleFunction<? super P> function, P parameter) {
        double value;
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value2 = function.doubleValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value3 = function.doubleValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value4 = function.doubleValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value5 = function.doubleValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.doubleValueOf(parameter);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public double getIfAbsentPutWithKey(int key, IntToDoubleFunction function) {
        double value;
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value2 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value3 = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value4 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value5 = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(key);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public double updateValue(int key, double initialValueIfAbsent, DoubleToDoubleFunction function) {
        double value;
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(initialValueIfAbsent);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public IntDoubleHashMap withKeyValue(int key1, double value1) {
        this.put(key1, value1);
        return this;
    }

    public IntDoubleHashMap withKeysValues(int key1, double value1, int key2, double value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public IntDoubleHashMap withKeysValues(int key1, double value1, int key2, double value2, int key3, double value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public IntDoubleHashMap withKeysValues(int key1, double value1, int key2, double value2, int key3, double value3, int key4, double value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public IntDoubleHashMap withoutKey(int key) {
        this.removeKey(key);
        return this;
    }

    public IntDoubleHashMap withoutAllKeys(IntIterable keys) {
        keys.forEach(new IntProcedure(){

            public void value(int key) {
                IntDoubleHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableIntDoubleMap asUnmodifiable() {
        return new UnmodifiableIntDoubleMap(this);
    }

    public MutableIntDoubleMap asSynchronized() {
        return new SynchronizedIntDoubleMap(this);
    }

    public ImmutableIntDoubleMap toImmutable() {
        return IntDoubleMaps.immutable.ofAll((IntDoubleMap)this);
    }

    public double get(int key) {
        return this.getIfAbsent(key, 0.0);
    }

    public double getIfAbsent(int key, double ifAbsent) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public double getOrThrow(int key) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (IntDoubleHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(int key) {
        if (IntDoubleHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (IntDoubleHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(double value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i]) || Double.compare(this.values[i], value) != 0) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(DoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(IntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1);
            }
        }
        for (int key : this.keys) {
            if (!IntDoubleHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(IntDoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyIntIterable keysView() {
        return new KeysView();
    }

    public IntDoubleHashMap select(IntDoublePredicate predicate) {
        IntDoubleHashMap result = new IntDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0, this.sentinelValues.zeroValue)) {
                result.put(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1, this.sentinelValues.oneValue)) {
                result.put(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public IntDoubleHashMap reject(IntDoublePredicate predicate) {
        IntDoubleHashMap result = new IntDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0, this.sentinelValues.zeroValue)) {
                result.put(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1, this.sentinelValues.oneValue)) {
                result.put(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public double sum() {
        double result = 0.0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.values[i];
        }
        return result;
    }

    public double max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        DoubleIterator iterator = this.doubleIterator();
        double max = iterator.next();
        while (iterator.hasNext()) {
            double value = iterator.next();
            if (Double.compare(max, value) >= 0) continue;
            max = value;
        }
        return max;
    }

    public double maxIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public double min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        DoubleIterator iterator = this.doubleIterator();
        double min = iterator.next();
        while (iterator.hasNext()) {
            double value = iterator.next();
            if (Double.compare(value, min) >= 0) continue;
            min = value;
        }
        return min;
    }

    public double minIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        double[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            double first = sortedArray[middleIndex];
            double second = sortedArray[middleIndex - 1];
            return (first + second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public double[] toSortedArray() {
        double[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newList((DoubleIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeInt(0);
                out.writeDouble(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeInt(1);
                out.writeDouble(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeInt(this.keys[i]);
            out.writeDouble(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readInt(), in.readDouble());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        int[] old = this.keys;
        double[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!IntDoubleHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(int element) {
        int index = this.spread(element);
        int keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(int element) {
        int code = element;
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new int[sizeToAllocate];
        this.values = new double[sizeToAllocate];
    }

    private static boolean isEmptyKey(int key) {
        return key == 0;
    }

    private static boolean isRemovedKey(int key) {
        return key == 1;
    }

    private static boolean isNonSentinel(int key) {
        return !IntDoubleHashMap.isEmptyKey(key) && !IntDoubleHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableIntSet keySet() {
        return new KeySet();
    }

    public MutableDoubleCollection values() {
        return new ValuesCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableDoubleCollection {
        private ValuesCollection() {
        }

        public void clear() {
            IntDoubleHashMap.this.clear();
        }

        public MutableDoubleCollection select(DoublePredicate predicate) {
            return IntDoubleHashMap.this.select(predicate);
        }

        public MutableDoubleCollection reject(DoublePredicate predicate) {
            return IntDoubleHashMap.this.reject(predicate);
        }

        public double detectIfNone(DoublePredicate predicate, double ifNone) {
            return IntDoubleHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
            return IntDoubleHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
            return IntDoubleHashMap.this.injectInto(injectedValue, function);
        }

        public double sum() {
            return IntDoubleHashMap.this.sum();
        }

        public double max() {
            return IntDoubleHashMap.this.max();
        }

        public double maxIfEmpty(double defaultValue) {
            return IntDoubleHashMap.this.maxIfEmpty(defaultValue);
        }

        public double min() {
            return IntDoubleHashMap.this.min();
        }

        public double minIfEmpty(double defaultValue) {
            return IntDoubleHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return IntDoubleHashMap.this.average();
        }

        public double median() {
            return IntDoubleHashMap.this.median();
        }

        public double[] toSortedArray() {
            return IntDoubleHashMap.this.toSortedArray();
        }

        public MutableDoubleList toSortedList() {
            return IntDoubleHashMap.this.toSortedList();
        }

        public MutableDoubleCollection with(double element) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleCollection without(double element) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleCollection withAll(DoubleIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleCollection withoutAll(DoubleIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleCollection asUnmodifiable() {
            return UnmodifiableDoubleCollection.of(this);
        }

        public MutableDoubleCollection asSynchronized() {
            return SynchronizedDoubleCollection.of(this);
        }

        public ImmutableDoubleCollection toImmutable() {
            return DoubleLists.immutable.withAll((DoubleIterable)this);
        }

        public boolean contains(double value) {
            return IntDoubleHashMap.this.containsValue(value);
        }

        public boolean containsAll(double ... source) {
            return IntDoubleHashMap.this.containsAll(source);
        }

        public boolean containsAll(DoubleIterable source) {
            return IntDoubleHashMap.this.containsAll(source);
        }

        public MutableDoubleList toList() {
            return IntDoubleHashMap.this.toList();
        }

        public MutableDoubleSet toSet() {
            return IntDoubleHashMap.this.toSet();
        }

        public MutableDoubleBag toBag() {
            return IntDoubleHashMap.this.toBag();
        }

        public LazyDoubleIterable asLazy() {
            return new LazyDoubleIterableAdapter((DoubleIterable)this);
        }

        public boolean isEmpty() {
            return IntDoubleHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return IntDoubleHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (IntDoubleHashMap.this.sentinelValues != null) {
                    if (IntDoubleHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(IntDoubleHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (IntDoubleHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(IntDoubleHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < IntDoubleHashMap.this.keys.length; ++i) {
                    int key = IntDoubleHashMap.this.keys[i];
                    if (!IntDoubleHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(IntDoubleHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public DoubleIterator doubleIterator() {
            return IntDoubleHashMap.this.doubleIterator();
        }

        public void forEach(DoubleProcedure procedure) {
            IntDoubleHashMap.this.forEach(procedure);
        }

        public int count(DoublePredicate predicate) {
            return IntDoubleHashMap.this.count(predicate);
        }

        public boolean anySatisfy(DoublePredicate predicate) {
            return IntDoubleHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(DoublePredicate predicate) {
            return IntDoubleHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(DoublePredicate predicate) {
            return IntDoubleHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(double element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(double ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(DoubleIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(double item) {
            int oldSize = IntDoubleHashMap.this.size();
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey && Double.compare(item, IntDoubleHashMap.this.sentinelValues.zeroValue) == 0) {
                    IntDoubleHashMap.this.removeKey(0);
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey && Double.compare(item, IntDoubleHashMap.this.sentinelValues.oneValue) == 0) {
                    IntDoubleHashMap.this.removeKey(1);
                }
            }
            for (int i = 0; i < IntDoubleHashMap.this.keys.length; ++i) {
                if (!IntDoubleHashMap.isNonSentinel(IntDoubleHashMap.this.keys[i]) || Double.compare(item, IntDoubleHashMap.this.values[i]) != 0) continue;
                IntDoubleHashMap.this.removeKey(IntDoubleHashMap.this.keys[i]);
            }
            return oldSize != IntDoubleHashMap.this.size();
        }

        public boolean removeAll(DoubleIterable source) {
            int oldSize = IntDoubleHashMap.this.size();
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != IntDoubleHashMap.this.size();
        }

        public boolean removeAll(double ... source) {
            int oldSize = IntDoubleHashMap.this.size();
            for (double item : source) {
                this.remove(item);
            }
            return oldSize != IntDoubleHashMap.this.size();
        }

        public int size() {
            return IntDoubleHashMap.this.size();
        }

        public double[] toArray() {
            return IntDoubleHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableIntSet {
        private KeySet() {
        }

        public IntIterator intIterator() {
            return new KeySetIterator();
        }

        public void forEach(IntProcedure procedure) {
            IntDoubleHashMap.this.forEachKey(procedure);
        }

        public int count(IntPredicate predicate) {
            int count = 0;
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    ++count;
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    ++count;
                }
            }
            for (int key : IntDoubleHashMap.this.keys) {
                if (!IntDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(IntPredicate predicate) {
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return true;
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return true;
                }
            }
            for (int key : IntDoubleHashMap.this.keys) {
                if (!IntDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(IntPredicate predicate) {
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0)) {
                    return false;
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1)) {
                    return false;
                }
            }
            for (int key : IntDoubleHashMap.this.keys) {
                if (!IntDoubleHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(IntPredicate predicate) {
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return false;
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return false;
                }
            }
            for (int key : IntDoubleHashMap.this.keys) {
                if (!IntDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(int element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(IntIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(int key) {
            int oldSize = IntDoubleHashMap.this.size();
            IntDoubleHashMap.this.removeKey(key);
            return oldSize != IntDoubleHashMap.this.size();
        }

        public boolean removeAll(IntIterable source) {
            int oldSize = IntDoubleHashMap.this.size();
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                IntDoubleHashMap.this.removeKey(iterator.next());
            }
            return oldSize != IntDoubleHashMap.this.size();
        }

        public boolean removeAll(int ... source) {
            int oldSize = IntDoubleHashMap.this.size();
            for (int item : source) {
                IntDoubleHashMap.this.removeKey(item);
            }
            return oldSize != IntDoubleHashMap.this.size();
        }

        public void clear() {
            IntDoubleHashMap.this.clear();
        }

        public MutableIntSet select(IntPredicate predicate) {
            IntHashSet result = new IntHashSet();
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    result.add(0);
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    result.add(1);
                }
            }
            for (int key : IntDoubleHashMap.this.keys) {
                if (!IntDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableIntSet reject(IntPredicate predicate) {
            IntHashSet result = new IntHashSet();
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0)) {
                    result.add(0);
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1)) {
                    result.add(1);
                }
            }
            for (int key : IntDoubleHashMap.this.keys) {
                if (!IntDoubleHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableIntSet with(int element) {
            throw new UnsupportedOperationException();
        }

        public MutableIntSet without(int element) {
            throw new UnsupportedOperationException();
        }

        public MutableIntSet withAll(IntIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableIntSet withoutAll(IntIterable elements) {
            throw new UnsupportedOperationException();
        }

        public int detectIfNone(IntPredicate predicate, int ifNone) {
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return 0;
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return 1;
                }
            }
            for (int key : IntDoubleHashMap.this.keys) {
                if (!IntDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(IntToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0));
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1));
                }
            }
            for (int key : IntDoubleHashMap.this.keys) {
                if (!IntDoubleHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableIntSet asUnmodifiable() {
            return UnmodifiableIntSet.of(this);
        }

        public MutableIntSet asSynchronized() {
            return SynchronizedIntSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (int key : IntDoubleHashMap.this.keys) {
                if (!IntDoubleHashMap.isNonSentinel(key)) continue;
                sum += (long)key;
            }
            return sum;
        }

        public int max() {
            if (IntDoubleHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            int max = 0;
            boolean isMaxSet = false;
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0;
                    isMaxSet = true;
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < 1)) {
                    max = 1;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < IntDoubleHashMap.this.keys.length; ++i) {
                if (!IntDoubleHashMap.isNonSentinel(IntDoubleHashMap.this.keys[i]) || isMaxSet && max >= IntDoubleHashMap.this.keys[i]) continue;
                max = IntDoubleHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public int maxIfEmpty(int defaultValue) {
            if (IntDoubleHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public int min() {
            if (IntDoubleHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            int min = 0;
            boolean isMinSet = false;
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0;
                    isMinSet = true;
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey && (!isMinSet || 1 < min)) {
                    min = 1;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < IntDoubleHashMap.this.keys.length; ++i) {
                if (!IntDoubleHashMap.isNonSentinel(IntDoubleHashMap.this.keys[i]) || isMinSet && IntDoubleHashMap.this.keys[i] >= min) continue;
                min = IntDoubleHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public int minIfEmpty(int defaultValue) {
            if (IntDoubleHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            int[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                int first = sortedArray[middleIndex];
                int second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public int[] toSortedArray() {
            int[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableIntList toSortedList() {
            return IntArrayList.newList((IntIterable)this).sortThis();
        }

        public int[] toArray() {
            int size = IntDoubleHashMap.this.size();
            final int[] result = new int[size];
            IntDoubleHashMap.this.forEachKey(new IntProcedure(){
                private int index;

                public void value(int each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(int value) {
            return IntDoubleHashMap.this.containsKey(value);
        }

        public boolean containsAll(int ... source) {
            for (int item : source) {
                if (IntDoubleHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(IntIterable source) {
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                if (IntDoubleHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableIntList toList() {
            return IntArrayList.newList((IntIterable)this);
        }

        public MutableIntSet toSet() {
            return IntHashSet.newSet((IntIterable)this);
        }

        public MutableIntBag toBag() {
            return IntHashBag.newBag((IntIterable)this);
        }

        public LazyIntIterable asLazy() {
            return new LazyIntIterableAdapter((IntIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0);
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1);
                }
            }
            for (int i = 0; i < IntDoubleHashMap.this.keys.length; ++i) {
                if (!IntDoubleHashMap.isNonSentinel(IntDoubleHashMap.this.keys[i])) continue;
                result = function.valueOf(result, IntDoubleHashMap.this.keys[i]);
            }
            return result;
        }

        public IntSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableIntSet toImmutable() {
            return IntSets.immutable.withAll((IntIterable)this);
        }

        public int size() {
            return IntDoubleHashMap.this.size();
        }

        public boolean isEmpty() {
            return IntDoubleHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return IntDoubleHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IntSet)) {
                return false;
            }
            IntSet other = (IntSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < IntDoubleHashMap.this.keys.length; ++i) {
                if (!IntDoubleHashMap.isNonSentinel(IntDoubleHashMap.this.keys[i])) continue;
                result += IntDoubleHashMap.this.keys[i];
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (IntDoubleHashMap.this.sentinelValues != null) {
                    if (IntDoubleHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (IntDoubleHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (int key : IntDoubleHashMap.this.keys) {
                    if (!IntDoubleHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements IntIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < IntDoubleHashMap.this.size();
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntDoubleHashMap.this.containsKey(0)) {
                    return 0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntDoubleHashMap.this.containsKey(1)) {
                    return 1;
                }
            }
            int[] keys = IntDoubleHashMap.this.keys;
            while (!IntDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            int result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyIntIterable {
        private KeysView() {
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public int size() {
            return IntDoubleHashMap.this.size();
        }

        public boolean isEmpty() {
            return IntDoubleHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return IntDoubleHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (IntDoubleHashMap.this.sentinelValues != null) {
                    if (IntDoubleHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (IntDoubleHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (int key : IntDoubleHashMap.this.keys) {
                    if (!IntDoubleHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public IntIterator intIterator() {
            return new KeySetIterator();
        }

        public boolean contains(int key) {
            return IntDoubleHashMap.this.containsKey(key);
        }

        public boolean containsAll(int ... keys) {
            for (int key : keys) {
                if (IntDoubleHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(IntIterable source) {
            return source.allSatisfy(new IntPredicate(){

                public boolean accept(int key) {
                    return IntDoubleHashMap.this.containsKey(key);
                }
            });
        }

        public void forEach(IntProcedure procedure) {
            IntDoubleHashMap.this.forEachKey(procedure);
        }

        public int count(IntPredicate predicate) {
            int count = 0;
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    ++count;
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    ++count;
                }
            }
            for (int key : IntDoubleHashMap.this.keys) {
                if (!IntDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(IntPredicate predicate) {
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return true;
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return true;
                }
            }
            for (int key : IntDoubleHashMap.this.keys) {
                if (!IntDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(IntPredicate predicate) {
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0)) {
                    return false;
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1)) {
                    return false;
                }
            }
            for (int key : IntDoubleHashMap.this.keys) {
                if (!IntDoubleHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(IntPredicate predicate) {
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return false;
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return false;
                }
            }
            for (int key : IntDoubleHashMap.this.keys) {
                if (!IntDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public LazyIntIterable select(IntPredicate predicate) {
            return new SelectIntIterable((IntIterable)this, predicate);
        }

        public LazyIntIterable reject(IntPredicate predicate) {
            return new SelectIntIterable((IntIterable)this, IntPredicates.not(predicate));
        }

        public int detectIfNone(IntPredicate predicate, int value) {
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return 0;
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return 1;
                }
            }
            for (int key : IntDoubleHashMap.this.keys) {
                if (!IntDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(IntToObjectFunction<? extends V> function) {
            return new CollectIntToObjectIterable<V>((IntIterable)this, function);
        }

        public long sum() {
            long result = 0L;
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0L;
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int key : IntDoubleHashMap.this.keys) {
                if (!IntDoubleHashMap.isNonSentinel(key)) continue;
                result += (long)key;
            }
            return result;
        }

        public int max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            IntIterator iterator = this.intIterator();
            int max = iterator.next();
            while (iterator.hasNext()) {
                int value = iterator.next();
                if (max >= value) continue;
                max = value;
            }
            return max;
        }

        public int min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            IntIterator iterator = this.intIterator();
            int min = iterator.next();
            while (iterator.hasNext()) {
                int value = iterator.next();
                if (value >= min) continue;
                min = value;
            }
            return min;
        }

        public int minIfEmpty(int defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public int maxIfEmpty(int defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            int[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                int first = sortedArray[middleIndex];
                int second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public int[] toSortedArray() {
            int[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public int[] toArray() {
            int size = IntDoubleHashMap.this.size();
            final int[] result = new int[size];
            IntDoubleHashMap.this.forEachKey(new IntProcedure(){
                private int index;

                public void value(int each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (IntDoubleHashMap.this.sentinelValues != null) {
                if (IntDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0);
                }
                if (IntDoubleHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1);
                }
            }
            for (int i = 0; i < IntDoubleHashMap.this.keys.length; ++i) {
                if (!IntDoubleHashMap.isNonSentinel(IntDoubleHashMap.this.keys[i])) continue;
                result = function.valueOf(result, IntDoubleHashMap.this.keys[i]);
            }
            return result;
        }

        public MutableIntList toList() {
            return IntArrayList.newList((IntIterable)this);
        }

        public MutableIntList toSortedList() {
            return IntArrayList.newList((IntIterable)this).sortThis();
        }

        public MutableIntSet toSet() {
            return IntHashSet.newSet((IntIterable)this);
        }

        public MutableIntBag toBag() {
            return IntHashBag.newBag((IntIterable)this);
        }

        public LazyIntIterable asLazy() {
            return this;
        }
    }

    private class InternalDoubleIterator
    implements DoubleIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalDoubleIterator() {
        }

        public boolean hasNext() {
            return this.count < IntDoubleHashMap.this.size();
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntDoubleHashMap.this.containsKey(0)) {
                    return IntDoubleHashMap.this.get(0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntDoubleHashMap.this.containsKey(1)) {
                    return IntDoubleHashMap.this.get(1);
                }
            }
            int[] keys = IntDoubleHashMap.this.keys;
            while (!IntDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            double result = IntDoubleHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private double zeroValue;
        private double oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(double value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && Double.compare(this.zeroValue, value) == 0;
            boolean valueEqualsOneValue = this.containsOneKey && Double.compare(this.oneValue, value) == 0;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

