/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction0;
import com.gs.collections.api.block.function.primitive.ByteToByteFunction;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectBytePredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectByteProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.map.primitive.ImmutableObjectByteMap;
import com.gs.collections.api.map.primitive.MutableObjectByteMap;
import com.gs.collections.api.map.primitive.ObjectByteMap;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.tuple.primitive.ObjectBytePair;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedByteCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import com.gs.collections.impl.factory.primitive.ByteLists;
import com.gs.collections.impl.factory.primitive.ObjectByteMaps;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedObjectByteMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableObjectByteMap;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectByteHashMap<K>
implements MutableObjectByteMap<K>,
Externalizable {
    public static final byte EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final Object NULL_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectByteHashMap.NULL_KEY";
        }
    };
    private static final Object REMOVED_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectByteHashMap.REMOVED_KEY";
        }
    };
    private Object[] keys;
    private byte[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;

    public ObjectByteHashMap() {
        this.allocateTable(16);
    }

    public ObjectByteHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public ObjectByteHashMap(ObjectByteMap<? extends K> map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    public static <K> ObjectByteHashMap<K> newMap() {
        return new ObjectByteHashMap<K>();
    }

    public static <K> ObjectByteHashMap<K> newWithKeysValues(K key1, byte value1) {
        return new ObjectByteHashMap<K>(1).withKeyValue((Object)key1, value1);
    }

    public static <K> ObjectByteHashMap<K> newWithKeysValues(K key1, byte value1, K key2, byte value2) {
        return new ObjectByteHashMap<K>(2).withKeysValues(key1, value1, key2, value2);
    }

    public static <K> ObjectByteHashMap<K> newWithKeysValues(K key1, byte value1, K key2, byte value2, K key3, byte value3) {
        return new ObjectByteHashMap<K>(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static <K> ObjectByteHashMap<K> newWithKeysValues(K key1, byte value1, K key2, byte value2, K key3, byte value3, K key4, byte value4) {
        return new ObjectByteHashMap<K>(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectByteMap)) {
            return false;
        }
        ObjectByteMap other = (ObjectByteMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || other.containsKey(this.toNonSentinel(this.keys[i])) && this.values[i] == other.getOrThrow(this.toNonSentinel(this.keys[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            result += (this.toNonSentinel(this.keys[i]) == null ? 0 : this.keys[i].hashCode()) ^ this.values[i];
        }
        return result;
    }

    public String toString() {
        return this.makeString("{", ", ", "}");
    }

    public int size() {
        return this.occupiedWithData;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean notEmpty() {
        return this.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            for (int i = 0; i < this.keys.length; ++i) {
                Object key = this.keys[i];
                if (!ObjectByteHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.toNonSentinel(key))).append("=").append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteIterator byteIterator() {
        return new InternalByteIterator();
    }

    public byte[] toArray() {
        byte[] result = new byte[this.size()];
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            result[index] = this.values[i];
            ++index;
        }
        return result;
    }

    public boolean contains(byte value) {
        return this.containsValue(value);
    }

    public boolean containsAll(byte ... source) {
        for (byte item : source) {
            if (this.containsValue(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ByteIterable source) {
        return this.containsAll(source.toArray());
    }

    public void clear() {
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, (byte)0);
    }

    public void put(K key, byte value) {
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = value;
            return;
        }
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectByteHashMap.toSentinelIfNull(key);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public void putAll(ObjectByteMap<? extends K> map) {
        map.forEachKeyValue(new ObjectByteProcedure<K>(){

            public void value(K key, byte value) {
                ObjectByteHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(K key) {
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(K key) {
        this.removeKey(key);
    }

    public byte removeKeyIfAbsent(K key, byte value) {
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            byte oldValue = this.values[index];
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public byte getIfAbsentPut(K key, byte value) {
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectByteHashMap.toSentinelIfNull(key);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public byte getIfAbsentPut(K key, ByteFunction0 function) {
        byte value;
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectByteHashMap.toSentinelIfNull(key);
        this.values[index] = value = function.value();
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public <P> byte getIfAbsentPutWith(K key, ByteFunction<? super P> function, P parameter) {
        byte value;
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectByteHashMap.toSentinelIfNull(key);
        this.values[index] = value = function.byteValueOf(parameter);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public byte getIfAbsentPutWithKey(K key, ByteFunction<? super K> function) {
        byte value;
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectByteHashMap.toSentinelIfNull(key);
        this.values[index] = value = function.byteValueOf(key);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public byte updateValue(K key, byte initialValueIfAbsent, ByteToByteFunction function) {
        byte value;
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectByteHashMap.toSentinelIfNull(key);
        this.values[index] = value = function.valueOf(initialValueIfAbsent);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public ObjectByteHashMap<K> withKeyValue(K key1, byte value1) {
        this.put(key1, value1);
        return this;
    }

    public ObjectByteHashMap<K> withKeysValues(K key1, byte value1, K key2, byte value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ObjectByteHashMap<K> withKeysValues(K key1, byte value1, K key2, byte value2, K key3, byte value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ObjectByteHashMap<K> withKeysValues(K key1, byte value1, K key2, byte value2, K key3, byte value3, K key4, byte value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ObjectByteHashMap<K> withoutKey(K key) {
        this.removeKey(key);
        return this;
    }

    public ObjectByteHashMap<K> withoutAllKeys(Iterable<? extends K> keys) {
        for (K key : keys) {
            this.removeKey(key);
        }
        return this;
    }

    public MutableObjectByteMap<K> asUnmodifiable() {
        return new UnmodifiableObjectByteMap(this);
    }

    public MutableObjectByteMap<K> asSynchronized() {
        return new SynchronizedObjectByteMap(this);
    }

    public ImmutableObjectByteMap<K> toImmutable() {
        return ObjectByteMaps.immutable.withAll((ObjectByteMap)this);
    }

    public byte get(Object key) {
        return this.getIfAbsent(key, (byte)0);
    }

    public byte getOrThrow(Object key) {
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public byte getIfAbsent(Object key, byte ifAbsent) {
        int index = this.probe(key);
        if (ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public boolean containsKey(Object key) {
        int index = this.probe(key);
        return ObjectByteHashMap.isNonSentinel(this.keys[index]) && ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key);
    }

    public boolean containsValue(byte value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEach(ByteProcedure procedure) {
        this.forEachValue(procedure);
    }

    public void forEachValue(ByteProcedure procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(Procedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]));
        }
    }

    public void forEachKeyValue(ObjectByteProcedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    public ObjectByteHashMap<K> select(ObjectBytePredicate<? super K> predicate) {
        ObjectByteHashMap<K> result = ObjectByteHashMap.newMap();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    public ObjectByteHashMap<K> reject(ObjectBytePredicate<? super K> predicate) {
        ObjectByteHashMap<K> result = ObjectByteHashMap.newMap();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    public MutableByteCollection select(BytePredicate predicate) {
        ByteArrayList result = new ByteArrayList();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableByteCollection reject(BytePredicate predicate) {
        ByteArrayList result = new ByteArrayList();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return ifNone;
    }

    public <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
        FastList result = FastList.newList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(function.valueOf(this.values[i]));
        }
        return result;
    }

    public int count(BytePredicate predicate) {
        int count = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(BytePredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(BytePredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectByteToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public long sum() {
        long sum = 0L;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            sum += (long)this.values[i];
        }
        return sum;
    }

    public byte max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        byte max = 0;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || isMaxSet && max >= this.values[i]) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    public byte min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        byte min = 0;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || isMinSet && this.values[i] >= min) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return min;
    }

    public byte maxIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        byte max = 0;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || isMaxSet && max >= this.values[i]) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    public byte minIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        byte min = 0;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i]) || isMinSet && this.values[i] >= min) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return min;
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        byte[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            byte first = sortedArray[middleIndex];
            byte second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public MutableByteList toList() {
        ByteArrayList result = new ByteArrayList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableByteSet toSet() {
        ByteHashSet result = new ByteHashSet(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableByteBag toBag() {
        ByteHashBag result = new ByteHashBag(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public byte[] toSortedArray() {
        byte[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableByteList toSortedList() {
        return this.toList().sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeObject(this.toNonSentinel(this.keys[i]));
            out.writeByte(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(size * 2));
        this.allocateTable(capacity);
        for (int i = 0; i < size; ++i) {
            this.put(in.readObject(), in.readByte());
        }
    }

    public LazyIterable<K> keysView() {
        return new KeysView();
    }

    public RichIterable<ObjectBytePair<K>> keyValuesView() {
        return new KeyValuesView();
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        Object[] old = this.keys;
        byte[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ObjectByteHashMap.isNonSentinel(old[i])) continue;
            this.put(this.toNonSentinel(old[i]), oldValues[i]);
        }
    }

    int probe(Object element) {
        int index = this.spread(element);
        int removedIndex = -1;
        if (ObjectByteHashMap.isRemovedKey(this.keys[index])) {
            removedIndex = index;
        } else if (this.keys[index] == null || ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), element)) {
            return index;
        }
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (ObjectByteHashMap.isRemovedKey(this.keys[nextIndex &= this.keys.length - 1])) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (ObjectByteHashMap.nullSafeEquals(this.toNonSentinel(this.keys[nextIndex]), element)) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == null) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(Object element) {
        int h = element == null ? 0 : element.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & this.keys.length - 1;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new Object[sizeToAllocate];
        this.values = new byte[sizeToAllocate];
    }

    private static boolean isRemovedKey(Object key) {
        return key == REMOVED_KEY;
    }

    private static <K> boolean isNonSentinel(K key) {
        return key != null && !ObjectByteHashMap.isRemovedKey(key);
    }

    private K toNonSentinel(Object key) {
        return (K)(key == NULL_KEY ? null : key);
    }

    private static Object toSentinelIfNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public Set<K> keySet() {
        return new KeySet();
    }

    public MutableByteCollection values() {
        return new ValuesCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<ObjectBytePair<K>> {
        private KeyValuesView() {
        }

        public void forEach(Procedure<? super ObjectBytePair<K>> procedure) {
            for (int i = 0; i < ObjectByteHashMap.this.keys.length; ++i) {
                if (!ObjectByteHashMap.isNonSentinel(ObjectByteHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectByteHashMap.this.toNonSentinel(ObjectByteHashMap.this.keys[i]), ObjectByteHashMap.this.values[i]));
            }
        }

        public void forEachWithIndex(ObjectIntProcedure<? super ObjectBytePair<K>> objectIntProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectByteHashMap.this.keys.length; ++i) {
                if (!ObjectByteHashMap.isNonSentinel(ObjectByteHashMap.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(ObjectByteHashMap.this.toNonSentinel(ObjectByteHashMap.this.keys[i]), ObjectByteHashMap.this.values[i]), index);
                ++index;
            }
        }

        public <P> void forEachWith(Procedure2<? super ObjectBytePair<K>, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectByteHashMap.this.keys.length; ++i) {
                if (!ObjectByteHashMap.isNonSentinel(ObjectByteHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectByteHashMap.this.toNonSentinel(ObjectByteHashMap.this.keys[i]), ObjectByteHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<ObjectBytePair<K>> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<ObjectBytePair<K>> {
            private int count;
            private int position;

            @Override
            public ObjectBytePair<K> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectByteHashMap.this.keys;
                while (!ObjectByteHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ObjectBytePair<Object> result = PrimitiveTuples.pair(ObjectByteHashMap.this.toNonSentinel(ObjectByteHashMap.this.keys[this.position]), ObjectByteHashMap.this.values[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectByteHashMap.this.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    extends AbstractLazyIterable<K> {
        private KeysView() {
        }

        public void forEach(Procedure<? super K> procedure) {
            for (int i = 0; i < ObjectByteHashMap.this.keys.length; ++i) {
                if (!ObjectByteHashMap.isNonSentinel(ObjectByteHashMap.this.keys[i])) continue;
                procedure.value(ObjectByteHashMap.this.toNonSentinel(ObjectByteHashMap.this.keys[i]));
            }
        }

        public void forEachWithIndex(ObjectIntProcedure<? super K> objectByteProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectByteHashMap.this.keys.length; ++i) {
                if (!ObjectByteHashMap.isNonSentinel(ObjectByteHashMap.this.keys[i])) continue;
                objectByteProcedure.value(ObjectByteHashMap.this.toNonSentinel(ObjectByteHashMap.this.keys[i]), index);
                ++index;
            }
        }

        public <P> void forEachWith(Procedure2<? super K, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectByteHashMap.this.keys.length; ++i) {
                if (!ObjectByteHashMap.isNonSentinel(ObjectByteHashMap.this.keys[i])) continue;
                procedure.value(ObjectByteHashMap.this.toNonSentinel(ObjectByteHashMap.this.keys[i]), parameter);
            }
        }

        public Iterator<K> iterator() {
            return new InternalKeysViewIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeysViewIterator<K>
        implements Iterator<K> {
            private int count;
            private int position;

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectByteHashMap.this.keys;
                while (!ObjectByteHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                Object result = ObjectByteHashMap.this.keys[this.position];
                ++this.count;
                ++this.position;
                return (K)result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectByteHashMap.this.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableByteCollection {
        private ValuesCollection() {
        }

        public int size() {
            return ObjectByteHashMap.this.size();
        }

        public boolean isEmpty() {
            return ObjectByteHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ObjectByteHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                for (int i = 0; i < ObjectByteHashMap.this.keys.length; ++i) {
                    Object key = ObjectByteHashMap.this.keys[i];
                    if (!ObjectByteHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ObjectByteHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean add(byte element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(byte ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(ByteIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(byte item) {
            int oldSize = ObjectByteHashMap.this.size();
            for (int i = 0; i < ObjectByteHashMap.this.keys.length; ++i) {
                if (!ObjectByteHashMap.isNonSentinel(ObjectByteHashMap.this.keys[i]) || item != ObjectByteHashMap.this.values[i]) continue;
                ObjectByteHashMap.this.removeKey(ObjectByteHashMap.this.keys[i]);
            }
            return oldSize != ObjectByteHashMap.this.size();
        }

        public boolean removeAll(ByteIterable source) {
            int oldSize = ObjectByteHashMap.this.size();
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != ObjectByteHashMap.this.size();
        }

        public boolean removeAll(byte ... source) {
            int oldSize = ObjectByteHashMap.this.size();
            for (byte item : source) {
                this.remove(item);
            }
            return oldSize != ObjectByteHashMap.this.size();
        }

        public void clear() {
            ObjectByteHashMap.this.clear();
        }

        public MutableByteCollection with(byte element) {
            throw new UnsupportedOperationException();
        }

        public MutableByteCollection without(byte element) {
            throw new UnsupportedOperationException();
        }

        public MutableByteCollection withAll(ByteIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableByteCollection withoutAll(ByteIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableByteCollection asUnmodifiable() {
            return UnmodifiableByteCollection.of(this);
        }

        public MutableByteCollection asSynchronized() {
            return SynchronizedByteCollection.of(this);
        }

        public ImmutableByteCollection toImmutable() {
            return ByteLists.immutable.withAll((ByteIterable)this);
        }

        public ByteIterator byteIterator() {
            return ObjectByteHashMap.this.byteIterator();
        }

        public byte[] toArray() {
            return ObjectByteHashMap.this.toArray();
        }

        public boolean contains(byte value) {
            return ObjectByteHashMap.this.containsValue(value);
        }

        public boolean containsAll(byte ... source) {
            return ObjectByteHashMap.this.containsAll(source);
        }

        public boolean containsAll(ByteIterable source) {
            return ObjectByteHashMap.this.containsAll(source);
        }

        public void forEach(ByteProcedure procedure) {
            ObjectByteHashMap.this.forEach(procedure);
        }

        public MutableByteCollection select(BytePredicate predicate) {
            return ObjectByteHashMap.this.select(predicate);
        }

        public MutableByteCollection reject(BytePredicate predicate) {
            return ObjectByteHashMap.this.reject(predicate);
        }

        public <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
            return ObjectByteHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
            return ObjectByteHashMap.this.injectInto(injectedValue, function);
        }

        public byte detectIfNone(BytePredicate predicate, byte ifNone) {
            return ObjectByteHashMap.this.detectIfNone(predicate, ifNone);
        }

        public int count(BytePredicate predicate) {
            return ObjectByteHashMap.this.count(predicate);
        }

        public boolean anySatisfy(BytePredicate predicate) {
            return ObjectByteHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(BytePredicate predicate) {
            return ObjectByteHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(BytePredicate predicate) {
            return ObjectByteHashMap.this.noneSatisfy(predicate);
        }

        public MutableByteList toList() {
            return ObjectByteHashMap.this.toList();
        }

        public MutableByteSet toSet() {
            return ObjectByteHashMap.this.toSet();
        }

        public MutableByteBag toBag() {
            return ObjectByteHashMap.this.toBag();
        }

        public LazyByteIterable asLazy() {
            return new LazyByteIterableAdapter((ByteIterable)this);
        }

        public byte[] toSortedArray() {
            return ObjectByteHashMap.this.toSortedArray();
        }

        public MutableByteList toSortedList() {
            return ObjectByteHashMap.this.toSortedList();
        }

        public long sum() {
            return ObjectByteHashMap.this.sum();
        }

        public byte max() {
            return ObjectByteHashMap.this.max();
        }

        public byte maxIfEmpty(byte defaultValue) {
            return ObjectByteHashMap.this.maxIfEmpty(defaultValue);
        }

        public byte min() {
            return ObjectByteHashMap.this.min();
        }

        public byte minIfEmpty(byte defaultValue) {
            return ObjectByteHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return ObjectByteHashMap.this.average();
        }

        public double median() {
            return ObjectByteHashMap.this.median();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySetIterator
    implements Iterator<K> {
        private int count;
        private int position;
        private K currentKey;
        private boolean isCurrentKeySet;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ObjectByteHashMap.this.size();
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            Object[] keys = ObjectByteHashMap.this.keys;
            while (!ObjectByteHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.currentKey = ObjectByteHashMap.this.keys[this.position];
            this.isCurrentKeySet = true;
            ++this.position;
            return ObjectByteHashMap.this.toNonSentinel(this.currentKey);
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (ObjectByteHashMap.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                ((ObjectByteHashMap)ObjectByteHashMap.this).keys[index] = REMOVED_KEY;
                ((ObjectByteHashMap)ObjectByteHashMap.this).values[index] = 0;
                ObjectByteHashMap.this.occupiedWithData--;
                ObjectByteHashMap.this.occupiedWithSentinels++;
                if (ObjectByteHashMap.this.occupiedWithSentinels > ObjectByteHashMap.this.maxOccupiedWithSentinels()) {
                    ObjectByteHashMap.this.rehash();
                }
            } else {
                ObjectByteHashMap.this.removeKey(this.currentKey);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public boolean equals(Object obj) {
            Set other;
            if (obj instanceof Set && (other = (Set)obj).size() == this.size()) {
                return this.containsAll(other);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            Object[] table = ObjectByteHashMap.this.keys;
            for (int i = 0; i < table.length; ++i) {
                Object key = table[i];
                if (!ObjectByteHashMap.isNonSentinel(key)) continue;
                Object nonSentinelKey = ObjectByteHashMap.this.toNonSentinel(key);
                hashCode += nonSentinelKey == null ? 0 : nonSentinelKey.hashCode();
            }
            return hashCode;
        }

        @Override
        public int size() {
            return ObjectByteHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectByteHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ObjectByteHashMap.this.containsKey(o);
        }

        @Override
        public Object[] toArray() {
            int size = ObjectByteHashMap.this.size();
            Object[] result = new Object[size];
            this.copyKeys(result);
            return result;
        }

        @Override
        public <T> T[] toArray(T[] result) {
            int size = ObjectByteHashMap.this.size();
            if (result.length < size) {
                result = (Object[])Array.newInstance(result.getClass().getComponentType(), size);
            }
            this.copyKeys(result);
            if (size < result.length) {
                result[size] = null;
            }
            return result;
        }

        @Override
        public boolean add(K key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object key) {
            int oldSize = ObjectByteHashMap.this.size();
            ObjectByteHashMap.this.removeKey(key);
            return oldSize != ObjectByteHashMap.this.size();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object aCollection : collection) {
                if (ObjectByteHashMap.this.containsKey(aCollection)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int oldSize = ObjectByteHashMap.this.size();
            for (Object next : this) {
                if (collection.contains(next)) continue;
                this.remove(next);
            }
            return oldSize != ObjectByteHashMap.this.size();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            int oldSize = ObjectByteHashMap.this.size();
            for (Object object : collection) {
                ObjectByteHashMap.this.removeKey(object);
            }
            return oldSize != ObjectByteHashMap.this.size();
        }

        @Override
        public void clear() {
            ObjectByteHashMap.this.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        private void copyKeys(Object[] result) {
            int count = 0;
            for (int i = 0; i < ObjectByteHashMap.this.keys.length; ++i) {
                Object key = ObjectByteHashMap.this.keys[i];
                if (!ObjectByteHashMap.isNonSentinel(key)) continue;
                result[count++] = ObjectByteHashMap.this.keys[i];
            }
        }
    }

    private class InternalByteIterator
    implements ByteIterator {
        private int count;
        private int position;

        private InternalByteIterator() {
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] keys = ObjectByteHashMap.this.keys;
            while (!ObjectByteHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            byte result = ObjectByteHashMap.this.values[this.position];
            ++this.count;
            ++this.position;
            return result;
        }

        public boolean hasNext() {
            return this.count != ObjectByteHashMap.this.size();
        }
    }
}

