/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction0;
import com.gs.collections.api.block.function.primitive.CharToCharFunction;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToCharFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortCharPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortCharProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.ImmutableShortCharMap;
import com.gs.collections.api.map.primitive.MutableShortCharMap;
import com.gs.collections.api.map.primitive.ShortCharMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableShortSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.set.primitive.ShortSet;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.block.factory.primitive.ShortPredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedCharCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.factory.primitive.ShortCharMaps;
import com.gs.collections.impl.factory.primitive.ShortSets;
import com.gs.collections.impl.lazy.primitive.CollectShortToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectShortIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedShortCharMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableShortCharMap;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedShortSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableShortSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortCharHashMap
implements MutableShortCharMap,
Externalizable {
    static final char EMPTY_VALUE = '\u0000';
    private static final long serialVersionUID = 1L;
    private static final short EMPTY_KEY = 0;
    private static final short REMOVED_KEY = 1;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private short[] keys;
    private char[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public ShortCharHashMap() {
        this.allocateTable(16);
    }

    public ShortCharHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public ShortCharHashMap(ShortCharMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static ShortCharHashMap newWithKeysValues(short key1, char value1) {
        return new ShortCharHashMap(1).withKeyValue(key1, value1);
    }

    public static ShortCharHashMap newWithKeysValues(short key1, char value1, short key2, char value2) {
        return new ShortCharHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static ShortCharHashMap newWithKeysValues(short key1, char value1, short key2, char value2, short key3, char value3) {
        return new ShortCharHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static ShortCharHashMap newWithKeysValues(short key1, char value1, short key2, char value2, short key3, char value3, short key4, char value4) {
        return new ShortCharHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShortCharMap)) {
            return false;
        }
        ShortCharMap other = (ShortCharMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey((short)0) || other.containsKey((short)1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey((short)0) || this.sentinelValues.zeroValue != other.getOrThrow((short)0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey((short)1) || this.sentinelValues.oneValue != other.getOrThrow((short)1))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            short key = this.keys[i];
            if (!ShortCharHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += '\u0000' ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += '\u0001' ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortCharHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ this.values[i];
        }
        return result;
    }

    public String toString() {
        return this.makeString("{", ", ", "}");
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(0)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                short key = this.keys[i];
                if (!ShortCharHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CharIterator charIterator() {
        return new InternalCharIterator();
    }

    public char[] toArray() {
        char[] array = new char[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortCharHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(char value) {
        return this.containsValue(value);
    }

    public boolean containsAll(char ... source) {
        for (char each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(CharIterable source) {
        return source.allSatisfy(new CharPredicate(){

            public boolean accept(char value) {
                return ShortCharHashMap.this.contains(value);
            }
        });
    }

    public void forEach(CharProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableCharCollection select(CharPredicate predicate) {
        CharArrayList result = new CharArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableCharCollection reject(CharPredicate predicate) {
        CharArrayList result = new CharArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortCharHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortCharHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public char detectIfNone(CharPredicate predicate, char value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(CharPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(CharPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(CharPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortCharHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectCharToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortCharHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableCharList toList() {
        return CharArrayList.newList((CharIterable)this);
    }

    public MutableCharSet toSet() {
        return CharHashSet.newSet((CharIterable)this);
    }

    public MutableCharBag toBag() {
        return CharHashBag.newBag((CharIterable)this);
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, (short)0);
        Arrays.fill(this.values, '\u0000');
    }

    public void put(short key, char value) {
        if (ShortCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (ShortCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = value;
            return;
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public void putAll(ShortCharMap map) {
        map.forEachKeyValue(new ShortCharProcedure(){

            public void value(short key, char value) {
                ShortCharHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(short key) {
        if (ShortCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = '\u0000';
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (ShortCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = '\u0000';
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            this.values[index] = '\u0000';
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(short key) {
        this.removeKey(key);
    }

    public char removeKeyIfAbsent(short key, char value) {
        if (ShortCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            char oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = '\u0000';
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (ShortCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            char oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = '\u0000';
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            char oldValue = this.values[index];
            this.values[index] = '\u0000';
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public char getIfAbsentPut(short key, char value) {
        if (ShortCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (ShortCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public char getIfAbsentPut(short key, CharFunction0 function) {
        char value;
        if (ShortCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value2 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value3 = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (ShortCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value4 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value5 = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.value();
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public <P> char getIfAbsentPutWith(short key, CharFunction<? super P> function, P parameter) {
        char value;
        if (ShortCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value2 = function.charValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value3 = function.charValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (ShortCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value4 = function.charValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value5 = function.charValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.charValueOf(parameter);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public char getIfAbsentPutWithKey(short key, ShortToCharFunction function) {
        char value;
        if (ShortCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value2 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value3 = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (ShortCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value4 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value5 = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(key);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public char updateValue(short key, char initialValueIfAbsent, CharToCharFunction function) {
        char value;
        if (ShortCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(initialValueIfAbsent);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public ShortCharHashMap withKeyValue(short key1, char value1) {
        this.put(key1, value1);
        return this;
    }

    public ShortCharHashMap withKeysValues(short key1, char value1, short key2, char value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ShortCharHashMap withKeysValues(short key1, char value1, short key2, char value2, short key3, char value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ShortCharHashMap withKeysValues(short key1, char value1, short key2, char value2, short key3, char value3, short key4, char value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ShortCharHashMap withoutKey(short key) {
        this.removeKey(key);
        return this;
    }

    public ShortCharHashMap withoutAllKeys(ShortIterable keys) {
        keys.forEach(new ShortProcedure(){

            public void value(short key) {
                ShortCharHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableShortCharMap asUnmodifiable() {
        return new UnmodifiableShortCharMap(this);
    }

    public MutableShortCharMap asSynchronized() {
        return new SynchronizedShortCharMap(this);
    }

    public ImmutableShortCharMap toImmutable() {
        return ShortCharMaps.immutable.ofAll((ShortCharMap)this);
    }

    public char get(short key) {
        return this.getIfAbsent(key, '\u0000');
    }

    public char getIfAbsent(short key, char ifAbsent) {
        if (ShortCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public char getOrThrow(short key) {
        if (ShortCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (ShortCharHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(short key) {
        if (ShortCharHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (ShortCharHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(char value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!ShortCharHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(CharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortCharHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(ShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((short)0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((short)1);
            }
        }
        for (short key : this.keys) {
            if (!ShortCharHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(ShortCharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortCharHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyShortIterable keysView() {
        return new KeysView();
    }

    public ShortCharHashMap select(ShortCharPredicate predicate) {
        ShortCharHashMap result = new ShortCharHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept((short)0, this.sentinelValues.zeroValue)) {
                result.put((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept((short)1, this.sentinelValues.oneValue)) {
                result.put((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public ShortCharHashMap reject(ShortCharPredicate predicate) {
        ShortCharHashMap result = new ShortCharHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept((short)0, this.sentinelValues.zeroValue)) {
                result.put((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept((short)1, this.sentinelValues.oneValue)) {
                result.put((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortCharHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (long)this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (long)this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortCharHashMap.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    public char max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        CharIterator iterator = this.charIterator();
        char max = iterator.next();
        while (iterator.hasNext()) {
            char value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public char maxIfEmpty(char defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public char min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        CharIterator iterator = this.charIterator();
        char min = iterator.next();
        while (iterator.hasNext()) {
            char value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public char minIfEmpty(char defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        char[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            char first = sortedArray[middleIndex];
            char second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public char[] toSortedArray() {
        char[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableCharList toSortedList() {
        return CharArrayList.newList((CharIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeShort(0);
                out.writeChar(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeShort(1);
                out.writeChar(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortCharHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeShort(this.keys[i]);
            out.writeChar(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readShort(), in.readChar());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        short[] old = this.keys;
        char[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ShortCharHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(short element) {
        int index = this.spread(element);
        short keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(short element) {
        int code = element;
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new short[sizeToAllocate];
        this.values = new char[sizeToAllocate];
    }

    private static boolean isEmptyKey(short key) {
        return key == 0;
    }

    private static boolean isRemovedKey(short key) {
        return key == 1;
    }

    private static boolean isNonSentinel(short key) {
        return !ShortCharHashMap.isEmptyKey(key) && !ShortCharHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableShortSet keySet() {
        return new KeySet();
    }

    public MutableCharCollection values() {
        return new ValuesCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableCharCollection {
        private ValuesCollection() {
        }

        public void clear() {
            ShortCharHashMap.this.clear();
        }

        public MutableCharCollection select(CharPredicate predicate) {
            return ShortCharHashMap.this.select(predicate);
        }

        public MutableCharCollection reject(CharPredicate predicate) {
            return ShortCharHashMap.this.reject(predicate);
        }

        public char detectIfNone(CharPredicate predicate, char ifNone) {
            return ShortCharHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
            return ShortCharHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
            return ShortCharHashMap.this.injectInto(injectedValue, function);
        }

        public long sum() {
            return ShortCharHashMap.this.sum();
        }

        public char max() {
            return ShortCharHashMap.this.max();
        }

        public char maxIfEmpty(char defaultValue) {
            return ShortCharHashMap.this.maxIfEmpty(defaultValue);
        }

        public char min() {
            return ShortCharHashMap.this.min();
        }

        public char minIfEmpty(char defaultValue) {
            return ShortCharHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return ShortCharHashMap.this.average();
        }

        public double median() {
            return ShortCharHashMap.this.median();
        }

        public char[] toSortedArray() {
            return ShortCharHashMap.this.toSortedArray();
        }

        public MutableCharList toSortedList() {
            return ShortCharHashMap.this.toSortedList();
        }

        public MutableCharCollection with(char element) {
            throw new UnsupportedOperationException();
        }

        public MutableCharCollection without(char element) {
            throw new UnsupportedOperationException();
        }

        public MutableCharCollection withAll(CharIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableCharCollection withoutAll(CharIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableCharCollection asUnmodifiable() {
            return UnmodifiableCharCollection.of(this);
        }

        public MutableCharCollection asSynchronized() {
            return SynchronizedCharCollection.of(this);
        }

        public ImmutableCharCollection toImmutable() {
            return CharLists.immutable.withAll((CharIterable)this);
        }

        public boolean contains(char value) {
            return ShortCharHashMap.this.containsValue(value);
        }

        public boolean containsAll(char ... source) {
            return ShortCharHashMap.this.containsAll(source);
        }

        public boolean containsAll(CharIterable source) {
            return ShortCharHashMap.this.containsAll(source);
        }

        public MutableCharList toList() {
            return ShortCharHashMap.this.toList();
        }

        public MutableCharSet toSet() {
            return ShortCharHashMap.this.toSet();
        }

        public MutableCharBag toBag() {
            return ShortCharHashMap.this.toBag();
        }

        public LazyCharIterable asLazy() {
            return new LazyCharIterableAdapter((CharIterable)this);
        }

        public boolean isEmpty() {
            return ShortCharHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ShortCharHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ShortCharHashMap.this.sentinelValues != null) {
                    if (ShortCharHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(ShortCharHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (ShortCharHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(ShortCharHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < ShortCharHashMap.this.keys.length; ++i) {
                    short key = ShortCharHashMap.this.keys[i];
                    if (!ShortCharHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ShortCharHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public CharIterator charIterator() {
            return ShortCharHashMap.this.charIterator();
        }

        public void forEach(CharProcedure procedure) {
            ShortCharHashMap.this.forEach(procedure);
        }

        public int count(CharPredicate predicate) {
            return ShortCharHashMap.this.count(predicate);
        }

        public boolean anySatisfy(CharPredicate predicate) {
            return ShortCharHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(CharPredicate predicate) {
            return ShortCharHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(CharPredicate predicate) {
            return ShortCharHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(char element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(char ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(CharIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(char item) {
            int oldSize = ShortCharHashMap.this.size();
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey && item == ShortCharHashMap.this.sentinelValues.zeroValue) {
                    ShortCharHashMap.this.removeKey((short)0);
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey && item == ShortCharHashMap.this.sentinelValues.oneValue) {
                    ShortCharHashMap.this.removeKey((short)1);
                }
            }
            for (int i = 0; i < ShortCharHashMap.this.keys.length; ++i) {
                if (!ShortCharHashMap.isNonSentinel(ShortCharHashMap.this.keys[i]) || item != ShortCharHashMap.this.values[i]) continue;
                ShortCharHashMap.this.removeKey(ShortCharHashMap.this.keys[i]);
            }
            return oldSize != ShortCharHashMap.this.size();
        }

        public boolean removeAll(CharIterable source) {
            int oldSize = ShortCharHashMap.this.size();
            CharIterator iterator = source.charIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != ShortCharHashMap.this.size();
        }

        public boolean removeAll(char ... source) {
            int oldSize = ShortCharHashMap.this.size();
            for (char item : source) {
                this.remove(item);
            }
            return oldSize != ShortCharHashMap.this.size();
        }

        public int size() {
            return ShortCharHashMap.this.size();
        }

        public char[] toArray() {
            return ShortCharHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableShortSet {
        private KeySet() {
        }

        public ShortIterator shortIterator() {
            return new KeySetIterator();
        }

        public void forEach(ShortProcedure procedure) {
            ShortCharHashMap.this.forEachKey(procedure);
        }

        public int count(ShortPredicate predicate) {
            int count = 0;
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    ++count;
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    ++count;
                }
            }
            for (short key : ShortCharHashMap.this.keys) {
                if (!ShortCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(ShortPredicate predicate) {
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return true;
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return true;
                }
            }
            for (short key : ShortCharHashMap.this.keys) {
                if (!ShortCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(ShortPredicate predicate) {
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((short)0)) {
                    return false;
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey && !predicate.accept((short)1)) {
                    return false;
                }
            }
            for (short key : ShortCharHashMap.this.keys) {
                if (!ShortCharHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(ShortPredicate predicate) {
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return false;
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return false;
                }
            }
            for (short key : ShortCharHashMap.this.keys) {
                if (!ShortCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(short element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(short ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(ShortIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(short key) {
            int oldSize = ShortCharHashMap.this.size();
            ShortCharHashMap.this.removeKey(key);
            return oldSize != ShortCharHashMap.this.size();
        }

        public boolean removeAll(ShortIterable source) {
            int oldSize = ShortCharHashMap.this.size();
            ShortIterator iterator = source.shortIterator();
            while (iterator.hasNext()) {
                ShortCharHashMap.this.removeKey(iterator.next());
            }
            return oldSize != ShortCharHashMap.this.size();
        }

        public boolean removeAll(short ... source) {
            int oldSize = ShortCharHashMap.this.size();
            for (short item : source) {
                ShortCharHashMap.this.removeKey(item);
            }
            return oldSize != ShortCharHashMap.this.size();
        }

        public void clear() {
            ShortCharHashMap.this.clear();
        }

        public MutableShortSet select(ShortPredicate predicate) {
            ShortHashSet result = new ShortHashSet();
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    result.add((short)0);
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    result.add((short)1);
                }
            }
            for (short key : ShortCharHashMap.this.keys) {
                if (!ShortCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableShortSet reject(ShortPredicate predicate) {
            ShortHashSet result = new ShortHashSet();
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((short)0)) {
                    result.add((short)0);
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey && !predicate.accept((short)1)) {
                    result.add((short)1);
                }
            }
            for (short key : ShortCharHashMap.this.keys) {
                if (!ShortCharHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableShortSet with(short element) {
            throw new UnsupportedOperationException();
        }

        public MutableShortSet without(short element) {
            throw new UnsupportedOperationException();
        }

        public MutableShortSet withAll(ShortIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableShortSet withoutAll(ShortIterable elements) {
            throw new UnsupportedOperationException();
        }

        public short detectIfNone(ShortPredicate predicate, short ifNone) {
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return 0;
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return 1;
                }
            }
            for (short key : ShortCharHashMap.this.keys) {
                if (!ShortCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(ShortToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf((short)0));
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf((short)1));
                }
            }
            for (short key : ShortCharHashMap.this.keys) {
                if (!ShortCharHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableShortSet asUnmodifiable() {
            return UnmodifiableShortSet.of(this);
        }

        public MutableShortSet asSynchronized() {
            return SynchronizedShortSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (short key : ShortCharHashMap.this.keys) {
                if (!ShortCharHashMap.isNonSentinel(key)) continue;
                sum += (long)key;
            }
            return sum;
        }

        public short max() {
            if (ShortCharHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            short max = 0;
            boolean isMaxSet = false;
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0;
                    isMaxSet = true;
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < 1)) {
                    max = 1;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < ShortCharHashMap.this.keys.length; ++i) {
                if (!ShortCharHashMap.isNonSentinel(ShortCharHashMap.this.keys[i]) || isMaxSet && max >= ShortCharHashMap.this.keys[i]) continue;
                max = ShortCharHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public short maxIfEmpty(short defaultValue) {
            if (ShortCharHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public short min() {
            if (ShortCharHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            short min = 0;
            boolean isMinSet = false;
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0;
                    isMinSet = true;
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey && (!isMinSet || 1 < min)) {
                    min = 1;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < ShortCharHashMap.this.keys.length; ++i) {
                if (!ShortCharHashMap.isNonSentinel(ShortCharHashMap.this.keys[i]) || isMinSet && ShortCharHashMap.this.keys[i] >= min) continue;
                min = ShortCharHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public short minIfEmpty(short defaultValue) {
            if (ShortCharHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            short[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                short first = sortedArray[middleIndex];
                short second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public short[] toSortedArray() {
            short[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableShortList toSortedList() {
            return ShortArrayList.newList((ShortIterable)this).sortThis();
        }

        public short[] toArray() {
            int size = ShortCharHashMap.this.size();
            final short[] result = new short[size];
            ShortCharHashMap.this.forEachKey(new ShortProcedure(){
                private int index;

                public void value(short each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(short value) {
            return ShortCharHashMap.this.containsKey(value);
        }

        public boolean containsAll(short ... source) {
            for (short item : source) {
                if (ShortCharHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(ShortIterable source) {
            ShortIterator iterator = source.shortIterator();
            while (iterator.hasNext()) {
                if (ShortCharHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableShortList toList() {
            return ShortArrayList.newList((ShortIterable)this);
        }

        public MutableShortSet toSet() {
            return ShortHashSet.newSet((ShortIterable)this);
        }

        public MutableShortBag toBag() {
            return ShortHashBag.newBag((ShortIterable)this);
        }

        public LazyShortIterable asLazy() {
            return new LazyShortIterableAdapter((ShortIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, (short)0);
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, (short)1);
                }
            }
            for (int i = 0; i < ShortCharHashMap.this.keys.length; ++i) {
                if (!ShortCharHashMap.isNonSentinel(ShortCharHashMap.this.keys[i])) continue;
                result = function.valueOf(result, ShortCharHashMap.this.keys[i]);
            }
            return result;
        }

        public ShortSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableShortSet toImmutable() {
            return ShortSets.immutable.withAll((ShortIterable)this);
        }

        public int size() {
            return ShortCharHashMap.this.size();
        }

        public boolean isEmpty() {
            return ShortCharHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ShortCharHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ShortSet)) {
                return false;
            }
            ShortSet other = (ShortSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < ShortCharHashMap.this.keys.length; ++i) {
                if (!ShortCharHashMap.isNonSentinel(ShortCharHashMap.this.keys[i])) continue;
                result += ShortCharHashMap.this.keys[i];
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ShortCharHashMap.this.sentinelValues != null) {
                    if (ShortCharHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (ShortCharHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (short key : ShortCharHashMap.this.keys) {
                    if (!ShortCharHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements ShortIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < ShortCharHashMap.this.size();
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ShortCharHashMap.this.containsKey((short)0)) {
                    return 0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ShortCharHashMap.this.containsKey((short)1)) {
                    return 1;
                }
            }
            short[] keys = ShortCharHashMap.this.keys;
            while (!ShortCharHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            short result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyShortIterable {
        private KeysView() {
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public int size() {
            return ShortCharHashMap.this.size();
        }

        public boolean isEmpty() {
            return ShortCharHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ShortCharHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ShortCharHashMap.this.sentinelValues != null) {
                    if (ShortCharHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (ShortCharHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (short key : ShortCharHashMap.this.keys) {
                    if (!ShortCharHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ShortIterator shortIterator() {
            return new KeySetIterator();
        }

        public boolean contains(short key) {
            return ShortCharHashMap.this.containsKey(key);
        }

        public boolean containsAll(short ... keys) {
            for (short key : keys) {
                if (ShortCharHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(ShortIterable source) {
            return source.allSatisfy(new ShortPredicate(){

                public boolean accept(short key) {
                    return ShortCharHashMap.this.containsKey(key);
                }
            });
        }

        public void forEach(ShortProcedure procedure) {
            ShortCharHashMap.this.forEachKey(procedure);
        }

        public int count(ShortPredicate predicate) {
            int count = 0;
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    ++count;
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    ++count;
                }
            }
            for (short key : ShortCharHashMap.this.keys) {
                if (!ShortCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(ShortPredicate predicate) {
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return true;
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return true;
                }
            }
            for (short key : ShortCharHashMap.this.keys) {
                if (!ShortCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(ShortPredicate predicate) {
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((short)0)) {
                    return false;
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey && !predicate.accept((short)1)) {
                    return false;
                }
            }
            for (short key : ShortCharHashMap.this.keys) {
                if (!ShortCharHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(ShortPredicate predicate) {
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return false;
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return false;
                }
            }
            for (short key : ShortCharHashMap.this.keys) {
                if (!ShortCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public LazyShortIterable select(ShortPredicate predicate) {
            return new SelectShortIterable((ShortIterable)this, predicate);
        }

        public LazyShortIterable reject(ShortPredicate predicate) {
            return new SelectShortIterable((ShortIterable)this, ShortPredicates.not(predicate));
        }

        public short detectIfNone(ShortPredicate predicate, short value) {
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return 0;
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return 1;
                }
            }
            for (short key : ShortCharHashMap.this.keys) {
                if (!ShortCharHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(ShortToObjectFunction<? extends V> function) {
            return new CollectShortToObjectIterable<V>((ShortIterable)this, function);
        }

        public long sum() {
            long result = 0L;
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0L;
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (short key : ShortCharHashMap.this.keys) {
                if (!ShortCharHashMap.isNonSentinel(key)) continue;
                result += (long)key;
            }
            return result;
        }

        public short max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            ShortIterator iterator = this.shortIterator();
            short max = iterator.next();
            while (iterator.hasNext()) {
                short value = iterator.next();
                if (max >= value) continue;
                max = value;
            }
            return max;
        }

        public short min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            ShortIterator iterator = this.shortIterator();
            short min = iterator.next();
            while (iterator.hasNext()) {
                short value = iterator.next();
                if (value >= min) continue;
                min = value;
            }
            return min;
        }

        public short minIfEmpty(short defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public short maxIfEmpty(short defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            short[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                short first = sortedArray[middleIndex];
                short second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public short[] toSortedArray() {
            short[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public short[] toArray() {
            int size = ShortCharHashMap.this.size();
            final short[] result = new short[size];
            ShortCharHashMap.this.forEachKey(new ShortProcedure(){
                private int index;

                public void value(short each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (ShortCharHashMap.this.sentinelValues != null) {
                if (ShortCharHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, (short)0);
                }
                if (ShortCharHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, (short)1);
                }
            }
            for (int i = 0; i < ShortCharHashMap.this.keys.length; ++i) {
                if (!ShortCharHashMap.isNonSentinel(ShortCharHashMap.this.keys[i])) continue;
                result = function.valueOf(result, ShortCharHashMap.this.keys[i]);
            }
            return result;
        }

        public MutableShortList toList() {
            return ShortArrayList.newList((ShortIterable)this);
        }

        public MutableShortList toSortedList() {
            return ShortArrayList.newList((ShortIterable)this).sortThis();
        }

        public MutableShortSet toSet() {
            return ShortHashSet.newSet((ShortIterable)this);
        }

        public MutableShortBag toBag() {
            return ShortHashBag.newBag((ShortIterable)this);
        }

        public LazyShortIterable asLazy() {
            return this;
        }
    }

    private class InternalCharIterator
    implements CharIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalCharIterator() {
        }

        public boolean hasNext() {
            return this.count < ShortCharHashMap.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ShortCharHashMap.this.containsKey((short)0)) {
                    return ShortCharHashMap.this.get((short)0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ShortCharHashMap.this.containsKey((short)1)) {
                    return ShortCharHashMap.this.get((short)1);
                }
            }
            short[] keys = ShortCharHashMap.this.keys;
            while (!ShortCharHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            char result = ShortCharHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private char zeroValue;
        private char oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(char value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

