/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction0;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortLongPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortLongProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.ImmutableShortLongMap;
import com.gs.collections.api.map.primitive.MutableShortLongMap;
import com.gs.collections.api.map.primitive.ShortLongMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableShortSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.set.primitive.ShortSet;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.block.factory.primitive.ShortPredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedLongCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.LongLists;
import com.gs.collections.impl.factory.primitive.ShortLongMaps;
import com.gs.collections.impl.factory.primitive.ShortSets;
import com.gs.collections.impl.lazy.primitive.CollectShortToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectShortIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedShortLongMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableShortLongMap;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedShortSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableShortSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortLongHashMap
implements MutableShortLongMap,
Externalizable {
    static final long EMPTY_VALUE = 0L;
    private static final long serialVersionUID = 1L;
    private static final short EMPTY_KEY = 0;
    private static final short REMOVED_KEY = 1;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private short[] keys;
    private long[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public ShortLongHashMap() {
        this.allocateTable(16);
    }

    public ShortLongHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public ShortLongHashMap(ShortLongMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static ShortLongHashMap newWithKeysValues(short key1, long value1) {
        return new ShortLongHashMap(1).withKeyValue(key1, value1);
    }

    public static ShortLongHashMap newWithKeysValues(short key1, long value1, short key2, long value2) {
        return new ShortLongHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static ShortLongHashMap newWithKeysValues(short key1, long value1, short key2, long value2, short key3, long value3) {
        return new ShortLongHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static ShortLongHashMap newWithKeysValues(short key1, long value1, short key2, long value2, short key3, long value3, short key4, long value4) {
        return new ShortLongHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShortLongMap)) {
            return false;
        }
        ShortLongMap other = (ShortLongMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey((short)0) || other.containsKey((short)1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey((short)0) || this.sentinelValues.zeroValue != other.getOrThrow((short)0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey((short)1) || this.sentinelValues.oneValue != other.getOrThrow((short)1))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            short key = this.keys[i];
            if (!ShortLongHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ (int)(this.sentinelValues.zeroValue ^ this.sentinelValues.zeroValue >>> 32);
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ (int)(this.sentinelValues.oneValue ^ this.sentinelValues.oneValue >>> 32);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortLongHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ (int)(this.values[i] ^ this.values[i] >>> 32);
        }
        return result;
    }

    public String toString() {
        return this.makeString("{", ", ", "}");
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(0)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                short key = this.keys[i];
                if (!ShortLongHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LongIterator longIterator() {
        return new InternalLongIterator();
    }

    public long[] toArray() {
        long[] array = new long[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortLongHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(long value) {
        return this.containsValue(value);
    }

    public boolean containsAll(long ... source) {
        for (long each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(LongIterable source) {
        return source.allSatisfy(new LongPredicate(){

            public boolean accept(long value) {
                return ShortLongHashMap.this.contains(value);
            }
        });
    }

    public void forEach(LongProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableLongCollection select(LongPredicate predicate) {
        LongArrayList result = new LongArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableLongCollection reject(LongPredicate predicate) {
        LongArrayList result = new LongArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortLongHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortLongHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public long detectIfNone(LongPredicate predicate, long value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(LongPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(LongPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(LongPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortLongHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectLongToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortLongHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableLongList toList() {
        return LongArrayList.newList((LongIterable)this);
    }

    public MutableLongSet toSet() {
        return LongHashSet.newSet((LongIterable)this);
    }

    public MutableLongBag toBag() {
        return LongHashBag.newBag((LongIterable)this);
    }

    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter((LongIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, (short)0);
        Arrays.fill(this.values, 0L);
    }

    public void put(short key, long value) {
        if (ShortLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (ShortLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = value;
            return;
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public void putAll(ShortLongMap map) {
        map.forEachKeyValue(new ShortLongProcedure(){

            public void value(short key, long value) {
                ShortLongHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(short key) {
        if (ShortLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0L;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (ShortLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0L;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            this.values[index] = 0L;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(short key) {
        this.removeKey(key);
    }

    public long removeKeyIfAbsent(short key, long value) {
        if (ShortLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            long oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0L;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (ShortLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            long oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0L;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            long oldValue = this.values[index];
            this.values[index] = 0L;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public long getIfAbsentPut(short key, long value) {
        if (ShortLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (ShortLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public long getIfAbsentPut(short key, LongFunction0 function) {
        long value;
        if (ShortLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                long value2 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            long value3 = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (ShortLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                long value4 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            long value5 = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.value();
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public <P> long getIfAbsentPutWith(short key, LongFunction<? super P> function, P parameter) {
        long value;
        if (ShortLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                long value2 = function.longValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            long value3 = function.longValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (ShortLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                long value4 = function.longValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            long value5 = function.longValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.longValueOf(parameter);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public long getIfAbsentPutWithKey(short key, ShortToLongFunction function) {
        long value;
        if (ShortLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                long value2 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            long value3 = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (ShortLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                long value4 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            long value5 = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(key);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public long updateValue(short key, long initialValueIfAbsent, LongToLongFunction function) {
        long value;
        if (ShortLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(initialValueIfAbsent);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public ShortLongHashMap withKeyValue(short key1, long value1) {
        this.put(key1, value1);
        return this;
    }

    public ShortLongHashMap withKeysValues(short key1, long value1, short key2, long value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ShortLongHashMap withKeysValues(short key1, long value1, short key2, long value2, short key3, long value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ShortLongHashMap withKeysValues(short key1, long value1, short key2, long value2, short key3, long value3, short key4, long value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ShortLongHashMap withoutKey(short key) {
        this.removeKey(key);
        return this;
    }

    public ShortLongHashMap withoutAllKeys(ShortIterable keys) {
        keys.forEach(new ShortProcedure(){

            public void value(short key) {
                ShortLongHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableShortLongMap asUnmodifiable() {
        return new UnmodifiableShortLongMap(this);
    }

    public MutableShortLongMap asSynchronized() {
        return new SynchronizedShortLongMap(this);
    }

    public ImmutableShortLongMap toImmutable() {
        return ShortLongMaps.immutable.ofAll((ShortLongMap)this);
    }

    public long get(short key) {
        return this.getIfAbsent(key, 0L);
    }

    public long getIfAbsent(short key, long ifAbsent) {
        if (ShortLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public long getOrThrow(short key) {
        if (ShortLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (ShortLongHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(short key) {
        if (ShortLongHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (ShortLongHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(long value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!ShortLongHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(LongProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortLongHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(ShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((short)0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((short)1);
            }
        }
        for (short key : this.keys) {
            if (!ShortLongHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(ShortLongProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortLongHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyShortIterable keysView() {
        return new KeysView();
    }

    public ShortLongHashMap select(ShortLongPredicate predicate) {
        ShortLongHashMap result = new ShortLongHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept((short)0, this.sentinelValues.zeroValue)) {
                result.put((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept((short)1, this.sentinelValues.oneValue)) {
                result.put((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public ShortLongHashMap reject(ShortLongPredicate predicate) {
        ShortLongHashMap result = new ShortLongHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept((short)0, this.sentinelValues.zeroValue)) {
                result.put((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept((short)1, this.sentinelValues.oneValue)) {
                result.put((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortLongHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortLongHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.values[i];
        }
        return result;
    }

    public long max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        LongIterator iterator = this.longIterator();
        long max = iterator.next();
        while (iterator.hasNext()) {
            long value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public long maxIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public long min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        LongIterator iterator = this.longIterator();
        long min = iterator.next();
        while (iterator.hasNext()) {
            long value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public long minIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        long[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            long first = sortedArray[middleIndex];
            long second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public long[] toSortedArray() {
        long[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableLongList toSortedList() {
        return LongArrayList.newList((LongIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeShort(0);
                out.writeLong(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeShort(1);
                out.writeLong(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ShortLongHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeShort(this.keys[i]);
            out.writeLong(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readShort(), in.readLong());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        short[] old = this.keys;
        long[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ShortLongHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(short element) {
        int index = this.spread(element);
        short keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(short element) {
        int code = element;
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new short[sizeToAllocate];
        this.values = new long[sizeToAllocate];
    }

    private static boolean isEmptyKey(short key) {
        return key == 0;
    }

    private static boolean isRemovedKey(short key) {
        return key == 1;
    }

    private static boolean isNonSentinel(short key) {
        return !ShortLongHashMap.isEmptyKey(key) && !ShortLongHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableShortSet keySet() {
        return new KeySet();
    }

    public MutableLongCollection values() {
        return new ValuesCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableLongCollection {
        private ValuesCollection() {
        }

        public void clear() {
            ShortLongHashMap.this.clear();
        }

        public MutableLongCollection select(LongPredicate predicate) {
            return ShortLongHashMap.this.select(predicate);
        }

        public MutableLongCollection reject(LongPredicate predicate) {
            return ShortLongHashMap.this.reject(predicate);
        }

        public long detectIfNone(LongPredicate predicate, long ifNone) {
            return ShortLongHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
            return ShortLongHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
            return ShortLongHashMap.this.injectInto(injectedValue, function);
        }

        public long sum() {
            return ShortLongHashMap.this.sum();
        }

        public long max() {
            return ShortLongHashMap.this.max();
        }

        public long maxIfEmpty(long defaultValue) {
            return ShortLongHashMap.this.maxIfEmpty(defaultValue);
        }

        public long min() {
            return ShortLongHashMap.this.min();
        }

        public long minIfEmpty(long defaultValue) {
            return ShortLongHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return ShortLongHashMap.this.average();
        }

        public double median() {
            return ShortLongHashMap.this.median();
        }

        public long[] toSortedArray() {
            return ShortLongHashMap.this.toSortedArray();
        }

        public MutableLongList toSortedList() {
            return ShortLongHashMap.this.toSortedList();
        }

        public MutableLongCollection with(long element) {
            throw new UnsupportedOperationException();
        }

        public MutableLongCollection without(long element) {
            throw new UnsupportedOperationException();
        }

        public MutableLongCollection withAll(LongIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableLongCollection withoutAll(LongIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableLongCollection asUnmodifiable() {
            return UnmodifiableLongCollection.of(this);
        }

        public MutableLongCollection asSynchronized() {
            return SynchronizedLongCollection.of(this);
        }

        public ImmutableLongCollection toImmutable() {
            return LongLists.immutable.withAll((LongIterable)this);
        }

        public boolean contains(long value) {
            return ShortLongHashMap.this.containsValue(value);
        }

        public boolean containsAll(long ... source) {
            return ShortLongHashMap.this.containsAll(source);
        }

        public boolean containsAll(LongIterable source) {
            return ShortLongHashMap.this.containsAll(source);
        }

        public MutableLongList toList() {
            return ShortLongHashMap.this.toList();
        }

        public MutableLongSet toSet() {
            return ShortLongHashMap.this.toSet();
        }

        public MutableLongBag toBag() {
            return ShortLongHashMap.this.toBag();
        }

        public LazyLongIterable asLazy() {
            return new LazyLongIterableAdapter((LongIterable)this);
        }

        public boolean isEmpty() {
            return ShortLongHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ShortLongHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ShortLongHashMap.this.sentinelValues != null) {
                    if (ShortLongHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(ShortLongHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (ShortLongHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(ShortLongHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < ShortLongHashMap.this.keys.length; ++i) {
                    short key = ShortLongHashMap.this.keys[i];
                    if (!ShortLongHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ShortLongHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public LongIterator longIterator() {
            return ShortLongHashMap.this.longIterator();
        }

        public void forEach(LongProcedure procedure) {
            ShortLongHashMap.this.forEach(procedure);
        }

        public int count(LongPredicate predicate) {
            return ShortLongHashMap.this.count(predicate);
        }

        public boolean anySatisfy(LongPredicate predicate) {
            return ShortLongHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(LongPredicate predicate) {
            return ShortLongHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(LongPredicate predicate) {
            return ShortLongHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(long element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(long ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(LongIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(long item) {
            int oldSize = ShortLongHashMap.this.size();
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey && item == ShortLongHashMap.this.sentinelValues.zeroValue) {
                    ShortLongHashMap.this.removeKey((short)0);
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey && item == ShortLongHashMap.this.sentinelValues.oneValue) {
                    ShortLongHashMap.this.removeKey((short)1);
                }
            }
            for (int i = 0; i < ShortLongHashMap.this.keys.length; ++i) {
                if (!ShortLongHashMap.isNonSentinel(ShortLongHashMap.this.keys[i]) || item != ShortLongHashMap.this.values[i]) continue;
                ShortLongHashMap.this.removeKey(ShortLongHashMap.this.keys[i]);
            }
            return oldSize != ShortLongHashMap.this.size();
        }

        public boolean removeAll(LongIterable source) {
            int oldSize = ShortLongHashMap.this.size();
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != ShortLongHashMap.this.size();
        }

        public boolean removeAll(long ... source) {
            int oldSize = ShortLongHashMap.this.size();
            for (long item : source) {
                this.remove(item);
            }
            return oldSize != ShortLongHashMap.this.size();
        }

        public int size() {
            return ShortLongHashMap.this.size();
        }

        public long[] toArray() {
            return ShortLongHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableShortSet {
        private KeySet() {
        }

        public ShortIterator shortIterator() {
            return new KeySetIterator();
        }

        public void forEach(ShortProcedure procedure) {
            ShortLongHashMap.this.forEachKey(procedure);
        }

        public int count(ShortPredicate predicate) {
            int count = 0;
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    ++count;
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    ++count;
                }
            }
            for (short key : ShortLongHashMap.this.keys) {
                if (!ShortLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(ShortPredicate predicate) {
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return true;
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return true;
                }
            }
            for (short key : ShortLongHashMap.this.keys) {
                if (!ShortLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(ShortPredicate predicate) {
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((short)0)) {
                    return false;
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey && !predicate.accept((short)1)) {
                    return false;
                }
            }
            for (short key : ShortLongHashMap.this.keys) {
                if (!ShortLongHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(ShortPredicate predicate) {
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return false;
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return false;
                }
            }
            for (short key : ShortLongHashMap.this.keys) {
                if (!ShortLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(short element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(short ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(ShortIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(short key) {
            int oldSize = ShortLongHashMap.this.size();
            ShortLongHashMap.this.removeKey(key);
            return oldSize != ShortLongHashMap.this.size();
        }

        public boolean removeAll(ShortIterable source) {
            int oldSize = ShortLongHashMap.this.size();
            ShortIterator iterator = source.shortIterator();
            while (iterator.hasNext()) {
                ShortLongHashMap.this.removeKey(iterator.next());
            }
            return oldSize != ShortLongHashMap.this.size();
        }

        public boolean removeAll(short ... source) {
            int oldSize = ShortLongHashMap.this.size();
            for (short item : source) {
                ShortLongHashMap.this.removeKey(item);
            }
            return oldSize != ShortLongHashMap.this.size();
        }

        public void clear() {
            ShortLongHashMap.this.clear();
        }

        public MutableShortSet select(ShortPredicate predicate) {
            ShortHashSet result = new ShortHashSet();
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    result.add((short)0);
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    result.add((short)1);
                }
            }
            for (short key : ShortLongHashMap.this.keys) {
                if (!ShortLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableShortSet reject(ShortPredicate predicate) {
            ShortHashSet result = new ShortHashSet();
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((short)0)) {
                    result.add((short)0);
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey && !predicate.accept((short)1)) {
                    result.add((short)1);
                }
            }
            for (short key : ShortLongHashMap.this.keys) {
                if (!ShortLongHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableShortSet with(short element) {
            throw new UnsupportedOperationException();
        }

        public MutableShortSet without(short element) {
            throw new UnsupportedOperationException();
        }

        public MutableShortSet withAll(ShortIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableShortSet withoutAll(ShortIterable elements) {
            throw new UnsupportedOperationException();
        }

        public short detectIfNone(ShortPredicate predicate, short ifNone) {
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return 0;
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return 1;
                }
            }
            for (short key : ShortLongHashMap.this.keys) {
                if (!ShortLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(ShortToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf((short)0));
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf((short)1));
                }
            }
            for (short key : ShortLongHashMap.this.keys) {
                if (!ShortLongHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableShortSet asUnmodifiable() {
            return UnmodifiableShortSet.of(this);
        }

        public MutableShortSet asSynchronized() {
            return SynchronizedShortSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (short key : ShortLongHashMap.this.keys) {
                if (!ShortLongHashMap.isNonSentinel(key)) continue;
                sum += (long)key;
            }
            return sum;
        }

        public short max() {
            if (ShortLongHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            short max = 0;
            boolean isMaxSet = false;
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0;
                    isMaxSet = true;
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < 1)) {
                    max = 1;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < ShortLongHashMap.this.keys.length; ++i) {
                if (!ShortLongHashMap.isNonSentinel(ShortLongHashMap.this.keys[i]) || isMaxSet && max >= ShortLongHashMap.this.keys[i]) continue;
                max = ShortLongHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public short maxIfEmpty(short defaultValue) {
            if (ShortLongHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public short min() {
            if (ShortLongHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            short min = 0;
            boolean isMinSet = false;
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0;
                    isMinSet = true;
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey && (!isMinSet || 1 < min)) {
                    min = 1;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < ShortLongHashMap.this.keys.length; ++i) {
                if (!ShortLongHashMap.isNonSentinel(ShortLongHashMap.this.keys[i]) || isMinSet && ShortLongHashMap.this.keys[i] >= min) continue;
                min = ShortLongHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public short minIfEmpty(short defaultValue) {
            if (ShortLongHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            short[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                short first = sortedArray[middleIndex];
                short second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public short[] toSortedArray() {
            short[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableShortList toSortedList() {
            return ShortArrayList.newList((ShortIterable)this).sortThis();
        }

        public short[] toArray() {
            int size = ShortLongHashMap.this.size();
            final short[] result = new short[size];
            ShortLongHashMap.this.forEachKey(new ShortProcedure(){
                private int index;

                public void value(short each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(short value) {
            return ShortLongHashMap.this.containsKey(value);
        }

        public boolean containsAll(short ... source) {
            for (short item : source) {
                if (ShortLongHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(ShortIterable source) {
            ShortIterator iterator = source.shortIterator();
            while (iterator.hasNext()) {
                if (ShortLongHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableShortList toList() {
            return ShortArrayList.newList((ShortIterable)this);
        }

        public MutableShortSet toSet() {
            return ShortHashSet.newSet((ShortIterable)this);
        }

        public MutableShortBag toBag() {
            return ShortHashBag.newBag((ShortIterable)this);
        }

        public LazyShortIterable asLazy() {
            return new LazyShortIterableAdapter((ShortIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, (short)0);
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, (short)1);
                }
            }
            for (int i = 0; i < ShortLongHashMap.this.keys.length; ++i) {
                if (!ShortLongHashMap.isNonSentinel(ShortLongHashMap.this.keys[i])) continue;
                result = function.valueOf(result, ShortLongHashMap.this.keys[i]);
            }
            return result;
        }

        public ShortSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableShortSet toImmutable() {
            return ShortSets.immutable.withAll((ShortIterable)this);
        }

        public int size() {
            return ShortLongHashMap.this.size();
        }

        public boolean isEmpty() {
            return ShortLongHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ShortLongHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ShortSet)) {
                return false;
            }
            ShortSet other = (ShortSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < ShortLongHashMap.this.keys.length; ++i) {
                if (!ShortLongHashMap.isNonSentinel(ShortLongHashMap.this.keys[i])) continue;
                result += ShortLongHashMap.this.keys[i];
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ShortLongHashMap.this.sentinelValues != null) {
                    if (ShortLongHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (ShortLongHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (short key : ShortLongHashMap.this.keys) {
                    if (!ShortLongHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements ShortIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < ShortLongHashMap.this.size();
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ShortLongHashMap.this.containsKey((short)0)) {
                    return 0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ShortLongHashMap.this.containsKey((short)1)) {
                    return 1;
                }
            }
            short[] keys = ShortLongHashMap.this.keys;
            while (!ShortLongHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            short result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyShortIterable {
        private KeysView() {
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public int size() {
            return ShortLongHashMap.this.size();
        }

        public boolean isEmpty() {
            return ShortLongHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ShortLongHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ShortLongHashMap.this.sentinelValues != null) {
                    if (ShortLongHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (ShortLongHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (short key : ShortLongHashMap.this.keys) {
                    if (!ShortLongHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ShortIterator shortIterator() {
            return new KeySetIterator();
        }

        public boolean contains(short key) {
            return ShortLongHashMap.this.containsKey(key);
        }

        public boolean containsAll(short ... keys) {
            for (short key : keys) {
                if (ShortLongHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(ShortIterable source) {
            return source.allSatisfy(new ShortPredicate(){

                public boolean accept(short key) {
                    return ShortLongHashMap.this.containsKey(key);
                }
            });
        }

        public void forEach(ShortProcedure procedure) {
            ShortLongHashMap.this.forEachKey(procedure);
        }

        public int count(ShortPredicate predicate) {
            int count = 0;
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    ++count;
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    ++count;
                }
            }
            for (short key : ShortLongHashMap.this.keys) {
                if (!ShortLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(ShortPredicate predicate) {
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return true;
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return true;
                }
            }
            for (short key : ShortLongHashMap.this.keys) {
                if (!ShortLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(ShortPredicate predicate) {
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((short)0)) {
                    return false;
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey && !predicate.accept((short)1)) {
                    return false;
                }
            }
            for (short key : ShortLongHashMap.this.keys) {
                if (!ShortLongHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(ShortPredicate predicate) {
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return false;
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return false;
                }
            }
            for (short key : ShortLongHashMap.this.keys) {
                if (!ShortLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public LazyShortIterable select(ShortPredicate predicate) {
            return new SelectShortIterable((ShortIterable)this, predicate);
        }

        public LazyShortIterable reject(ShortPredicate predicate) {
            return new SelectShortIterable((ShortIterable)this, ShortPredicates.not(predicate));
        }

        public short detectIfNone(ShortPredicate predicate, short value) {
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept((short)0)) {
                    return 0;
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey && predicate.accept((short)1)) {
                    return 1;
                }
            }
            for (short key : ShortLongHashMap.this.keys) {
                if (!ShortLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(ShortToObjectFunction<? extends V> function) {
            return new CollectShortToObjectIterable<V>((ShortIterable)this, function);
        }

        public long sum() {
            long result = 0L;
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0L;
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (short key : ShortLongHashMap.this.keys) {
                if (!ShortLongHashMap.isNonSentinel(key)) continue;
                result += (long)key;
            }
            return result;
        }

        public short max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            ShortIterator iterator = this.shortIterator();
            short max = iterator.next();
            while (iterator.hasNext()) {
                short value = iterator.next();
                if (max >= value) continue;
                max = value;
            }
            return max;
        }

        public short min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            ShortIterator iterator = this.shortIterator();
            short min = iterator.next();
            while (iterator.hasNext()) {
                short value = iterator.next();
                if (value >= min) continue;
                min = value;
            }
            return min;
        }

        public short minIfEmpty(short defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public short maxIfEmpty(short defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            short[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                short first = sortedArray[middleIndex];
                short second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public short[] toSortedArray() {
            short[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public short[] toArray() {
            int size = ShortLongHashMap.this.size();
            final short[] result = new short[size];
            ShortLongHashMap.this.forEachKey(new ShortProcedure(){
                private int index;

                public void value(short each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (ShortLongHashMap.this.sentinelValues != null) {
                if (ShortLongHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, (short)0);
                }
                if (ShortLongHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, (short)1);
                }
            }
            for (int i = 0; i < ShortLongHashMap.this.keys.length; ++i) {
                if (!ShortLongHashMap.isNonSentinel(ShortLongHashMap.this.keys[i])) continue;
                result = function.valueOf(result, ShortLongHashMap.this.keys[i]);
            }
            return result;
        }

        public MutableShortList toList() {
            return ShortArrayList.newList((ShortIterable)this);
        }

        public MutableShortList toSortedList() {
            return ShortArrayList.newList((ShortIterable)this).sortThis();
        }

        public MutableShortSet toSet() {
            return ShortHashSet.newSet((ShortIterable)this);
        }

        public MutableShortBag toBag() {
            return ShortHashBag.newBag((ShortIterable)this);
        }

        public LazyShortIterable asLazy() {
            return this;
        }
    }

    private class InternalLongIterator
    implements LongIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalLongIterator() {
        }

        public boolean hasNext() {
            return this.count < ShortLongHashMap.this.size();
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ShortLongHashMap.this.containsKey((short)0)) {
                    return ShortLongHashMap.this.get((short)0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ShortLongHashMap.this.containsKey((short)1)) {
                    return ShortLongHashMap.this.get((short)1);
                }
            }
            short[] keys = ShortLongHashMap.this.keys;
            while (!ShortLongHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            long result = ShortLongHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private long zeroValue;
        private long oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(long value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

